/* 
 *  This file is part of Nathive.
 * 
 *  Nathive is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  Nathive is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nathive.  If not, see <http://www.gnu.org/licenses/>.
 */
 

int dom_tab()
{
	return gtk_notebook_get_current_page(GTK_NOTEBOOK(tabs));
}


char *dom_file_path()
{
	return n_tree_get(dom, n_tree_stalk(2, dom_tab(), DOM_PATH) );
}

int dom_file_count()
{
	return n_tree_count(dom, n_tree_stalk(0));
}


int *dom_w()
{
	int tab = gtk_notebook_get_current_page(GTK_NOTEBOOK(tabs));
	return n_tree_get(dom, n_tree_stalk(2,tab,DOM_W));
}


int *dom_h()
{
	int tab = gtk_notebook_get_current_page(GTK_NOTEBOOK(tabs));
	return n_tree_get(dom, n_tree_stalk(2,tab,DOM_H));
}


GtkWidget *dom_scroll()
{
	int tab = gtk_notebook_get_current_page(GTK_NOTEBOOK(tabs));
	return n_tree_get(dom, n_tree_stalk(2,tab,DOM_SCROLL));
}


GdkPixbuf *dom_pix()
{
	return n_tree_get(dom, n_tree_stalk(2, dom_tab() ,DOM_PIX));
}


GtkWidget *dom_img()
{
	int tab = gtk_notebook_get_current_page(GTK_NOTEBOOK(tabs));
	return n_tree_get(dom, n_tree_stalk(2,tab,DOM_IMG));
}


uchar *dom_raw()
{
	int tab = gtk_notebook_get_current_page(GTK_NOTEBOOK(tabs));
	return n_tree_get(dom, n_tree_stalk(2,tab,DOM_RAW));
}


GtkWidget *dom_align()
{
	int tab = gtk_notebook_get_current_page(GTK_NOTEBOOK(tabs));
	return n_tree_get(dom, n_tree_stalk(2,tab,DOM_ALIGN));
}


GtkWidget *dom_fixed()
{
	int tab = gtk_notebook_get_current_page(GTK_NOTEBOOK(tabs));
	return n_tree_get(dom, n_tree_stalk(2,tab,DOM_FIXED));
}


GtkWidget *dom_visual(int tab, int n)
{
	if(tab==-1) tab = gtk_notebook_get_current_page(GTK_NOTEBOOK(tabs));
	return n_tree_get(dom, n_tree_stalk(3,tab,DOM_VISUAL,n));
}


int *dom_obj_sel(int tab)
{
	if(tab==-1) tab = dom_tab();
	return n_tree_get(dom, n_tree_stalk(3,tab,DOM_OBJ,0));
}

int dom_obj_count(int tab)
{
	if(tab==-1) tab = dom_tab();
	return n_tree_count(dom, n_tree_stalk(2,tab,DOM_OBJ)) - 1;
}


uchar *dom_obj_raw(int n)
{
	int tab = gtk_notebook_get_current_page(GTK_NOTEBOOK(tabs));
	if(!n) n = *dom_obj_sel(-1);
	return n_tree_get(dom, n_tree_stalk(4,tab,DOM_OBJ,n,OBJ_RAW));
}


int *dom_obj_w(int n)
{
	int tab = gtk_notebook_get_current_page(GTK_NOTEBOOK(tabs));
	if(!n) n = *dom_obj_sel(-1);
	return n_tree_get(dom, n_tree_stalk(4,tab,DOM_OBJ,n,OBJ_W));
}


int *dom_obj_h(int n)
{
	int tab = gtk_notebook_get_current_page(GTK_NOTEBOOK(tabs));
	if(!n) n = *dom_obj_sel(-1);
	return n_tree_get(dom, n_tree_stalk(4,tab,DOM_OBJ,n,OBJ_H));
}


int *dom_obj_x(int n)
{
	int tab = gtk_notebook_get_current_page(GTK_NOTEBOOK(tabs));
	if(!n) n = *dom_obj_sel(-1);
	return n_tree_get(dom, n_tree_stalk(4,tab,DOM_OBJ,n,OBJ_X));
}


int *dom_obj_y(int n)
{
	int tab = gtk_notebook_get_current_page(GTK_NOTEBOOK(tabs));
	if(!n) n = *dom_obj_sel(-1);
	return n_tree_get(dom, n_tree_stalk(4,tab,DOM_OBJ,n,OBJ_Y));
}


GtkTreeModel *dom_objgui_model(int n)
{
	return n_tree_get(dom, n_tree_stalk(3,n,DOM_OBJGUI,0));
}


GtkListStore *dom_objgui_store(int n)
{
	return n_tree_get(dom, n_tree_stalk(3,n,DOM_OBJGUI,1));
}


uchar *dom_mosaic()
{
	int tab = gtk_notebook_get_current_page(GTK_NOTEBOOK(tabs));
	return n_tree_get(dom, n_tree_stalk(3,tab,DOM_PRE,0));
}
