/*
 *  This file is part of Nathive.
 *
 *  Nathive is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Nathive is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Nathive.  If not, see <http://www.gnu.org/licenses/>.
 */


double round(double x)
{
	return floor(x+0.5);
}


double log_base(double base, double x)
{
	return log(x) / log(base);
}


int max(int a, int b)
{
	if(a>b) return a;
	else return b;
}


int min(int a, int b)
{
	if(a>b) return b;
	else return a;
}


void mark(int num)
{
	printf("%i\n", num);
}


char *file_to_str(char *path)
{
	FILE *file = fopen(path,"r");
	if(!file)
	{
		printf("ERROR: file_to_str: %s can not be opened\n", path);
		return path;
	}

	int n = 0;
	while(getc(file)!=EOF) n++;
	rewind(file);

	char *str = (char*)calloc(n+1, sizeof(char));
	int i;
	for(i=0; i<n; i++) str[i] = getc(file);
	str[n+1] = '\0';
	return str;
}


char *parse(char *str, char *in, char *out)
{
	char *inp = strstr(str, in);
	char *outp = strstr(str, out);
	inp+= strlen(in);

	int n = outp-inp;
	if(n<1) return "PARSE ERROR";
	char *get = (char*)malloc((n+1)*sizeof(char));
	int i;
	for(i=0; i<=n; i++)
	{
		if(i<n) get[i] = *(inp+i);
		else get[i] = '\0';
	}
	return get;
}


char *strcatnew(char *s1, char *s2)
{
	char *s3 = (char*)malloc(( strlen(s1) + strlen(s2) + 1 )*sizeof(char));
	sprintf(s3, "%s%s", s1, s2);
	return s3;
}


int hash_basic(char *str)
{
	int hash = 0;
	int i = 0;
	while(str[i] != '\0')
	{
		hash = (hash + str[i]) * str[i];
		hash = abs(hash);
		i++;
	}
	hash *= i;
	return abs(hash);
}
