/* 
 *  This file is part of Nathive.
 * 
 *  Nathive is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 * 
 *  Nathive is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nathive.  If not, see <http://www.gnu.org/licenses/>.
 */
 

cfg_load()
{
	printf("> loading user cfg\n", language_);

	char *cfg = file_to_str( strcatnew(PATH,"cfg/cfg.xml") );
	
	language_ = n_xml_get(cfg, 3, "cfg", "misc", "language");
	folder_last = n_xml_get(cfg, 3, "cfg", "misc", "folder-last");
	
	win_w = atoi( n_xml_get(cfg, 3, "cfg", "misc", "win-w") );
	win_h = atoi( n_xml_get(cfg, 3, "cfg", "misc", "win-h") );
	
	color1[0] = atoi( n_xml_get(cfg, 3, "cfg", "color", "r") );
	color1[1] = atoi( n_xml_get(cfg, 3, "cfg", "color", "g") );
	color1[2] = atoi( n_xml_get(cfg, 3, "cfg", "color", "b") );
	
	brush_size = atoi(n_xml_get(cfg, 3, "cfg", "brush", "size") );
	brush_mode = atoi(n_xml_get(cfg, 3, "cfg", "brush", "mode") );
	brush_fade = atoi(n_xml_get(cfg, 3, "cfg", "brush", "soft") );
	brush_opacity = atoi(n_xml_get(cfg, 3, "cfg", "brush", "opacity") );
	brush_space = atoi( n_xml_get(cfg, 3, "cfg", "brush", "space") );
}
