/*
 *  This file is part of Nathive.
 *
 *  Nathive is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Nathive is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Nathive.  If not, see <http://www.gnu.org/licenses/>.
 */


void gui_main(int argc, char *argv[])
{
	printf("> loading gtk interface\n");
	gtk_init(&argc, &argv);

	win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	g_signal_connect(G_OBJECT(win), "destroy", G_CALLBACK(gtk_quit), NULL);

	gtk_window_set_default_size(GTK_WINDOW(win), win_w, win_h);
	gtk_window_set_focus(GTK_WINDOW(win), NULL);
	gtk_window_set_position(GTK_WINDOW(win), GTK_WIN_POS_CENTER);
	gtk_window_set_default_icon_from_file( strcatnew(PATH,"img/icon.png") , NULL);

	char win_title[100];
	sprintf(win_title, "Nathive %s", VERSION);
	gtk_window_set_title(GTK_WINDOW(win), win_title);

	GtkWidget *vbox = gtk_vbox_new(FALSE,0);
		#include "menubar.c"
		#include "headbar.c"
		GtkWidget *workarea = gtk_hbox_new(FALSE,2);
			#include "toolbar.c"
			#include "tabs.c"
			#include "sidebar.c"
			#include "colorbar.c"

			gtk_box_pack_start(GTK_BOX(workarea),toolbar,FALSE,FALSE,0);
			gtk_box_pack_start(GTK_BOX(workarea),tabs,TRUE,TRUE,0);
			gtk_box_pack_start(GTK_BOX(workarea),sidebar,FALSE,FALSE,0);
			gtk_box_pack_start(GTK_BOX(workarea),colorbar,FALSE,FALSE,0);

		statusbar = gtk_statusbar_new();

		gtk_box_pack_start(GTK_BOX(vbox),menubar,FALSE,FALSE,0);
		gtk_box_pack_start(GTK_BOX(vbox),headbar,FALSE,FALSE,0);
		gtk_box_pack_start(GTK_BOX(vbox),workarea,TRUE,TRUE,0);
		gtk_box_pack_start(GTK_BOX(vbox),statusbar,FALSE,FALSE,0);

	gtk_container_add(GTK_CONTAINER(win), vbox);
	gtk_widget_show_all(win);

	sidebar_tool_change(NULL, NULL);

	main_load = 1;
	printf("> waiting for events\n");
	gtk_main();
}
