Nagios Plugins
==============

* For instructions on installing these plugins for use with Nagios,
  see below.

* For major changes between releases, read the `NEWS` file.

* For information on detailed changes that have been made or plugins
  that have been added, read the `NEWS` file.

* Some plugins require that you have additional programs and/or
  libraries installed on your system before they can be used.  Plugins that
  are dependent on other programs/libraries that are missing are usually not
  compiled.  Read the `REQUIREMENTS` file for more information.

* Individual plugins are self-documenting.  All plugins that comply with
  the basic guidelines for development will provide detailed help when
  invoked with the `-h` or `--help` options.

You can check for the latest plugins at:

* <https://www.nagios-plugins.org/>

Send an email to <help@nagios-plugins.org> for assistance.  Please include
the OS type and version that you are using.  Also, run the plugin with the
`-vvv` option and provide the resulting version information.  Of course,
there may be additional diagnostic information required as well.  Use good
judgment.

Send an email to <devel@nagios-plugins.org> for developer discussions.

For patch submissions and bug reports, please use the appropriate resources
at:

* <https://github.com/nagios-plugins>


Installation Instructions
-------------------------

1.  If you are using the Git tree, you will need m4, gettext, automake, and
    autoconf.  To start out, run:

        ./tools/setup

    For more detail, see the developer guidelines at
    <https://www.nagios-plugins.org/doc/guidelines.html>.

2.  Run the configure script to initialize variables and create a Makefile,
    etc.

        ./configure --prefix=BASEDIRECTORY --with-cgiurl=SOMEURL

    Replace `BASEDIRECTORY` with the path of the directory under which Nagios
    is installed (default is `/usr/local/nagios`), and replace `SOMEURL` with
    the path used to access the Nagios CGIs with a web browser (default is
    `/nagios/cgi-bin`).

3.  Compile the plugins with the following command:

        make

4.  Install the compiled plugins and plugin scripts with the following
    command:

        make install

    The installation procedure will attempt to place the plugins in a
    `libexec/` subdirectory in the base directory you specified with the
    `--prefix` argument to the configure script.

5.  There are some plugins that require setuid.  If you run make install as
    a non-root user, they will not be installed.  To install, switch to root
    and run:

        make install-root

That's it!  If you have any problems or questions, feel free to send an
email to <help@nagios-plugins.org>.


Testing With libtap
-------------------

1.  The nagios-plugins source includes a perl testing suite.  the libtap 
    library and headers are included with the source.  Configure with:

        ./configure --enable-libtap

    Note: "--enable-extra-opts" used to be required as well, but is no 
    longer required as it is a default configure option.

2.  Make and then make test:

        make
        make test

3.  Testing is pseudo intelligent and will try to autodetect which plugins
    to test.  You may need to look at the REQUIREMENTS doc as to what
    dependencies are required to satisfy the test.

    Additionally, default and user supplied (at runtime) testing parameters
    are saved in the file:

        /var/tmp/NPTest.cache

    If you need to change any testing parameters, edit them in this file
    or just remove the line to force the test to re-prompt you for input.


License Notice
--------------

You can redistribute and/or modify this software under the terms of the GNU
General Public License as published by the Free Software Foundation; either
version 3 of the License, or (at your option) any later version; with the
additional exemption that compiling, linking, and/or using OpenSSL is
allowed.

This software is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.

See the `COPYING` file for the complete text of the GNU General Public
License, version 3.

Static Analysis Tools
--------------

Coverity is a tool used to statically analyze C\C++ code and determine
possible vulnerabilities, bugs, and usage errors. Nagios-Plugins considers
these items to be extremely important for proper code coverage and
longevity. It should be noted that a "Passed", does not mean that all
Coverity reported issues have been resolved, instead that the latest build
submitted did not have any newly found issues, and may or may not have
eliminated previously found issues. We use several testing processes that
end with a submission to Coverity on each successful build. This means that
you will often see this badge pending or with new issues found as new
features, pull requests, and github issue resolutions submitted in other
branches will reflect on the badge displayed on the master branch. However,
the master branch and therefore any releases will not be updated without a
current clean scan from Coverity. With that said, below you can find the
current state of the Nagios-Plugins project per Coverity's view.

<a href="https://scan.coverity.com/projects/2376">
  <img alt="Coverity Scan Build Status"
       src="https://scan.coverity.com/projects/2376/badge.svg"/>
</a>
