#include <gtk/gtk.h>
#include "grabbing.h"
#include "gestures.h"

GtkWidget * ui_create_combo_box_devices() {

	GtkWidget * combo;

	combo = gtk_combo_box_text_new();

	gtk_combo_box_text_append(GTK_COMBO_BOX_TEXT(combo), "1", "Button 1");
	gtk_combo_box_text_append(GTK_COMBO_BOX_TEXT(combo), "2", "Button 2");
	gtk_combo_box_text_append(GTK_COMBO_BOX_TEXT(combo), "3", "Button 3");
	gtk_combo_box_text_append(GTK_COMBO_BOX_TEXT(combo), "4", "Button 4");
	gtk_combo_box_text_append(GTK_COMBO_BOX_TEXT(combo), "5", "Button 5");

	gtk_combo_box_set_active(GTK_COMBO_BOX(combo), 1);

	return combo;

}

enum {
	ACTIVE_COLUMN, DEVICE_COLUMN, N_COLUMNS
};

enum {
	BUTTON_ID, BUTTON_NAME
};

static GtkTreeModel *
create_items_model(void) {
	gint i = 0;
	GtkListStore *model;
	GtkTreeIter iter;

	/* create list store */
	model = gtk_list_store_new(2, G_TYPE_INT, G_TYPE_STRING);

	/* add items */

	gtk_list_store_append(model, &iter);
	gtk_list_store_set(model, &iter, BUTTON_ID, -1, BUTTON_NAME, "Disabled", -1);

	gtk_list_store_append(model, &iter);
	gtk_list_store_set(model, &iter, BUTTON_ID, 1, BUTTON_NAME, "Button 1", -1);

	gtk_list_store_append(model, &iter);
	gtk_list_store_set(model, &iter, BUTTON_ID, 2, BUTTON_NAME, "Button 2", -1);

	gtk_list_store_append(model, &iter);
	gtk_list_store_set(model, &iter, BUTTON_ID, 3, BUTTON_NAME, "Button 3", -1);

	gtk_list_store_append(model, &iter);
	gtk_list_store_set(model, &iter, BUTTON_ID, 4, BUTTON_NAME, "Button 4", -1);

	gtk_list_store_append(model, &iter);
	gtk_list_store_set(model, &iter, BUTTON_ID, 5, BUTTON_NAME, "Button 5", -1);

	return GTK_TREE_MODEL(model);
}

static void cb_toggled(GtkCellRendererToggle *cell, gchar *path, GtkTreeModel *model) {
	GtkTreeIter iter;
	gboolean active;

	g_object_get(G_OBJECT(cell), "active", &active, NULL);

	gtk_tree_model_get_iter_from_string(model, &iter, path);
	gtk_list_store_set(GTK_LIST_STORE(model), &iter, ACTIVE_COLUMN, !active, -1);
}

GtkWidget *
ui_load_apps(Engine * engine) {

	return NULL;
}

GtkWidget *
ui_load_devices(Grabber * grabber) {

	int n_devices = 0;
	char ** devices = NULL;
	devices = grabber_get_device_names(grabber, &n_devices);

	char * current_grabber = grabber_get_device_name(grabber);

	GtkListStore *store;
	GtkWidget *tree;
	GtkTreeViewColumn *column;
	GtkCellRenderer *renderer;

	/* Create a model.  We are using the store model for now, though we
	 * could use any other GtkTreeModel */
	store = gtk_list_store_new(N_COLUMNS,
	G_TYPE_BOOLEAN,
	G_TYPE_STRING);

	tree = gtk_tree_view_new_with_model(GTK_TREE_MODEL(store));

	renderer = gtk_cell_renderer_toggle_new();
	g_signal_connect(G_OBJECT( renderer ), "toggled", G_CALLBACK( cb_toggled ),
			GTK_TREE_MODEL( store ));
	column = gtk_tree_view_column_new_with_attributes("Active", renderer, "active", ACTIVE_COLUMN,
	NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(tree), column);

	renderer = gtk_cell_renderer_text_new();
	column = gtk_tree_view_column_new_with_attributes("Device Name", renderer, "text",
			DEVICE_COLUMN,
			NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(tree), column);

	/* The view now holds a reference.  We can get rid of our own
	 * reference */
	//g_object_unref(G_OBJECT(store));
	/* Now we can manipulate the view just like any other GTK widget */

	GtkTreeIter iter;

	for (int i = 0; i < n_devices; ++i) {

		gtk_list_store_append(store, &iter); /* Acquire an iterator */

		int is_current_device = FALSE;

		if (strcasecmp(current_grabber, devices[i]) == 0) {
			is_current_device = TRUE;
		}

		gtk_list_store_set(store, &iter, DEVICE_COLUMN, devices[i], ACTIVE_COLUMN,
				is_current_device, -1);

	}

	return tree;
}

ui_create_panel_apps(Engine * engine) {

	GtkWidget * panel = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 10);
	GtkWidget *label = gtk_label_new("Applications: ");
	GtkWidget * input = ui_load_apps(engine);

	gtk_box_pack_start(GTK_BOX(panel), label, TRUE, FALSE, 10);
	gtk_box_pack_start(GTK_BOX(panel), input, TRUE, TRUE, 10);

	return panel;

}

ui_create_panel_devices(Grabber * grabber) {

	GtkWidget * panel = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 10);

	GtkWidget * input = ui_load_devices(grabber);

	gtk_box_pack_start(GTK_BOX(panel), input, TRUE, TRUE, 10);

	return panel;

}

ui_create_panel_buttons(Grabber * grabber) {

	GtkWidget * panel = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 10);

	gtk_box_set_homogeneous(panel, TRUE);

	GtkWidget * panel_buttons = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0);

	gtk_box_set_homogeneous(GTK_BOX(panel_buttons), TRUE);

	GtkWidget *button_devices = gtk_toggle_button_new_with_label("Devices");
	gtk_box_pack_start(GTK_BOX(panel_buttons), button_devices, FALSE, FALSE, 0);

	GtkWidget *button_gestures = gtk_toggle_button_new_with_label("Gestures");
	gtk_box_pack_start(GTK_BOX(panel_buttons), button_gestures, FALSE, FALSE, 0);

	gtk_box_pack_start(GTK_BOX(panel), panel_buttons, FALSE, FALSE, 10);

	return panel;

}

int ui_create(struct args_t * args, Engine * engine, Grabber * grabber) {

	gtk_init(NULL, NULL);

	GtkWidget * window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	GtkWidget * background_panel = gtk_box_new(GTK_ORIENTATION_VERTICAL, 10);

	GtkWidget * panel_buttons = ui_create_panel_buttons(grabber);
	gtk_box_pack_start(GTK_BOX(background_panel), panel_buttons, FALSE, TRUE, 10);

	//GtkWidget * panel_apps = ui_create_panel_apps(engine);
	//gtk_box_pack_start(GTK_BOX(background_panel), panel_apps, TRUE, TRUE, 10);

	GtkWidget * panel_devices = ui_create_panel_devices(grabber);
	gtk_box_pack_start(GTK_BOX(background_panel), panel_devices, TRUE, TRUE, 10);

//	GtkWidget * devices_panel = gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 10);
	//	GtkWidget *devices_label = gtk_label_new("Button: ");
	//	GtkWidget *devices_list = ui_create_combo_box_devices(devices, ndevices);
	//	gtk_box_pack_start(GTK_BOX(devices_panel), devices_label, TRUE, FALSE, 10);
	//	gtk_box_pack_start(GTK_BOX(devices_panel), devices_list, TRUE, TRUE, 10);
	//	gtk_box_pack_start(GTK_BOX(background_panel), devices_panel, FALSE, FALSE, 10);

// ------ //

	gtk_container_add(GTK_CONTAINER(window), background_panel);

	gtk_widget_show_all(window);
	gtk_main();

	return 0;
}
