<?php

/**
  * login_form.tpl
  *
  * Template for login page controls added by the Multilogin plugin
  *
  * The following variables are available in this template:
  *
  * array   $select_options                       A list of the server names
  *                                               to be used as server selection
  *                                               options (values and text both)
  * string  $default_option                       The option that should be selected
  * boolean $show_remember_login_server_checkbox  Indicates if checkbox should be shown
  * boolean $login_server_checkbox_checked        Indicates if checkbox should be
  *                                               checked by default or not (only 
  *                                               relevant if checkbox is shown
  *                                               in the first place)
  *
  * Copyright (c) 2003-2008 Paul Lesniewski <paul@squirrelmail.org>,
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage multilogin
  *
  */


// retrieve the template vars
//
extract($t);


?>

<tr>
   <td colspan="2">
      <br />
      <center>
      <table width="350">
         <tr>
            <td bgcolor="#dcdcdc">
               <table width="100%">
                  <tr>
                     <td width='30%' align="right"><?php echo _("Log in to"); ?>:</td>
                     <td width="*" align="left">
                        <select name="loginServer">
                           <?php foreach ($select_options as $option) echo '<option value="' . $option . '"' . ($default_option == $option ? ' selected' : '') . '>' . $option . "</option>\n"; ?>
                        </select>
                     </td>
                  </tr>
               </table>
            </td>
         </tr>
         <?php if ($show_remember_login_server_checkbox) { ?>
         <tr>
            <td>
               <center>
               <input type='checkbox' <?php if ($login_server_checkbox_checked) { ?>checked<?php } ?> name='rememberLoginServer' id='remember' value='1'><label for='remember'><?php echo _("Remember login server"); ?></label>
               </center>
            </td>
         </tr>
         <?php } ?>
      </table>
      </center>
   </td>
</tr>

