#!python

from distutils.core import setup
from glob import glob

docfiles=glob("doc/*.html")+glob("doc/*.css")+glob("doc/*.png")
            


setup(  name="moonshiner",
        version="1.0",
        author="Benjamin Dumke",
        author_email="balpha@users.sourceforge.net",
        url="http://moonshiner.sourceforge.net/",
        description="Graphical frontend for Ghostscript's PS-to-PDF converter",
        license="GNU GPL v3+",
        long_description="""Moonshiner is a graphical frontend (GUI) for Ghostscript's
PostScript-to-PDF converter. While Ghostscript (and its wrapper
ps2pdf) is a very powerful instrument, it is quite challenging
to use its parameters on the command line, especially if you
(like me) often change the settings as to what kind of color
conversion, image resampling etc. you want Ghostscript to perform.

So by basically being a graphical ps2pdf, Moonshiner makes it
easier to tweak PDF creation settings.""",

        requires=["pygtk (>= 2.10)"],
        
        packages=["moonshiner_modules"],
        package_data={"moonshiner_modules" : ["img/*.png"]},
        data_files=[("/usr/share/doc/moonshiner" , docfiles)],
        scripts=["moonshiner"]
        
        )
