# -*- coding: utf-8 -*-

#   This file is part of Moonshiner.
#   Copyright 2008, 2009 Benjamin Dumke
#
#   Moonshiner is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   Moonshiner is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with Moonshiner (see the file LICENSE).  If not, see
#   <http://www.gnu.org/licenses/>.


import pygtk
pygtk.require("2.0")
import gtk

class XPadding(gtk.Label):
    def __init__(self,xpadding):
        gtk.Label.__init__(self,"")
        self.set_padding(xpadding / 2,0) # left and right!
        self.show()
        

class HRow(gtk.HBox):
    """A gtk.HBox with a constructor that packs widgets."""
    def __init__(self,*args,**kwargs):
        if "padding" not in kwargs:
            kwargs["padding"]=0
        gtk.HBox.__init__(self,False,kwargs["padding"])
        self.widget_list=[]
        if "left" in kwargs:
            self.pack_start(XPadding(kwargs["left"]),False,False,0)        
        for widget in args:
            if not isinstance(widget,gtk.Widget):
                widget=gtk.Label(widget)
            if "right_to_left" in kwargs: #no matter what the value
                self.pack_end(widget,False,False,0)
            else:
                self.pack_start(widget,False,False,0)
            widget.show()
            self.widget_list.append(widget)
    def __getitem__(self,n):
        return self.widget_list[n]

class VRow(gtk.VBox):
    """A gtk.VBox with a constructor that packs widgets."""
    def __init__(self,*args,**kwargs):
        if "padding" not in kwargs:
            kwargs["padding"]=0
        gtk.VBox.__init__(self,False,kwargs["padding"])
        self.widget_list=[]
        for widget in args:
            if not isinstance(widget,gtk.Widget):
                widget=gtk.Label(widget)
            self.pack_start(widget,False,False,1)
            widget.show()
            self.widget_list.append(widget)
    
    def __getitem__(self,n):
        return self.widget_list[n]

def Chooser(*args):
    """A gtk.ComboBox with simpler construction and access.
    
    Takes tuples of the type (key,combo_box_value)"""
   
    result=gtk.combo_box_new_text()
    result.choicelist=[]
    for a in args:
        result.append_text(a[1])
        result.choicelist.append(a[0])
        
    result.get=lambda : result.choicelist[result.get_active()]
    result.set=lambda s : result.set_active(result.choicelist.index(s))
    
    return result

class IntEntry(gtk.Entry):
    def get(self,event=None,check=True):
        vs=self.get_text()
        try:
            v=int(vs)
        except ValueError:
            v=self.min
        if check or not self.is_focus():
            if v>self.max: v=self.max
            if v<self.min: v=self.min
            self.set_text(str(v))
        if event is not None:
            return False
        else:
            return v
    def set(self,v):
        self.set_text(str(v))
        self.get()
    def __init__(self,min,max):
        gtk.Entry.__init__(self)
        self.min=min
        self.max=max
        self.set_width_chars(len(str(max)))
#        self.connect("changed",IntEntry.get,None,False)
        self.connect("focus-out-event",IntEntry.get,False)
        self.get()
        
class HIGFrame(gtk.Frame):
    """A frame conforming to the Gnome Human Interface Guidelines
    
    See http://library.gnome.org/devel/hig-book/stable/controls-frames.html.en
    Thanks to Tboias Jakobs for pointing me there."""
    
    def __init__(self,label=None):
        if isinstance(label,str):
            lbl=gtk.Label()
            lbl.set_markup("<b>"+label+"</b>")
            lbl.show()
            gtk.Frame.__init__(self,None)
            self.set_label_widget(lbl)
        else:
            gtk.Frame.__init__(self,label)
        self.set_shadow_type(gtk.SHADOW_NONE)
        self.set_border_width(6)

class IndentedCheckButton(HRow):
    def __init__(self,*args):
        HRow.__init__(self,gtk.CheckButton(*args),left=12)
    def get_active(self):
        return self[0].get_active()
    def set_active(self,val):
        return self[0].set_active(val)
    def connect(self,*args):
        if args[0] == "toggled":
            return self[0].connect(*args)
        else:
            return HRow.connect(self,*args)
