# -*- coding: utf-8 -*-

#   This file is part of Moonshiner.
#   Copyright 2008, 2009 Benjamin Dumke
#
#   Moonshiner is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   Moonshiner is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with Moonshiner (see the file LICENSE).  If not, see
#   <http://www.gnu.org/licenses/>.


import pygtk
pygtk.require("2.0")
import gtk

from moonshiner_commondata import version,Moonshiner_AboutDialog,logo,icon,helpfile
from moonshiner_ui_tools import HRow,VRow,Chooser,IntEntry,HIGFrame,IndentedCheckButton
from moonshiner_params import params_to_ui,param_presets,ui_to_params,compare_params
from moonshiner_go import go
from moonshiner_config import settings_dialog
from os.path import dirname,join,isfile,isdir,basename,normpath
from urllib import unquote

#from webbrowser import open as webopen
#there is a bug in webbrowser.open, that's why we're doing this ugly thing:
def webopen(url):
	from os import system
	system('gnome-open "'+url+'"')

class MoonshinerTab(gtk.VBox):
    def __init__(self,label_text):
        gtk.VBox.__init__(self,False,10)
        self.label = gtk.Label(" "+label_text+" ")
        self.set_border_width(6)
        
        self.label.show()
        
    def append_to_notebook(self,notebook):
        notebook.append_page(self,self.label)

class MoonshinerTab_Misc(MoonshinerTab):
    def basedon_changed_callback(self,widget,window,notebook):
        new_basedon=self.opts_row_basedon[1].get()
        if self.opt__BasedOn is None: #initialization
            difference={}
        else:
            difference=compare_params(param_presets[self.opt__BasedOn],ui_to_params(notebook))
        yes=True
        if difference:
            dia=gtk.MessageDialog(window,gtk.DIALOG_MODAL,gtk.MESSAGE_WARNING,gtk.BUTTONS_YES_NO,
                        "Changing the preset will overwrite all changes you have made to other settings. Do it anyway?")
            yes=dia.run() == gtk.RESPONSE_YES
            dia.destroy()
        if yes:
            self.opt__BasedOn=new_basedon
            params_to_ui(param_presets[new_basedon],notebook)
        else:
            self.opts_row_basedon[1].handler_block(notebook.basedon_change_handler_id)
            self.opts_row_basedon[1].set(self.opt__BasedOn)
            self.opts_row_basedon[1].handler_unblock(notebook.basedon_change_handler_id)
        
    def __init__(self):
        MoonshinerTab.__init__(self,"Misc")
        
        self.opts_frame_basic=HIGFrame("Basic settings")
        self.opts_frame_fileprop=HIGFrame("File properties")
        self.opt__BasedOn=None
        self.opts_row_basedon=HRow("Parameters currently based on preset: ",
                Chooser(("default","default (multi-purpose)"),
                        ("screen","screen (low-res for on-screen viewing)"),
                        ("ebook","ebook (medium-res for on-screen viewing)"),
                        ("printer","printer (for printing, copying etc.)"),
                        ("prepress","prepress (high quality output for offset print etc.)")),left=12)
        self.opt_CompatibilityLevel=HRow("PDF Version: ",Chooser((13,"1.3"),(14,"1.4")),left=12)
        self.opt_CompressPages=IndentedCheckButton("Compress content streams, e.g. page descriptions")
        self.opt_ASCII85EncodePages=IndentedCheckButton("Encode binary data as ASCII")
        self.opt_AutoRotatePages=HRow("If no page orientation information is found, ",
                Chooser(("None","do nothing about it."),
                        ("PageByPage","use the text orientation of each page."),
                        ("All","use the overall document text orientation for all pages.")),left=12)

        self.opt_LockDistillerParams=IndentedCheckButton("Enforce all settings, even if the PostScript file tries to override them.")
        
        self.opts_row_basic=VRow(self.opts_row_basedon,self.opt_LockDistillerParams)
        self.opts_row_fileprop=VRow(self.opt_CompatibilityLevel,self.opt_CompressPages,self.opt_ASCII85EncodePages,self.opt_AutoRotatePages)
        
        self.pack_start(self.opts_frame_basic,False,False,0)
        self.pack_start(self.opts_frame_fileprop,False,False,0)

        self.opts_frame_fileprop.add(self.opts_row_fileprop)
        self.opts_frame_basic.add(self.opts_row_basic)

        self.opts_row_basedon.show()
        self.opts_row_basic.show()
        self.opts_frame_basic.show()
        self.opts_row_fileprop.show()
        self.opts_frame_fileprop.show()
        self.opt_LockDistillerParams.show()
        
class MoonshinerTab_Images(MoonshinerTab):
    def __init__(self):
        MoonshinerTab.__init__(self,"Images")
        
        self.opts_frame_color=HIGFrame("Color images")
        self.opts_frame_gray=HIGFrame("Grayscale images")
        self.opts_frame_mono=HIGFrame("Monochrome images")
        
        
        self.opt_ColorImageCompression=HRow("Color image compression: ",
                Chooser(("None","No compression"),
                        ("DCTEncode","JPEG compression"),
                        ("FlateEncode","ZIP compression"),
                        ("Auto","Choose JPEG/ZIP based on image contents")),left=12)
        self.opt__ColorImageJpegQuality= HRow("Quality of JPEG compressed color images: ",
                Chooser(("0.15","Maximum"),
                        ("0.25","Very High"),
                        ("0.4","High"),
                        ("0.76","Medium"),
                        ("0.9","Low"),
                        ("1.2","Very low"),
                        ("1.5","Minimum")),left=12)
        self.opt_ColorImageDownsampling=HRow(gtk.CheckButton("Downsample color images")," to ",IntEntry(9,2400)," dpi if the image has at least ",IntEntry(100,1000),
                        " percent of this.",left=12)
        self.opt_GrayImageCompression=HRow("Grayscale image compression: ",
                Chooser(("None","No compression"),
                        ("DCTEncode","JPEG compression"),
                        ("FlateEncode","ZIP compression"),
                        ("Auto","Choose JPEG/ZIP based on image contents")),left=12)
        self.opt__GrayImageJpegQuality= HRow("Quality of JPEG compressed grayscale images: ",
                Chooser(("0.15","Maximum"),
                        ("0.25","Very High"),
                        ("0.4","High"),
                        ("0.76","Medium"),
                        ("0.9","Low"),
                        ("1.2","Very low"),
                        ("1.5","Minimum")),left=12)
        self.opt_GrayImageDownsampling=HRow(gtk.CheckButton("Downsample grayscale images")," to ",IntEntry(9,2400)," dpi if the image has at least ",IntEntry(100,1000),
                        " percent of this.",left=12)
        self.opt_MonoImageCompression=HRow("Monochrome image compression: ",
                Chooser(("None","No compression"),
                        ("CCITTFaxEncode","CCITT fax encoding"),
                        ("FlateEncode","ZIP compression"),
                        ("RunLengthEncode","Run length encoding")),left=12)
        self.opt_MonoImageDownsampling=HRow(gtk.CheckButton("Downsample monochrome images")," to ",IntEntry(9,2400)," dpi if the image has at least ",IntEntry(100,1000),
                        " percent of this.",left=12)

        self.opt_ColorImageDownsampling[0].connect("toggled",lambda x : [self.opt_ColorImageDownsampling[n+1].set_sensitive(x.get_active()) for n in xrange(5)] )
        self.opt_ColorImageDownsampling[0].set_active(True)
        
        self.opt_ColorImageCompression[1].connect("changed",lambda x : self.opt__ColorImageJpegQuality.set_sensitive(x.get() in ["DCTEncode","Auto"]))
        
        self.opt_GrayImageDownsampling[0].connect("toggled",lambda x : [self.opt_GrayImageDownsampling[n+1].set_sensitive(x.get_active()) for n in xrange(5)] )
        self.opt_GrayImageDownsampling[0].set_active(True)

        self.opt_GrayImageCompression[1].connect("changed",lambda x : self.opt__GrayImageJpegQuality.set_sensitive(x.get() in ["DCTEncode","Auto"]))

        self.opt_MonoImageDownsampling[0].connect("toggled",lambda x : [self.opt_MonoImageDownsampling[n+1].set_sensitive(x.get_active()) for n in xrange(5)] )
        self.opt_MonoImageDownsampling[0].set_active(True)

        self.opts_row_color=VRow(self.opt_ColorImageCompression,self.opt__ColorImageJpegQuality,self.opt_ColorImageDownsampling)
        self.opts_row_gray=VRow(self.opt_GrayImageCompression,self.opt__GrayImageJpegQuality,self.opt_GrayImageDownsampling)
        self.opts_row_mono=VRow(self.opt_MonoImageCompression,self.opt_MonoImageDownsampling)

        self.pack_start(self.opts_frame_color,False,False,0)
        self.pack_start(self.opts_frame_gray,False,False,0)
        self.pack_start(self.opts_frame_mono,False,False,0)
        
        self.opts_frame_color.add(self.opts_row_color)
        self.opts_frame_gray.add(self.opts_row_gray)
        self.opts_frame_mono.add(self.opts_row_mono)
        
        self.opts_row_color.show()
        self.opts_row_gray.show()
        self.opts_row_mono.show()
        
        self.opts_frame_color.show()
        self.opts_frame_gray.show()
        self.opts_frame_mono.show()

class MoonshinerTab_Color(MoonshinerTab):
    def __init__(self):
        MoonshinerTab.__init__(self,"Color")
        
        self.opts_frame_conversion=HIGFrame("Color conversion")
        self.opts_frame_preserve=HIGFrame("Passing settings from PS to PDF")

        self.opt_ColorConversionStrategy=HRow("Color conversion: ",
                Chooser(("UseDeviceIndependentColor","Convert to CIE (device independent)"),
                        ("CMYK","Convert to CMYK"),
                        ("sRGB","Convert to RGB"),
                        ("Gray","Convert to grayscale"),
                        ("LeaveColorUnchanged","No conversion")),left=12)
        self.opt_DefaultRenderingIntent=HRow("Default rendering intent: ",
                Chooser(("Default","Default"),
                        ("Perceptual","Perceptual"),
                        ("Saturation","Saturation"),
                        ("RelativeColorimetric","Relative colorimetric"),
                        ("AbsolutColorimetric","Absolute colorimetric")),left=12)
                        
        self.opt_PreserveOverprintSettings=IndentedCheckButton("Preserve overprint settings")
        self.opt_PreserveHalftoneInfo=IndentedCheckButton("Preserve halftone information")
        self.opt_UCRandBGInfo=IndentedCheckButton("Preserve undercolor removal (UCR) and black generation (BG) information")

        self.opt_ColorConversionStrategy[1].connect("changed", lambda x : self.opt_DefaultRenderingIntent.set_sensitive(x.get() != "LeaveColorUnchanged"))

        self.opts_row_conversion=VRow(self.opt_ColorConversionStrategy,self.opt_DefaultRenderingIntent)
        self.opts_row_preserve=VRow(self.opt_PreserveOverprintSettings,self.opt_PreserveHalftoneInfo,self.opt_UCRandBGInfo)
                        
        self.opts_frame_conversion.add(self.opts_row_conversion)
        self.opts_frame_preserve.add(self.opts_row_preserve)

        self.pack_start(self.opts_frame_conversion,False,False,0)
        self.pack_start(self.opts_frame_preserve,False,False,0)
        
        self.opts_row_preserve.show()
        self.opts_row_conversion.show()
        self.opts_frame_preserve.show()
        self.opts_frame_conversion.show()


class MoonshinerTab_Fonts(MoonshinerTab):
    def __init__(self):
        MoonshinerTab.__init__(self,"Fonts")
        
        self.opts_frame_embedding=HIGFrame("Font embedding")
        
        self.opt_EmbedAllFonts=IndentedCheckButton("Embed fonts")
        self.opt_FontSubsetting=HRow(gtk.CheckButton("Do not embed unused glyphs")," unless more then ",IntEntry(0,100)," percent of the font's glyphs are used.",left=12)
        self.opt__CompressFonts=IndentedCheckButton("Compress fonts")

        self.opt_EmbedAllFonts.connect("toggled",lambda x : [y.set_sensitive(x.get_active()) for y in (self.opt_FontSubsetting,self.opt__CompressFonts)] )
        self.opt_EmbedAllFonts.set_active(True)
        self.opt_FontSubsetting[0].connect("toggled",lambda x : [self.opt_FontSubsetting[n+1].set_sensitive(x.get_active()) for n in xrange(3)] )
        self.opt_FontSubsetting[0].set_active(True)
        
        self.opts_row_embedding=VRow(self.opt_EmbedAllFonts,self.opt_FontSubsetting,self.opt__CompressFonts)
        
        self.opts_frame_embedding.add(self.opts_row_embedding)
        self.pack_start(self.opts_frame_embedding,False,False,0)
        
        self.opts_row_embedding.show()
        self.opts_frame_embedding.show()
        
class MoonshinerTab_Encryption(MoonshinerTab):
    def version_changed_callback(self,widget,window,notebook):
        caller=notebook.tab_misc
        new=caller.opt_CompatibilityLevel[1].get()
        old=27-new # :-)
        if self.opt__Encrypt.get_active() and old == 14:
            dia=gtk.MessageDialog(window,gtk.DIALOG_MODAL,gtk.MESSAGE_WARNING,gtk.BUTTONS_YES_NO,
                        "Changing to PDF Version 1.3 might lose some encryption settings. Do it anyway?")
            no=dia.run() == gtk.RESPONSE_NO
            dia.destroy()
            if no:
                caller.opt_CompatibilityLevel[1].handler_block(notebook.version_change_handler_id)
                caller.opt_CompatibilityLevel[1].set(14)
                caller.opt_CompatibilityLevel[1].handler_unblock(notebook.version_change_handler_id)
        if caller.opt_CompatibilityLevel[1].get() == 13:
            self.opts_frame_restrictions14.hide()
            self.opts_frame_restrictions13.show()
        else:
            self.opts_frame_restrictions13.hide()
            self.opts_frame_restrictions14.show()
        params_to_ui(ui_to_params(notebook,old),notebook)


    def __init__(self,version):
        MoonshinerTab.__init__(self,"Encryption")
        
        self.opt__Encrypt=IndentedCheckButton("Encrypt the PDF File")
        
        self.opts_frame_encryption=HIGFrame("Encryption")
        self.opts_frame_passwords=HIGFrame("Passwords")
        self.opts_frame_restrictions14=HIGFrame("Restrictions")
        self.opts_frame_restrictions13=HIGFrame("Restrictions")
        
        
        self.opt_Passwords=VRow(HRow("Full-access password: ",gtk.Entry()," (required)",left=12),
                                HRow("Restricted access password: ",gtk.Entry()," (leave empty to allow access without password)",left=12))

        self.opt_Restrictions14=VRow(HRow("Printing: ",
                Chooser((4+2048,"Unrestricted printing"),
                        (4,"Only allow low-quality printing"),
                        (0,"Do not allow printing")),left=12),
                HRow("Modifying contents: ",
                Chooser((8+32+256,"Unrestricted modification"),
                        (32+256,"Only allow adding/modifying annotations and filling out forms"),
                        (256,"Only allow filling out forms"),
                        (0,"Do not allow modification")),left=12),
                HRow("Extracting text and graphics: ",
                Chooser((16+512,"Unrestricted extraction"),
                        (512,"Allow extraction for accessibility purposes only"),
                        (0,"Do not allow extraction")),left=12),
                IndentedCheckButton("Allow document assembly (inserting, deleting, rotating pages etc.)"))
                
        self.opt_Restrictions14[1][1].connect("changed",lambda x : self.opt_Restrictions14[3].set_sensitive(not x.get() & 8))

        self.opt_Restrictions13=VRow(IndentedCheckButton("Allow printing"),
                HRow("Modifying contents: ",
                Chooser((8+32,"Unrestricted modification"),
                        (32,"Only allow adding/modifying annotations and filling out forms"),
                        (0,"Do not allow modification")),left=12),
                IndentedCheckButton("Allow extraction of text and graphics"))


        self.opts_row_encryption=VRow(self.opts_frame_passwords,self.opts_frame_restrictions14,self.opts_frame_restrictions13,padding=10)
        self.opts_row_encryption.set_sensitive(False)

        self.opt__Encrypt.connect("toggled",lambda x : self.opts_row_encryption.set_sensitive(x.get_active()))
        self.opt__Encrypt.set_active(False)
        
        self.opts_frame_encryption.add(self.opt__Encrypt)
        self.opts_frame_passwords.add(self.opt_Passwords)
        self.opts_frame_restrictions14.add(self.opt_Restrictions14)
        self.opts_frame_restrictions13.add(self.opt_Restrictions13)
        
        self.pack_start(self.opts_frame_encryption,False,False,0)
        self.pack_start(self.opts_row_encryption,False,False,0)
        
        self.opt_Restrictions13.show()
        self.opt_Restrictions14.show()
        if version==13:
            self.opts_frame_restrictions14.hide()
        else:
            self.opts_frame_restrictions13.hide()
        self.opts_frame_encryption.show()
        self.opt_Passwords.show()
        self.opt__Encrypt.show()
        self.opts_row_encryption.show()
        

class MoonshinerTab_GSOutput(MoonshinerTab):
    def __init__(self):
        MoonshinerTab.__init__(self,"GhostScript Output")
        
        self.gs_frame=gtk.ScrolledWindow()
        self.gs_text=gtk.TextView()
        
        self.gs_text.set_wrap_mode(gtk.WRAP_WORD)
        
        self.gs_frame.set_policy(gtk.POLICY_AUTOMATIC,gtk.POLICY_AUTOMATIC)
        
        self.add(self.gs_frame)
        self.gs_frame.add(self.gs_text)
        
        self.gs_text.show()
        self.gs_frame.show()
        


class MoonshinerParameterTabs(gtk.Notebook):
    def __init__(self,window,params):
        gtk.Notebook.__init__(self)
        self.tab_misc = MoonshinerTab_Misc()
        self.tab_images = MoonshinerTab_Images()
        self.tab_color = MoonshinerTab_Color()
        self.tab_fonts = MoonshinerTab_Fonts()
        self.tab_encryption = MoonshinerTab_Encryption(params["CompatibilityLevel"])
        self.tab_gsoutput = MoonshinerTab_GSOutput()

        # the order of the folling three lines is essential
        self.basedon_change_handler_id=self.tab_misc.opts_row_basedon[1].connect("changed",self.tab_misc.basedon_changed_callback,window,self)
        self.version_change_handler_id=self.tab_misc.opt_CompatibilityLevel[1].connect("changed",self.tab_encryption.version_changed_callback,window,self)
        params_to_ui(params,self)

        self.tab_misc.append_to_notebook(self)
        self.tab_images.append_to_notebook(self)
        self.tab_color.append_to_notebook(self)
        self.tab_fonts.append_to_notebook(self)
        self.tab_encryption.append_to_notebook(self)
        self.tab_gsoutput.append_to_notebook(self)
        
        self.tab_misc.show()
        self.tab_images.show()
        self.tab_color.show()
        self.tab_fonts.show()
        self.tab_encryption.show()
        # tab_gsoutput is not shown until the user clicks "Go Moonshining"



class MoonshinerWindow(gtk.Window):

    def about_dialog(self,widget):
        dia=Moonshiner_AboutDialog()
        dia.run()
        dia.destroy()

    def uri_drop_callback(self,widget,context,x,y,data,info,time):
        uris=data.get_uris()
        for uri in uris:
            if uri.startswith("file://"):
                uri=unquote(uri[7:])
                if isfile(uri):
                    self.input_file=uri
                    if self.output_file is None: uri=dirname(uri)
                if isdir(uri):
                    if self.output_file is None:
                        if self.input_file is None:
                            fn="moonshiner_output.pdf"
                        else:
                            fn=basename(self.input_file)
                            if fn.endswith(".ps"): fn=fn[:-3]
                            fn+=".pdf"
                    else:
                        fn=basename(self.output_file)
                    self.output_file=join(uri,fn)
        self.show_file_names()

    def pipe_button_clicked(self,widget,which):
        if which == 0:
            self.input_file=None
        else:
            self.output_file=None
        self.show_file_names()

    def basename_changed(self,widget,event):
        fn=self.filebox[1][2].get_text().lstrip("/")        
        self.output_file=normpath(join(dirname(self.output_file),fn))
        self.show_file_names()
    
    def show_file_names(self):
        self.filebox[0][1].set_text(self.input_file if self.input_file is not None else "Standard input")
        if self.output_file is not None:
            self.filebox[1][1].set_text(dirname(self.output_file)+"/")
            self.filebox[1][2].set_text(basename(self.output_file))
            self.filebox[1][2].show()
        else:
            self.filebox[1][2].hide()
            self.filebox[1][1].set_text("Standard output")

    def __init__(self,params):
        gtk.Window.__init__(self,gtk.WINDOW_TOPLEVEL)

        # These shouldn't belong to the window... oh well. None means stdin / stdout
        self.input_file=None
        self.output_file=None

        self.connect("delete_event",lambda x, y : False)
        self.connect("destroy",lambda x : gtk.main_quit())

        self.set_title("Moonshiner v"+version)
        self.set_border_width(5)
        
        self.set_icon(icon.get_pixbuf())
        
        self.vbox = gtk.VBox(False,5)
        self.header=HRow(logo,right_to_left=True,padding=12)
        self.filebox=VRow(HRow("Input File: ","",left=7),
                          HRow("Output File: ","",gtk.Entry(),left=7),
                          gtk.HSeparator(),
                          HRow("Drag and drop input file and output directory onto the window or",left=7),
            HRow(gtk.Button("Use standard input")," / ",gtk.Button("Use standard output"),left=7),padding=5)
        self.filebox[4][0].connect("clicked",self.pipe_button_clicked,0)
        self.filebox[4][2].connect("clicked",self.pipe_button_clicked,1)
        self.filebox.set_border_width(6)
        self.filebox[1][2].set_width_chars(20)
        self.filebox[1][2].connect("focus-out-event",self.basename_changed)
        self.show_file_names()
        self.buttons=HRow(gtk.CheckButton("Quit if successful"),gtk.Button(" Go Moonshining! "),right_to_left=True)
        self.buttons[0].set_active(False)
        self.buttons[1].connect("clicked",go,self)

        self.leftbuttons=HRow(gtk.Button("Help"),gtk.Button("About"),gtk.Button("Configure"),gtk.Button("Quit"))
        self.leftbuttons[3].connect("clicked",lambda x : self.destroy())
        self.leftbuttons[2].connect("clicked",lambda x : settings_dialog(self))
        self.leftbuttons[1].connect("clicked",self.about_dialog)
        self.leftbuttons[0].connect("clicked",lambda x : webopen("file://"+helpfile))

        self.buttons.pack_start(self.leftbuttons)
        
        self.file_outer_frame=gtk.Frame()
        self.file_frame=HIGFrame("Input and Output")
        self.file_frame.add(self.filebox)
        self.file_frame.set_border_width(13)
        self.file_outer_frame.add(self.file_frame)

        self.parametertabs = MoonshinerParameterTabs(self,params)

        self.add(self.vbox)

        self.header.pack_start(self.file_outer_frame)
        self.vbox.pack_start(self.header,False,False,0)
        self.vbox.pack_start(self.parametertabs,True,True,0)
        self.vbox.pack_start(self.buttons,False,False,0)
        
        self.drag_dest_set(gtk.DEST_DEFAULT_ALL,[],gtk.gdk.ACTION_COPY)
        self.drag_dest_add_uri_targets()
        self.connect("drag-data-received",self.uri_drop_callback)
        
        self.filebox.show()
        self.file_outer_frame.show()
        self.file_frame.show()
        self.header.show()
        self.parametertabs.show()
        self.buttons.show()
        self.leftbuttons.show()
        self.vbox.show()
        
        
