# -*- coding: utf-8 -*-

#   This file is part of Moonshiner.
#   Copyright 2008, 2009 Benjamin Dumke
#
#   Moonshiner is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   Moonshiner is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with Moonshiner (see the file LICENSE).  If not, see
#   <http://www.gnu.org/licenses/>.

import pygtk
pygtk.require("2.0")
import gtk

from moonshiner_params import params_to_command,ui_to_params
from subprocess import Popen,PIPE
from sys import stdout
from os.path import exists
from time import sleep

def go(button,window):
    to_stdout=window.output_file is None
    params=ui_to_params(window.parametertabs)
    cmd=params_to_command(params)
    cmd.insert(1,"-sOutputFile="+ ("-" if to_stdout else window.output_file))
    cmd+=["-" if window.input_file is None else window.input_file]
    doit=True
    if params["_Encrypt"] and params["_OwnerPassword"]=="":
        window.parametertabs.set_current_page(4)
        dia=gtk.MessageDialog(window,gtk.DIALOG_MODAL,gtk.MESSAGE_ERROR,gtk.BUTTONS_OK,
                        "A full-access password is required for encrypted documents.")
        dia.run()
        dia.destroy()
        return
    if window.output_file is not None and exists(window.output_file):
        dia=gtk.MessageDialog(window,gtk.DIALOG_MODAL,gtk.MESSAGE_WARNING,gtk.BUTTONS_YES_NO,
                        "The output file already exists. Overwrite it?")
        doit=dia.run() == gtk.RESPONSE_YES
        dia.destroy()
    if doit:
        window.parametertabs.tab_gsoutput.show()
        window.parametertabs.set_current_page(-1)
        buf=window.parametertabs.tab_gsoutput.gs_text.get_buffer()
        cmd_string=""
        for c in cmd:
            if " " in c:
                c="\""+c+"\""
            cmd_string+=c+" "
        buf.insert(buf.get_end_iter(),"\n------------\nInvoking Ghostscript:\n------------\n\n"+cmd_string+"\n\n"+
                    "------------\nGhostscript Output:\n------------\n\n")

        gtk.main_iteration(False)
        try:
            p=Popen(cmd,stderr=PIPE,stdout=PIPE)
        except OSError:
            dia=gtk.MessageDialog(window,gtk.DIALOG_MODAL,gtk.MESSAGE_ERROR,gtk.BUTTONS_OK,
                            "Could not launch Ghostscript. Please check if Ghostscript is installed on your system "
                            "and that the Ghostscript executable is properly set in the configuration dialog.")
            dia.run()
            dia.destroy()
            buf.insert(buf.get_end_iter(),"\n------------\nGhostscript could not be launched\n------------\n\n")
            return
        # Unfortunately, GS sends most of its error messages to stdout, so we have to do some filtering
        in_pdf = False
        read_so_far = ""
        window.buttons.set_sensitive(False)
        while p.poll() is None:
            if to_stdout:
                s_out=p.stdout.read(65536)
                if not in_pdf:
                    read_so_far += s_out
                    i=read_so_far.find("%PDF-1")
                    if i>=0:
                        buf.insert(buf.get_end_iter(),read_so_far[:i])
                        s_out=read_so_far[i:]
                        in_pdf = True
                if in_pdf:
                    stdout.write(s_out)

            if not to_stdout:
                sleep(.5)
            while gtk.events_pending():
                gtk.main_iteration()
            
        window.buttons.set_sensitive(True)
        if not to_stdout:
            buf.insert(buf.get_end_iter(),p.stdout.read())
        buf.insert(buf.get_end_iter(),p.stderr.read())
        returncode=p.poll()
        buf.insert(buf.get_end_iter(),"\n------------\nGhostscript returned "+str(returncode)+ \
                        ( " (success)" if not returncode else " (failure)" )+"\n------------\n\n")
        gtk.main_iteration(False)
        v=window.parametertabs.tab_gsoutput.gs_frame.get_vadjustment()
        v.set_value(v.upper) # FIXME: this doesn't seem to work
        v.value_changed()
        if p.poll() == 0 and window.buttons[0].get_active(): # (Quit if succesful)
            gtk.main_quit()
