# -*- coding: utf-8 -*-

#   This file is part of Moonshiner.
#   Copyright 2008, 2009 Benjamin Dumke
#
#   Moonshiner is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   Moonshiner is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with Moonshiner (see the file LICENSE).  If not, see
#   <http://www.gnu.org/licenses/>.

import pygtk
pygtk.require("2.0")
import gtk
from ConfigParser import SafeConfigParser,ParsingError
from os.path import expanduser
from sys import stderr
from moonshiner_ui_tools import HRow,VRow,Chooser

defaults = {"ghostscript_exec" : "gs",
            "default_preset" : "default"}

settings = defaults

def load_settings():
    global settings
    cp = SafeConfigParser(defaults)
    try:
        cp.read(expanduser("~/.moonshiner.conf"))
    except ParsingError , err:
        stderr.write(err.__class__.__name__+" while parsing configuration file. Continuing anyway...")
    settings=dict(cp.items("DEFAULT"))

def save_settings():
    cp = SafeConfigParser(settings)
    f = open(expanduser("~/.moonshiner.conf"),"w")
    cp.write(f)
    f.close()    

def get_settings():
    return settings

def settings_dialog(window):
    global settings
    dia=gtk.Dialog("Moonshiner Configuration",window,gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
                    (gtk.STOCK_CANCEL, gtk.RESPONSE_REJECT,gtk.STOCK_OK, gtk.RESPONSE_ACCEPT))

    config_row=VRow(HRow("Ghostscript executable: ",gtk.Entry()),
                    HRow("Default preset: ",
                         Chooser(("default","default (multi-purpose)"),
                                ("screen","screen (low-res for on-screen viewing)"),
                                ("ebook","ebook (medium-res for on-screen viewing)"),
                                ("printer","printer (for printing, copying etc.)"),
                                ("prepress","prepress (high quality output for offset print etc.)"))))
                                
    config_row[0][1].set_text(settings["ghostscript_exec"])
    try:
        config_row[1][1].set(settings["default_preset"])
    except ValueError:
        config_row[1][1].set("default")
        
    config_row.set_border_width(5)
    dia.vbox.pack_start(config_row,False,False,0)
    config_row.show()
    resp=dia.run()
    if resp==gtk.RESPONSE_ACCEPT:
        settings={ "ghostscript_exec" : config_row[0][1].get_text(),
                   "default_preset" : config_row[1][1].get() }
        save_settings()
    dia.destroy()
    

load_settings()

