/*
 * $Id$
 *
 * Test program for mr_stresc
 * Can be used on host system with valgrind easier than with mondorestore
 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <dirent.h>
#include "mr_sys.h"

void (*mr_cleanup)(void) = NULL;

#define TEMPDIR "/tmp/test-mr_sys"

int main() {

	int i;
	DIR *d = NULL;

	i= mr_system("mkdir -p %s",TEMPDIR);
	if (i != 0) {
		printf("Unable to create the temp dir\n");
		exit(i);
	}
	d = opendir(TEMPDIR);
	if (d == NULL) {
		printf("temp dir not created\n");
		exit(-1);
	}
	closedir(d);
	i = rmdir(TEMPDIR);
	if (i != 0) {
		printf("Unable to remove the temp dir\n");
		exit(i);
	}

	exit(0);
}
