/*
 * $Id$
 *
 * Test program for mr_str_substitute
 * Can be used on host system with valgrind easier than with mondorestore
 */
#include <stdio.h>
#include <stdlib.h>
#include "mr_str.h"
#include "mr_mem.h"
#include "my-stuff.h"

/* Whether we should fail immediately at first error */
bool g_fail_immediately = FALSE;

void (*mr_cleanup)(void) = NULL;

char *strl[] = {
		"test with _ERR_",
		"test with CDROM",
		NULL
};

char *strlorg[] = {
		"_ERR_",
		"CDROM",
		NULL
};

char *strlsub[] = {
		"ERROR FOUND !",
		"which cdrom device do you want to use",
		NULL
};

int main() {

		char *p;
		int i;

		for (i = 0; strl[i] != NULL ; i++) {
			printf("Test %2d Original chain is %s\n",i,strl[i]);
			p = mr_str_substitute(strl[i], strlorg[i], strlsub[i]);
			printf("Test %2d Transformed chain (with \") is %s\n",i,p);
			mr_free(p);
		}
exit(0);
}
