/*
 * $Id$
 *
 * Code (c)2006-2016 Bruno Cornec <bruno@mondorescue.org>
 *
 *     Main file of mr_sys : a very small and simple
 *     library for system management
 *
 * Provided under the GPLv2
 */

#ifndef _GNU_SOURCE
#define _GNU_SOURCE
#endif

#include <stdio.h>
#include <stdlib.h>

#include "mr_err.h"
#include "mr_msg.h"
#include "mr_mem.h"

/*
 * Function that calls system in a sure way
 */
int mr_system_int(int line, const char *file, const char *fmt, ...) {

	char *cmd = NULL;
	int res = 0;
	va_list args;

	va_start(args,fmt);
	/*
	printf("Format : %s\n",fmt);
	*/
	res = vasprintf(&cmd, fmt, args);
	if (res == -1) {
		mr_msg_int(1,line,file,"mr_system_int","Unable to alloc memory in mr_system_int\nExiting...");
		mr_exit(-1,"Unable to alloc memory in mr_system_int");
	}
	/*
	printf("Command : %s\n",cmd);
	*/
	res = system(cmd);
	if (res < 0 ) {
		mr_msg(4, "Unable to execute %s",cmd);
	}
	mr_free(cmd);
	va_end(args);
	return(res);
}
