#!/bin/bash

# Note: git describe doesn't work if no tag is available
git_tag="$(git describe --dirty --always)"
git_hash="$(git rev-parse --short HEAD 2> /dev/null || echo unknown)"
git_files_are_clean=1
# Check if there are any modified files.
git diff --no-ext-diff --quiet --exit-code 2> /dev/null || git_files_are_clean=0
# Check if there are any staged files.
git diff-index --cached --quiet HEAD -- 2> /dev/null || git_files_are_clean=0
if [ "${git_files_are_clean}" != "1" ]; then
    git_hash="${git_hash}-dirty"
fi
cat <<EOF
// This file was generated by py/py-version.sh
#define MICROPY_GIT_TAG "${git_tag}"
#define MICROPY_GIT_HASH "${git_hash}"
#define MICROPY_BUILD_DATE "$(date '+%Y-%m-%d')"
EOF
