void pver();
void usage(const char *name);
void parse_opts(int *argc_p, char ***argv_p);
int ftype(const char *strtype);
void do_cmd(struct minix_fs_dat *fs, int argc, char **argv);
int main(int argc, char **argv);
unsigned long get_free_bit(u8 *bmap, int bsize);
struct minix_fs_dat *new_fs(const char *fn, int magic, unsigned long fsize, int inodes);
struct minix_fs_dat *open_fs(const char *fn, int chk);
struct minix_fs_dat *close_fs(struct minix_fs_dat *fs);
void fatalmsg(const char *s, ...);
void die(const char *s, ...);
FILE *goto_blk(FILE *fp, int blk);
void *dofwrite(FILE *fp, void *buff, int cnt);
void *dofread(FILE *fp, void *buff, int cnt);
void *domalloc(unsigned long size, int elm);
int dogetuid();
int dogetgid();
u32 ino2_zone(struct minix_fs_dat *fs, struct minix2_inode *ino, u32 blk);
int ino_zone(struct minix_fs_dat *fs, struct minix_inode *ino, int blk);
void ino2_setzone(struct minix_fs_dat *fs, struct minix2_inode *ino, u32 blk, u32 zone);
void ino_setzone(struct minix_fs_dat *fs, struct minix_inode *ino, int blk, int zone);
void ino2_freezone(struct minix_fs_dat *fs, struct minix2_inode *ino, u32 blk);
void ino_freezone(struct minix_fs_dat *fs, struct minix_inode *ino, int blk);
int read_inoblk(struct minix_fs_dat *fs, int inode, u32 blk, u8 *buf);
void write_inoblk(struct minix_fs_dat *fs, int inode, u32 blk, u8 *buf);
void free_inoblk(struct minix_fs_dat *fs, int inode, u32 blk);
void trunc_inode(struct minix_fs_dat *fs, int inode, u32 sz);
int find_inode(struct minix_fs_dat *fs, const char *path);
void set_inode(struct minix_fs_dat *fs, int inode, int mode, int nlinks, int uid, int gid, u32 size, u32 atime, u32 mtime, u32 ctime, int clr);
void clr_inode(struct minix_fs_dat *fs, int inode);
void parse_mkfs(int argc, char **argv, int *magic_p, int *nblks_p, int *inodes_p);
void cmd_mkfs(int argc, char **argv);
void cmd_genfs(int argc, char **argv);
void outent(FILE *fp, const char *dp, int namlen);
void dodir(struct minix_fs_dat *fs, const char *path);
void cmd_dir(struct minix_fs_dat *fs, int argc, char **argv);
int domkdir(struct minix_fs_dat *fs, char *newdir);
void cmd_mkdir(struct minix_fs_dat *fs, int argc, char **argv);
void timefmt(FILE *fp, const char *str, u32 usecs);
void outmode(FILE *fp, int mode);
void dostat(struct minix_fs_dat *fs, const char *path);
void cmd_stat(struct minix_fs_dat *fs, int argc, char **argv);
void dormdir(struct minix_fs_dat *fs, const char *dir);
void cmd_rmdir(struct minix_fs_dat *fs, int argc, char **argv);
void dounlink(struct minix_fs_dat *fs, char *fpath);
void cmd_unlink(struct minix_fs_dat *fs, int argc, char **argv);
int readfile(struct minix_fs_dat *fs, FILE *fp, const char *path, int type, int ispipe);
void cmd_cat(struct minix_fs_dat *fs, int argc, char **argv);
void cmd_extract(struct minix_fs_dat *fs, int argc, char **argv);
void cmd_readlink(struct minix_fs_dat *fs, int argc, char **argv);
void writefile(struct minix_fs_dat *fs, FILE *fp, int inode);
void writedata(struct minix_fs_dat *fs, u8 *blk, u32 cnt, int inode);
void domklnk(struct minix_fs_dat *fs, char *target, char *lnknam);
void cmd_mklnk(struct minix_fs_dat *fs, int argc, char **argv);
void domkhlnk(struct minix_fs_dat *fs, char *target, char *lnknam);
void cmd_hardlnk(struct minix_fs_dat *fs, int argc, char **argv);
void cmd_mknode(struct minix_fs_dat *fs, int type, int argc, char **argv);
void cmd_add(struct minix_fs_dat *fs, int argc, char **argv);
int cmp_name(const char *lname, const char *dname, int nlen);
int ilookup_name(struct minix_fs_dat *fs, int inode, const char *lname, u32 *blkp, int *offp);
void dname_add(struct minix_fs_dat *fs, int dinode, const char *name, int inode);
void dname_rem(struct minix_fs_dat *fs, int dinode, const char *name);
int make_node(struct minix_fs_dat *fs, char *fpath, int mode, int uid, int gid, u32 size, u32 atime, u32 mtime, u32 ctime, int *dinode_p);
