# -*- coding: binary -*-
#
# frozen_string_literal: true

# A mixin used for providing Modules with post-exploitation options and helper methods
#
module Msf::OptionalSession
  include Msf::SessionCompatibility

  def initialize(info = {})
    super

    if framework.features.enabled?(Msf::FeatureManager::SMB_SESSION_TYPE)
      register_options(
        [
          Msf::OptInt.new('SESSION', [ false, 'The session to run this module on' ]),
          Msf::Opt::RHOST(nil, false),
          Msf::Opt::RPORT(nil, false)
        ]
      )
      add_info('New in Metasploit 6.4 - This module can target a %grnSESSION%clr or an %grnRHOST%clr')
    end

    if framework.features.enabled?(Msf::FeatureManager::MYSQL_SESSION_TYPE)
      register_options(
        [
          Msf::OptInt.new('SESSION', [ false, 'The session to run this module on' ]),
          Msf::Opt::RHOST(nil, false),
          Msf::Opt::RPORT(3306, false)
        ]
      )
      add_info('New in Metasploit 6.4 - This module can target a %grnSESSION%clr or an %grnRHOST%clr')
    end

    if framework.features.enabled?(Msf::FeatureManager::POSTGRESQL_SESSION_TYPE)
      register_options(
        [
          Msf::OptInt.new('SESSION', [ false, 'The session to run this module on' ]),
          Msf::OptString.new('DATABASE', [ false, 'The database to authenticate against', 'postgres']),
          Msf::OptString.new('USERNAME', [ false, 'The username to authenticate as', 'postgres']),
          Msf::Opt::RHOST(nil, false),
          Msf::Opt::RPORT(5432, false)
        ]
      )
      add_info('New in Metasploit 6.4 - This module can target a %grnSESSION%clr or an %grnRHOST%clr')
    end

    if framework.features.enabled?(Msf::FeatureManager::MSSQL_SESSION_TYPE)
      register_options(
        [
          Msf::OptInt.new('SESSION', [ false, 'The session to run this module on' ]),
          Msf::OptString.new('USERNAME', [ false, 'The username to authenticate as', 'MSSQL']),
          Msf::Opt::RHOST(nil, false),
          Msf::Opt::RPORT(1433, false)
        ]
      )
      add_info('New in Metasploit 6.4 - This module can target a %grnSESSION%clr or an %grnRHOST%clr')
    end
  end

  def session
    return nil unless (framework.features.enabled?(Msf::FeatureManager::SMB_SESSION_TYPE) || framework.features.enabled?(Msf::FeatureManager::POSTGRESQL_SESSION_TYPE) || framework.features.enabled?(Msf::FeatureManager::MYSQL_SESSION_TYPE) || framework.features.enabled?(Msf::FeatureManager::MSSQL_SESSION_TYPE))

    super
  end
end
