# -*- coding: binary -*-

module Msf::Exploit::Remote::HTTP::Gitlab::Rest::V4::Version
  # Extracts the Gitlab version information from various sources
  #
  # @return [String,nil] Gitlab version if found, nil otherwise
  def gitlab_version
    res = send_request_cgi({
      'method' => 'GET',
      'uri' => normalize_uri(target_uri.path, '/api/v4/version'),
      'keep_cookies' => true
    })
    raise Msf::Exploit::Remote::HTTP::Gitlab::Error::ClientError.new message: 'Request timed out' unless res
    raise Msf::Exploit::Remote::HTTP::Gitlab::Error::VersionError unless res.code == 200

    body = JSON.parse(res.body)
    version = body['version'][Regexp.new(Msf::Exploit::Remote::HTTP::Gitlab::GITLAB_VERSION_PATTERN), 1]

    return version if version

    nil
  end
end
