//************************************************************
//* All levels extract from: 
//* Lode Runner I (C64) DISK IMAGE
//* by Simon Hung 2015/01/05
//************************************************************

var proData = [
//======<<< Level 001 >>>======

"0             &            0" +
"#S###########  ###########S#" +
"HHHHHHHHHHHHHHHHHHHHHHHHHHHH" +
"$HH   HHH    HH   HHH    HH$" +
"$HH H  HH HH HH H  HH HH HH$" +
"$HH HH HH HH HH HH HH HH HH$" +
"$HH H  HH HH HH H  HH HH HH$" +
"$HH   HHH    HH   HHH    HH$" +
"$HHHHHHHHHHHHHHHHHHHHHHHHHH$" +
"$HHHHHHHHHHHHHHHHHHHHHHHHHH$" +
"$HH    HH    HH    H     HH$" +
"$HH HHHHH HH HH HHHHHH HHHH$" +
"$HH    HH HH HH   HHHH HHHH$" +
"$HHHHH HH HH HH HHHHHH HHHH$" +
"$HH    HH    HH HHHHHH HHHH$" +
"HHHHHHHHHHHHHHHHHHHHHHHHHHHH",

//======<<< Level 002 >>>======

"           SSSSSSS          " +
"         SSSS               " +
"        SSSS                " +
"H------ H           &       " +
"H      #H     H@##########  " +
"H      #H     H@#########   " +
"H      #H    H@@##    ##    " +
"H      ## 0 H@@##$    $#    " +
"H    @@##@@@X@###      #    " +
"H   @#HHHHHHHHH#########    " +
"H   @#$       $#########    " +
"H   @#X#################$   " +
"H 0@@#X###########$$$$$###X " +
"H @@@@$$$@$$$@@@@@ $$$ @@$  " +
"H      $   $        $      0" +
"############################",

//======<<< Level 003 >>>======

"S@@@@@@@@@@@@@@@@@@@@@@@@@@@" +
"S $    @@@@@ -  @  ---    @@" +
"####H#$  -  -0H @ H   H@@$$$" +
"@@@@H##H@$@H  H   H   H@@###" +
"@@@ H$$H@$@H  H- -H    @@###" +
"@@ -@##@@$@ -0  H      @ @#X" +
"@ - @   @$@H ####     -  $  " +
" - @@@#H@$@$H     #H## @ @H " +
"$ @   #H@$@H$ $$$$$H$$@@ $H " +
"# @   #H@$@$H #H######@@H@  " +
" -@   #H@$@H$ $H  $  $@@H$  " +
"##@   #H@$@$H ######H#@@ @H " +
"H@   $#H@$@H$ $   $ H @@ $H " +
"H######H@$@$H ##### H @ H@  " +
"H      H   H &     H#######H" +
"#@#@#@#@#@#@#@#@#@#H$$$$$$X ",

//======<<< Level 004 >>>======

"@@@@@@@@@@@@@@@@@@@@@@@@@@@S" +
"$ @  00$ $  &   $ $00  @ $ S" +
"@H@@@@@@ @@@@@@@@ @@@@@@H@@$" +
" H                      H @$" +
"$H     $ $      $ $     H$@$" +
"######H# ######H# ######H#@$" +
"$     H$ $     H$ $     H$@$" +
"#H###### #H###### #H######@$" +
"$H     $ $H     $ $H     $@$" +
"######H# ######H# ######H#@$" +
"$     H$ $     H$ $     H$@$" +
"#H###### #H###### #H######@$" +
"$H     $ $H     $ $H     $@$" +
"######H# ######## ######H#@$" +
"      H                 H   " +
"#@#@#@#@#@#@#@#@#@#@#@#@#@#@",

//======<<< Level 005 >>>======

"                            " +
"$           0S0            $" +
"#@#@H@#@#@#@#@#@#@#@#@#H#@#@" +
"    H$       $        $H    " +
"#######H#######H###########H" +
"$ @ $ @H $    @H $         H" +
"#@##@##@##@##@##@##H##@##@##" +
" $   @ $   @$      H   @   $" +
"@#@@H@@#@@#@@#@@H@@#@@H@@#@@" +
"$  @H    @ $ @$@H    @H     " +
"#@#@#@H@#@#@#@H@#@#@H@#@#@#H" +
"$     H   @  &H  @  H@  $  H" +
"#########H########H#########" +
"         H        H         " +
"         H        H         " +
"$$$$H##@##@##@##@##@##@H$$$$",

//======<<< Level 006 >>>======

"   -    -    -    -    -    " +
"H@@0@@@@0@@@@&@@@@0@@@@0@@@H" +
"H                          H" +
"H  ---------------------   H" +
"H                          H" +
"H              $           H" +
"H               $          H" +
"H      ###########         H" +
"H     #     #     -        H" +
"H    #      #     $-       H" +
"H   # ---------------###   H" +
"H  ##   ##########   ####$ H" +
"H ### $ ########## $ ##### H" +
"H    $$$          $$$      H" +
"H     $            $       H" +
"############################",

//======<<< Level 007 >>>======

"             S              " +
"             S              " +
" 0 $---------S----------$ 0 " +
"H###     $$$ S $$$      ###H" +
"H $     $###$S$###$      $ H" +
"H##    $X   #$#   X$     ##H" +
"H $    #     X     #     $ H" +
"H##    #$         $#     ##H" +
"H  $    #$       $#     $  H" +
"H###     #$     $#      ###H" +
"H   $     #$   $#      $   H" +
"H####      #$ $#       ####H" +
"H    $      #$#       $    H" +
"H#####       X        #####H" +
"H0           &            0H" +
"############################",

//======<<< Level 008 >>>======

"                           S" +
" ------------------------- S" +
"H  $       $       $      #$" +
"H ###  -  ###  -  ###  -  ##" +
"H     - H     - H     - H   " +
"H    0  H    0  H    0  H   " +
"######  ######  ######  ###H" +
"$                      H   H" +
"####       H##########H ####" +
"$   ##H -- H           HH   " +
"H##   H@$$@ #####H###### H  " +
"H  ######## #####H        H " +
"H           ##$##H   &   H  " +
"#######H#########H#######   " +
"       H      ---H#$$$$$H## " +
"$H###########H$$$H$#######H$",

//======<<< Level 009 >>>======

"             HH----HHHHH####" +
"            H##H---H$$ H####" +
"           H####H   HH$H H H" +
"          H######H    HH$H$H" +
"          H######H     HHHHH" +
"          H#@#@#@H     H H H" +
"          H$@#@#$H     H H H" +
"          H#@#@#@H     H$H$H" +
"$---------H#@#@#@H     HHHHH" +
"H$        H$@#@#$H     H H H" +
"#H$       H#@#@#@H     H H H" +
"##H$      H#@#@#@H     H$H$H" +
"###H$     H$####$H     HHHHH" +
"####H$    H######H     H H H" +
"#####H$  H@# #@ #@H   &H$H$H" +
"######H 0H@# #@ #@H0 H######",

//======<<< Level 010 >>>======

"#####S######################" +
"    #S# ------ # ---------- " +
"S##S S# ######S# @  $   $  H" +
"S ##### #    #S# @ ### ### H" +
"#S     -#S##S S# @  $   $  H" +
"####### #S ##### @ ### ### H" +
"0     $ ##S $   -@ 0$   $0 H" +
"H###### ######## @ ### ### H" +
"H--------------------------H" +
"H $H $H $H  @HHHHHHHHH@ -$ H" +
"H H$ H$ H$  @HH@@@@@HH@ $- H" +
"H $H $H $H  @HHHHHHHHH@ -$ H" +
"H H$ H$ H$       $      $- H" +
"H $H $H $H   @#@#@#@#@  -$ H" +
"H H$ H$ H$ &-    -    -  - H" +
"###########H$H##H$H##H$H####",

//======<<< Level 011 >>>======

"S                           " +
"S                           " +
"S#@@############@H00 $      " +
"SX@@ ---------- @##########H" +
"S $@ $$$       H@     $    H" +
"S#@@ $$$ ##### H@H##########" +
"SX@@ $$$ ##$## H@H   $      " +
"S $@     ##### H@##########H" +
"S#@@           H@     $    H" +
"SX@@ ----  $  -H@H##########" +
"S $@H    #@#@#  @H   $      " +
"S#@@H --        @##########H" +
"SX@@H@$$@H  $$  @     $    H" +
"S $@H##### #### @H##########" +
"S##@H         00@H   $     &" +
"S#X H########### H##########",

//======<<< Level 012 >>>======

"          00                " +
"X##########################H" +
"$# - #####################@H" +
"$#H#$# - #################@H" +
"$#H#$#H#$# - #############@H" +
"$#H#$#H#$#H#$# - #########@H" +
"$#H#$#H#$#H#$#H#$# - #####@H" +
"$#H#$#H#$#H#$#H#$#H#$# - #@H" +
"$#H#$#H#$#H#$#H#$#H#$#H#$ @H" +
"$#H#$#H#$#H#$#H#$#H#$#H##H@H" +
"$#H#$#H#$#H#$#H#$#H#  H##H@H" +
"$#H#$#H#$#H#$#H#  H#### HH@H" +
"$#H#$#H#$#H#  H####@@@ H@@@H" +
"$#H#$#H#  H########   H@H @H" +
"$#H#  H############0$   H#@H" +
"  H#####################H#&H",

//======<<< Level 013 >>>======

"             @#0 $  &  @    " +
"S@   -       @####X##X#@    " +
"S@###$@H $   @@@@ # @@@@    " +
"S@$###@H HXH$-    ---------$" +
"S@###$@H HXHH -          - H" +
"S@$###@H H  H  -        -  H" +
"S@###$@H H- H   -      -   H" +
//"S@$###@H-H  H    -    -    H" +
"S@$###@H-H  H    --  --    H" + //modified for this platform
"S@####@H    H     -  -     H" +
"S        -- H   $ ----   $ H" +
"H#@#@#@H#$$#H@#@@  --  @@#@H" +
"H      H@##@H      --      H" +
"H0    0H    H      --      H" +
"X@@@@@@@ $$ H   $  --    $ H" +
"X$$$$$$@    H      --      H" +
"#@#@#@#-----H####  --  H###H",

//======<<< Level 014 >>>======

"S                           " +
"S#           @@@@@@@@@@@@@@ " +
"S#  -H       @@@@#@#@#@@@$H " +
"S# #- H        H      0 @@H " +
"S# #- H  H   --H####### @HH " +
"S-S#-  H@H X#X H-       @H  " +
" #S#-   $H X$X H -     --H  " +
" #S$   H@H XXX H  -   -&  # " +
" #S#    $H  -  H   - -    #X" +
" @@    H@HX#X  H    -       " +
"       H@HX$X  H     -      " +
"   ##X H@HXXX  H      -     " +
"    $  H@H -   H       -    " +
" H@@@X@H@H-    H            " +
" H@@@@@H@H0    H           $" +
" H     H@##############S####",

//======<<< Level 015 >>>======

"@          @ SS @          @" +
"@   $  $   @ SS @   $  $   @" +
"@@@@@XX@@@@@S  S@@@@@XX@@@@@" +
"H------  --  SS  -@  $$$$$$$" +
"H $#$   $H $ SS   @ H@@@@@@@" +
"H#X#X###H  $S  S  @ H$$$$$  " +
"H$X#X$     S    S @@@@@@@@H " +
"H# #X#X  @0$     &@   $$$$H " +
"H###X#X  ####X##### HH@@@@@@" +
"H  --H  -H--------HH ----  $" +
"@@@  H - H   $$   H      @@@" +
" -H  H-  H   $$   H      H- " +
"$H   -    H      H    -   H$" +
"H  @@      H    H    - @@  H" +
"H   0       H  H       0   H" +
"H$###########X############$H",

//======<<< Level 016 >>>======

"                            " +
"S   -- @   @ -            - " +
"S# #- H@H@H@HX###########H $" +
"S# #- H$H@H$HX           H $" +
"S#$#- ###@###X##########@H $" +
"S###- $    00X           H $" +
"S# $  H######XH@@@@@@@@H@H $" +
"S# #  H     $XH@      @H@H $" +
"S@X@  ######HXH@#@@@@H@H@H $" +
"S  @  $     HXH@$   @H@H@H $" +
" @@@  H######XH      H@H@H $" +
"      H     $X@@@@@@@@@H@H $" +
" -----######H          H H $" +
" $$$$$      HH@@@@@@@@@@@H $" +
"            HH&         0H  " +
" ###########HH###########H##",

//======<<< Level 017 >>>======

"             @@             " +
"S        $ @X  X@ $        S" +
"S      $ @#  00  #@ $      S" +
"S    $ @# -------- #@ $    S" +
"S  $ @#   $       H  #@ $  S" +
"S$ @@###X###X#####HH###@@ $S" +
"S@@-------#  $   # H#----@@S" +
"S#        # $$$  @H @     #S" +
"S# $      H------@ H@   $ #S" +
"S# $$     H      HH H  $$$#S" +
"S#H###########X##########H#S" +
"S#H     #-------------#  H#S" +
"S#H     #             #  H#S" +
"S#H     #             #  H#S" +
"SHH$    H   $  &  $   H  HHS" +
"############################",

//======<<< Level 018 >>>======

"        S          S        " +
"       $S          S$       " +
"H@@@@@@@@  H@HH@H  @@@@@@@@H" +
"H         #H@HH@H#         H" +
"@@@@@@@@@@@H@HH@H@@@@@@@@@@@" +
"$          H@HH@H          $" +
"############@HH@############" +
"- -    0    -HH-    0    - -" +
"$H$@#######@$HH$@#######@$H$" +
" H @  ###  @ HH @  ###  @ H " +
" H @  ###  @ HH @  ###  @ H " +
" H @###$###@ HH @###$###@ H " +
" H @  ###  @ HH @  ###  @ H " +
" H $-H---H-$ HH $-H---H-$ H " +
" H # H $ H #&HH # H $ H # H " +
"############################",

//======<<< Level 019 >>>======

"#$H 0#H###H#$H  #H###H#$H 0#" +
"###H#$H  #H###H#$H  #H###H#$" +
" $#H###H#$H  #H###H#$H  #H##" +
"H#$H  #H###H#$H  #H###H#$H  " +
"H###H#$H  #H###H#$H  #H###H#" +
"H $#H###H#$H  #H###H#$H  #H#" +
"#H#$H  #H###H#$H  #H###H#$H " +
"#H###H#$H  #H###H#$H  #H###H" +
"$H  #H###H#$H  #H###H#$H  #H" +
"##H#$H  #H###H#$H  #H###H#$H" +
"$#H###H#$H  #H###H#$H  #H###" +
"X$H  #H###H#$H  #H###H#$H  #" +
"###H#$H  #H###H#$H  #H###H#$" +
" $#H###H#$H  #H###H#$H  #H##" +
"H#$H  #H###H#$H &#H###H#$H  " +
"############################",

//======<<< Level 020 >>>======

"              S      0      " +
"-&  ----     S-S     $SSSSS$" +
" #X##X 0#####HS#   # S#   #H" +
"     X  #   #HS#   #  #   #H" +
" $$$ X  #   #HS#   #  #-  #H" +
" $$$ X  #   #HS#   #  # - #H" +
" $$$ X  #   #HS#$$$#  ## -#H" +
" $$$ X  #   #HS#####  # # #H" +
" $$$ X  #   #HS#####  #-$##H" +
" $$$ X  #   #HS# $ #  # -$#H" +
" -   X  #   #HS#   #  #  -#H" +
"$    X  # $$#HS#   #  #   #H" +
"     X  #0$$#HS#   #  #   #H" +
" ####X  #####HS#   #  #   #H" +
"             HS            H" +
"@@#@@#@#HXH##HS######X#####H",

//======<<< Level 021 >>>======

"S#00$$$$$$$$$$$$$$$$$$$$$$$#" +
"S#########################H#" +
"S#$$$$$$$$$$$$$$$$$$$$$$$$H#" +
"S#@@@#@#@#@###############H#" +
"S#$$$$$$$$$$$$$$$$$$$$$$$$H#" +
"S#########################H#" +
"S#$$$$$$$$$$$$$$$$$$$$$$$&H#" +
"S#H#########################" +
"S#H$$$$$$$$$$$$$$$$$$$$$$$$#" +
"S#H###########@#@#@#@#@@@@@#" +
"S#H$$$$$$$$$$$$$$$$$$$$$$$$#" +
"S#H#########################" +
"S#H$$$$$$$$$$$$$$$$$$$$$$$$#" +
"S#########################H#" +
"S000$$$$$$$$$$$$$$$$$$$$$$H#" +
"############################",

//======<<< Level 022 >>>======

"0 - H--$--    0------------H" +
"SH -H  @  -   H  ----------H" +
"HS  -  @ H -  H  $  $  $  $ " +
"SH   - @ H- - H  ----------H" +
"HS ## -  H - -H-H         -H" +
"SH ##  - H  - - H-----H  H-X" +
"HS $$   -H   - -H  $ $H $H $" +
"SH     - $ $ $ $  H---H--H-#" +
"HS -  -           H      H  " +
"SH $ -########H##########X--" +
"HS  -     $ H H  $       - -" +
"SH -    $ H H-H ###    -- - " +
"HS $    H H-H $  $   --    H" +
"SH      H-H $   ###-- &    H" +
"HS      H $           @@H###" +
"####################H   H##$",

//======<<< Level 023 >>>======

"#######HH----------HH#######" +
"######HH   -    -   HH######" +
"#####HH     #00#     HH#####" +
"####HH    - #### -    HH####" +
"###HH    - ###### -    HH###" +
"##HH----- ######## -----HH##" +
"#HH    - ####$$#### -    HH#" +
"HH      ############      HH" +
"#HH    - ####$$#### -    HH#" +
"##HH    - ######## -    HH##" +
"###HH    - ###### -    HH###" +
"####HH    - #### -    HH####" +
"#####HH    -    -    HH#####" +
"######HH            HH######" +
"#######HH0   &    0HH#######" +
"############################",

//======<<< Level 024 >>>======

"       HHH#-----------------" +
"      H$$$#SS   SS  H      0" +
"     H    #S S S    H      @" +
"    H     #SS  S S @H@$    @" +
"   H     $#S S SSS @H@XXXXX@" +
"  H     $# SS  $$$$@H@ $   @" +
" H      ###H   ####@H@XXXXX@" +
"H       ###H   ##& @H@  $  @" +
"H       # $ H  ####@H@XXXXX@" +
"HH      # # H   ##$@H@   $ @" +
"  H     # #H   ## $@H@XXXXX@" +
"   H    # #H  ##  $@H@    $@" +
"    HH $# #H ##   $@H@XXXXX@" +
"    0H    #H##$$$$$@H@     @" +
"####################H#####X#" +
"#$                 $H$    $@",

//======<<< Level 025 >>>======

"&     $ $      ------H     S" +
"@@@@@@@ #######H$$#  H     S" +
"  -----        H  #  H@@@@@@" +
" -   #H$$ $   $H$$#  H      " +
"-$  $#### ######### #######H" +
"-##### $$ $--------H       H" +
"-----# #####$ $ $$$H       H" +
" 0   # ######## H--H $  #  H" +
"X#####$ $   #H--H  ########H" +
" ########$  #H             H" +
"######### $$#H#     $ $    H" +
"$    $ ## H# H#H##### #####H" +
"######X## H#$H#H      0    H" +
" $    $## H#############H  H" +
"X#######H$H##$#$      $#H  H" +
"  $    $H##@#@#@#@#@#@#@#@#@",

//======<<< Level 026 >>>======

"                           H" +
"                     0     H" +
"  H#X#H     &H##############" +
"  H   H     $H              " +
"  H   H     $H  $ $ $ $     " +
"  H   H     $H $ $ $ $ $    " +
"  H$$ ###H  $H  $ $ $ $     " +
"  X##X 0 H  $H              " +
"  H$$H   H  $H##########X#H " +
"  H@@H   H  $H    0       H " +
"  H$$H   H  $H            H " +
"  H@@H   H  $H            H " +
"         H  $H            H " +
" -       H- $H            H " +
"  #  H###H H$H          $-H " +
"$#H##H$$#H X#XS         # H ",

//======<<< Level 027 >>>======

"  -  0--------------H       " +
"  @@##              H       " +
"                    H       " +
"     H---           H    H  " +
"     S      $    ---H-   H  " +
"#X   H      ##@@@   H @##H  " +
" H   S      $-      H    H  " +
"  S  H      $ -     H    H  " +
"  $  S      $ ---HH H    H  " +
"     H      $ H  $  H$   H  " +
"     H      $ H  S  H$   H  " +
"@##@S#$     $ H     H$   H  " +
"##  S   &---$-H     H$   H  " +
"      @     X@H     H$   H  " +
"------      $ H    $H$   H  " +
"             H#@#@X#@@   H  ",

//======<<< Level 028 >>>======

"            0              &" +
"S@@@@@@@  @@@@@@  @@@@@@  @@" +
"S@ $       --               " +
"S@ @@@@H --@###H##H##H##H##H" +
"S@$    H-  @0  H $H $H $H $H" +
"S@@  --    @###H########H##H" +
"S  --      @0  H $  $  $H $H" +
"S--        @H##############H" +
"S$@H#$   $# H  $    ###### H" +
"@H@H##   ## ######H ##### HH" +
"HX@H###X###    $  H #### HH#" +
"XH@H##   ## H###### $$# HH##" +
"HX@H#     # H       ## HH###" +
"XH@H#X###X########### HH####" +
"HX@H                 HH#####" +
"XH H##############H$HH######",

//======<<< Level 029 >>>======

"                            " +
"       0 ###H               " +
"      $#######H             " +
"     $##    ###H            " +
"     ##      ######H        " +
"     ##      #####HH        " +
"     ##           H         " +
"     ##          0H         " +
"     ##      #####H         " +
"     ##      ######H        " +
"      ##$  $###    H        " +
"       #######     H        " +
"        ####       H        " +
"                   H        " +
"&                  H       0" +
"############################",

//======<<< Level 030 >>>======

" $ H#H $ H#H $ H#H $ H#H $ H" +
"#H## ##H## ##H## ##H## ##H##" +
" H # # H # # H # # H # # H #" +
"H#H $ H#H $ H#H $ H#H $ H#H$" +
"# ##H## ##H##&##H## ##H## ##" +
"# # H # # H # # H # # H # # " +
" $ H#H $ H#H $ H#H $ H#H $ H" +
"#H## ##H## ##H## ##H## ##H##" +
" H # # H # # H # # H # # H #" +
"H#H $ H#H $ H#H $ H#H $ H#H$" +
"# ##H## ##H## ##H## ##H## ##" +
"# # H # # H # # H # # H # # " +
"0$ H#H $ H#H $ H#H $ H#H $0H" +
"#H## ##H## ##H## ##H## ##H##" +
" H # # H # # H # # H # # H #" +
"H#H $ H#H $ H#H $ H#H $ H#H$",

//======<<< Level 031 >>>======

"00    &    00---------------" +
"H###########H              $" +
"H#$       $#H$###########H#H" +
"H###########H@@@@@@@@@@@@XHX" +
"H-----------H $# $  # $ #HX$" +
"HXXXXXXXXXXXH#H#H#HH#H#H#X#H" +
"H           H#H$H#HH$H#H   H" +
"H#####H#####H#####H##H##H#H#" +
"H  @H@H@H$ @H     H$#H  H#H$" +
"H@H@H@H$H@H@H##H##########H#" +
"H@H$H@H@H@H$H  H $#       H " +
"H@H@H$H@H@H@H######H######H#" +
"H$H@H@H@H@H@H  #   H $#$  H " +
"H@H@H@H@H@H@H###H#########H#" +
"H$H H H H H$H   H         H " +
"H#H#H#H#H#H#H@#@#@#@#@#@#@#@",

//======<<< Level 032 >>>======

"   S           0           0" +
"   S    $             $$$---" +
"SSSSSSS ####H@ - H@ -H@@@@@ " +
"S     S     H@@H@@@@X@@@@---" +
"#H###H##H H#H  H$  $  $ @ @@" +
"0    H  #########H-#H-#H@--@" +
"##H H##          ------H$$ 0" +
"  H-H  H@#@#@#@#@      ####H" +
"##@ @##H    $&$   ####H####H" +
"##@ @##H@#@#@H@#@# ---H    H" +
"$$@ @$$H     H    H   ####H#" +
"#######HH#########H#$     H " +
"---    HH    ---  H #  H####" +
"   H########H   ###H # H   0" +
"   H   $$   H   $###H ###H#$" +
"$  H########H   #####H $ H#$",

//======<<< Level 033 >>>======

"           SS               " +
"     --    SS               " +
"    H  - @@SS@@             " +
"   H    #  SS  #         -H-" +
"  H     ########   -    - H " +
" H $    ###@@###  H -  $ H  " +
" H    $ #@#@@#@#  H  -   H  " +
"  H     # $@@$ #   H  - H   " +
"   H    #@####@#   H   -H  $" +
"    H               H      0" +
"    H    ------     H    H##" +
"   H    H@    @H     H  H##@" +
"  H $   H@@@@@@H     H H## $" +
" H      H      H    H#######" +
"0H     0H$ &  $H0   H      $" +
"############################",

//======<<< Level 034 >>>======

"                       S    " +
"@$   0                  S   " +
"@#@@@@@@@@@@@@@@H--     S   " +
"             $@ H  --    S  " +
" @@@@@@@@@@@@#@ H    --  S  " +
"H @$            H      -- S " +
"H @#@@@@@@@@@@  H        -S$" +
"H          $@ H H         @#" +
"H  @@@@@@@@#@ H H        H@ " +
"H H @$        H H       H@ $" +
"H H @#@@@@@@  H H      H@ #@" +
"H H      $@ H H H     H@ ##@" +
"H H  @@@@#@ H H H    H@@@# @" +
"H H H @$    H H H   H@@@@#@@" +
"H H H @#@@  H H H   H    0 $" +
"#####H0  &H#################",

//======<<< Level 035 >>>======

"0##########################0" +
"S#H---HHH---H  H---HHH---H#S" +
"S#H HH     HH##HH     HH H#S" +
"S#HH     HH H##H HH     HH#S" +
"S#H   HHH   H##H   HHH   H#S" +
"S#H  H     HH##HH     H  H#S" +
"S#H H    HH H##H HH    H H#S" +
"S#H#H####H###$$###H####H#H#S" +
"S#H#H####H###$$###H####H#H#S" +
"S H H----HH0H##H0HH----H H S" +
"S#H  H     HH##HH     H  H#S" +
"S#H   HHH   H##H   HHH   H#S" +
"S#HH     HH H##H HH     HH#S" +
"S#H HH     HH##HH     HH H#S" +
"S#$   HHH   H &H   HHH   $#S" +
"S##########################S",

//======<<< Level 036 >>>======

"##########S#################" +
"#HH$HHH$HHHHH$HHH$HH#@$HH$@#" +
"#HHHHHHHHHHHHHHHHHHH#H@HH@H#" +
"#H###H###HXH###H###H#HHHHHH#" +
"#H0H-H--#HXH#H-H--0H#H@HH@H#" +
"##XHX#XH#HXH#HX#XHX##@HHHH@#" +
"#H H---HH$X$HHH--H H#HH$$HH#" +
"#H##XXH##X#X##HXX##H#HHX#HH#" +
"#H----H#$   $#H----H#H##$#H#" +
"#HXXXXH###X###HXXXXH#HH#XHH#" +
"#H# --H-------H-- #H#HH$$HH#" +
"#H#H##H##XXX##H##H#H#@HHHH@#" +
"#H H--H---X---H--H H#H@HH@H#" +
"#H#H#H##XH#HX##H#H#H#HHHHHH#" +
"#H H#H   H&H$  H#H H H@HH@H#" +
"#####################@$HH$@#",

//======<<< Level 037 >>>======

"H                        & #" +
"H#########################$#" +
"H## ## ## ## ## ## ## ## ## " +
"H ## ## ## ## ## ## ## ## # " +
"H# ## ## ## ## ## ## ## ##$0" +
"H## ## ## ## ## ## ## ## ##$" +
"H ## ## ## ## ## ## ## ## # " +
"H# ## ## ## ## ## ## ## ##$ " +
"H## ## ## ## ## ## ## ## ## " +
"H ## ## ## ## ## ## ## ## # " +
"H# ## ## ## ## ## ## ## ##$0" +
"H## ## ## ## ## ## ## ## ##$" +
"H$##$##$##$##$##$##$##$##$# " +
"H# ## ## ## ## ## ## ## ##  " +
"H                           " +
"H###########################",

//======<<< Level 038 >>>======

"----------------------------" +
"H $     $$ $     $$ $     $$" +
"H #######  #######  ####### " +
"H #######  #######$ #######$" +
"H ##   ##  ##       ##      " +
"H ##   ##$ ##       ##      " +
"H0##       ##   0   ##$    $" +
"H ##  $  $ ##       ####### " +
"H ##  ###  ##       ####### " +
"H ##  ###  ##            ## " +
"H ##   ##  ##            ## " +
"H ##$ $##  ##$    $     $## " +
"H #######  #######$ ####### " +
"H #######$ #######  #######$" +
"H            &             0" +
"H###########################",

//======<<< Level 039 >>>======

"                          S " +
"0              0 $#$   $#$S0" +
"#########H###H##H###H######H" +
"#########H#  H #H   H #    H" +
"# #######H$#### #H###$######" +
"# #$$####H##  #$ H         $" +
"$ #######H###  ####H########" +
"#########H#---     H       $" +
"         H  H########  @@@@@" +
"#########@H H######### --  $" +
"H####$ ##@H H  &    HH#  HHH" +
"H######$ @@@@#####H#XHH#  H$" +
"H    $###$   @@@@@H#X#HH# HH" +
"H##########H#$#   H#X##HH#$H" +
"H   $   0# H###H@ H#X###HH# " +
"#########  H$  H@@H     $HH$",

//======<<< Level 040 >>>======

"                            " +
"      S              S      " +
" H#-HXS@@@@H@##@H@@@@SXH-#H " +
" H    S    H    H    S    H " +
" H   ###   H    H   ###   H " +
"H--  $ $  -H 00 H-  $ $  --H" +
"H  #X# ### ###### ### #X#  H" +
"H #       H  00  H       # H" +
"H  #$  $H#H--##--H#H$  $#  H" +
" H  # H#H    ##    H#H #  H " +
"  H  #H    ##$$##    H#  H  " +
" H  $#H$---##$$##---$H#$  H " +
"H - # H#H    ##    H#H # - H" +
"H# #    H#H  ##  H#H    # #H" +
"H         H-- &--H         H" +
"H H####### ###### #######H H",

//======<<< Level 041 >>>======

"             SS             " +
"   0 0       SS       0 0   " +
"$ H###H $    SS    $ H###H $" +
"@### ###@H########H@### ###@" +
"@#$###$#@H  #  #  H@#$###$#@" +
"@### ###@##H#$$#H##@### ###@" +
"@  ###  @  H ## H  @  ###  @" +
"@### ###@H########H@### ###@" +
"@#$###$#@H        H@#$###$#@" +
"@### ###@H   &    H@### ###@" +
"@  ###  @####HH####@  ###  @" +
"@### ###@$   HH   $@### ###@" +
"@#$###$#@@@@H@@H@@@@#$###$#@" +
"@### ###@   H  H   @### ###@" +
"@#@#@#@#@H@ H  H @H@#@#@#@#@" +
"    $    H########H    $    ",

//======<<< Level 042 >>>======

"# ##########################" +
"#S-------------------------#" +
"#H######################## #" +
"#H# ---------------------# #" +
"#H##H################### # #" +
"#H##H#-----------------# # #" +
"#H##H#H############### # # #" +
"#H##H#H#             # # # #" +
"#H##H#H#H@$       0 $# # # #" +
"#H##H#H#H############# # # #" +
"#H##H#H#H0            $# # #" +
"#H##H#H################# # #" +
"#H##H#H0                $# #" +
"#H##H##################### #" +
"#H##H0                    $#" +
"#H&#########################",

//======<<< Level 043 >>>======

"#            SS            #" +
"#------------SS------------#" +
"##           HH           ##" +
"#@# ---------HH--------- #@#" +
"#$ #         HH         # $#" +
"#@@@# -------HH------- #@@@#" +
"#$   #       HH       #   $#" +
"#@@@@@# -----HH----- #@@@@@#" +
"#$     #     HH     #     $#" +
"#@@@@@@@# ---HH--- #@@@@@@@#" +
"#$       #   HH   #       $#" +
"#@@@@@@@@@# -HH- #@@@@@@@@@#" +
"#$         # HH #         $#" +
"#@@@@@@@@@@@#HH#@@@@@@@@@@@#" +
"#$&          HH          0$#" +
"############################",

//======<<< Level 044 >>>======

"S&                        0S" +
"S                          S" +
"H--------------------------H" +
" H                        H " +
" #H    @$$@     @$$@     H# " +
" # H   ####     ####    H # " +
" # #H      @$ $@       H# # " +
" # #$H   @ #####  @   H$# # " +
" # #  H  @        @  H  # # " +
" #$@@@ H @$      $@ H @@@$# " +
" #    # H ######## H #    # " +
"$@@@@@@@ H        H @@@@@@@$" +
"        # H      H #        " +
"@@@@@@@@@@@H    H@@@@@@@@@@@" +
"$0          H  H          0$" +
"#############HH#############",

//======<<< Level 045 >>>======

"H-------------------------HS" +
"H&                        HS" +
"H@##$##@##$##@##$##@##$##@HS" +
"H#@#####$#####$#####$##@##HS" +
"H                        0HS" +
"###########################S" +
"                         0#S" +
"H##########################S" +
"H####$################$####S" +
"H                       0H#S" +
"#########################H#S" +
"#####$################$##H#S" +
"H                       0H#S" +
"H##########################S" +
"H####$################$####S" +
"H                          S",

//======<<< Level 046 >>>======

"                            " +
"       0         &         S" +
"H#@#@#@H@@#X@@@H # H@     @S" +
"H$ X $#H@$ X $@H # H@#####@S" +
"@#@@@#@H@#@@@#@H # H@###$#@S" +
"       H--   --H # H@#####@S" +
"##H#####H#####H### H@@#@@@@S" +
"##H     H-   HHH   H@@   @@S" +
"##H-----H -HHH#HHH@@@@@@#@@S" +
"##H@$ $@H- HXXHXXH@        S" +
"$#HH###HH -H  H  H@@@@@@@@@ " +
"###H###H - H#H H#H       #- " +
"   H   H  -  H H0#######H###" +
"####H#######H# 0#@      H   " +
"$   H       H  ##@H@@@@@@X@@" +
"#################@H$    $X  ",

//======<<< Level 047 >>>======

"                     0     &" +
"SSSSSSSSSSSSSSSSSSSSSSSSSSSS" +
"$H H H H H H H H HHHH@@@##@@" +
"# # # # # # # # #   H#$ ## $" +
"$      X X X X X H###$@####@" +
"@#@#@#      -    H $#H#@##@#" +
"      #@#@#@ H@@@ @@#H##    " +
"H#####      H    -@ -H-#@@@#" +
"H  $  H####H  @ @  $ H      " +
"######H----H 0@ @H#XXH######" +
"@@@@@@@    #H@@ @H $ H      " +
"HHHHHH$#### H@ $ @#########H" +
"H#X#X##0    H@###@         H" +
"H     ####H##@###@H#########" +
"H         H       H        $" +
"##################H#H H#H H#",

//======<<< Level 048 >>>======

" S    H- 0H-   0         $ S" +
" S    H - H - H#############" +
" S    H  -H  -H ------------" +
" H#####  ##  ## ###########H" +
" H   $@     $$ $@        --H" +
" H    @@###### @@--------  H" +
"H#######  $     $ #$ # $ 0 H" +
"H#######  ####### ####  ###H" +
"H@@#@@@@                   H" +
"H##$##  #H#######@##@H  #  H" +
"H##X#####H#######@@# ####H##" +
"H## ##$##H#######@@#$ ###H##" +
"H  ---   H#######$@##    H $" +
"H  $$$ H####$$$###@##H######" +
"H&     H           0 H  --##" +
"######################H$#H$$",

//======<<< Level 049 >>>======

"@@S                         " +
"@@S00        $ $ $    $    0" +
"@@@#@#@#@#@#@#@#@#@#@S@@@@@@" +
"----------H@         S      " +
"@ $$$$    H@        $S$  & $" +
"@@     H@@@@H#####@@@S######" +
"$@@    H    H#####   S      " +
"H @@  H     H@$@$@   S      " +
"H      H H@@@@X#X@H@@S#####H" +
"H#### H  H         $ S#####H" +
"H      H H   $ H@@@@ S#####H" +
"H ### H  HH@@@ H     S###$#H" +
"H $#$  H HH    H  $  S$$###H" +
"##### H  @@@@@@@@@@  S     H" +
"       H             S   ##H" +
" $ $H###################H  H",

//======<<< Level 050 >>>======

"S@ 0                        " +
"S### 0                      " +
"S $@@@ $                    " +
"H@# $### $                @@" +
"H@### $@@@ $          0 ###-" +
"H@##### $### $      0 @@@---" +
"H@####### $@@@    $ ###---H-" +
"H@# $ ##@@#     $ @@@---- H-" +
"H@######@@@   $ ###---@ $@H-" +
"H----       $ @@@---- @##@H-" +
"    H  $    ###$----      H-" +
"H#######  @@@@@####       H-" +
"H        &                H-" +
"H##########################H" +
"H           $@@$           H" +
"############H0 H############",

//======<<< Level 051 >>>======

"-------S####################" +
"H######S# ------------------" +
"H#   $#S# #################H" +
"H#H####S# #-------------- #H" +
"H#H    S# #H############# #H" +
"H######## #H#-----$0      #H" +
"H-------# #H#$   $#########H" +
"H######H# #H##### #$#---- #H" +
"H#    #H# #H----# #H#H### #H" +
"H# ##H#H# #H###H# #H#H#$# #H" +
"H# $#H#H# #H $#H# #H#H#H# #H" +
"H####H#H# #####H# #H#H#H# #H" +
"H----H#H#      H# #H#H#H   H" +
"H######H######### #H#H######" +
"H   $$#H0          H#H     &" +
"############################",

//======<<< Level 052 >>>======

"H------------ & -----------H" +
"H####### -- 0###0 -- ######H" +
"H    $   - ####### -   $   H" +
"H#####  - ###$ $### -  ####H" +
"H  $   - ###$   $### -   $ H" +
"H###  - ###$     $### -  ##H" +
"H $   -###$  ###  $###-   $H" +
"H##    ###  #####  ###    #H" +
"H   $   ###  #$#  ###   $  H" +
"H#### ---###     ###--- ###H" +
"H     $   ###$ $###   $    H" +
"H######    ### ###    #####H" +
"H  $    $ #### #### $    $ H" +
"H###    #####   #####    ##H" +
"H             0            H" +
"############################",

//======<<< Level 053 >>>======

"              H&          -S" +
"  H@---------HHH---------@-S" +
" H@0          H          0 S" +
"H@            H        @ $ S" +
"H@@#@   $   $#H#$   $  @@# S" +
"HH $@   ### @XHX@ ###      S" +
" HH@   $####@ $ @####$   @SS" +
" H@    ## ##$ @ $## ##  @SS " +
" H     ##  ## @ ##  ##  SS $" +
" HH@H   ##$##   ##$## SSS@ H" +
" H@ H   ##  #X X#  ##SS$@  H" +
" @ $H    @@##X@X##@@ S @  $H" +
" @@@@H   @@X#X@X#X@@  S@@@@H" +
"----@H----------------H-- @H" +
"   @ H  $   $   $   $ H    H" +
"     H    0   0   0   H##H H",

//======<<< Level 054 >>>======

"      0   S                0" +
"    --H   S       0         " +
"######H   S                 " +
"##########H-     -HH-     -H" +
"#########@H -   - HH -   - H" +
"#########@H  - -  HH  - -  H" +
"##$  # $ @H   - $ HH $ -   H" +
"#########@H  $ -  HH  - $  H" +
"#########@H-  $ - HH - $  -H" +
"### $   #@H -  $ -HH- $  - H" +
"#########@H  -  $ -- $  -  H" +
"#########@H   -   --   -   H" +
"#$   #  $@H    - -  - -    H" +
"#########@H     - $$ -     H" +
"&   ##    H                H" +
"###H $H#####################",

//======<<< Level 055 >>>======

"            0  #S###########" +
"         ----H #SS####SSSSS#" +
"#       #    H ##SSS##S###S#" +
"#########    H   ##SSSS###S#" +
"       $@   --H#         $S#" +
"#########  -- H@@@@@@@@@@@@@" +
"       $@ --  H            0" +
"#########--   H-------H#####" +
"      $@--    H $     HH####" +
"#######--     H       HHH##$" +
"      --      H H######HHH##" +
"     --       ##H##$####HHH#" +
"    --        ##H########HHH" +
"   $          ##H#########HH" +
"&               H         0H" +
"############################",

//======<<< Level 056 >>>======

" &                        S " +
"H#######H-            H## S#" +
"H $###$ H -          H$ # S#" +
"H ##### H  -     $#H  H ##S#" +
"H#######H#$ -    ##H$H  #S$#" +
"H $###$ H##    $###HH   #S##" +
"H ##### H ##   ####  H$ #$S#" +
"H#######H  ##$#####   H ##S#" +
"H$ #####H   ####### $H  #SS#" +
"H #####$H###@###### H   #S##" +
"H#######H@#$@######  H  #SS#" +
"H$ #####H@##@######   H ##S#" +
"H ####$#H            H$ #SS#" +
"H#######H ----        H #S##" +
"H$ #####H@    @H     H H#SS#" +
"H0######H0####0H####H  H0S##",

//======<<< Level 057 >>>======

"@S@@H                  H@@S@" +
"@S@@ H                H @@S@" +
"SSSSS S    HH##$##HH   SSSSS" +
"S0@@  S   H HH0#0HH H  S@@0S" +
"@@@@  S  H    $#$    H S@@@@" +
"   SSS  H     H#H     H SS  " +
"  S    H     H###H     H  S " +
" S SSSH----- -###- ---H SS  " +
" S    H $$  #######   H   S " +
"--S---H###############H@@-S-" +
"---S--H#####$ ### $###H     " +
"----S-H###############H     " +
"   S  H  -         -  H     " +
"  S   H               H     " +
" S    H        &      H     " +
"######H###############H#####",

//======<<< Level 058 >>>======

"@0                $    @   @" +
"@@@@@@@@@@@@@@@@@@@  @@@@H@@" +
" H H  H   H   H H  @     H  " +
" H-H- H   H  -H H  ----- H  " +
" H H -H  -H - HH   H@ $@ H  " +
" H H  H - H-  HH @@ ---  S  " +
" H-H  H-  H$0 HH   #  @  HH " +
" H H  H  #### H H  $ -HH@@H0" +
" H H  H       H H  @ @ H H##" +
" H-H  H$  ####@H@#     ##H  " +
"#H H ####     HHH        H##" +
"#H H          H-H-       H  " +
"#H H          H H #######S##" +
"#H&H--------  H#@#  @SSSSSS@" +
"#@#@S      S##@ @   @SSSSSS@" +
"##@ S######S$@  @   @SSS0SS@",

//======<<< Level 059 >>>======

"           ##  HHH0---------" +
"  $     ##    H$H$H         " +
" H#         -HHHHHH  #######" +
"H#$#H  HHH--  HHHHH  ##### #" +
"H X   HHHH  H HHH$H  #$### #" +
"H H   HHHH  H HHHHH  ####  #" +
"H     HHH$H   H$HHH  ## # ##" +
"H      HHHHH  HHHH   ##   ##" +
"H  $  $HHHHHHHHHHH   ##  ###" +
"H     HHHHHH$HH$HH   ## ####" +
"H      HHHHHHHHHH    ##  ###" +
"H    HHHHHHHH&HHH    #### ##" +
"H   H   HHHHHHHHHH 0 ####$ #" +
"H   H$HH-H----HHHH # #######" +
"H              HH$H         " +
"############### HHH#########",

//======<<< Level 060 >>>======

"0                     $ ### " +
"####################### ###S" +
"                      SS  #S" +
"##HH##HHH####HHH#### HH #H#S" +
"##HH#HHH## #HHHHH##H HH  H#S" +
"$#HH#HHH####HHHHH##H HH H##S" +
"###H#HH##  $#HHHH##H HHHHH#S" +
"##HH#HH######HHHH##H HH #H#S" +
"##HH#H##HHHHH#HHH##HSS& #H#S" +
"##HH#H###HHHH##H####SHH #H#S" +
"   H0H   S  S  H    SS  #H#S" +
"###########0S############H#S" +
"@          @@ $          H#S" +
"@S@@@@@@@#S  H#############S" +
"@S       @@@@@@@@@@@@@@@@@@S" +
"@@S0S###S                  S",

//======<<< Level 061 >>>======

"S@@@@@@@@@@@@@@@@@@@@@@@@000" +
"S@   -----------H--------@@$" +
"S@ #H     --    H  -      H " +
"S@ #H    -      H   -     H$" +
"S@ #H    -      H    - -- H " +
"S@ #H     --    H     -   H$" +
"S@ #H ###   -   H   -- -  H " +
"S@ #H  ###  -#######    - H$" +
"S@ #H ### -- $     $     -  " +
"S@ #H  ###  -#      -   - H$" +
"S@ #H ### -- #H##### - -  H " +
"S@ #H  ###    H       -   H " +
"S@ #H ### --  H      - -  H " +
"S@ #H $     - H     -   - H " +
"S$ #H   & --  H    -     -H " +
"############################",

//======<<< Level 062 >>>======

"          S& S              " +
"          S@@S              " +
"          S@@S              " +
"         HH##HH             " +
"        H  ##  H            " +
"         H#  #H SS          " +
"        H##$$##H  SS        " +
"       H@@@  @@@H   S       " +
"       HH######HHSSSSSSSSS  " +
"       H##    ##H   S   @S00" +
"       H#0$  $0#H  S    @@@@" +
"     H@@@##HH##@@@H         " +
"     HH####HH####HH         " +
"     H###  HH  ###H         " +
"     H     HH     H      $0 " +
"#####H#####HH#####H##### ###",

//======<<< Level 063 >>>======

"@@@@@@@@@@@@@@@@@@@@@@@@@@&@" +
"- -H----HH- -HH - HH- -HH@H@" +
" #-H    HH # HH# #HH # HH@H@" +
"##-H####HH## HH#$#HH## HH@H@" +
" #-H 0  HH # HH # HH # HH@H@" +
"$# H####HH # HH# #HH # HH@H@" +
"###H    HH###HH# #HH###HH@H@" +
"   H    HH   HH   HH   HH@H@" +
"###H####HH###HH###HH###HH@H@" +
"   H    HH   HH   HH   HH@H@" +
"## H    HH # HH# #HH## HH@H@" +
"- #H####HH## HH#$#HH  #HH@H@" +
"$# H 0  HH # HH # HH # HH@H@" +
"#  H####HH # HH# #HH#  HH@H@" +
"###H    HH###HH# #HH###HH H@" +
"   HHHHHHHHHHHHHHHHHHHHHH#@@",

//======<<< Level 064 >>>======

"H--------------------------H" +
"H0           0            @H" +
"H@H----------------------H0H" +
"H H#                     H#H" +
"H#H H------------------H#H H" +
"H$H@H                 @H$H@H" +
"H@H H@H--------------H H@H H" +
"H H#H H#             H#H H#H" +
"H#H H#H H----------H#H H#H H" +
"H H@H H@H         @H H@H H@H" +
"H@H$H@H H@H------H H@H$H@H H" +
"H H#H H#H H#     H#H H#H H#H" +
"H#H H#H H#H H--H#H H#H H#H H" +
"H$H@H H@H H@H @H H@H H@H H@H" +
"H@H H@H H@H H@&H@H H@H H@H$H" +
"############################",

//======<<< Level 065 >>>======

"           H##     H        " +
"           H###H  H#H       " +
"          H   ##H## ##H     " +
"       H###   H #HHHHH#H    " +
"     HH#  ##  H#H   SH#H    " +
"    H##    ## H#$H  SHH#H   " +
"  HH#HHH #####H###  SSH#HS  " +
"  H0-0H HH######HHH SH0H0H  " +
"  H---H  HHH####H   SH-H-H  " +
"  -----   HHH#H#H   S--H-SS " +
"  -----   H &#H# H  S--H--S " +
"  - - -   H######H  S--H--S " +
"  $ $ $   H######H  S- H -S " +
"          H## ###H  S$ H $S " +
"          H##$###H  S  H  S " +
"##########H  H    H#########",

//======<<< Level 066 >>>======

"S   ###     ####H0    0H####" +
"S #######   ####H$    $H####" +
"S#########   $H##H    H##H##" +
"S###HHH####H##H##H$  $H##H##" +
"S#HHH HHH##H##HH0#H  H##HH##" +
"SHH     HH#H##HH##H  H##HH##" +
"H     H H##H##HHH##HH##HHH##" +
"H    H #### ##H H##HH##H H##" +
"H    H###   ##H HH#HH##H H##" +
"HH   HH###  ##H  H#HH#H  H##" +
"# H   HHH##H##H  HHHHHH  H##" +
"##H H0H H##H##H   HHHH   H##" +
"####HHH#H## ##H   HHHH   H##" +
" ###-$ #H#  ##H          H##" +
"  ######H   ##H          H##" +
"    ### &     H##########H##",

//======<<< Level 067 >>>======

"##############S#############" +
"# H0H H H H H H H H H H H0H#" +
"# H#H#H#H#H#H#############H#" +
"# H$H H H H H H H H H H$H#H#" +
"# H ##########H#H#H#H#H#H#H#" +
"# H #$H H H H H H H H$H#H#H#" +
"# H # H#H#H#H#########H#H#H#" +
"# H # H-H-H-H-H H H H#H#H#H#" +
"# H # H H H H&H H H H#H#H#H#" +
"# H # H#######H#H#H#H#H#H#H#" +
"# H #$H H H H H H H H$H#H#H#" +
"# H ####H#H#H###########H#H#" +
"# H$H H H H H H H H H H$H#H#" +
"# H#H#H#######H#H#H#H#H#H#H#" +
"# H0H H H H H H H H H H H0H#" +
"############################",

//======<<< Level 068 >>>======

"@#############S############@" +
"@H$         $ S $        $H@" +
"@H@######################@H@" +
"@H@H          &         H@H@" +
"@H@H@#########H########@H@H@" +
"@H@H@H        H       H@H@H@" +
"@H@H@H@##############@H@H@H@" +
"@H@H@H@--------------@H@H@H@" +
"@H@H@H@$    $ H $   $@H@H@H@" +
"@H@H@H@##X####H##X###@H@H@H@" +
"@H@H@H0       H     0 H@H@H@" +
"@H@H@#######X###X######@H@H@" +
"@H@H          H         H@H@" +
"@H@#####X#####H#####X####@H@" +
"@H$        $  H  $       $H@" +
"@##########################@",

//======<<< Level 069 >>>======

"                           S" +
"                           S" +
"                          &S" +
" #####S##H## ##H####S######H" +
"         H ### H           H" +
"         H  0  H           H" +
"         H $#$ H           H" +
"H##########################X" +
"H                           " +
"H            #H             " +
"H###########X##############H" +
"S                          H" +
"H############ ##           H" +
"H     $    ###$#H#####0####H" +
"H 0   #    #### H     $    H" +
"############################",

//======<<< Level 070 >>>======

"H------&                    " +
"H                           " +
"H                           " +
"H                           " +
"H    ##@@@#########@@@##    " +
"H #####@@@#########@@@##### " +
"H@####@   ---------   @####@" +
"H@$###@ @ $ $ $ $ $ @ @@##$@" +
"H @#@@  @@0        @@  @@#@ " +
"H      0@@#########@@     # " +
"H      @@@@@ $$$ @@@@@     #" +
"H     @@@@@ $@@@$ @@@@@    #" +
"H    @@@@@@ $@@@$ @@@@@@$## " +
"H    @@@@@@@ $$$ @@@@@@@##  " +
"H    @@@@@@@@@#@@@@@@@@@    " +
"####H                   H###",

//======<<< Level 071 >>>======

"                      &   S " +
"                     #@$  S " +
"          $ ----     @@@  S " +
"H########## H        #@#  S " +
"H0          H   $         S " +
"##########H H  $######### S " +
"          H H $##  #######S " +
"H########## H ##    #### ##$" +
"H           H       ####  ##" +
"##########H H       ##$#  ##" +
"          H H     ------- ##" +
"H########## H     ##  ##H # " +
"H           H   $## $## H   " +
"##########H H   ##  ##  H   " +
"$         H H   #  ##   H   " +
"##########H H     ##    H  0",

//======<<< Level 072 >>>======

"             @  - 0S        " +
"0  $ $       @ --- S $ $   0" +
"@@@@@@  $ $  S-----S @@@@@@@" +
"     @@@@@@  S  $ $  @   -H " +
"    -H  -H@ $S  @@@@@@ -- H " +
"   - H - H@@@S$ @ -----$  H " +
"###  H-  H   S@@@ @$ @$###H " +
"###  @   H   S    @##@    H " +
"#$#$$ $$ H  $S            H " +
"#X#      H@@@S     H#######H" +
"         H   S     H   $   H" +
"         H  $S     H$  ####H" +
"H############S#######       " +
"H            S              " +
"H&           S           #H " +
"########################@$H#",

//======<<< Level 073 >>>======

"H--  H-------&--------H-    " +
"H  ###   --- # ---    H -   " +
"H $    ##$ -###- $##  H  - $" +
"###H   #### ### ####  H   @@" +
"   H   $###########$  HH -  " +
" $ H     ####$####    H@H -$" +
"H###      # $X$ #     H@@@@@" +
"H         ###$###     H -H  " +
"H $      #### ####    H- H  " +
"###H    $###   ###$  ### H  " +
"   H    ###     ###      H  " +
" $ H    ##       ##   ##HH  " +
"H###  $ 0         0 $   H   " +
"H    H###H       H###H  H   " +
"H    H   H$     $H   H  H# $" +
"########################H @@",

//======<<< Level 074 >>>======

"0             H-       S    " +
"    ----    & H #      S    " +
"        H#####H ###    S    " +
"       #H####@H###$#   S --S" +
"   ## ##H####@HH##### $S-  S" +
"  #$ ###H####@ H#######    S" +
"  ##$###H###$@H########    S" +
"   #X###H####@H######   @H@S" +
"     ###H####@H$####  @@@H@S" +
"      #$H####@H@     @   H@S" +
"      @@H    HH@     @H@@@@S" +
" --- @@@H    H@@     @H  @ S" +
"#   H@@ H    H@@     @@@H@ S" +
" #  H @@HH   HH@@       H@$S" +
"$ # H  @@H    H@@@   H@@@@@@" +
"   #H   HH    H      H     0",

//======<<< Level 075 >>>======

"          S      S          " +
"   ---  --H-- &--H--  ---   " +
"  H - ##  S- ## -S  ## - H  " +
" $H $#### S #### S ####$ H$ " +
"  H ######S######S###### H  " +
"  H ######S######S###### H  " +
"  H  #####X######X#####  H  " +
"  H   ###$X##$$##X$###   H  " +
"  H                      H  " +
"  H     ############     H  " +
"  H       ########       H  " +
"  H          $$          H  " +
"  H        ######        H  " +
"  H          ##          H  " +
"  H          $$          H  " +
"0$H######################H$0",

//======<<< Level 076 >>>======

"       @      H             " +
"       @      H             " +
"####H  @0  $  HSSS----S$   0" +
"####H  @@@@@$  $   -- S@@@@@" +
"$###H---   @@@@@$ $   S     " +
"####    H  -   @@@@$ $S     " +
"        H - H  -  @@@@S    $" +
"        H-  H - H     S H###" +
"    H#      H-  H     S H   " +
"H####$   $$$$$$$H     S H - " +
"H               H     S H- H" +
"#####H          H##H##S  $ H" +
"#####H             H $     H" +
"#####H  H############# #####" +
"#####H  H                  $" +
"$####H& H###################",

//======<<< Level 077 >>>======

"S    0                      " +
"S---------------------------" +
"SSSSSSSSSSSSSSSS     &     H" +
"#####X $    $  S     @@@@@@H" +
"#####X     ####S     @@@@@@H" +
"###$#X  $ SSSSSS H######   H" +
"## SSSSS##S     $H######   H" +
"#  S $ SSSS   H######      H" +
"   S###       H######      H" +
" $ S       H######         H" +
"###SS     $H######         H" +
"    S   H######            H" +
"    S   H######            H" +
"    H#######               H" +
" $  H#######$$             H" +
"############################",

//======<<< Level 078 >>>======

"@@@@@@@@@@@S@@@@@@@@@@@@@@@@" +
"H--    -   S        ----H -H" +
"H$$@##@$############   0H  H" +
"H  @##@ ####$#####$#    H  H" +
"H  @  @  ###  $ $       H  H" +
"H 0@##@   ###           H  H" +
"H  @  @   $###     -    H  H" +
"H  @##@     #$#   ---   H  H" +
"H  @  @     #$#  -----  H  H" +
"H  @##@   $##X    ---   H  H" +
"H  @$ @   ###      -    H  H" +
"H  @##@ 0###            ## H" +
"H       ####$#####$#  $  $ H" +
"H       ############       H" +
"H            &             H" +
"############################",

//======<<< Level 079 >>>======

"0S            0      0      " +
" S ---- -                 0$" +
"#@#    H -       H##########" +
" @$@ - H  -      H         &" +
" @  #  H   -     H     @@@@@" +
"$@@@@@ H    -$   H         $" +
"      #H     #-  H     H####" +
"@@@@@@@H       - H     H    " +
"       H   --   -H     ####H" +
"H@#####  H@$$@H            H" +
"H@#####  H@##@H  ##### H####" +
"H@#####  H    H  ##### H    " +
"H@#####  H    H  #$### ####H" +
"H@####$  H    H  #####    $H" +
"H        H    H            H" +
"############################",

//======<<< Level 080 >>>======

"               00           " +
"H############SS############H" +
"H# $#  #  #  ##  #  #  #$ #H" +
"H#  # $#  #$    $#  #$ #  #H" +
"H####  # $#@    @#$ #  ####H" +
"H#     #  #$    $#  #     #H" +
"H#######  #@@  @@#  #######H" +
"H#        #      #        #H" +
"H@@@@@@@@@@@@$$@@@@@@@@@@@@H" +
"H    -         #    #H @   H" +
"H###SS@ X####  #H# $#H#$#@@H" +
"H@@@@#@$X   #  #H#@@#H @@@@H" +
"H        H#$#  #H    H     H" +
"H###X#####@@#  ############H" +
"H&                       00H" +
"H############SS#############",

//======<<< Level 081 >>>======

"           S                " +
"  @@@@@@@@@S@@@@@@@@@@@@@@@H" +
" 0# $ $ $ #S#    #$HHHHH$@$H" +
" &# H H H #S#H#H##HHHHHHH@@H" +
"$0# ##H## #S#H#H##$HHHHH$@$H" +
"#     H    H H#  $      H@@H" +
"  ########XS###X#########@$H" +
"         $@S@ X @ #######@@H" +
"  @@@@@@@@@S@ @ @ #######  H" +
"         $ S@ @ @$#######  H" +
"SS@@@@@@@@@@@ @ @@####$##  H" +
"S        $    @   #######  H" +
"S @@@@@@@@@@@@@ $          H" +
"S        $    @ # #########H" +
"S #H@@@@@@@@@@@ @@@@@@@@@@@H" +
"S$#H                       H",

//======<<< Level 082 >>>======

"                            " +
"H#$#                    #$#H" +
"H####$#              #$####H" +
"H   ####$#   --   #$####   H" +
"H      ####$#  #$####      H" +
"H#$#      ###  ###      #$#H" +
"H####$#     #HH#     #$####H" +
"H   ####$#   HH   #$####   H" +
"H      ####$#HH#$####      H" +
"H#$#      ###HH###      #$#H" +
"H####$#     #HH#     #$####H" +
"H   ####$#   HH   #$####   H" +
"H      ####$#  #$####      H" +
"H         ###  ###         H" +
"H&                    00000H" +
"############################",

//======<<< Level 083 >>>======

"S            --            S" +
"SH-         H##H # #######HS" +
"SH -        H##H # #$    #HS" +
"SH  - &  -  H##H # ##### #HS" +
"SH  H###H - H##H #       #HS" +
"SH  H#$#H  -H##H #########HS" +
"SH  H#$#H   0##0          HS" +
"S##########################S" +
"S##########################S" +
"S#         -0##0         $ S" +
"S# #########H##   H####H   S" +
"S#$#$#$    #H##   H#$$#H   S" +
"S# # ###### H##$#HH#$$#H   S" +
"S# #       #H############# S" +
"S# ######## H##            S" +
"S#         #H  H###########S",

//======<<< Level 084 >>>======

"                          & " +
"                      0000#S" +
"                           S" +
"H#$#$#$#$#H          $     S" +
"H#########H#########H#     S" +
"H $#$#$#$ H         H $    S" +
"H###X#X###H#########H##    S" +
"H#$#$#$#$#H         H  $   S" +
"H###X#X###H#########H###   S" +
"H $#$#$#$ H         H   $  S" +
"H###X#X###H#########H####  S" +
"H#$#$#$#$#H         H    $ S" +
"H###X#X###H#########H##### S" +
"H $#$#$#$ H         H     $S" +
"H###X#X###H#########H###### " +
"H $     $ H         H      $",

//======<<< Level 085 >>>======

"0$@          &           @$0" +
"H@@H@@@H@@@@@@@@@H@@@@H@H@@H" +
"H@HH H@H H H H H HH@H H@H@@H" +
"H@H@@@@@@H@@@H@@@@H H@@@H@@H" +
"H@HH@@@H$H@H H H@H@@@H  H@@H" +
"HH@H H@@@@@@@@@H@H H H@H@@@H" +
"@H@@@H$H H H H$H @@@@H@H H H" +
"@H H$H@@H@@@@@@@H@@H H @@@@@" +
"@H@@@@H H H H H H @H@@@@H H@" +
"$H H @@@@@@@@@H@@@@H H HH@@@" +
"@@@@H H @ H H H@H H@@@@@H H@" +
"H H H@H$@@H@@@@@H@H H H@@@H$" +
"H@@@@@@@H H H H H@@@@@H H@@@" +
"H H H @@H@@@@@@@@$H H @@H H@" +
"H@@@@H@@H H H@H@@@H@H@@@@@H@" +
"H H$@H $H@@@@@H$H H H H H H@",

//======<<< Level 086 >>>======

"                           S" +
"  $ &                  0  0S" +
"H@######@H########HHH S#H #S" +
"H@######@  H H H H HH#H#H #S" +
"H@######@H##########H@##H$#S" +
"H@######@H           ####H#S" +
"H@######@H@@@@@@@@@@# @##H S" +
"H@##$###@H       @@@@#@####H" +
"H@######@H##X###H@$@  @  $ H" +
"H--------H##X$##H@H@#@@H####" +
"  #       X@X@XXH H@  @H $  " +
"#H##@#H@ #X@X@ @XH  @#@####H" +
"#H $@#H@   @X@$@X@#H  @  $ H" +
"#@@@@# @@@@        @@@@H####" +
"$   @H#   @H@@@@@@H    H    " +
"###H H#H## H      H####     ",

//======<<< Level 087 >>>======

"&0 0 0 0@$           @######" +
"#S S S S@@@@@@@H@####@SSSSSS" +
" S#S S S@     @H@$###@S#####" +
" S S#S S@H#####H@@@##@SSSSSS" +
" S S S#S H#$###H -  @@@@@@@H" +
" S SSS S#HX####H-#H $      H" +
" SS   SS       @#@H # #@#@#H" +
" S -H- S    ---   H @@#@#@#H" +
"  - H -        -  H        H" +
" - -H- -        - H        H" +
"$ - H - $        -H $$     H" +
" - -H- -    --    #  # #@#@H" +
" $- H -$  H#$$#H     @@#@#@H" +
" - -H- -  H####H           H" +
"  -$H$-   H    H           H" +
"#################  ########H",

//======<<< Level 088 >>>======

"# # ## # # ## # ## # # ## #S" +
"# # ## # # ## # ## # # ## #S" +
"# # ## # # ## # ## # # ## #S" +
"#0#0## # # ## # ## # #0##0#S" +
"#$#$##$#$#$##$#$##$#$#$##$#S" +
"#X#X##X#X#X##X#X##X#X#X##X#S" +
"#X#X##X#X#X##X#X##X#X#X##X#S" +
"H   - -   - -- -   ---     S" +
"H### # ### #  # ###   #####H" +
"H# # # # # ## # # #   #   #H" +
"H### # ### #### # #   #   #H" +
"H#   # # # #### # #   #   #H" +
"H#   # # # # ## # #  @@  @@H" +
"H#   # # # #& # ###  @@  @@H" +
"H           $              H" +
"H##########################H",

//======<<< Level 089 >>>======

"&@  ##################     S" +
" @H###0              #H#$##S" +
" #H#$# #############H#H####S" +
" #H### #0          #H#H####S" +
" #H#$# # #########H#H#H####S" +
" #H### # #0      #H#H#H##$#S" +
" #H#$# # # #####H#H#H#H####S" +
" #H### # # #0$ #H#H#H#H####S" +
" #H#$# # # ###H#H#H#H#H####S" +
" #H### # # $  H#H#H#H#H#$##S" +
" #H#$# # #######H#H#H#H####S" +
" #H### # $      H#H#H#H####S" +
" #H#$# ###########H#H#H####S" +
" #H### $          H#H#H##$#S" +
" #H#################H#H####S" +
"  H#                H H    S",

//======<<< Level 090 >>>======

"#############SS#############" +
" #           SS           # " +
" #           SS           # " +
" #H@####H##########H####@H# " +
"0 H@    H          H    @H 0" +
"##H######################H##" +
"##H######$   ##   $######H##" +
"##H##########$$##########H##" +
"##H#####$#  $##$  #$#####H##" +
"##H###$##$###$$###$##$###H##" +
"##H########$-##-$########H##" +
"##H# $ # $ ##$$## $ # $ #H##" +
"##H#########$##$#########H##" +
"##H######################H##" +
"  H           &          H  " +
"############################",

//======<<< Level 091 >>>======

"S            0             S" +
"S--------------------------S" +
"H                          H" +
"H                          H" +
"H     ####       - ### -   H" +
"H   #####         #$#$#    H" +
"H  ###$#   $$     #####    H" +
"H  #####   $$     #####    H" +
"H   #####         #####    H" +
"H     ####        # # #    H" +
"H                          H" +
"H                          H" +
"H                          H" +
"H                          H" +
"H00          &           00H" +
"############################",

//======<<< Level 092 >>>======

"$--------          --------$" +
"H        ##########        H" +
"H       #          #       H" +
"H      #  $$    $$  #      H" +
"H      #  ##    ##  #      H" +
"H      #     &      #      H" +
"H       #    ##    #       H" +
"H        #   ##   #        H" +
"H         #      #         H" +
"H          ######          H" +
"H 0        #$$$$#        0 H" +
"H ###      ######      ### H" +
"H $#######        #######$ H" +
"H ###    $########$    ### H" +
"H                          H" +
"H                          H",

//======<<< Level 093 >>>======

"                            " +
"S #          0     0     0  " +
"S ##S##H #H#-H#-H#-H#-H#-H#$" +
"S   S  S #H                 " +
"S ### #H #H#####H@# @#######" +
"S @   #H #H#$#$#H # @#######" +
"S @#H #H #H#####H # @#######" +
"S @#H #H #H##$##H # @#######" +
"S @#H #H #H#####H # @#######" +
"S @#H$#H$#H#$#$#H # @#######" +
"##@##@##@#H#####H#$ @###$###" +
"  $   @   H &   H ##@#######" +
"############H#####          " +
"$ ----------H-------@##X####" +
"#           H            #H$" +
"$H@#@#@#@#@#@#@#@#@#@#@#H#  ",

//======<<< Level 094 >>>======

" 00000                      " +
"@@@S@@@@@@@@@@@@@@@@@@@@@@@@" +
"@$@S                       @" +
"@H@S@@@@@@@@@@@@@@@@@@@@@@H@" +
"@H@S@H H H H H H       -- H@" +
"@H@S@H@@@@@@@@@H@@@@@@@  @H@" +
"@H@S@H H $H@@H@H   $@@  @HH@" +
"@H@S@@@@@@H $H@H@@@@@  @HHH@" +
"@H@S@H H H@H@@@H $@@  @HH@H@" +
"@H@S@H@@@H@H H@H@@@  @HH@@H@" +
"@H@S@H H@H@@@H@H&  $@HH@@@H@" +
"@H@S@@@H@H H@H@@@H-@HH@@@@H@" +
"@H@S@$  @@@H H@     H  $  H@" +
"@HHS@#@@@@@@@@@#@@@@@@@@@#H@" +
"@  S                      H@" +
"@##########################@",

//======<<< Level 095 >>>======

"SSSSSSSSSSSSSSSSSSSSSSSSSSSS" +
"H#############X############H" +
"H##HHHHHHHH###X#########$##H" +
//"H#############X############H" +
"H###XXXXXXX###X############H" + //modified for easier passed
"H#                        #H" +
"H# $ $ $ $ $ $ $ $ $ $ HH #H" +
"H#                        #H" +
"H#  $ $ $ $ $ $ $ $ $  HH #H" +
"H#                        #H" +
"H#0H $ $ $ $ $ $ $ $ H HH #H" +
"H#0                       #H" +
"H#0HH $ $ $ $ $ $ $ HH HH #H" +
"H#0                       #H" +
"H#0   HHHHHHHHHHHHHHHH&   #H" +
"H########################X#H" +
"HHHHHHHHHHHHHHHHHHHHHHHHHHHH",

//======<<< Level 096 >>>======

"#0000#                      " +
"#X#  #                     S" +
"#$# $#   #  #$# $#   #  #$#S" +
"#X##X#   #$ #X##X# $ #$ #X#S" +
"  #   #X##X#  #   #X##X#  #S" +
" $#   #  #$# $#   #  #$# $#S" +
"#X# $ #$ #X##X# $ #$ #X##X#S" +
"   #X##X#  #   #X##X#  #   S" +
"   #  #$# $#   #  #$# $#   S" +
"   #$ #X##X# $ #$ #X##X# $ S" +
"#X##X#  #   #X##X#  #   #X#S" +
"#  #$# $#   #  #$# $#   #  S" +
"                           S" +
"H##########################S" +
"H            &             S" +
"############################",

//======<<< Level 097 >>>======

"                            " +
"S###########################" +
"SSSSSSSSSSSSSSSSSSSSSSSSSSSS" +
" --------------------      S" +
"          &          H     S" +
"$ -####H#####H####-  ######H" +
"$ -###$H##$##H$###-        H" +
"$ -####H#   #H####-  H#####$" +
"$ -###$##   ##$###-  H######" +
"$ -###############-  H######" +
"$ -###############-  H----- " +
"$ -###############-  #X##X#H" +
"    -----000-----    #$  $#H" +
"   H     H0H     H   ######H" +
"   HH   HH0HH   HH         H" +
"###H#####H#H#####H#########H",

//======<<< Level 098 >>>======

"& #0000#    $    $          " +
"###----#H##########S#####   " +
"  #    #H#    -    S  -  -  " +
"  $    #H#H###S####$## ## ##" +
"###    #H#H#$#S#####$## ## #" +
"HH     #H#H# #S    ##$## ## " +
"HH     HH#H###S     ##$## ##" +
"HH        H#  S      ##$## #" +
"###    ###H#  S       ##$## " +
"@@@@@@@@@@##S#######H  ##$##" +
"            S#$H#   H   ## #" +
"$         #HS#  #   H       " +
"#########H####@@########H##H" +
"         H          #    # H" +
"$        H    HXH  $#####$ H" +
"#########################XH#",

//======<<< Level 099 >>>======

"  -       $     $     $00000" +
"H# @#@#@#@#@#@#@#@#@#@#@#@#@" +
"H#                          " +
"H#        $     $     $     " +
"H# @#@#@#@X@#@#@#@#@X@#@X@#@" +
"H#                          " +
"H#        $     $     $     " +
"H# @#@#@X@#@#@X@#@#@X@#@X@#@" +
"H#                          " +
"H#        $     $     $     " +
"H# H#@#@#@X@#@#@X@#@X@#@X@#H" +
"H# H                       H" +
"H# H      $     $     $    H" +
"H  H#@#@#@#@X@#@X@#@X@#@#@#H" +
"##SH            &          H" +
"############################",

//======<<< Level 100 >>>======

"H------------------------ $ " +
"H          000       &    #H" +
"H   ###- #######  #######  H" +
"H  ####- #######  ####### H#" +
"H #####- ##- -##  ##   ## H " +
"H   ###- ##- -##  ## - ## #H" +
"H   ###- ##- -##  ## - ##  H" +
"H   ###- ##- -##  ## - ## H#" +
"H   ###- ##- -##  ## - ## H " +
"H   ###- ##- -##  ## - ## #H" +
"H   ###- ##- -##  ##   ##  H" +
"H   ###- #######  # ### # H#" +
"H   #$X- #$#$#$#  #$###$# H " +
"H-------------------------#H" +
"H                          H" +
"@#@#@#@#@#@#@#@#@#@#@#@#@#@#",

//======<<< Level 101 >>>======

"&      0    S       0       " +
"        ##  S    H##        " +
"      ######SS H######      " +
"-----########SH########-----" +
"   ##########H ##########   " +
" ####0---H  - H-  H---0#### " +
"-- ##$   H - H  - H   $##   " +
" @#$##   H-   H  -H   ##$#@ " +
" @@# ##  X#  H   #X  ## #@@ " +
" @@@#$##  ##  H ##  ##$#@@@ " +
" @@@@# ##  ##H ##  ## #@@@@ " +
" @@@@@#$##  # H#  ##$#@@@@@ " +
" @@@@@@# ## #H # ## #@@@@@@ " +
" @@@@@@@#$### H###$#@@@@@@@ " +
" @@@@@@@@#   H    #@@@@@@@@ " +
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@",

//======<<< Level 102 >>>======

"S#@#@#@#@#@#@#@#@#@#@#@#@#@#" +
"S-            $            H" +
"HX########### @ @#@#@#@#@#@H" +
"H# ########## #@#@#@#@#@#@#H" +
"H# ##########  $           H" +
"H# #-#@#-##-#  @ @#@#@#@#@#H" +
"H# #-#@#-##-#  #@#@#@#@#@#@H" +
"H# #-#@#-##-#   $          H" +
"H# #-#@#-##-#   @ @#@#@#@#@H" +
"H# #-#@#-##-#   #@#@#@#@#@#H" +
"H# #-#@#-##-#    $         H" +
"H#$#$#@#$##$#    @ @#@#@#@#H" +
"H#X##########    #@#@#@#@#@H" +
"H                          H" +
"H&                    00000H" +
"H@#@#@#@#@#@#@#@#@#@#@#@#@#H",

//======<<< Level 103 >>>======

" @#@#@#@#@#@#@#@#@#@#@#@#@#@" +
"S0     &              @#@#@#" +
"S                    H      " +
"S#     $            HH      " +
"S###################H#      " +
"S###################H#$     " +
"S  ########## ######H##     " +
"S             ######H####   " +
" SSS  S   S S ##H###H####   " +
"S     S   S S$  H ##H ##### " +
"S $$$ S   S SS$ H$$#H #####$" +
"S SSS S   S S S$HXX#H #####X" +
"S  S  S$$$S S  SH   H   ###X" +
" SSS   SSS  S   S   H   ###X" +
"                    H   ###X" +
"######################S     ",

//======<<< Level 104 >>>======

"         S  0               " +
" ------- S                  " +
"H        SSSSH@@@@@@@@@@@@@H" +
"H     ###    H@     00    #H" +
"H#### # $##  H# H#@#@#@#$ @H" +
"H#### ###### H@ H@#@#@#@X@#H" +
"H#### #    #-H# H          H" +
"H#### ###### H@#@#@#@#@#@#@H" +
"H#### #    #            SS  " +
"H#### ################## S  " +
"H#### #$ # $#    0#    # S  " +
"H#### #########X######## SSS" +
"H##$# #     # $   ##  $#   S" +
"HXXX# #########X########   S" +
"H&        0                S" +
"H#X############X########X###",

//======<<< Level 105 >>>======

" &#########       0     -   " +
" H---------H@@@@@@@@@@@@ -  " +
" H         H@$        $@  - " +
" H         H@@@@@@H@H@@@   -" +
" HH###H    H@$    H0H $@$$$$" +
" HH#$#H    H@@@@H@@H@@@@ 0  " +
" HH#$#H    H@   H  H        " +
" ##########H###############H" +
" ########  H $##########  #H" +
" #$ 0  #HH####    $########H" +
" #####H#H#$  #X####   $#  #H" +
" #    H H###H#X####X#######H" +
" ##H########H#X####X#### $XH" +
" ##H       #H#X####X#X####XH" +
" ###########H   0       X##H" +
" ##########################H",

//======<<< Level 106 >>>======

"#$              #       #$#S" +
"######H#H########H# $ @H#H#S" +
"&    #H#H#$$#####H# @@@H#H#S" +
"#0000#H#H#  #####H#    H#H#S" +
"#    #H########$#H# $ @H#H#S" +
"#    #H#        #H# @@@H#H#S" +
"#     H# @@@@@@@#H#    H#H#S" +
"## # ###         H# $ @H#H#S" +
"  #     ########### @@@H#H#S" +
"#H #     ---------#    H#H#S" +
"$#H #   H  $#$ #$ #@@@#@@H#S" +
"  #H #  H  ########      H#S" +
"   #H # H  -------##@@@@@@#S" +
"    #H #H  $ $  $          S" +
"      H H                  S" +
"############################",

//======<<< Level 107 >>>======

"################S###########" +
"################S###########" +
"#########H  $   S #         " +
"#########H######S###########" +
"#&      #H------------H#####" +
"#########H            H $ ##" +
"#########H############H#####" +
"#########H#     S    #H## $ " +
"#########H##    S   ##H#####" +
"#########H###   S  ###H $0##" +
"#####$  #H##### S$####H#####" +
"#########H# $  #S#####H## $ " +
"#######  H######S#####H#####" +
"################S#####H $0##" +
"              $$$     H#####" +
"############################",

//======<<< Level 108 >>>======

"S  @   @###################@" +
"S  #$  0H------------       " +
"S  ###H###      $##  H@####$" +
"S $#  H ##       ##  H@#####" +
"H###  H ##       ##  H@$####" +
"H  #  H ##       ##  H@#####" +
"H  #  H ##       ##  H@#####" +
"H$0#  H ##       ##  H      " +
"H###  H ##$      ##  ####H##" +
"H  #  H ###########$     H  " +
"H  #  H #######$###H---- H0$" +
"H  #  H #   $$    #H   @###@" +
"H  #  H # ####### #H        " +
"H  #  H   $        H        " +
"H  @ @######H########H#####@" +
"H$        $ H        H & $  ",

//======<<< Level 109 >>>======

"@@@@@@@@@S                  " +
"@#######@S                  " +
"@#@    $@@@@@@S             " +
"@   H@######@SS$  0  H@@@@#H" +
"@$--H@#$    @S @#@#@HH@ @@#H" +
"@@@ H@###@H @SS  @  $H@ @@#H" +
"@$  H  0$@##@ S  @   H  @@#H" +
"@H@@@#####@  SS0$@$  $@H@@#H" +
"@H -H@####@  S@##@#@ @@H@ #H" +
"@@@ H@$ ##@$ SS  @    @H@$#H" +
"@   H@####@#@ S  @H--- H@X#H" +
"@H@@H     @  SS $@H  H@ @$-H" +
"@H @@@##@H@  S@##@H$ H@ @#H " +
"@H  $@$ @H@  S  $@@@ H  @##H" +
"@H H@@##@H@##@H@#@    @H@$#H" +
"@@@@@@   H  & H   H@H  H   H",

//======<<< Level 110 >>>======

"$   &@##@@     S            " +
"########@$   0$S    $      $" +
"########@@H@@#@S@ @H# #H##@@" +
"# $     @$H@ $ S@ #H# #H    " +
"########@@H@S@#@@ #H# #####H" +
"#######@ $H@S $ @ #H# #    H" +
"# $     #H@@@#@S@ #H# #H####" +
"########@H @ $ S@$#H# #H $  " +
"########@@H@S@#@@ #H# #####H" +
"# $     @$H@S $ @ #H# #    H" +
"########@@H@@#@S@ #H# #H####" +
"#   #$  @$H@$  S@ #H  #H 0  " +
"#$  ####@@H@@##@@ #########H" +
"##H #     H                H" +
"$ H##H##H##################H" +
"##H  H##H          0$      H",

//======<<< Level 111 >>>======

"@@@@@@@@@@@@@@@@           S" +
"@---------------           S" +
"@H@ @$  H@  @$ @$  --      S" +
"@H# @#####  @@####@  @     S" +
" H#      @$ @  # $#$ @- H@$S" +
"H@###### @##@  ######@$@@@@S" +
"H@ #$  #    #$ #  # $#     S" +
"H@ ##@@##X# ####  ######@  S" +
"H     0  $#    #$ #  # $#$ S" +
"H@@#@@@@H##### ####  ######X" +
"H#     @H    #$0  #$ #  0$ X" +
"H######@@@@@H#### #########X" +
"H  @      $@H   #    #$ ###X" +
"H#####@@@#@@@@@H#### ######X" +
"H     $  &    @H   @       $" +
"@###########@H H    H######@",

//======<<< Level 112 >>>======

"##################@0       S" +
"XH----------------@#@#@#@#@S" +
"XH $   $   $   $ @@  -    $S" +
"XH    -----------H@H@ @@@@@ " +
"XH          0    H@H   - -  " +
"X##@@##@#@##@###@H@@@@@ @ @H" +
"H----------------H-  -     H" +
"H                  H# ####H#" +
"H $   $   $   $   $H# # ##H#" +
"H           0      H# # ##H$" +
"H ######H@##@@##@#@@# # ##H#" +
"H #$    H#$# $ # $ ## # $#H#" +
"H       H  #H#H#H#H#  $###H$" +
"H##H######H#H#H#H#H#$#####H#" +
"H #H     #H#H#H#H#H#######H#" +
"H ####H  #H H#H H#H   $&  H#",

//======<<< Level 113 >>>======

"                           S" +
"###################    0   S" +
"$H----    &    --- H########" +
"#H $ H#########$ ###########" +
"$H@@@H###########HHH###$ ###" +
"#H   H# #$ ## ### $HHH## $##" +
"$H-H H# ## ## ###   $HHH####" +
"#@ H H# $# $# $##@@   $HHH##" +
"$  H H#############@@   $H #" +
"#H-H-            $###@@    #" +
"$H $ H#@@@@#H @########@@@##" +
"#H@@@H      H              #" +
" H   H----  H          0    " +
"@##H     $  H##############H" +
"   H  0     H  --------    H" +
"$  H###########   0 0  #####",

//======<<< Level 114 >>>======

"##@####@#@  S 0 0 0 0 0@    " +
"$H---H---   S#@##@#@##@#@   " +
"#H $ H $  S##            #  " +
"$H   H  #H#     $     $ $ @ " +
"@H##H###@H###@#@##@@H####X#@" +
"#H#HHH# #H#      $#HHH#  $ #" +
"#H#H#H# #H#H#######H#H#### #" +
"#H#H$H# #H#H##$&###H H#  $ #" +
"#H##### #H#H#######H H#X####" +
"#H $ $  #H#H    ###H$H#   $#" +
"@###X##@HHH####H########@X@@" +
"$H#H----H#H---HHH#        H$" +
"#H#H          H H#--------H#" +
"#HHH ######## H H#      $ #@" +
"##H  ##$##$## HHH$##@#@#@H $" +
"##H            H #@$     H@#",

//======<<< Level 115 >>>======

"               S            " +
"    0    -0    S0  $0   0  $" +
"H#######H #    S  $H########" +
"H###$###H ##   S $H         " +
"H @###@ H ###  S$H         $" +
"H  @#@  H #$ ##SH$  ######X#" +
"H   @   H #####S H$         " +
"H   &   H ### #S  H$       $" +
"####H#### # ###S  $H########" +
"    H     $####S $H         " +
"    H     #####S$H    #@###H" +
"H##############SH$   @H    H" +
"H                H$  @@#   H" +
"H                 H$ @@$## H" +
"H                  H @@@   H" +
"#@#@#@#@#@#@#@#@#@#@#@#@#@#@",

//======<<< Level 116 >>>======

"                            " +
"  #  #  #  #  #  #  #  #  #S" +
"S# S# S# S# S# S# S# S# S# S" +
"S##X##X##X##X##X##X##X##X##X" +
"S      &   #X    #X         " +
"H#####@H##H#XH##H#XH####### " +
"H###$#@H##H  H##H  H####### " +
"H# ###@H##H  H##H  H####### " +
"H###$#@H############## #### " +
"H# ###@H#$#$     ##### ####-" +
"H###$#@H  ######H# $ # ####-" +
"H# ###@H###  0  H ####$ #$# " +
"H###$#@H  $######H    # ### " +
"H# ###@H###      ####H----- " +
"H#####@H                  H$" +
"H0    0H#@#@#@#@#@#@#@#-H#-H",

//======<<< Level 117 >>>======

"  -                         " +
"H@X##H@         0-          " +
"H@X##H#H#@@@@@@@# H#@#@#@#@#" +
"H@X##H@H#$     $# H   # ---$" +
"H$X##H#H#@@@@@@@# H#####    " +
"H@X##H@H        & H #  H####" +
"H$X##H#@@@@@@@@@H@@@@@@H####" +
"H@X##H@---------H----- H####" +
"H@$##H#    $    H@#@#@  H###" +
"H@#XXH@ ####### H#@#@#  H###" +
"H    H#         H       H###" +
"H#@#@#@#@H@#@#@#@#@#@#@H-H##" +
"H       @H  $   $   $  H H##" +
"@@@@#@@@@H ### ### ### H H##" +
"$        H    0   0    H###$" +
"#########H#############H    ",

//======<<< Level 118 >>>======

"        SS    S$       -----" +
"H####H@0S S   S#######H# X #" +
"H##  H@@HS    S$      H# X #" +
"H ## H  H S S S#######H# X #" +
"H  ##H@0HS$$ S        H# X #" +
"H ## H@@#@#@#H#@#@#@#@X# X #" +
"H##  H   ----H  #      # X #" +
"H ## H@0 $  $H@#$#@H#X$# X #" +
"H  ##H@@H#  #H@###@H   # X #" +
"H ## H  H ## H@###@H#### X #" +
"H##  H@0H    H     H   # X #" +
"H ## H@@#H  H#H H#####H# X #" +
"H  ##H   ########     H#####" +
"H ## H@          $   $H#$#$#" +
"H#$$#H@0 H######H  &  H     " +
"H ## H ###@@@@@@##########S$",

//======<<< Level 119 >>>======

"             &              " +
"H@##########@HH@##########@H" +
"H############HH############H" +
"H##$#########HH##$#########H" +
"H############HH#######$####H" +
"H##$##H#$####HH############H" +
"H#####-######HH#$$#####$$##H" +
"H#####-######HH############H" +
"H#####-#$ ###HH########## #H" +
"H##### ##H###HH#########$$#H" +
"H#######$H###HH$######$$###H" +
"H########H###HH############H" +
"H#$#####$H###HH@#$#########H" +
"H############HH#######$####H" +
"H0          0HH0          0H" +
"############################",

//======<<< Level 120 >>>======

"&                          0" +
"   @#H#####H############H###" +
"  H  H     H            H @@" +
"@@   H     H           #S# @" +
"   @@H @@## H@ @  H#@@H###H@" +
"@@@  H #-## H@ @ S@#H@H$  H@" +
"     H  ## H@@ @@@@#@@@@$ H@" +
" # H@H @$$@H  H $@ $   #@@@@" +
"  #@ H  ## H-@ @@@#@@H##    " +
"$H-@ H  @  H  @ --- @S#$- @ " +
"#@@@ H @$#@H   0@@@H@@@@S#H " +
"--   H  @# H@#@H   H    @@@ " +
" # - H   # H@H$##H H H-H-H-H" +
"#H#S#H 0   H @H-H# H@-H-H-H-" +
"H$@@#H#H#S#H @@ @@H$@H-H-H-H" +
"@#HHH##### H###@####@-H-H-H$",

//======<<< Level 121 >>>======

"@@@@@@@@@@@H-    -   &00    " +
"H   --     H #  # ###H  @@@@" +
"H###       H $  $ #$#H      " +
"H#$#       H #  # # #H  $   " +
"H# #$@@@###@ #### ###H      " +
"H### @  $$$  ---     H  ####" +
"H    @#H   H#   #H   H  $###" +
"####H@#H  HH#   #HH  H #####" +
//"    H@#H  H # $ # H  H     $" +
"    H@#H  H # $ # H  H    $ " + //modified for easier passed
"H####@#H HH##$ $##HH H      " +
"H    @#H H #$   $# H H H####" +
"####H@#H H#$ ### $#H H H    " +
"    H@#H  #0##### #  H HHHHH" +
"H####@#H  $ ##### $  H ----H" +
"H     #H    #$$$#    H     H" +
"###########H     H##########",

//======<<< Level 122 >>>======

"SSSSSSSSSSSSSSSSSSSSSSSSSSSS" +
"0           SSSS           0" +
"H##########################H" +
"H##########################H" +
"H# $##      #$$#      ##$ #H" +
"H  ######$  ####   $#####  H" +
"##H  #######  & #######  H##" +
"  ##H  #####0##0#####  H##  " +
"    ##H -- # $# # -- H##    " +
" $##$ ##  H# ## #H  ## $##$ " +
"##$$##  H### #$ ###H  ##$$##" +
"  ##  H##### ## #####H  ##  " +
"    H####          ####H    " +
"  H####  H########H  ####H  " +
"$#H      H#  $$  #H      H#$" +
"############################",

//======<<< Level 123 >>>======

"#HSH H   HS SH  SS   SS SHS#" +
"#H0H H   H S H S  S S  0 H #" +
"#HSH H   H   H S  S SSS  H #" +
"#H H H   H   H S  S   S  H #" +
"#H$H$HSS$H$$ H $SS$$SS$$ H #" +
"############SSS#############" +
"HHHHHHHHHHHHHHHHHHHHHHHHHHHH" +
" HHHH                  HHHH " +
"  HHH##################HHH  " +
"   HHHHHHHHHHHHHHHHHHHHHH   " +
"    HHHH      &     HHHH    " +
"     HHH############HHH     " +
"      HHHHHHHHHHHHHHHH      " +
"       HHHH      HHHH       " +
"        HHH######HHH      $0" +
"$####H   HHHHHHHHHH   H## ##",

//======<<< Level 124 >>>======

"@@##SSS S$S#SSS SSS##SSS    " +
"@@@##H  H#H#H###S  S#H@@####" +
"@@#$#H@#HSH HS##SHH##HS@####" +
"@@@##H@#S#S#S###H##H#H@@###$" +
"     H@$S#S#SSS#H##H HSS####" +
"H@#@#@#@#@#@#@#@#@#@#@#@#@#H" +
"H        @    --   #      #H" +
"H H-  -H @ H######H#H###  #H" +
"H H -- H @ H######H#H#$####H" +
"H H-  -H @ H##$$##H0H# ####H" +
"H H#$$#H @@@@@@@@@@@@#### #H" +
"H H    H     ------------- H" +
"H H    H     $   $   $   $ H" +
"H H    H                   H" +
"H H    H            &  00  H" +
"H##########################H",

//======<<< Level 125 >>>======

"                           H" +
"                           H" +
"        H###               H" +
"       H######             H" +
"      HH########           H" +
"     HH ##########         H" +
"    HH   ########          H" +
"   HH    #######$          H" +
"  HH      #####$$          H" +
"  HH      ####$$           H" +
"  HH       ##$$            H" +
"  HH       #               H" +
"  HH                       H" +
"  HH                       H" +
"  HH HH                    H" +
"#########H00000           &H",

//======<<< Level 126 >>>======

"&0      $      $           0" +
"@     H###-   -H H##########" +
"@  @  H    - - H H##########" +
"  #$# H     -  H H##########" +
" @#@#@H    - - H H##########" +
" -----H $ -   -H H####$$####" +
"      #X##       H##########" +
"           H#H   H          " +
" ####H##H############H#####H" +
" #$ # $#H            H#   #H" +
" #@@#@@#H  ###  ###  H# $ #H" +
"    0   H  ###  ###  HX   #H" +
" #######H#H $ $$ $ H#H#@@@XH" +
"        H H        H H     H" +
"        H0H        H0H     H" +
"############################",

//======<<< Level 127 >>>======

"              &             " +
"SSSSSSSSSSSSSSSSSSSSSSSSSSSS" +
"$   S------------------S   $" +
"####H@#####X@  @X#####@H####" +
"$   H@@@@@@@ ## @@@@@@@H   $" +
"####H@@@@@@ #### @@@@@@H####" +
"$   H@@@@@ ##$$## @@@@@H   $" +
"####H@@@@ ##$  $## @@@@H####" +
"    H@@@ ##$    $## @@@H    " +
"H####   ##$      $##   ####H" +
"H###    ##$      $##    ###H" +
"H####   $##$    $##$   ####H" +
"H@@@#@@@@ ##$  $## @@@@#@@@H" +
"H@@@ @@@@@ ##$$## @@@@@ @@@H" +
"H         00####00         H" +
"###########H XX H###########",

//======<<< Level 128 >>>======

"         SSSSSSSSSS         " +
"      SSSS  0000  SSSS      " +
"   SSSS  $  @@@@  $  SSSS   " +
"SSSS  $  @@@@  @@@@  $  SSSS" +
"S  $  @@@@$      $@@@@  $  S" +
"@@@@S $  @@@@HH@@@@  $ S@@@@" +
"   @@@@S $  @HH@  $ S@@@@   " +
"$     @@@@S $HH$ S@@@@     $" +
"####H    @@@@HH@@@@    H####" +
"   ####H     HH     H####   " +
"      ####H  HH  H####      " +
"         ####HH####         " +
"             HH             " +
"#############HH#############" +
"             HH&            " +
"############################",

//======<<< Level 129 >>>======

"& --- --  ----- -   - - -   " +
"##   #  ##   # H HHH HSH H  " +
"# # # # # # # #H S S H H H  " +
"# # # # # # # #H SSS HSH H S" +
"#$# #$# #$# #$XH   S H H SHS" +
"#X   X  #X   X S SSS HHH   H" +
"                           H" +
"-------------   -- --   -  H" +
"H HHH HHH HHH###  #  ### ###" +
"H S S S S S  #$  # # #$   # " +
"H SSS SSS SSS### # # ##   # " +
"H   S S S   S $# #$# #    # " +
"H SSS SSS SSS###  X  #    # " +
"H                       0000" +
"@@@@@@@@@@@@@###############" +
"#############@@@@@@@@@@@@@@@",

//======<<< Level 130 >>>======

" &           $$           0 " +
"S##########################S" +
"S#           $$           #S" +
"S#@@@@@#H@@@@HH############S" +
"S#@$   #   $@HH           #S" +
"S##@@@@#@@@@#HH@####    ###S" +
"S#-----------HH@###   #0#$#S" +
"S#     -     HH@##   ####H#S" +
"S#### #0# ## HH  $# #$###H#S" +
"S ### ### X$ HH  # ####H H#S" +
"S#### ### $# HH   $$   H#H#S" +
"S#$##  $  ## HH@@@@@@@@H H#S" +
"S#          0HH0  $$   H#H#S" +
"S##########################S" +
"S$                        $S" +
"############################",

//======<<< Level 131 >>>======

"     @@@       H-   -H#    &" +
"H#$#H@ H ######H #H# H#   $0" +
"H###H@H $      H # # H@@@@@ " +
"H###H@H XX#####H #H# H      " +
"H###H@H        H # # H  @@  " +
"H###H@ H ######H #H# H # $# " +
"H###H@@@@   ###H # # H #H## " +
"H###H      H#@#H ### H #H## " +
"H###H#   @@##-#H ### H #H## " +
"H   H#   @@##-#H #$# H #H## " +
"H@@@##X$ @@$#@@H     H #H## " +
"H   $### @@#@@@######H #H   " +
"H@@X##$    0         H #H-# " +
"H     @@@@@#@@@@@@@@@H #### " +
"H0                  0H      " +
"############################",

//======<<< Level 132 >>>======

"   $         0        -     " +
"H### ################# ###H " +
"H  0 ################# ###H " +
"###H ################# ##HH " +
"#$#H ######## ###### $ #HHH#" +
"##HH #######   #######  H#H#" +
" HH# ######$   $###### 0H#$#" +
" H## #######   ####### #HH##" +
"#HH# ######## ###$#### ##HH#" +
"##HH #################  ##H " +
"###H ########  ####### $##H " +
" #HH ######## ######## ##HH#" +
"$HH# ########$######## #HH##" +
"HH## ########X######## HH#$$" +
"H            &         H  ##" +
"############################",

//======<<< Level 133 >>>======

"-------$------------$-------" +
"H-  -  #  - &HH  -  #  -  -H" +
"H -  - $ -  -HH-  - $ -  - H" +
"H  -  ###  - HH -  ###  -  H" +
"H   -  $  -  HH  -  $  -   H" +
"H    #####   HH   #####    H" +
"H   #-###-#  HH  #-###-#   H" +
"H  #  -#- ## HH ## -#- ##  H" +
"H  ##-$#$-## HH ##-$#$-##  H" +
"H ###-#0#-###HH###-#0#-### H" +
"H ## -# #- ##HH## -# #- ## H" +
"H#   -#$#-   HH   -#$#-   #H" +
"H#### -#- ###HH### -#- ####H" +
"H0###-$#$-###HH###-$#$-###0H" +
"H  ## ### ## HH ## ### ##  H" +
"H    H###H   HH   H###H    H",

//======<<< Level 134 >>>======

"H@@@@@@@ 0   &   00 @@@@@@@H" +
"H  @@@@  @@@@@#@@@@  @@@@  H" +
"H@S0@  $HHH      HHH$  @0S@H" +
"H@@@@ @@##H@@@#@@H##@@ @@@@H" +
"H@     HHHH      HHHH     @H" +
"H@ #@@#H###@@@#@@###H#@@# @H" +
"S      HHHH      HHHH      S" +
"#@@@@#@###H@@@@@@H###@#@@@@#" +
"$         HHH  HHH         $" +
"#@@X#@X@@@###HH###@@@X@#X@@#" +
"     $       HH       $     " +
"@@@X@#X@@@HHH  HHH@@@X#@X@@@" +
"$      HHHH  HH  HHHH      $" +
"#@@#@@XH   HX@@XH   HX@@#@@#" +
"$   HHHHHX@@@HH@@@XHHHHH   $" +
"@@@XH   H@HHHHHHHH@H   HX@@@",

//======<<< Level 135 >>>======

" @@@@@@@@H                  " +
"         H        --        " +
"    0 $  H-SSSSSSH  -  $   $" +
"   H#H##X@ -  S0 H   --H####" +
"   H@S  $@$-  S H@X#@  H    " +
"   H@@@@@@@ @@H-H  $  H@####" +
"   H-- @@@@   H    @  H-   H" +
" --- @H     $ H$      H-# @H" +
"#-@-#@H@X#H@@@@@@H##X#H@#$@H" +
"#   #@H   H  @@  H    H H#@H" +
"##$##@H@##H##$@@ H   @H    H" +
" ##   H   H ##$@@H $  H-H##@" +
"      H   H#$##$@H @  $ H#$@" +
"######H   H##$## H ---@ HX#@" +
"      H0  H ##$##H      H   " +
"######@###H&  0  H#######@##",

//======<<< Level 136 >>>======

"S                           " +
"S                     ----- " +
"S        &          0      H" +
"S    ###################   H" +
"S  ######################$ H" +
"S ####  $               ## H" +
"S ##$$  ## 0      $     #X H" +
"$###    #################$ H" +
" X##    ################   H" +
" $##               $       H" +
"  ####  $       0 ##       H" +
"   #################$      H" +
"     ###############       H" +
"                           H" +
"0           0              H" +
"############################",

//======<<< Level 137 >>>======

"S@ @@ @@@@@@    @@@@@@@@@@@@" +
"S@ @@ ----- ----          -@" +
"S----H-----@S  H@@@@@@@@@H @" +
"S$   H$    @S  H   $   @ H &" +
"S#H#X@##H##@S  H###@###@#H#@" +
"S H-----H $@S  H$  @ HHHHH @" +
"S H @ @ H @@S  H#$   H$@  $@" +
"H@H$   0H  @S  H####X@#@###@" +
"H@@##H##@##@S  H#  @ $ @$  @" +
"S$   H    $@H--H#  @ @@@@  @" +
"H### H    @@H0$H# $@ $   $ @" +
"H####@#H##@@@##@#H#@##X###H@" +
"H--- @-H----- #@#H--------H@" +
"H$  H@ H $   H$  H $    $ H@" +
"@#H#@@#@X#@##H#X#@#H#@H##H#@" +
"$#H $        H     H 0H$ H  ",

//======<<< Level 138 >>>======

"         S    #####&        " +
"         S   #$HHH$# ------H" +
" -----   S   #HHHHHH#      H" +
"H        S   #HHH0HHH#     H" +
"H     ## S   #HHHHHHH#     H" +
"H    #$ #S    #$HHHHH#     H" +
"H     ##       #HHH$##     H" +
"H               ####### -  H" +
"H   0                ###   H" +
"HHHHHHH-#H  S   SS SSS##@  H" +
"HHHHHHH #H S S S   S  $#@@ H" +
"HHHHHHH #H S S S   SS   @@@H" +
"HHHHHHH #H SSS S   S     @@@" +
"HHHHHHH$#H S S  SS SSS    @@" +
"--------#H  0              0" +
"$  $ H######################",

//======<<< Level 139 >>>======

"S##########################S" +
"S----H@H----H##H----H@H----S" +
"S    H@H   H &  H   H@H    S" +
"S    H@H    H##H    H@H    S" +
"S    HHH    H##H    HHH    S" +
"H@S    H####H  H####H    S@H" +
"H@0S   H    H##H    H   S0@H" +
"H###########H##H###########H" +
"H@@@@@@@@@@@@##@@@@@@@@@@@@H" +
"H@0     @          @     0@H" +
"H@     H####H$$H####H     @H" +
"H      H    H##H    H      H" +
"H    H@H    H##H    H@H    H" +
"H    H@H   H $$ H   H@H    H" +
"H   $H@H$ @ H##H @ $H@H$   H" +
"############################",

//======<<< Level 140 >>>======

"0--------------H            " +
"          $$   H            " +
"H######   HH   @######H#####" +
"H        H@@H         H#$$##" +
"@#####H #H@@H#        H#  ##" +
"      H  HHHH  H######@##X##" +
"######@   HH   H          $0" +
"######@   HH  -H # #########" +
"######@   HH      # ########" +
"######@   HH       # #######" +
"######@   HH        # ####$#" +
"$#####@   HH         # #####" +
" ----- S###@#H              " +
"S     SS##@@#H0   @@H       " +
"S     S###@@#@####@@@H     &" +
"S     S###@@#@####@@@@H-----",

//======<<< Level 141 >>>======

"S##0#0################0#0##S" +
"S      H---H    H---H      S" +
"S   #$#H   H-HH-H   H#$#   S" +
"S   ##X#$  ##HH##  $#X##   S" +
"S   $   ##  HHHH  ##   $   S" +
"S## ####$## H##H ##$#### ##S" +
"S      ##$##H##H##$##      S" +
"SHH###  ##$ H  H $##  ###HHS" +
"SHH####  ####HH####  ####HHS" +
"SHH#$ $@H    HH    H@$ $#HHS" +
"SHH#$#@  ####HH####  @#$#HHS" +
"SHHX@@ $##$  HH& $##$ @@XHHS" +
"HHHH   ##$##HHHH##$##   HHHH" +
"HHHH####$## HHHH ##$####HHHH" +
"HHHH    ##$ HHHH $##    HHHH" +
"#######@H$@######@$H@#######",

//======<<< Level 142 >>>======

"                           S" +
"$         $@@$            -S" +
"H0       H####H     #####@&H" +
"H0       H$@@$H     #####H H" +
"H0     H###@@###H   ##$##@ H" +
"H0     H$  @@  $H   #####@ H" +
"H    H#####@@#####H #####@ H" +
"H    HH$   @@   $HH        H" +
"H####  H###@@###H     #####H" +
"H      HH$ @@ $HH          H" +
"H        H#@@#H            H" +
"H        HH$$HH            H" +
"H          HH              H" +
"H         H@@H             H" +
"H$        H  H            $H" +
"############################",

//======<<< Level 143 >>>======

"                            " +
"S & SSS0 SSS0 SSS0 SSS0 SSSS" +
"H###H H##H H##H H##H H##H  S" +
"H#$#H H##H H##H H##H H##H  S" +
"HX#X# #### #### #### ####  S" +
"H            H             S" +
"H H#$$# #### H@$# H### ####H" +
"H  #  # @H$@ H@## H#$# #$  H" +
"H  #### @@@@ H@## #X## ##X#H" +
"H            HH            H" +
"H#### #### ##@H @@@@ @@@@  H" +
"H##$# #$$# #$@H @$     $@  H" +
"H#X## #  # #X@H @@@H H@@@  H" +
"H            HH            H" +
"H            HH            H" +
"############################",

//======<<< Level 144 >>>======

"S@         --&            @ " +
"S@        H  $$           @ " +
"S@        H  ##           @ " +
"S@    ##@HH #@@# HH@##    @ " +
"S@   ##@HH #@HH@# HH@##   @ " +
"S@  ##@HH #@HHHH@# HH@##  @ " +
"S@$##@HH #@HH--HH@# HH@##$@ " +
"S@##@HH #@HH----HH@# HH@##@ " +
"S@#0HH #@HH--  --HH@# HH0#@ " +
"S@#HH #@HH-- $$ --HH@# HH#@ " +
"S@HH #@HH--  ##  --HH@# HH@ " +
"S@H #@HH--  ####  --HH@# H@ " +
"S@H#@HH--  ##HH##  --HH@# @ " +
"S@#@HH--  ##HHHH##  --HH@#  " +
"S@@HH--- ##HH$$HH## ---HH@# " +
"SSHH--0 ##HH-##-HH##  --HH##",

//======<<< Level 145 >>>======

"HH$0H  H  H  H 0H  H  H  H0H" +
"H #H #H #H #H #H H# H#$H#$HH" +
"H#H #H #H #H #HH# H# H# H# H" +
"HH #H #H #H #H  H# H# H# H#H" +
"H #H$#H #H #H H# H#$H# H# HH" +
"H#H #H #H$#HH# H# H# H# H# H" +
"HH #H #H #H  H# H# H# H# H#H" +
"H #H #H #H H# H#$H# H# H# HH" +
"H#H #H #HH# H# H# H# H# H# H" +
"HH #H #H& H# H# H# H# H# H#H" +
"H #H #H H# H# H# H# H# H# HH" +
"H#H #HH# H# H# H# H# H# H# H" +
"HH #H  H#$H# H#$H# H# H# H#H" +
"H #H H# H# H# H# H# H# H# HH" +
"H#HH# H# H# H# H# H# H# H# H" +
"HH  H  H  H  H  H  H  H  H H",

//======<<< Level 146 >>>======

"        &         - - -  -- " +
"H@#H#@H ###H@#H#@H H H ##  H" +
"H@#H#@H### H@#H#@H H H  ## H" +
"H@#H#@H ###H@#H#@H H H ##  H" +
"H@#H#@H### H@#H#@H H H  ## H" +
"HH#@#HH ###HH#@#HH H H ##0 H" +
"0H#@#H ### 0H#@#H0 H H  ## H" +
" H#@#H @  @ H#@#H HH H ##  H" +
" H#@#HH@$ @HH#@#H H  H  ## H" +
" HHH#@H ## H@#HHH H HH #$  H" +
"   H#@H  ##H@#H   H H   ## H" +
"HH H#@H ## H@#H HHH H  ##  H" +
" H H#@H  ##H@#H H   H   ## H" +
" H HHHH@@ @HHHH H HHHH ##  H" +
" H    H@ $@H    H H  H  $# H" +
" HHHH H@## H HHHH H  H ##  H",

//======<<< Level 147 >>>======

"HHHHHHH-       -----  & HHHH" +
"HHHHHH  #######     H##  HHH" +
"HHHHH  #########     H##  HH" +
"HHHH  ##$     $##     H##  H" +
"HHH  ##         ##     H##  " +
"HH $##$         $##    $H##$" +
"H  #########H     #####X####" +
"H  ##########H    $####X####" +
"HH  ##H $  $##H          ## " +
"HHH  ##H     ##H        ##  " +
"HHHH  ##H     ##H $  0 ##  H" +
"HHHHH  ##H0    #X#######  HH" +
"HHHHHH  ##H     X######  HHH" +
"HHHHHHH             $   HHHH" +
"HHHHHHHH     0         HHHHH" +
"############################",

//======<<< Level 148 >>>======

"S-  0                  &  -H" +
"S @@@#@@@#@@@##@@@#@@@#@@@ H" +
"S#0                      0#H" +
"H@  HH   HH      HH   HH  @H" +
"H@ H  H H  H $$ H  H H  H @H" +
"H@ H  H H  H HH H  H H  H @H" +
"H@ $HH$$$HH$    $HH$$$HH$ @H" +
"H@ H  H H  H HH H  H H  H @H" +
"H@ H  H H  H$  $H  H H  H @H" +
"H@  HH   HH      HH   HH  @H" +
"H@                        @H" +
"H @@@#@@@#@######@#@@@#@@@ H" +
"H --------- #### --------- H" +
"H  $    $  H####H  $    $  H" +
"H 0        H#HH#H        0 H" +
"@@@@@#@@@#@#$HH$#@#@@@#@@@@@",

//======<<< Level 149 >>>======

"@@  -   @@@  -  @ --        " +
" $-H @#$   #H @#$#  H@@#$@H#" +
" #  H @#  $#H  @@  H@ $## H#" +
" @#  H ##@ #@H0   H@  #@@@@#" +
" @@#  H @@#@@#@@@#H@@@#    $" +
" @$## H----   -- #H     @H X" +
" @@#  @X@   #@ $ @#@@#@@ H@X" +
" @@  @@$@@ #@@@#@@   -  H@@ " +
" @  @@@X@@@#$    @$#@  H@@  " +
"  $@@ H--- @@@    #@  H@@ --" +
"  @@ H    H          H@@ H $" +
" @@ H@    ----H@#H  H@   H# " +
"   H  @0#   0 H #@#H@ ##@H# " +
"  SXH  #@# S#@@##$@H @##$ #@" +
"$S@$@H  @$#S#$ ##@@#H ###@@@" +
"@S X  H  #@S@ @@#&  H@H#  $@",

//======<<< Level 150 >>>======

"SSHSS H  H HSH  HSH H  H HS " +
"  S   S  S S    S   SS S S S" +
"  S   SSSS SS   SS  SS S S S" +
"  S   S  S S    S   S SS S S" +
"  H   H  H HSH  HSH H SH HS " +
"H@@@@@@@@@@@@@@@@@@@@@@@@@@H" +
"H@#H$H#H$H#H0HH0H#H$H#H$H#@H" +
"H@#H#H#H#H#H#HH#H#H#H#H#H#@H" +
"H@$H#H$H#H$H#HH#H$H#H$H#H$@H" +
"H############HH############H" +
"H@$H#H$H#H$H#HH#H$H#H$H#H$@H" +
"H@#H#H#H#H#H#HH#H#H#H#H#H#@H" +
"H@#H0H#H$H#H HH H#H$H#H0H#@H" +
"H@@@@@@@@@@@@HH@@@@@@@@@@@@H" +
"H0$          HH          $&H" +
"##########H  HH  H##########"

];
