//******************************************************************
//* All levels convert from: LR Fan Book.lms
//* reference: http://www.spoonbillsoftware.com.au/loderunner.htm
//* converted by Simon Hung 2015/01/22
//******************************************************************

var fanBookData = [
//======<<< Level 001 >>>======
/* FIRST LEVEL 001 */
"       &          ---  ---  " +
" #   ### -H####- #   ##$  #H" +
" # $H#  # H#    # #  # #  #H" +
" #  H#$ # H# $ #S $# # #$ #H" +
" #  H###--HX## ##@@# #  # #H" +
" #$ H# #   X   #   # #  #$#H" +
" ### #  #  #   #   # #   ##H" +
"                  -        H" +
"  ####  H### -H### H#   #  H" +
"  #   @H#  H# #   #H#  #   H" +
"  #  $#H#  H# #   #H#$#    H" +
"  #H## H# $H# # $ #H##     H" +
"  #H H# # -H# # --#H###$   H" +
"  #H  # #   # #   #H#  # --H" +
"  ####   ###   ###  #   #   " +
"                            ",

/////////////////////////// BEGIN FOR NORMAL EASY //////////////////////////

//======<<< Level 006 >>>======
/* NORMAL EASY 002 */
"H----------  &  -----------H" +
"H          #####           H" +
"H       - ####### -        H" +
"H        ##-###-##         H" +
"H        ## ### ##         H" +
"HH    #  ### X ###  #     HH" +
"H H    #$$$$$$$$$$$#     H H" +
"H  H   #$    $    $#    H  H" +
"H   H   #$$$$#$$$$#    H   H" +
"H    H  ###@@#@@###   H    H" +
"H     H  ##HHHHH##   H     H" +
"H      H  #######   H      H" +
"H       H  #####   H       H" +
"H        H  ###   H        H" +
"H         H##### H         H" +
"         #########          ",

//======<<< Level 019 >>>======
/* NORMAL EASY 003 */
"@#########   #S#   ########@" +
"@    #  H#0 ##S## 0#H   #  @" +
"@   #  H##### S #####H --#H@" +
"@0  # H####   S   ####H  #H@" +
"@   # ####   S#S   ##### #H@" +
"@ &  ## #   S###S    # ## H@" +
"@ 00#####  S#####S   #####H@" +
"@      $  S   $   S  $    H@" +
"@     $H$S   $H$   S$H$   H@" +
"@    $H H$  $H H$  $H H$  H@" +
"@   $H   H$$H   H$$H   H$ H@" +
"@   H  $  HH  $  HH  $  H H@" +
"@    H   H  H   H  H   H  H@" +
"@    $H H$  $H H$  $H H$  H@" +
"@    --H------H------H--  H@" +
"@      $      $      $    H@",
	
//======<<< Level 042 >>>======
/* NORMAL EASY 004 */
"@        ######### S       @" +
"@        #   &   # S       @" +
"@-------###########S------H@" +
"@H      ##H -  - H##      H@" +
"@H      # H #  # H #      H@" +
"@H     $# H      H #$     H@" +
"@H    $# $H0    0H$ #$    H@" +
"@H   $# $# H  $ H #$ #$   H@" +
"@H  $# $#  $H  H$  #$ #$  H@" +
"@H $# $#  $# HH #$  #$ #$ H@" +
"@H # $#  $#  HH  #$  #$ # H@" +
"@H  $#  $#  ##H#  #$  #$  H@" +
"@H  #  $#  ##$H##  #$  #  H@" +
"@H     #  ##@H$@##  #   HHH@" +
"@H       ###@H@@###     H  @" +
"@H      HHHHHHHHHHHH   HH  @",

//======<<< Level 032 >>>======
/* NORMAL EASY 005 */
"    $      $     $          " +
"##H##X####H####X####H###X##H" +
"  H       H         H----  H" +
"  H 0     H              0 H" +
"######H#X#H#H#####X#H###H###" +
"      H---H H       H   H   " +
" $    H     H   $   H   H  $" +
"###HX########H##X########X##" +
"   H         H              " +
"$  H         H  0     $     " +
"######H##X#########H########" +
"      H            H        " +
"    $ H            H       $" +
"##H######X######X######H####" +
"  H                    H    " +
"  H         &          H    ",

//======<<< Level 077 >>>======
/* NORMAL EASY 006 */
"@@H@HH@@HH@HH@HHH@H@@@@H@@H@" +
"@HHHH@H@@@H@@0@@H@@H@H@@H@@@" +
"@@H@H@HHHH@HHHHH@HHHHH@HHH@@" +
"@HHH@@@@H@@@@@@H@@H@@H@H@@@@" +
"@H@H@HHHHH@HHH@H@HHH@@@H@HH@" +
"@H@H@HH@@H@H@@@HH@H@HHHHHHH@" +
"@H@H@@HH@HHHHH@H@@H@H@@@@H@@" +
"@H@H@H@H@@@H@H@H@HHHH@HH@HH@" +
"@H@HHH@HHH@@@H@H@H@@H@@HHH@@" +
"@H@@@@@H@H@HHH@H@H@H@@H@H@H@" +
"@HHHH@HH@H@H@@@H@HHHHH@HH@@@" +
"@@@H@H@@@H@H@HHH@@H@@HH@HHH@" +
"@0HH@HHH@H@H@@@HHHHH@H@H@@H@" +
"@@H@@H@HHH@HHH@@@@@@@HHH@@H@" +
"@@HHHH@H@HHH@HHHHH@HHH@@&$H@" +
"@HH@H@@H@H0H@H@H@HHH@H@0H@H@",
	
//======<<< Level 026 >>>======
/* NORMAL EASY 007 */
"$&    0           $#HHHHH$##" +
"##-#############-#H#H# #H###" +
"                  H#H# #H ##" +
"   ## ###### H######H# #H ##" +
"@@   #       H ##### # #H ##" +
"   # #########H #### # #H ##" +
"   # $       #H  ### # #H ##" +
"   ######### #H   ## # #H ##" +
"$  #$       $#HHHH## # #H ##" +
"## ######H####   H   # #H ##" +
"      #$ H $     H ### #H ##" +
"H# ####### ######H   # #H ##" +
"H ##  ###########H# $# #H ##" +
"H #################### #H ##" +
" $#  -                  H ##" +
"   S#$########H####### #H$##",

//======<<< Level 027 >>>======
/* NORMAL EASY 008 */
" $          0H              " +
" ############H    ##        " +
" HHH         H-     ##      " +
"   H    $  $H  -      ##    " +
"  #H##### 0#H#0 ---   0 ##  " +
"  #H     $# H #  $ ----     " +
" H##    $ $H$H   #   $      " +
"H H###### # H #  # $$#      " +
" H         #H#  ##$##       " +
"H#### $     H  ###          " +
"H    ####H#######$#####     " +
"H        H       ##$###$    " +
"H $$    H H   $ $######$    " +
"H# ############  ##$$$#$    " +
"H $   $     $& #### ##      " +
"##############H   $ $ H@# $ ",

//======<<< Level 030 >>>======
/* NORMAL EASY 009 */
"   0 0 0     & S  0   0     " +
"               S            " +
"               S            " +
"H-- - - - ---  S  - --H     " +
"H  # # # #  # #### #  H###  " +
"H  # # # ##$# #  # #  H#    " +
"H  # # # #### #    #  H###  " +
"H#$# # # # ## #$## #$#H#    " +
"HX## ### #  # #### ##XH###  " +
"H                     H     " +
"H#############H###H###H# $$ " +
"H#$#    -  #$#H   H  #H#####" +
"H## H### #H# #H#$$H###H    H" +
"H# $H#$#  H# #H---H#$######H" +
"H $#H# #  H ###   ##       H" +
"############################",

//======<<< Level 031 >>>======
/* NORMAL EASY 010*/
"                            " +
"  ########H###########$#####" +
"$-#$$$$$$#H$$$###$$$########" +
"#$@@@@@##$H#######H###$$$###" +
"#$$$$  ###H-------HH  ######" +
"#$#######$H$$$$$$$HH########" +
"#$$$$$$$$#H########H########" +
"#$########H####$###H#$$$####" +
"#$########H##$$$$$#H########" +
"#X#################H########" +
"# $$$$$$ ---$$$$$$$H$$$$####" +
"# ######H$-$################" +
"# ####  H###################" +
"# ###   H                   " +
"$       H       &      00000" +
"#     ##H###################",

//======<<< Level 037 >>>======
/* NORMAL EASY 011 */
"@                         S@" +
"@------------------------#S@" +
"@H       &     H 0 H     #S@" +
"@###### ###H ##@###H##   #S@" +
"@######   $H ##@###H $#  #S@" +
"@#####     H ### ##H     #S@" +
"@#    #    H #    #H     #S@" +
"@#    #    H #    #H  $  #S@" +
"@# - $#    H #    #H H#  #S@" +
"@#H ###    H #  $ #H H  ##S@" +
"@#H ##     H #  # #H H   #S@" +
"@#H ##$    H # $  #H H   #S@" +
"@#H        H # #  #H H    S@" +
"@######  $ H #    #H H S###@" +
"@######H   H      0H H    $@" +
"@$     HHHHH###############@",

//////////////////////////// BEGIN FOR NORMAL NORMAL ////////////////////////////

//======<<< Level 015 >>>======
/* Normal Normal 012 */
"@             S            @" +
//"@ ------------S ----$----  @" +
"@ ------------S ---------  @" + //Modified: can not reborn on gold position for this platform 
"@H#H    $    #H#  0   &  #H@" +
"@H #H######H# H ######### H@" +
"@H #H#--   H##H##### #### H@" +
"@H #H#H-###H  H    H----H-H@" +
"@H-   H # -###S###$H    H H@" +
"@H # #H $#$#  S  ##H#H# # H@" +
"@H ###H ###   S   ### #H# H@" +
"@H $  #  #    S       H## H@" +
"@H #  @$##    S    # #$## H@" +
"@H ####X #    S    ###### H@" +
"@H     $ #    S    #$     H@" +
"@H ##H## #    S    ####H# H@" +
"@H #H ####    S    ##$#H# H@" +
"@H$#H   $#  $ S $  ## H## H@",

//======<<< Level 016 >>>======
/* NORMAL NORMAL 013 */
"@     H----@---H--H------#@@" +
"@0 0  H        H  H  $ $-#@@" +
"@#### H ##$ $##H  HH #$# #@@" +
"@ 0   H  ## ##  --H H###H#@@" +
"@ H#  H   ###     H  #$# #@@" +
"@H $#HHH ##&##    H  #H# #@@" +
"@H#$# H           H  #-# #@@" +
"@H #@ ### #####H#HH#H#$# #@@" +
"@H#$H #$$H### #H#HH#H### #@@" +
"@H### #   #$$ # #HH      #@@" +
"@H#$# #######   # H####H #@@" +
"@H#$#     ####### H#$$## #@@" +
"@HH#              H##H## #@@" +
"@HHHHH ########H#####H## #@@" +
"@H    #            $$ #  #@@" +
"@#########################@@",

//======<<< Level 017 >>>======
/* NORMAL NORMAL 014 */
"@0     #     -- $  #$      @" +
"@     &#     H ###- ######H@" +
"@-   $##     H      -  #  H@" +
"@$####     $ H     #  $#$H @" +
"@#$# $  H### H$#H  #H###$H @" +
"@  #H#### $#### H  #H####H @" +
"@#--H-$$ ##   $ H  #H#$$##H@" +
"@$$$S ##  H###### $#H#-H  H@" +
"@H#H- $$$$$      $##H#$$$ H@" +
"@H# H H###H     $# #H######@" +
"@H#H$$H$ $H$$$$$#$H@       @" +
"@H####################H    @" +
"@H---------------  ---H#$-H@" +
"@H# 0     0  $          # H@" +
"@H####################### H@" +
"@H                        H@",

//======<<< Level 018 >>>======
/* NORMAL NORMAL 015 */
"@                          @" +
"@   #######H&      ###H    @" +
"@  #########H-----#####H   @" +
"@ #########$#     #####H   @" +
"@ #####   ###    #######H  @" +
"@ ####           #######H  @" +
"@ #####   ------ ####$##H  @" +
"@  ##$####   $  ###    # H @" +
"@    #######    ##H    ##H @" +
"@       @####   ##      #H @" +
"@        ####   ##      #H @" +
"@H##@    #### S###########H@" +
"@H#$#   ##### S###########H@" +
"@H #########  S#$#H   $# #H@" +
"@H  #####$# @@@###     ###H@" +
"@H                        H@",

//======<<< Level 024 >>>======
/* NORMAL NORMAL 016 */
"@                      &0$ @" +
"@     S  H $########H### # @" +
"@#   H-#####$-$ $ $ $H###  @" +
"@#H###  ### H ###########  @" +
"@#H   #-----H#$$#########  @" +
"@@@@@H@@@@ @@@@@@@@@@@###  @" +
"@    H----S- $ $ $ $ $ $   @" +
"@H#         S##########H   @" +
"@H########S#H           #  @" +
"@H#$ #######H           #  @" +
"@H##########H           #  @" +
"@H#$#$######H           #  @" +
"@H##########H$   $   $ $#  @" +
"@H$ $ $ $ $#H############  @" +
"@H######### H              @" +
"@H         #0# 000         @",

//======<<< Level 025 >>>======
/* NORMAL NORMAL 017 */
"@   - - -             - &$ @" +
"@H##$#$#$#H####H#####H-H#$#@" +
"@H# ###########-#$H$## ####@" +
"@H#H####  -###$H$#$#$---$--@" +
"@H#H#####$ # -#H#$X$## H###@" +
"@H#H#     - #$#H###### H#$#@" +
"@H#H#HHHH# #$##H  HH   H###@" +
"@H#H#H--- $##$-H##$$##H - 0@" +
"@H#H#   H# #$##HH$##$#H  # @" +
"@H#H####H###  #H##$###H  ##@" +
"@H#H#---H------H###$##H   0@" +
"@H#H#H----------H$##$HH  # @" +
"@H#H#H          ##$$##H  ##@" +
"@H#H HH#################H  @" +
"@H H--------------------H#$@" +
"@###XXX####################@",

//======<<< Level 028 >>>======
/* NORMAL NORMAL 018 */
"###       ####         #####" +
"# #H#####H# ####H####HH# ###" +
"##HH##$##H###$##H##$#H #####" +
"  H #####H  ####H#####H   ##" +
"  H##$#HHH      H###$#H   ##" +
" HH####H        H######H  ##" +
" H #$ #H    &   HHH##$#H  ##" +
"HH#####HHH#####HH H###$#H ##" +
"H #0###HHH##0##HH  H#0# H ##" +
" ####HHH H#####H   H####XH##" +
" #$#HH   H #0# H    H@$##H##" +
"####H   #########H   H###H##" +
"#$#HH    ###$####H###H   H##" +
"###H   #########HH#$#H###H##" +
"   H            H####H#$#H##" +
"################H#$S# #$#H##",

//======<<< Level 034 >>>======
/* NORMAL NORMAL 019 */
"                          S " +
"                         &S " +
"#H           H#H        ##S " +
"H#############H#########H#S " +
"H $ $ $ $#$$$$H#$ $ $ $ H#S " +
"H H H H H#$X##H#H H H H H#S " +
"H$H$H$H$H#$$$$H#H$H$H$H$H#S " +
"##########$X##H##X########S " +
"         #$$$$H           S " +
"         #$X##H$          S " +
"         #$$$$H$          S " +
"         #$X##H$          S " +
"         #$   H$          S " +
"         #$   H$          S " +
"         #$   H$          S " +
"         #$   H$          S ",

//======<<< Level 035 >>>======
/* NORMAL NORMAL 020 */
"@             S            @" +
"@          &  S            @" +
"@#########################S@" +
"@#########################S@" +
"@##   ###   H#H   ##   ###H@" +
"@# ###$#H###H#H###H#H## ##H@" +
"@# #####H###HHH###H#H### #H@" +
"@# #####H###H# # #H#H### #H@" +
"@# #####H###H# # #HHH#####H@" +
"@# ##$H# ###H# # #H#H### #H@" +
"@# ### # ###H# # #H#H### #H@" +
"@# ### # ###H#H###H# #-$##S@" +
"@##   ###$ H###HHH$#   # #H@" +
"@######################## S@" +
"@#########################S@" +
"@00000                    S@",

//======<<< Level 039 >>>======
/* NORMAL NORMAL 021 */
"@                     S    @" +
"@ ----------------    S--  @" +
"@H                  0  H   @" +
"@H  #####H#####    H###H   @" +
"@H   H  -H-  H     H  $    @" +
"@H   H$- H -$H     H       @" +
"@H   H- -H- -H     H       @" +
"@H   H -$H$- H H0H H###H   @" +
"@H#  H-  H  -H H#H   $ H   @" +
"@H#  H - H - H H#H     H   @" +
"@H#  H-$-H-$-H H#H     H   @" +
"@H#  H   H   H- #H H###H   @" +
"@H## H---H---H  #H H$      @" +
"@H#$     H    ###H H    $  @" +
"@H  0    H  ###$#H H   0#H&@" +
"@H#########H$H#############@",

//======<<< Level 040 >>>======
/* NORMAL NORMAL 022 */
"@         S                @" +
"@##$      S        0  $    @" +
"@  @@H---HSH-----HH@#@@#H  @" +
"@    H   H-H     #######H  @" +
"@$0--H        @@H#######H  @" +
"@##  H        --H-------H  @" +
"@@ $ H# 0     # H       H  @" +
"@@ $ H####$$$ # H    0  H  @" +
"@@        #@@## H ####  H  @" +
"@########       H ####H#H#H@" +
"@       #       H  $$ H   H@" +
"@         ------H-----H   H@" +
"@               H     H## H@" +
"@   $$          H     H#$@H@" +
"@ H#############H     H#$@H@" +
"@ H      &      H     H#$#H@",

//======<<< Level 044 >>>======
/* NORMAL NORMAL 023 */
"@#####            S        @" +
"@   ##      ### # S##      @" +
"@##     ###H #$ ##H ###### @" +
"@ $ #######HH#H ###H- ---H @" +
"@@@@#H-  $$ H#H--$#H -   H @" +
"@    H @@@@@H#   ##H ####H @" +
"@$$$0 #    #H&##H  H ##$#H @" +
"@#@@@@@ - ####@HH######### @" +
"@--   ## #- H#@H #0        @" +
"@  ## ##@# #H#$H #########@@" +
"@ ##  #  ###H#@H     ##### @" +
"@  ###@     H @H-  #H#####$@" +
"@$##$#@@@@@@@#@H$ ##H#####H@" +
"@#####H    H   H ###H     H@" +
"@     H  $ H0$ H####H    ##@" +
"@##########################@",

////////////////////////////// BEGIN FOR NORMAL HARD ////////////////////////////

//======<<< Level 002 >>>======
/* NORMAL HARD 024 */
//"  ---0  -   --&-----$--  0--" +
"  ---0  -   --&-----$--  0 -" + //"modified for this platform, 1/20/2015 
"##   ##H$###  #    $H- #X#  " +
"##$ $##H##### #   $H#-##X## " +
" ## ## H#####$#  $H##$##X## " +
"  # # H ## ###H $H##H### ###" +
"  # # H##   ##H$H## H##   ##" +
"  ### H##   ##H###  H##   ##" +
"  ### H##   ##H#$   H##   ##" +
"   #  H##   ##H##$  H##   ##" +
"   #  H##   ##H ##$ H##   ##" +
"   #  H##$ $##H  ##$H##$ $##" +
"   #  H### ###H   ##H### ###" +
"   #  S ##### #H   # #######" +
"   #  S ##### #H   ## ##### " +
"   #  S  ###  #H   ##  ###  " +
"##H$H###H$$$H#$#H$$$$H#$$$H#",

//======<<< Level 013 >>>======
/* NORMAL HARD 025 */
"        -           #       " +
"H# #  H## #H####### #H##$##H" +
"H$####H##X H#       #H# ## H" +
"H#    H- # H#---- $ #H#  $ H" +
"H    H## # H ########H#    H" +
"H H## # #  #H######  H#   H " +
"H H#$ # H ##H# # ##H#H    H " +
"H H ###  # #H# ---#H### # H " +
"H  H  #    #H#$$#$#H# ##  H " +
"HH##### #$ #H#HH-H#H##   # H" +
" H $   ###  H##### H# # # #H" +
" #####H  #  H   $  H#$#$ #HH" +
"#     ##H############H #$# H" +
"&      #H  $ # ##   # H ###H" +
"H#####H###H$H  #$  HH-#####H" +
"H##$##H   H H###H #H#      H",

//======<<< Level 020 >>>======
/* NORMAL HARD 026 */
"@& 0$                  $$$$@" +
"@## #     H#0$    #H   ###H@" +
"@ ###     H# #    #H $    H@" +
"@         H ##  $ #H # ###H@" +
"@##### #$ H# # ## #H ##  #H@" +
"@     $H- H#$$# ###H     #H@" +
"@$$$$ ##  H$###0# #H#$#$##H@" +
"@H##H     H#$# #$$$####0##H@" +
"@HH #- #$ H##$$######H####H@" +
"@#H## $H- H#H## #$$ #H    H@" +
"@#H## ##  H#H##$####H#H####@" +
"@$H# $    H#H###$ ##$$H### @" +
"@H#### #$ H#H#### ####H####@" +
"@H    $H#HH#H####$####H$## @" +
"@H$$  #####HH---##$-HHH#0##@" +
"@H###          #H# S##H#H# @",

//======<<< Level 021 >>>======
/* NORMAL HARD 027 */
"@#$#-&              # # #  @" +
"@#H# ######@@@@@H##-#-H-H$H@" +
"@#H#H--#-$-#H$H @H#$#H$# H#@" +
"@#H#H$H HHH  # H@@@@# H#H$ @" +
"@#H#H# H   H   H H#H#H ###$@" +
"@#H-H# H# H#H H  H H  H ---@" +
"@###H# H#  # H ####H######H@" +
"@  #H# H# # 0 H  -# ##- # H@" +
"@H#-H-H H - #H ##   #- #$#H@" +
"@H#-   H # #$#H # #   ##0#H@" +
"@H##### H# ### HH### ##$##H@" +
"@H#$## H   #$##H####-# #  H@" +
"@H####H#H###--#H#  #------H@" +
"@H#$ #H# #- ###H ###H- # H @" +
"@H  # H  #$#   H #  H #$  H@" +
"@H##$##### H####H#$#$### #H@",

//======<<< Level 041 >>>======
/* NORMAL HARD 028 */
"@         H ---            @" +
"@---------H-   H-----------@" +
"@         H#     #  $     H@" +
"@H###@@ #@## ######H  0H###@" +
"@HH$     --  ####$  H  H# #@" +
"@ H $ ###--0 ####H   H H###@" +
"@ H  $#$# -  $####H H  H   @" +
"@ H   ###-- #######H $0###H@" +
"@ H0    H&    $    #H  #$#H@" +
"@ H#######H #####H#### #$#H@" +
"@ H  #   #H # -##    # ###H@" +
"@ HH#### #H # $## $  # #--H@" +
"@ H #$ #$#H ########## #H$ @" +
"@ H#######H    ## -    ###H@" +
"@ H#   $ #H ##H#$H -      H@" +
"@ H  ##### 0##H##H  ###H  H@",

//======<<< Level 050 >>>======
/* NORMAL HARD 029 */
"@#                 #     $ @" +
"@#      ---        #####H##@" +
"@#  #H  H     H###H  $##H#0@" +
"@#H# H  H $   H#$ #H   #H##@" +
"@#H##H  H0   ###########H#$@" +
"@ H ##H####@#H       #  H##@" +
"@  H# H ##  #H###### #$ H##@" +
"@H### H ##  #H       #--H##@" +
"@H# $ H ##  #H $ $ $   $H##@" +
"@H#   H ## $#H########--H##@" +
"@H#   H #####H #$   H#$ H#$@" +
"@H#   H   &   ##### H#--H##@" +
"@H#    ########     H# $H##@" +
"@H#######$ #$ ##H#  H#  H##@" +
"@H  $  0########H   H#  H##@" +
"@######H  $  $ #H0  H#H H#$@",

//======<<< Level 057 >>>======
/* NORMAL HARD 030 */
"@     &                    @" +
"@    -H------H     H------H@" +
"@   - H      H     H      H@" +
"@  -  H #$###H     H #$###H@" +
"@$-  -H #####H-   -H #####H@" +
"@#  - H     0H - - H     0H@" +
"@  -  H  @@@#H  -  H  ####H@" +
"@$-  -H   $  H - - H    $ H@" +
"@#  - H######H-   -H ## ##H@" +
"@  -  H######H -$- H #####H@" +
"@$-  -H------H  -  H------H@" +
"@#  - H     0H$- -$H     0H@" +
"@  -  H @@@@#H-   -H  ####H@" +
"@$-   H   $  H - - H      H@" +
"@#  --H######H  -  H###$##H@" +
"@  S   ######  - -  ###### @",

//======<<< Level 066 >>>======
/* NORMAL HARD 031 */
"@    HHH  00000  HHH       @" +
"@   H   H ----- H   H      @" +
"@  H  &  H    -H $ $ H     @" +
"@  H - - H     H     H     @" +
"@  H  H  H $$$ H  #  H     @" +
"@#- H # H  ###  H   H  ##  @" +
"@#   HHH  #  #   HHH   #   @" +
"@ # $$H$$ #   #   H   #    @" +
"@  ###H###     ###H###     @" +
"@     H           H        @" +
"@     H           H        @" +
"@   HHH           H        @" +
"@  H   HH        H H       @" +
"@ H      H      H   H      @" +
"@##   $  H     H     H     @" +
"@       H##   ##H   H##S$  @",


//======<<< Level 070 >>>======
/* NORMAL HARD 032 */
"@                          @" +
"@  #0#H------$------H#0#   @" +
"@   #$#H     #     H#$# #  @" +
"@  #$# H----H H----H #$#   @" +
"@   #       H H       #    @" +
"@  H--------H0H            @" +
"@  H         # --------H   @" +
"@  H        #H#        H   @" +
"@  H       ##H##       H   @" +
"@  H    H ##$H$## H    H   @" +
"@  H     ##$#H#$##    H H  @" +
"@  H    ##$# H #$##  H   H @" +
"@  H   ##$X  H  X$## H    H@" +
"@  H         H       H # #H@" +
"@  H&        H       H#$#$S@" +
"@##########################@",

//======<<< Level 074 >>>======
/* NORMAL HARD 033 */
"@           H#H            @" +
"@           H#H            @" +
"@H#####H    H#H    H#####H @" +
"@H# $ #H    H#H    H#- -#H @" +
"@H# 0 #H    H#H    H#-$-#H @" +
"@H#####H    H#H HHHH#-0-#H @" +
"@HHHHHHHHHH#   #H  H#####H @" +
"@         H#   #H  HHHHHHH @" +
"@#########H# $ #H          @" +
"@         H# 0 #H##########@" +
"@ H#H#H#HHH#####H          @" +
"@ H#H# #H HHHHHHHHH#####H  @" +
"@ H#$#H#H    #    H#   #H  @" +
"@ H# 0 #H    #    H# $ #H  @" +
"@ H#####H    #    H# 0 #H  @" +
"@ HHHHHHH    # &  H#####H  @",

////////////// BEGIN FOR NORMAL HARD HARD //////////////////////
	
//======<<< Level 043 >>>======
/* NORMAL HARD HARD 034 */
"@ ####               S     @" +
"@  0   ##############S     @" +
"@H#HH#H0             S#####@" +
"@H ################ @H----H@" +
"@H H----    &  H-H###H    H@" +
"@H H    - H  H-H H---H    H@" +
"@H H     -H--H   $        H@" +
"@H H      H               H@" +
"@H H  $ $ H               H@" +
"@H H $0   H     -  0 -$$  H@" +
"@  H ##H###H#### #### ##  H@" +
"@  H   H   H              H@" +
"@  H---H   H              H@" +
"@      H   H              H@" +
"@      H   H              H@" +
"@$     H  0H              $@",
	
//======<<< Level 048 >>>======
/* NORMAL HARD HARD 035 */
"@   H-HHH       HHH-H    S @" +
"@---H HHHHH   HHHHH0#####S#@" +
"@H   ###############  -  S @" +
"@H @@#################  -$S@" +
"@H    #-----------#      H#@" +
"@H0#H #          -#   H-S  @" +
"@@@@HH# ###   ### #H###S$  @" +
"@   HH#  $  $  $  #H# ###H @" +
"@###H$#     $     #$ # $ H @" +
"@$##H$#     $     #$- ## H @" +
"@###H$#           #$ #   H @" +
"@#$#H  #  -----  #  - #  H @" +
"@###H   #   0   #    #   H @" +
"@$##H    #######    - #  H @" +
"@###H    HH&$0HH     #$ $H$@" +
"@##########################@",

//======<<< Level 049 >>>======
/* NORMAL HARD HARD 036 */
"@            S             @" +
"@            S             @" +
"@H   - -   0 S 0  &- -  0H @" +
"@H### # ##H#   #### # ###H @" +
"@H # # # # @#### # # # # H @" +
"@H# # # # # # # # # # # #H @" +
"@H # # # # ##### # # # # H @" +
"@H#$# #$# # ### # #$# #$#H @" +
"@H # # # #       # # # # H @" +
"@H       # H###H #       H @" +
"@H#######################H @" +
"@H##$##$  ###$###  $#0 $#H @" +
"@H#0 ###  ##$$$## #######H @" +
"@H##### ####HHH#### #####H @" +
"@H          HHH          H @" +
"@##########################@",

//======<<< Level 063 >>>======
/* NORMAL HARD HARD 037 */
"@      S            S      @" +
"@ #    S     &      S      @" +
"@ #$###H############H######@" +
"@H## ##H############H#@####@" +
"@H#   #H#HHH$H$HHHH#H##@# H@" +
"@H## ##H#HHHHHH#HHH#H#H  ##@" +
"@HH ###H#H#HH HHHH##H# H# #@" +
"@HH ###H#HH$H##$HHH#H# H#H#@" +
"@#   ##H#HHHHHHH#HH#H#HH#$#@" +
"@## ###H#$H#H$HHH$H#H#H H##@" +
"@#$####H#HHHHHHHHHH#H#H# $#@" +
"@      H#HH$H#H$HHH#H#H## #@" +
"@######H#HHHHHHH#HH#H######@" +
"@0     H#HH#HHHHHHH#H     0@" +
"@H###### H$HHHHH$H  ######H@" +
"@H $    #@@@@@@@@@@#  $   H@",

//======<<< Level 067 >>>======
/* NORMAL HARD HARD 038 */
"@   -------  &   -------   @" +
"@ $#H###   ######   ###H#$ @" +
"@--#H0#  ###    ###  #0H#--@" +
"@###HH  #  ######  #  HH###@" +
"@# #HH # H# #### #H # HH#$#@" +
"@####H-H H-      -H H-H####@" +
"@    ##H H ###### H#H##    @" +
"@### ##H#H#$##H#$#H#H## ###@" +
"@$    #H#H#-#H #-#H#H#    $@" +
"@#$##$#H#H ##$H## H#H#$##$#@" +
"@$ ####H#H ###### H#H#### $@" +
"@##  $ H #H  X#  H# H $  ##@" +
"@     HHH ##$X#$## HHH     @" +
"@##H##H #H  #$$#   # H##H##@" +
"@  H   H ##HH##HH## H   H  @" +
"@H####$#H0   HH   0H#$####H@",

//======<<< Level 075 >>>======
/* NORMAL HARD HARD 039 */
"@                          @" +
"@H################# #H#### @" +
"@H $##    0##       #H##$# @" +
"@H###    $##0        H#    @" +
"@H###0 -$####$   ##$###    @" +
"@H  ##$$#   ##$   #     #  @" +
"@H#  #####   ##$  ##$  # $ @" +
"@H##  #####$  ##$   #$  $##@" +
"@H ##  #####$  ## #  # $## @" +
"@H $##  #####$   ##$   ##H @" +
"@H$# ##  ##### # #       H @" +
"@H# $###   H## # @H@@H  $H$@" +
"@H $# $##  H#### @H @H  $H$@" +
"@H #  # ## H     @H$@H  $H$@" +
"@H  0     &H     @@@@H ####@" +
"@###############H    H#####@",

////////////////////////////// BEGIN FOR SPECIAL NORMAL ////////////////////////////

//======<<< Level 053 >>>======
/* SPECIAL NORMAL 040 */
"@   H                   -  @" +
"@---H---             ### H @" +
"@$  H $ H##@@@@@@@@@@#$# @H@" +
"@#  H # H--  $   $   ### #H@" +
"@# $H # H - H#H H#H      $H@" +
"@# #H # H# #@@@@@@@@@@@ ##H@" +
"@# -- # H#-  $ $   -H#- $-H@" +
"@ #$ ## H# #@@ @@@# H  $ #H@" +
"@  ##   H#  #  0$   #H ###H@" +
"@       H#$##########H  --H@" +
"@  H@@@@@#           # #0#H@" +
"@H H@#####H@#@@#@@#@@#####H@" +
"@@@@@#####H $  $  $      @H@" +
"@&        H               H@" +
"@@@@@@@@@@H@@@@@@@@@@@@@@@@@" +
"@$        H     0        $$@",

//======<<< Level 059 >>>======
/* SPECIAL NORMAL 041 */
"@S#0                       @" +
"@S##                       @" +
"@S###            $-        @" +
"@S####           #0 ######H@" +
"@S#####        - #########H@" +
"@S######     $-  #####   #H@" +
"@S     $     #   #$   #H$#H@" +
"@ ##H H#     ##### HH##H #H@" +
"@ 0#H H# $-  ######HH#HH##H@" +
"@###H H# @   #$   #H##   #H@" +
"@   H H# ########H#H#H#H##H@" +
"@   H H# #H#H H##H#  H#H$#H@" +
"@   H H# #$H#H$H#H ##H#  #H@" +
"@   S H# #################H@" +
"@ $ S#H    &       0      H@" +
"@##########################@",

//======<<< Level 003 >>>======
/* SPECIAL NORMAL 042 */
"&--  $$     H     -   @     " +
"H  # ## $   H###0# @@@@H### " +
"H  #### #   H#$$#   $$ H#$#H" +
"H   @  ##   HH## # H## H#$$#" +
"H  @@@    @  H0     $  H##$#" +
"H   @    $@  H#### ## ######" +
"H   @ $  @@@ H  # ##    H $H" +
"H0    #$  @  H #  ###  #H #H" +
"########  @ HH   ###  ##H   " +
"     $    @ H   @ #  ###H   " +
"  $####H  @ H  @@@  ####H   " +
" $###  H    H   @  #####H   " +
"######HH  $H# #H@$######H   " +
"#  H#$HH ### # H@#######H $ " +
"# $ ##HH      H         H # " +
"######## #####H### #####H## ",

//======<<< Level 005 >>>======
/* SPECIAL NORMAL 043 */
"#  -   &    #H             #" +
"###$###H###$#H#H#######H####" +
"#######H#$###H#H###H#$#H#H##" +
"#######H##$$#H#$#$#   #H####" +
"########H##$#H##$@@0@@0@@0@@" +
"#########H###H### $# $# $#  " +
"#########H###H###H#$H#$H#  $" +
"       ###H$#H##############" +
"H############H#            #" +
"H#$#$##$ $ $#H#  #########H#" +
"H$ $#########H#$ ## H H H#H#" +
"H#$##########H### $#$#$#$#H$" +
"H##$#########H####H H H H H#" +
"H$##$$$####$$H##@@#@#@#@#@$#" +
"H#$##H#$#$###H#$ #$ #$ #$ ##" +
"H#$#####$####H$#H$#H$#H$#H$#",

//======<<< Level 007 >>>======
/* SPECIAL NORMAL 044 */
"@ $------&   --------   $  @" +
"@$#0#####H#0#  ####H$#H####@" +
"@# ######H####    #H# H $  @" +
"@   $ ###H ##  $$ #H# H ###@" +
"@# ##    H     ## #H# H $  @" +
"@# ##    H# ####   H##H##0#@" +
"@###  ###H#  $   #H   H  # @" +
"@#     ##H###### #H# #H $  @" +
"@# ####$ H ##    $   #H@ ##@" +
"@#    ###H    ## #$   H@   @" +
"@## #####H#####  ## #HH ## @" +
"@  $# $ #H          #H #   @" +
"@ ### H#######H### H####@@@@" +
"@  $  H#     #H    H# $    @" +
"@########H############H####@" +
"@      $#H$         $#H$   @",

//======<<< Level 008 >>>======
/* SPECIAL NORMAL 045 */
"@#H#   #     # H #######-$H@" +
"@$H$ H#$HH##-$--H------ ##H@" +
"@H ##HH#--H #H  H#   H    H@" +
"@H-   H ##H #H ## H#$# #- H@" +
"@  H ##  #H   ## H  H #  #H@" +
"@H#-# #  # H# ##H -  H  # H@" +
"@H# # ##$##H# H  -H     # H@" +
"@H#   ##H  H#&H-H # #  H  H@" +
"@H  H ## # H-H0#H  H##   #H@" +
"@H #   # H-  H #H##$## # #H@" +
"@H #  H    H## #H #  # #-#H@" +
"@H#  # H  H ##   H#  ## H S@" +
"@H -# #$#H ## H# H## H    H@" +
"@H        #H  H# H--#HH## H@" +
"@H## ------H--$ ##HH$#H $H$@" +
"@H  ####### H #     #   #H#@",

//======<<< Level 009 >>>======
/* SPECIAL NORMAL 046 */
"@S       --$ & $0 -$      $@" +
"@S  0------#H###H#$H$$####H@" +
"@S  #H   #$   $ -##H# #0$#H@" +
"@S  #H  #  # H##  #H   ###H@" +
"@S  # H# $#  H$# $#H #H###H@" +
"@S  ##H ##   #H  ##  #H  #H@" +
"@S  ## H#$H#- #H #     ## H@" +
"@S  ###H##X#   H  ##H#  H##@" +
"@S  ###H     #$H    H####$ @" +
"@S  ###H  $$ ### #$#H    H @" +
"@S  ###H             #   H @" +
"@S  ###H###H     #  H#H####@" +
"@H#####H   H#HH#######H#   @" +
"@H  $####### H#H##   $H-#H @" +
"@HSH#  $  #  H  $# ##### #H@" +
"@ 00   #      #H  $## $   H@",

//======<<< Level 010 >>>======
/* SPECIAL NORMAL 047 */
"@                   ####  $@" +
"@###########H##     #HHH$@H@" +
"@     -  0 #H   #####H  - H@" +
"@H##H# ##HH-H         H  ##@" +
"@H## #H#    ##H    #H  H   @" +
"@H##H#$#     H######HHHH 0 @" +
"@H@@@@@@    H#$            @" +
"@H          H#####         @" +
"@H       $  H#     ###H#&$ @" +
"@H          H#H##H    H ## @" +
"@H#H     ---H#H  H    H  # @" +
"@H #H          #0  ####H#  @" +
"@$H#H  #############H  H # @" +
"@#H####           - H####  @" +
"@$    H##########H #H   #$ @" +
"@    $H   $ # $  H#0 H#H$  @",

//======<<< Level 012 >>>======
/* SPECIAL NORMAL 048 */
"     0           - -        " +
"   &    H########0#$####H###" +
"  #$#   H#$#  #  ####   H#$#" +
"   X    H## - #  -      H#$#" +
"        H  $  ##$  $    H###" +
"#H#0#   H#H-H#$#        H#$#" +
"#H ###  H##  ###   H########" +
"#H $    H        $ H--  -- #" +
"# ####S# #########    H#  $0" +
"#     S H        #    H  H  " +
"$#H--#H  ###########H##$#H  " +
"##    H       ###   H   #   " +
"#$H###H-$    # # #   H # # #" +
" H$  $#     #  #  #   H   # " +
"$H####H H       #     H     " +
"$H$$$$#H #### #####H  H   0$",

//======<<< Level 047 >>>======
/* SPECIAL NORMAL 049 */
"@      $            ----###@" +
"@  $$ #H00 #  #H#@@@    ###@" +
"@######H   ####H#         #@" +
"@     -H    # #H#$ # ###--#@" +
"@##@H -H  #####H######@@  #@" +
"@$$ H -H  #####H--H $#   ##@" +
"@   H -H$$    --  H $#H# #$@" +
"@ ##H     &       H   H#$#H@" +
"@   ####H#########H######HH@" +
"@       H#$#   # #H      H$@" +
"@######H #$#H###H#HH### ##H@" +
"@--####H##$##H##H#HH# $ #$H@" +
"@$0####H##$###$ H#HH#   ##H@" +
"@######HH#$####-H#HH### #$H@" +
"@  $     #########HH@@@@@@H@" +
"@######H     0    HH      H@",

//======<<< Level 052 >>>======
/* SPECIAL NORMAL 050 */
"@              --          @" +
"@    #@#@#H---H--##H#@#@#@#@" +
"@   ##  0# H    # #H#  0 $ @" +
"@# ##   #0H$   # -#H#H@@@@@@" +
"@ #    #  $H $#H  #H#H     @" +
"@  $  #   H  #HH# #H###@@  @" +
"@# # #     H   $ ##H$    @ @" +
"@  ###$ -### # #  ##H  #H  @" +
"@ ##  #  ##$# #$   #######H@" +
"@    #   ### # # - - - -  H@" +
"@    ---H#$## #$H#@#@#H ## @" +
"@  &  # H##### #H     H $##@" +
"@##@# # H       H     H ##$@" +
"@###### H#######H $ $ H  ##@" +
"@       H H# H##H#   #H###$@" +
"@   H###H H#$H#$ ##########@",

//======<<< Level 061 >>>======
/* SPECIAL NORMAL 051 */
"@#####################    S@" +
"@#   - - - - -            S@" +
"@ 0H#$#$#$#$#$#H   &      S@" +
"@################H########H@" +
"@               #H-----H  H@" +
"@ #H--    --    #      H  H@" +
"@ #H  ####  H#  ####$##H  H@" +
"@ ##H##   # H#  #$#####H  H@" +
"@ ##H#####  H#  #### --H  H@" +
"@ ## H#   # H#  #$##H     H@" +
"@ ## H####  H#  ### H##$ #H@" +
"@ ##$H#   # H#  #$##H#####H@" +
"@ ## H####  H#  ### H###$#H@" +
"@ ######$###H#  #$##H##  #H@" +
"@ ######   #H$  #######@@#H@" +
"@ ##########H#            S@",

//======<<< Level 065 >>>======
/* SPECIAL NORMAL 052 */
"@H #-------#######    H####@" +
"@H #   0   # $ $ # $ #H#  &@" +
"@H ######H##H######## H H##@" +
"@H # ### H#$H#H#$#### H## H@" +
"@H # ### H##H#H# #### H## H@" +
"@H #  $ H## ######   #    H@" +
"@H #  # H## #      H# ####H@" +
"@H ##H  H  $ ####H# 0$ H  H@" +
"@H  #H##### #####HH##0#H $ @" +
"@##H#H  $$   ##H---# H#H# #@" +
"@  H###########H$$$$ H#H# #@" +
"@H## ##########H@#  #@#H   @" +
"@H # ###     -H#@@@@###H## @" +
"@H  0    -### H#@@#    H# $@" +
"@H#####$#$### H    H#H H#  @" +
"@H     ###### H############@",

//======<<< Level 078 >>>======
/* SPECIAL NORMAL 053 */
"@S----    -        0       @" +
"@H 0  @@@@          #0     @" +
"@H# #      #########   0   @" +
"@H#####               #   $@" +
"@H 0        ########### & H@" +
"@H# #                   # H@" +
"@H####       ###########H H@" +
"@H               $       H @" +
"@H# #   $    ############ H@" +
"@H###   ##       $       H @" +
"@H  $- ##              H#  @" +
"@H $#  # $           H#$# $@" +
"@H#######@         H# #####@" +
"@H ------$       H# # #####@" +
"@H#      S       H#$#######@" +
"@##@@@@@@@   ####H#########@",

//======<<< Level 079 >>>======
/* SPECIAL NORMAL 054 */
"@##   ##     &     -H######@" +
"@$  #H   ########H# H      @" +
"@### H#### # ### H#### ###H@" +
"@### H#      $ H####  #   H@" +
"@ ## H# H#H##  H# $#----H#H@" +
"@##0#H  #  H ######     H#H@" +
"@ #######$#H        ### H#H@" +
"@    #### #H##H###  ### H#H@" +
"@###        H H#$H##H$H#H# @" +
"@# H@####   H H# H  H H#H#H@" +
"@ H    $H###  ####  H H#H#H@" +
"@$H##   H $H##   $##### H#H@" +
"@H@H$H###  H$H#########H##H@" +
"@H#H H###### H#0#$##  -H #H@" +
"@H#@#H##########  ##H# H##H@" +
"@    H         $    H#0@$#H@",

//======<<< Level 080 >>>======
/* SPECIAL NORMAL 055 */
"@        -- - - - -------  @" +
"@H######-H$#$#$#$#$H     #$@" +
"@H###### H#########H--#####@" +
"@H###### #    -    H       @" +
"@H#####$ ###H# ####### ###H@" +
"@H###### #$ H$ ####  $   $H@" +
"@H-  $#  ###H# #  #H## #H##@" +
"@H #H   ## #H#  ###H$   H $@" +
"@$#$H#   #$#H$ #-$#H## #H##@" +
"@H##H###-###H#$####H$  H  &@" +
"@$#$H#-#    H##############@" +
"@###H#$# ##H-    ----  -#  @" +
"@   H ## #$H ####S   ##$# #@" +
"@H####-   # H###$###H  -   @" +
"@H    -#$#$ H #$##$#H####$#@" +
"@H#### ####H #$#####H#$ #H$@",

/////////////////// BEGIN FOR SPECIAL HARD ////////////////////////////
	
//======<<< Level 022 >>>======
/* SPECIAL HARD 056 */
"@& 0#  -      --           @" +
"@X#X H# #H##$H$$#H###H####H@" +
"@   H## #  #H$$#H # ###H #H@" +
"@## H#  ##H###$ H#      H#H@" +
"@## H$$# #$$ $$H###  # #H#H@" +
"@$$ H# H$H ###$H  ##### H#H@" +
"@## HHH H HH $$$#H$#-  @$#H@" +
"@$$ $ $ H#H# # ###H# ## $#H@" +
"@## ###H###-  # # H # ### H@" +
"@  H- #H $# ## $  H# $####H@" +
"@H#H$##H $ #####0#H### ###H@" +
"@$#H#$ HH-##  # #$H$#  ###H@" +
"@$#H ## #     # $#H#$#0##0H@" +
"@H#H#### H#$ ####$H$# ####H@" +
"@  H    #H######H###     -H@" +
"@##H###H#H      H  # ####0H@",

//======<<< Level 023 >>>======
/* SPECIAL HARD 057 */
"@&                      #  @" +
"@##HH ####### ----H- - -  H@" +
"@####       ##    H # # #H @" +
"@    ####H##$$####H# # #$ $@" +
"@   #####H  ##    H # # X$ @" +
"@  ###$0#H##$0####H# # #$ $@" +
"@ # #####H  ##    H # # X$ @" +
"@#$       ##$$####H# # #$ $@" +
"@ # #####H  ##    H # # X$ @" +
"@  ##$0##H##$0####H# # #$ $@" +
"@    ####H  ##    H # # X$ @" +
"@     ###H##$$####H# # #$ $@" +
"@        H  ##    H # # XH @" +
"@       H H #     H    #  H@" +
"@ $    H   H      H     X #@" +
"@H## ####H###  ############@",

//======<<< Level 069 >>>======
/* SPECIAL HARD 058 */
"@#########################H@" +
"@#########################H@" +
"@H          -       $  -  S@" +
"@H##H###H# #0####H### #0##H@" +
"@H  H#$#H  ######H ## ### H@" +
"@ #$#H #H  $   ###H#   --HS@" +
"@H######## #H#####H $ $-H S@" +
"@-- --   $  H#$#$ H## #  HS@" +
"@0H# $#H####H###  H#      H@" +
"@##H###H-H##H#######H # $#H@" +
"@--H$##H H---       H#### H@" +
"@###@#H  H   ####H  H#   #H@" +
"@  0  H##H##H##$#H# ######H@" +
"@H####   H  H####H##   $0 H@" +
"@H##$# # -- H--&-H H   ###H@" +
"@H###H$H# $#H  #$$$$H  $  H@",

///////////////// BEGIN FOR SPECIAL HARD HARD ///////////////////////

//======<<< Level 083 >>>======
/* SPECIAL HARD HARD 059 */
"                            " +
"   H##################00000#" +
"   H---------------   ##### " +
"H@ H&               $ $ $ $ " +
"H#@#@#             ##X#####X" +
"H-------------------------- " +
"H-                         H" +
"  H#H##                    H" +
"  H#X##                     " +
"  H$$$ @@@@@@@@#############" +
"  H   S$$$$$$ @#    ##   # #" +
"  H@#@X@#@#@#H@# ## # #### #" +
"  H          H@#    # #### #" +
"  H          H@# #### ######" +
"  H          H@# #####   # #" +
"  S           @#############",	 
//"              @#############", //add a hide ladder	
	
//======<<< Level 072 >>>======
/* SPECIAL HARD HARD 060 */
"@@ @@@@@@@@@@@@@@@@@@@@@ @S@" +
"@@-                     -@S@" +
"@@H##########$ ########HH@S@" +
"@@H#$      $#0#H    H #HH@S@" +
"@@H###SH##### ###### H# H@S@" +
"@@H#$#H #$  # #$ #H$#H #H@S@" +
"@@H@@@@@@@@@@@@@@@@@@@@@H S@" +
"@@H0         &         0H@ @" +
"@@H#####################H@ @" +
"@@H$## $## $ # $ ##$ ##$H@ @" +
"@@H#####################H@ @" +
"@@H#########   #H#H#H#H#H@ @" +
"@@H H#H#H#H#$$$#H#H#H#H#H@ @" +
//"@@H HXH#H#H#$$$#H#H#H#H#H@ @" + //change one trap to block (harder)
"@@H@@@@@@@@#####@@@@@@@@H@ @" +
"@@H        #####        H  @" +
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@",

//======<<< Level 081 >>>======
/* SPECIAL HARD HARD 061 */
"&             --------      " +
"H#######   H##        ##H   " +
"H# H#  #   H#  H####H  #H   " +
"H#$ # $#   H#  H#$$#H  #H   " +
"H #####    H# #H#--#H# #H   " +
"H# H#  #   H############H   " +
"H#$ # $#  H              H  " +
"H #####   H#   H####H   #H  " +
"H# H#  #  H#   H#$$#H   #H  " +
"H#$ # $#  H# H# #  # #H #H  " +
"H #####   H##############H  " +
"H#HH#  # H                H " +
" #$ # $# H#SH#SH####H #H #H " +
"$####### H# H# H#$$#H #H #H " +
"         H#$H#$H#  #H$#H$#H " +
"############################",

//======<<< Level 082 >>>======
/* SPECIAL HARD HARD 062 */
"                         S S" +
"----------     $$$        S " +
"H      ##################H H" +
" H00000 ------------------H " +
"H      #H  #####           H" +
" H     #H    &            H " +
"H      #H  H###H      #H   H" +
" H     #H  H#$#H    #H#H  H " +
"H      #H - # #  $#H# #H   H" +
" H     #H  #####- #$#$#H  H " +
"H        H ##### @@@#@@@   H" +
" H     #- H#####          H " +
"H      $-H   $    ###HS#H  H" +
" H                #$#H #H H " +
"H                   #H##H  H" +
"H#     #########    S##H####",

//======<<< Level 085 >>>======
/* SPECIAL HARD HARD 063 */
" - - - - -                  " +
"# # # # # @@@@@@HH H H HHH  " +
" # # # # @#    H H HH   H   " +
"# # # # @     H  H H H   H  " +
" # # # @H-   H HHH H  H   H " +
"# # # @#H   H  0 H H 0 H HHH" +
" # # @# H ##################" +
"# # @# -H                -- " +
"$#$@ -H   #H###H#000--   # H" +
"    H     #H###HH###  #### H" +
"####H##   #H####H### ##@   H" +
"  - #######H####H$## #$    H" +
"H# H      #H#   #####H  &  H" +
"H## ##H### H H#---H#H##### H" +
"H#####H####H@## H H#H  -S# H" +
"$##H##$##$#H@$$# #H#H##S$# H",

//------------------------------------------------------------
// BEGIN 
// Levels from "Lode Runner Fan Book (4 levels) DISK IMAGE"
// URL: http://ww3.tiki.ne.jp/~maclr/lr/lr.html
// By maclrse
//------------------------------------------------------------

//======<<< Level 064 >>>======

"&             --------      " +
"H####### S H##        ##H S " +
"H# H#  # S H#  H####H  #H S " +
"H#$ # $# S H#  H#$$#H  #H S " +
"H #####  S H# @H#--#H@ #H S " +
"H# H#  # S H############H S " +
"H#$ # $#  H  SSSSSSSSSS  H  " +
"H #####   H#   H####H   #H  " +
"H# H#  #  H#   H#$$#H   #H  " +
"H#$ # $#  H# H# #  # #H #H  " +
"H #####   H##############H  " +
"H# H#  # H  SSSSSSSSSSSS  H " +
" #$ # $# H# H# H####H #H #H " +
"$####### H# H# H#  #H #H #H " +
"         H#$H#$H#$$#H$#H$#H " +
"############################",

//======<<< Level 065 >>>======

"                            " +
"-----------   S             " +
"H      ##################H H" +
" H00000 ------------------H " +
"H      #H  #####           H" +
" H     #H    &            H " +
"H      #H  H###H      #H   H" +
" H     #H  H#$#H    #H#H  H " +
"H      #H   # #  $#H# #H   H" +
" H     #H -#####- # # #H  H " +
"H        H ##### #######   H" +
" H     #-H #####          H " +
"H      $-H   $    ###H #H  H" +
" H                #$#H #H H " +
"H                   #HX#H  H" +
"H#     #########     ##H####",

//======<<< Level 066 >>>======

" - - - -                    " +
"# # # # # @@@@@@HH H H HHH  " +
" # # # # @#    H H HH   H   " +
"# # # # @     H  H H H   H  " +
" # # # @H-   H HHH H  H   H " +
"# # # @#H   H  0 H H 0 H HHH" +
" # # @# H ##################" +
"# # @# -H                -- " +
"$#$@  H   #H###H@000--   # H" +
"    H#    #H##XHH@##- #### H" +
"#####H#   #HX###H###-##@   H" +
"   - ######H####H$## #$    H" +
"H## H     #H#X  ###@##  &  H" +
"H### ##H## H H#---H@H##### H" +
"H######H####### H H@H    # H" +
"$###H##$##$##$$# #H@H###$# H"

//------------------------------------------------------------
// END 
// Levels from "Lode Runner Fan Book (4 levels) DISK IMAGE"
// URL: http://ww3.tiki.ne.jp/~maclr/lr/lr.html
// By maclrse
//------------------------------------------------------------

///////////////// END FOR SPECIAL HARD HARD ///////////////////////

//======<<< Level 004 >>>======
/* TOO BUSY
" -   - -   --& --   - -   - " +
"H @@@ @ @@@  #H  @@@ @ @@@ H" +
"H  $     $   HH   $     $  H" +
"H #H# # #H#  H#  #H# # #H# H" +
"H  H  H  H   HH   H     H  H" +
"H -H- - -H-  #H  -H- - -H- H" +
"H#0          HH          0#H" +
"H##########  H#  ##########H" +
"H##########  HH  ##########H" +
"H            #H            H" +
"H #########  HH  ######### H" +
"H# $     $   H#   $     $ #H" +
"H#### # ###  HH  ### # ####H" +
"H---- - ----H#HH---- - ----H" +
"H     #     H  H     #     H" +
"H    H H    H  H    H H    H",
*/

//======<<< Level 011 >>>======
/*
"                -         ##" +
" ###H########H##-#####H#####" +
"    H  &     H     @@@H#  ##" +
"#  S@ #0#    H #      H #H##" +
" #S@ @ ##    H  #  @@@##HH##" +
"  S   @ #@   H   #   #  HH##" +
"  S    @     H        #H H##" +
"#$ S         H         # H##" +
" # S     $   H     $  @  H##" +
"   S         H         @ H##" +
"#  S     #   H     #  @ @H##" +
" # S   $     H   $    @ @H##" +
"   S$@   --  H   #    @@@H##" +
"#  H#H#@     H        @ @H##" +
" # #   #H   #H##         H##" +
"#    H#H#H#HH     H##HHHH###",
*/

//======<<< Level 014 >>>======
/* NEED MODIFIED for this platform
"     -       &              " +
"      H     0 0             " +
"      H      X          # #H" +
" $$$  H     #$#         ###H" +
"##### H    # $ #           H" +
"      H   #  ## #     #$#$#H" +
"      H  #$$  H  #    #####H" +
"-     HHHH#### H #         H" +
"0#$#  H  #$#0#  H#  #$#$#$#H" +
"# #$# H  #X### H #  #######H" +
"0# #  HHHHH$  $ H#  $$     H" +
"# # # H  # H  $$#  ####    H" +
"      H  # H$$ H #     $$  H" +
"      H #   ####  #   #### H" +
"$ $ $ H    $$   $$         H" +
"#####H#H####### ###H       H",
*/

//======<<< Level 029 >>>======
/* NEED MORE CHECK
"-0    & ----   -----        " +
"$###H###$$$####$$$$$##H##$##" +
"#X##H#$#####$$########H##-$#" +
" X##H#-##$########H---H##-##" +
"#$# H#            H         " +
"## #H#$#########H######## #H" +
"#$# H##$####$###H###$#### #H" +
" # #H###$####$#$H#$###$ ###H" +
"# ##H#### 0####H ## ###H0  H" +
"$ ##H##$ ### ##H## 0 ##H# ##" +
" ###HH ####$ $#H$##### H####" +
"##   H### ######H$#### H H  " +
"  #H###$   ### #HH##--  #H  " +
"$#H  ######  $   H#$  ###$#H" +
" # #HH$$H#$ ####HH## ##H   H" +
"################H### $# ###H",
*/

//======<<< Level 033 >>>======
/* SKIP (TOO MANY TRAP)
" ---------------------------" +
"H#X#X#X#X#X##X##X#X#X#X#X#X#" +
"H X X X X # # # # X X X X X " +
"H###X#X#X####X##########X###" +
"H# X # # # # X # # # # X # X" +
"H#######X#########X#########" +
"H # X # X # X # # X # X X # " +
"H##X#X##X###################" +
"H# # X # # X # # X # X # X #" +
"H###########################" +
"H # X X # X # # X # X # X X " +
"H###########################" +
"H# X # X # # # # X # X # X #" +
"HX##########################" +
"H   # # # # # # # # X # # # " +
"H&#H $ $ $ $ $ $ $ $ $ $ $ $",
*/

//======<<< Level 036 >>>======
/* TOO MANY GUARD
"@             &            @" +
"@0     -------S-------    $@" +
"@H#####       H       #####@" +
"@H $    ------S------    0$@" +
"@H #####      H      ##### @" +
"@H $0    -----S-----   $   @" +
"@H  #####     H     ####   @" +
"@H    $   ----S----   0$   @" +
"@H    ####    H    ####    @" +
"@H      $  ---S---  $      @" +
"@H      ###   H   ###      @" +
"@H        $ --S-- $        @" +
"@H        ##  H  ##        @" +
"@H         $ -S- $         @" +
"@#########H###H###H########@" +
"@#$$$$$$$H#H$$ $$H#H$$$$$$$@",
*/

//======<<< Level 038 >>>======
/*
"@       S                  @" +
"@       S                  @" +
"@      #H#   # 00#         @" +
"@      #H#   #####         @" +
"@      #H#                 @" +
"@      #H#                 @" +
"@      #H#    H---- - -----@" +
"@      #H#    H   -# #    H@" +
"@ -    #H#    H    # #    H@" +
"@ -#@@@#H#    H#####$###  H@" +
"@ -    #H# #  H #######   H@" +
"@ -    #H# #  H #$$##$#   H@" +
"@ $#   #H# #  H #######   H@" +
"@@@@@@@#H############ ##H##@" +
"@   00  H       &     0 H  @" +
"@#######H###############H##@",
*/

//======<<< Level 045 >>>======
/* TOO MANY GUARD
"@            &S            @" +
"@             S           $@" +
"@HHHHHHHHHHHHHHHH-H-H-H-H-H@" +
"@HHHHHHHHHHHHHHHHH-H-H-H-H-@" +
"@HHHHHHH$$HHHHHHH-H-H-H-H-H@" +
"@HHHHHH-##-HHHHHHH-H-H-H-H-@" +
"@HHHHH-HHHHHHHHHH-H-H-H-H-H@" +
"@HHHHHHHHHHHHHHHH      - -0@" +
"@HHH--HH--HH--HHH#####H   H@" +
"@HHHHHHHHHHHHHHHHH-H######H@" +
"@HHHHHHHHHHHHHHHH-H#    ##H@" +
"@H$$HH$$HH$$HH$$HH-H## $##H@" +
"@H##HH##HH##HH##H-H#$$#$##H@" +
"@HHH$$HH$$HH$$HHHH-H######H@" +
"@HHH##HH##HH##HHH-H-H-H-H-H@" +
"@HHH0 HH0 HH0 HHH         $@",
*/

//======<<< Level 046 >>>======
/* TOO MANY GUARD
"@$     $               $   @" +
"@#H   H# $  H#      $ ##H0 @" +
"@ #H H   H#H      H##    H$@" +
"@  #H 0 H  # H   H  0     H@" +
"@   HH#H   H #H H   $@#  H @" +
"@   #H #$ H H  ##H $#     H@" +
"@ $H  H H        H H    $H @" +
"@@# $  H ##$     H# H  $##H@" +
"@  ##$ H   @#& H##   H$#  H@" +
"@$H  #H $    H#H    $ H HH @" +
"@#$  H ##@H$ H  H$0 ## H  $@" +
"@ # H     H#@H  $@#H    H #@" +
"@  # $  0H#  H $#  #H$  H# @" +
"@   #   H#   H#@    #H H#  @" +
"@    #H##    H       ##H   @" +
"@ $   H     HHH        H  $@",
*/	
	
//======<<< Level 051 >>>======
/* NORMAL HARD BAD 
"@            S             @" +
"@            S             @" +
"@            S             @" +
"@            S             @" +
"@            S             @" +
"@00         S&S         00 @" +
"@HHHH#####H##H##H#####HHHH @" +
"@$       H#H H H#H       $ @" +
"@########H###H###H@@@@@@@# @" +
"@           #H#            @" +
"@HHH#####H###H###H#@@@#HHH @" +
"@$      H#H  H  H#H      $ @" +
"@#######H####H#@@@H@@@@@@# @" +
"@           #H#            @" +
"@HH#@@@#H#@@#H#@@#H#@@@#HH @" +
"@$     H#H   H   H#H     $ @",
*/


//======<<< Level 054 >>>======
/* BAD CAN REMOVE 
"@                     &    @" +
"@####H                    $@" +
"@   ###S          H###H####@" +
"@      S     H####H   H$   @" +
"@  0   H#####H        H   $@" +
"@$$H###H              H####@" +
"@##H     $        H###H$   @" +
"@            H####H   H   $@" +
"@       H####H        H####@" +
"@$$0H###H       $     H$   @" +
"@###H             H###H   $@" +
"@    $         H##H   H####@" +
"@          H###H      H$   @" +
"@      H###H      H###H   $@" +
"@$$0H##H     H####H   H####@" +
"@H###$$  H####$$      H   $@",
*/

//======<<< Level 055 >>>======
/* BAD CAN REMOVE 
"@        &        S        @" +
"@                 S        @" +
"@                 S        @" +
"@   0    0        S      0 @" +
"@H######H H######H H######H@" +
"@       H     $  H        H@" +
"@H######H H######H H######H@" +
"@HH          $$    HH      @" +
"@H#H####H0H######H H#H####H@" +
"@    $  H         #H      H@" +
"@H#X X#HH @@@@@@@@ H## XX#H@" +
"@H XX  H           H##X$##H@" +
"@HH#$##HH H######H H###X##H@" +
"@ H $   H H  $$  H     $  H@" +
"@H######H H##X###H H######H@" +
"@H      H H        H   0  H@",
*/

//======<<< Level 056 >>>======
/* TOO HARD MAY BE DROP 
"@##@# H #@@##@###@#@##@@###@" +
"@@## H H ##@#@###@#@##H##H#@" +
"@$& H$H$H 0 0 $@#@ #@###@H#@" +
"@##H H H H###@### H @##H@H#@" +
"@#@ H$H$H @###@@ H$H @###@#@" +
"@$ @ H H   $    H H H     $@" +
"@##@# H #######H$H$H$H#####@" +
"@# $##H## ###H# H H H ##0$#@" +
"@#####H  H ##$## H$H ## ###@" +
"@#####H H H ####  H ## H ##@" +
"@$     H$H$H  $   H # H$H #@" +
"@#####H H H H######H H H H @" +
"@#H### H$H$H ##$ ## H$H$H$H@" +
"@##$ ## H H ##0##### H H H @" +
"@####### H #### ##### H$H  @" +
"@$       H     $       H  $@",
*/

//======<<< Level 058 >>>======
/* TOO MANY GUARD REMOVE 
"@            &0            @" +
"@ $ $-$ $-$ $SS$-$-$ $-$ $ @" +
"@ @H@ #H# @H@SS@H@ #H# @H@ @" +
"@0HH$$$HHH$H$HH$H$HHH$$$HH0@" +
"@HHH@@@HHH@#@HH@#@HHH@@@HHH@" +
"@HH H$$HH$$HH$$HH$$HH$$H HH@" +
"@H$$H@@HH##HH@@HH##HH@@H$$H@" +
"@H##HHH$$HH$$HH$$HH$$HHH##H@" +
"@H$$$HH@@HH##HH##HH@@HH$$$H@" +
"@H#@#H HH$$HH00HH$$HH H#@#H@" +
"@H$HH$$HH##HH$$HH##HH$$HH H@" +
"@H#HH@@ $$  H@@H  $$ @@HH#H@" +
"@HHHHHHH##H$$HH$$H##HHH HHH@" +
"@HH$$HH$$HH@@HH@@HH$$HH$$HH@" +
"@HH##HH@@HHHHHHHHHH@@HH##HH@" +
"@$H  HH  HH  HH  HH  HH  H$@",
*/

//======<<< Level 060 >>>======
/* BAD LEVEL 
"@  ########             H  @" +
"@  #$$00$$#             H  @" +
"@  #H# @#H#  &          H  @" +
"@  #H#H@$H#H#@@@@@@@@@@#H# @" +
"@  #H######H# $$$$$$$$ @H# @" +
"@  #H$$$$$$H#H#@@@@@@@H#H# @" +
"@@##@@@@@@#H#H@$$$$$$#H#H# @" +
"@#  $$$$$ @H#H#H#@ #H#H#H# @" +
"@#H#@#@ #H#H#H#H#0H0@#H#H# @" +
"@#H@$@0H#H#H#H#H#####@H#H# @" +
"@#H#H@@##H@H#H#H$$$$$$H#H# @" +
"@#H@H$$$$H@H#H#@######@#H# @" +
"@#H##@@@@##H#H$$$$$$$$$$H# @" +
"@#H$$$$$$$$H#@@###@#####@# @" +
"@#@##@####@H               @" +
"@          H               @",
*/

//======<<< Level 062 >>>======
/* TOO BAD 
"@       H---0##0---H       @" +
"@       H   #  #   H       @" +
"@       H  #$  $#  H       @" +
"@       H #  $$  # H       @" +
"@       H##########H       @" +
"@       H--- ## ---H       @" +
"@       H   #$$#   H       @" +
"@       H  #$  $#  H       @" +
"@       H #      # H       @" +
"@       H##########H       @" +
"@       H--- ## ---H       @" +
"@       H   #  #   H       @" +
"@       H  #$  $#  H       @" +
"@       H #$ &  $# H       @" +
"@       H##########H       @" +
"@       H          H       @",
*/

//======<<< Level 064 >>>======
/* BAD TOO HARD REMOVE
"@                          @" +
"@#######H           $-    &@" +
"@      SS       --- #00000#@" +
"@     SS      $     #######@" +
"@    SS       # ###########@" +
"@   SS          #HHH  HHHH#@" +
"@  SS      -- ###H    H  H#@" +
"@  S     $-   #  H HH H  H#@" +
"@ SS     #    #  H  H H  H#@" +
"@SS    -   ####  HHHH HHHH#@" +
"@S   $-  ###              #@" +
"@S   #   # H   H  H  H  H #@" +
"@S$-   ### HH HH H H HH H #@" +
"@##  ##    H H H HHH H HH #@" +
"@    #     H   H H H H  H #@" +
"@##########################@",
*/


//======<<< Level 068 >>>======
/* NORMAL HARD HARD MAY BE CAN REMOVE 
"@# #0# #0# #0# #0# #0# # # @" +
"@ H X H X H X H X H X H # H@" +
"@$ H $ H $ H H $ H $ H $ H @" +
"@ H   H   H   H   H   H   H@" +
"@H H H H H H H H H H H H H @" +
"@ # H - # H - # H - H H - H@" +
"@H H H H H H H H H H H H H @" +
"@ H #$# H #$# H #$# H #$# H@" +
"@H H # H H # H H # H H # H @" +
"@ #   H #   H #   H #   H #@" +
"@  # H   # H   # H   # H   @" +
"@ $ H H $ H H $ H H $ H H $@" +
"@  H     H     H     H     @" +
"@ H     H     H     H     H@" +
"@H H   H H   H H   H H   H @" +
"@ H     H    &H     H     H@",
*/

//======<<< Level 071 >>>======
/* TOO HARD TO GET TOP GOLD ??? 
"@           S              @" +
"@           S              @" +
"@           S              @" +
"@           S              @" +
"@           S$         &   @" +
"@H########## ###H   ####H##@" +
"@H              H   ####H##@" +
"@H H#@@@@#H#### H   ####H#0@" +
"@H H#    #H# $# H   ####H##@" +
"@H H####H#H#### #   ##0#H##@" +
"@H H#$   #H# $# #####$##H##@" +
"@H H@ $  #H##@@ ##$$#H##H##@" +
"@H H## #@#H# $  ###H#H##H#$@" +
"@H H######H#### ##$##H##H##@" +
"@  H   0  H             H  @" +
"@##########H   H###########@",
*/

//======<<< Level 073 >>>======
/* CAN NOT PASSED 
"@    S                S    @" +
"@    S       &        S    @" +
"@####H################H####@" +
"@$## H####### ########H   $@" +
"@##  H   #############H  ##@" +
"@$## H################H   $@" +
"@##  H#              #H  ##@" +
"@$## H##############H#H   $@" +
"@##  H#      $      H#H  ##@" +
"@0## H#H##############H   $@" +
"@##  H#H            # H  ##@" +
"@$## H#############H #H   $@" +
"@##  H#            H# H# ##@" +
"@$## H############## #H # $@" +
"@##  H              # H  ##@" +
"@$###H       0        H   $@",
*/
	
//======<<< Level 076 >>>======
/* NORMAL HARD HARD */
/*	
"@            S             @" +
"@            S             @" +
"@      &     H       0     @" +
"@   #@@#@@@@#S@@#@@@@#@    @" +
"@            H 0  $        @" +
"@    ##@@#@##S##@@###@#    @" +
"@       $    H             @" +
"@   @####@#@#S#@##@#@###   @" +
"@         0  H  $          @" +
"@    #@##@#@#S#@#@@###     @" +
"@         $  H             @" +
"@   ###@@#@##S##@#@##      @" +
"@            H    0 $      @" +
"@  @@###@##@#S###@###@##   @" +
"@     $      H             @" +
"@##########################@",
*/
	
//======<<< Level 084 >>>======
/* IMPOSSIBLE for this platform */
/*	
"@        H-----H----------H@" +
"@& -$    H     H          H@" +
"@#0$##   H ## - #  #  # ##H@" +
"@##      H #$# #-# #  # X-H@" +
"@ ## $   H ##  #$# #$ # $#H@" +
"@  ##  --H #    #  ## # ##H@" +
"@  H##0  H                H@" +
"@ # H##  H                H@" +
"@#@@@@## H################H@" +
"@0     H-H-------- ---H---H@" +
"@#####HH# #  ## - #   H   H@" +
"@ #   H#  #  # # # #  H   H@" +
"@ # ##H#  ## # # # #  H   H@" +
"@$#$# H#  #  #$# #$#H# #  H@" +
"@ #  #H # #  # #  X H##$# H@" +
"@     H             H#$# #H@",
*/
];
