//************************************************************
//* All levels extract from: 
//* Lode Runner (Apple-II 1983) DISK IMAGE
//* by Simon Hung 2014/02/20
//************************************************************

var classicData = [
//======<<< Level 001 >>>======

"                  S         " +
"    $             S         " +
"#######H#######   S         " +
"       H----------S    $    " +
"       H    ##H   #######H##" +
"       H    ##H          H  " +
"     0 H    ##H       $0 H  " +
"##H#####    ########H#######" +
"  H                 H       " +
"  H           0     H       " +
"#########H##########H       " +
"         H          H       " +
"       $ H----------H   $   " +
"    H######         #######H" +
"    H         &  $         H" +
"############################",

//======<<< Level 002 >>>======

"   $                       H" +
"H@@#@@H           $        H" +
"H     H    H#########H $   H" +
"H $ 0 H    H         H####XH" +
"H#@#@#H    H         H     S" +
"H     H----H------  0H     S" +
"H     H    H     H###@@@@@@H" +
"H     H    H  $  H         H" +
"H   0 H $  H#####H         H" +
"@###@##@##@H         H###H##" +
"@###@      H         H   H  " +
"@$  @      H   ------H   H $" +
"########H###@@@@     H  ####" +
"        H            H      " +
"        H   &        H      " +
"############################",

//======<<< Level 003 >>>======

"                           S" +
"----------    $            S" +
"H $      H##########H      S" +
"#####H   H          H@@@@@@@" +
"     H 0 H     $    H       " +
"     H######H#####H##       " +
"  $  H      H     H  --     " +
"####H#      H  0  H    --   " +
"    H    H######H##      --$" +
"    H----H      H  0       #" +
"    H       H#########H     " +
"    H       H#########H     " +
"###H##########   $   #####H#" +
"###H########## H###H #####H#" +
"   H      &    H###H   $  H " +
"############################",

//======<<< Level 004 >>>======

"S                           " +
"S-----------                " +
"H     H     # $ #     H     " +
"H $  HHH  $ ##### $  HHH  $ " +
"H HH  H  HH       HH  H  HH " +
"H H HHHHH H       H HHHHH H " +
"H H  $0$  H   H   H  $0$  H " +
"H  H#####H   HHH   H#####H  " +
"H   HHHHH HH  H  HH HHHHH   " +
"H         H HHHHH H         " +
"H    $    H  $0$  H     $   " +
"H######H   H#####H  H#######" +
"H      H    HHHHH   H       " +
"H      H            H       " +
"H      H       $  & H       " +
"############################",

//======<<< Level 005 >>>======

"         S                  " +
"         S       $      0   " +
"###      S      ####H#######" +
"  ##     S     ##   H       " +
"   ##    S    ##    H       " +
"$0 ###   S  $###    H   $   " +
"##H####  S  ####H###H#######" +
"  H   ## S ##   H           " +
"  H$0  ##H##    H     $     " +
"H###H    H     #H##H###     " +
"H   H              H        " +
"H   H    $     0   H        " +
"H   H#######H######H#####H##" +
"H           H            H  " +
"H           H  &         H  " +
"############################",

//======<<< Level 006 >>>======

"##################S#########" +
"# $               S# 0 $   #" +
"#X###H####H   $   S#######H#" +
"#X###H############## ###  H#" +
"#    H  $ 0     #### ###  H#" +
"#H#########H######## ###  H#" +
"#H   ######H#####$$# ###$ H#" +
"#H   ######H##############H#" +
"#H   #    $H    $  0   $ #H#" +
"#H   ###H#######H#######H#H#" +
"#H  $###H       H#######H#H#" +
"#H##X#  H    &  H  ##   H#H#" +
"#H##X#H#####H########$$ H#H#" +
"#H##X#H#####H######$######H#" +
"#H0   H##$##H    $  0     H#" +
"############################",

//======<<< Level 007 >>>======

"  S                         " +
"  S                 --------" +
"  S          0      H      H" +
"#####H#    #H###   0H    $ H" +
"     H      H    ###H#######" +
"  0  H   $  H       H       " +
"#####H####  H       H       " +
"     H      H       H       " +
"  $  H   $  H       H       " +
"##H############H    H #### H" +
"  H            H $  H #### H" +
"  H  $         H----H # $# H" +
"#######H            H #####H" +
"       H            H      H" +
"       H &        $ H  0   H" +
"############################",

//======<<< Level 008 >>>======

"           S    S           " +
"           S    S           " +
"   $ 0   H#S    S#H   0 $   " +
"H#####H--H#S    S#H--H#####H" +
"H#   #H   #S    S#   H#   #H" +
"H#   #H   #S    S#   H#   #H" +
"H# $ #H   #S    S#   H# $ #H" +
"H#####H   #S    S#   H#####H" +
"H#   #H   #S    S#   H#   #H" +
"H#   #H---#H####H#---H#   #H" +
"H#   #   H#H    H#H   #   #H" +
"H#0$ #   H#H  $0H#H   # $0#H" +
"H##X##   H#@@@@@@#H   ##X##H" +
"H     X  H        H  X     H" +
"H      X0H    &   H X      H" +
"############################",

//======<<< Level 009 >>>======

"S                           " +
"S---------------------------" +
"H# 0   #             #     #" +
"H #####               ##### " +
"H # ###               #$### " +
"H ##### 0    0      0 ##### " +
"H ### #X################# # " +
"H #####X### $## $########H# " +
"H #####X#################H# " +
"H #####X#################H# " +
"H #####X####    #########H# " +
"H #####X####    #########H# " +
"H #####X####   $H########H# " +
"H           ####H--------H  " +
"H          @@@@             " +
"H      &  @@@@      0       ",

//======<<< Level 010 >>>======

"          $              S  " +
"        H#######  $      S  " +
"    $   H      ######    S  " +
"##########H         $    S  " +
"          H######S#####H##  " +
"0         H      S     H    " +
"##########H      S 0   H   $" +
"##########H#######@@   H####" +
"##########H            H    " +
"##########H       $ ---H    " +
"##      ##H       ##   H    " +
"##  $$  ##H     $      H    " +
"###########H#######H   H    " +
"           H       ########H" +
"    $    & H               H" +
"############################",

//======<<< Level 011 >>>======

"       H                    " +
" 0$    H                 $0 " +
"H##0$  H               $0##H" +
"H  ##  H####SH#####H   ##  H" +
"H           HH$    H       H" +
"H           $HH    H       H" +
"H           HH$            H" +
"H           $HH            H" +
"H           HH$            H" +
"H           $HH            H" +
"H           HH$            H" +
"H           $HH            H" +
"H           HH$            H" +
"H           $HH            H" +
"H       &   HH$            H" +
"H    H################H    H",

//======<<< Level 012 >>>======

"      $     $           H   " +
"H#################H     H   " +
"H             $   H-----H  $" +
"#########H#########     H###" +
"########HH              H   " +
"#######HH-------H       H   " +
"#$ $##HH      0 H  $  0 H  $" +
"#####HH     H####@@@####H###" +
"     H      H           H   " +
"     H      H           H   " +
"    0H   $  H-----------H  $" +
"H###########H  $     $  H###" +
"H           H ######### H   " +
"H           H           H   " +
"H      $    H    & $    H   " +
"############################",

//======<<< Level 013 >>>======

"            0          0    " +
"XHXHXHXHXHXHXHXHXHXHXHXHXHXS" +
"XHXHXHXHXHXHXHXHXHXHXHXHXHXS" +
"$H#H H#H$H#H H#H$H#H H#H$H#S" +
"XH#HXH#HXH#HXH#HXH#HXH#HXH#S" +
"XH#HXH#HXH#HXH#HXH#HXH#HXH#S" +
"XH#HXH#HXH#HXH#HXH#HXH#HXH#S" +
" H#H$H#H H#H$H#H H#H$H#H H#S" +
"XH#HXH#HXH#HXH#HXH#HXH#HXH#S" +
"XH#HXH#HXH#HXH#HXH#HXH#HXH#S" +
"$H H H H H H H H H H H H H#S" +
"H##########################S" +
"H         $ 0 $   $ 0      S" +
"H@@@@@@@@@@@@@@@@@@@@@@@@@@S" +
"H$       &                $S" +
"############################",

//======<<< Level 014 >>>======

"  H   0    -   0-H    H-   $" +
" -H   -H-   -  - H-   H -  H" +
"- H  - H -    -  H -  H  - H" +
"$ H -  H  -  -   H  -$H   -H" +
"  H-  -H   --    H$  -H    H" +
"H-   - H-  --  - H------ -  " +
"H -   -H  -$ -   H  -   H - " +
"H- -   H$--H  -  H     -H  -" +
"H - -  H-- H   - H    - H  -" +
"H- $ -0H-  H -  -H-  -  H  -" +
"H -H  -    H   -   -    H  -" +
"H- H   -   H  - -   -   H  -" +
"H -H -  -  H$-   -   -  H $-" +
"H- H   - - H- -  $-   - H - " +
"H -H  -   -H     - - - -H-  " +
"   H     $     $&       H   ",

//======<<< Level 015 >>>======

"S                          S" +
"S     $ 0  $     $  0 $    S" +
"SSSS########H   H########SSS" +
"            H   H           " +
"       H#############H      " +
"$  0  $H     $ $     H$ 0  $" +
"#######H $ $#####$ $ H######" +
"       H ####   #### H      " +
"    $  H      $      H $    " +
"  H######################H  " +
"  H           &          H  " +
"  H $    $H#######H$   $ H  " +
"##########H       H#########" +
"          H       H         " +
"  $       H       H      $  " +
"#@#@#@#@#@#@#@#@#@#@#@#@#@#@",

//======<<< Level 016 >>>======

"                         S  " +
"                    &     S " +
"   X####HH######HHHHH      S" +
"         H   #  H         S " +
"    $     H H#  H        S  " +
"    #$     HH#  H       S   " +
"   ###$     H#  H      S    " +
"  #####$    H#  H     S     " +
"########    H#  H      S    " +
" $#####     H#  H       S   " +
"   ###      H#  H        S  " +
"    #       H#  H         S " +
"       0    H#  H   0      S" +
" H##############X######### S" +
" ###############         H#S" +
"################   $$$$$$H##",

//======<<< Level 017 >>>======

"S                          S" +
"S                          S" +
"S         0                S" +
"H###X######################H" +
"H###X######################H" +
"H   $   ##--------##       H" +
"H       $#H    0 $##    0  H" +
"H  ###  ##H ########  #####H" +
"H  #$#  ##H       ##  ##$##H" +
"H   &   ##H       ##  #####H" +
"H  ###  ########HH##  ##$##H" +
"H  ###  ########HH##  #####H" +
"H  ###  ##      H ##       H" +
"H  ###  ##     $H ##    $  H" +
"##########H#########H#######" +
"#######  $H###### $ H#######",

//======<<< Level 018 >>>======

"   S                        " +
"   S      $         $      $" +
"HX#H    H###H     H###H#  #H" +
"H  ######   H#####H   H  $ H" +
"H$ 0        H     H   #### H" +
"HX####         ###H#       H" +
"H @####       ##        H# H" +
"H @#####     ##       H#H  H" +
"H @###########    $   H   ##" +
"H @###########   ###  H     " +
"H @    ### ###        H   0$" +
"H @  $ ## $ ##     0  H   ##" +
"H @H###########H######H   ##" +
"H  H           H      H   ##" +
"H  H       &          H   ##" +
"############################",

//======<<< Level 019 >>>======

"            H##H            " +
"          0$H##H$0          " +
"          H######H          " +
"         $H######H$         " +
"        H##########H        " +
"      0$H##########H$0      " +
"      H##############H      " +
"     $H   $$$$$$$$   H$     " +
"    H##################H    " +
"   $H##################H$   " +
"  H######################H  " +
"  H######################H  " +
"  H                      H  " +
"  H                      H  " +
"  H          &           H  " +
"############################",

//======<<< Level 020 >>>======

"             0$             " +
"           ########H   0 $  " +
"       0 $         H#H#####H" +
"     $#####H       H H     H" +
"###X###    H-------H H$    H" +
"           H       H #######" +
" $         H       H        " +
"###H#######H       H--------" +
"$  H   0   H    $  H       $" +
"#########  ########H    ####" +
"       $   $       H        " +
"#####H###X###H  $  H   $    " +
"     H       ##############H" +
"     H                     H" +
"     H $   &      $        H" +
"############################",

//======<<< Level 021 >>>======

"@@@@@@@@@@@@@@@@@@@@@@@@@@S#" +
"H----------------------HSSS#" +
"H  H     ##  0   $     HS$ #" +
"H  H #####################H#" +
"H  H ###            $     H#" +
"H  H   # ###################" +
"H  H  H#   $  # $ # $ # $  #" +
"H  H  H##H##################" +
"H  H--H  H##### #####      #" +
"H  H  H  H    # $#     0   #" +
"H  H  H  H--H ####H--#######" +
"H  H  H  H  H     H  #######" +
"H  H  H  H  H--H  H  #######" +
"H  H  H  H  H  H #H### $$$ #" +
"H  H& H  H 0H  H  H###H#####" +
"##################H $$H#####",

//======<<< Level 022 >>>======

"       $    $               " +
"$$################H         " +
"##          $  $  H         " +
"         H########H  $   $  " +
"         H        H######## " +
"    $ 0$ H                  " +
"   H######H------     $     " +
"   H      H      H#########H" +
" $ H      H      H         H" +
"###H    0 H  0 $ H       $ H" +
"      H###H######H    H#####" +
"      H--------    $  H     " +
"    $ H$       H######H   $ " +
"#######H       H      H#####" +
"       H       H            " +
"       H  $  & H      $     ",

//======<<< Level 023 >>>======

"   @@@@@@@@@           S    " +
"  @         @          S @@ " +
" @   $$ 0    #H        S @@ " +
"@@##H########@@H    0  S$@@ " +
"@###H###########H##@@@#H@@@@" +
"@##HHH#-------#HHH#----H---H" +
"@##H H#  $    #H H# $    $ H" +
"@##H H#  &    #H H#        H" +
"@##H$H####H####H$H#@      @H" +
"@#########H################H" +
"@      ##HHH##  $    $   $ H" +
"@------#HH HH--------------H" +
"@ $    #H   H            0 H" +
"@       H   H  ########### H" +
"@@@@    H   H ### $##  $ ##H" +
"@######@H$ $H  #############",

//======<<< Level 024 >>>======

"                S           " +
"               SS           " +
"              SS            " +
"             SS             " +
"            SS              " +
"            S               " +
"          H##H              " +
"          H##H$             " +
"       H#######H  0         " +
" #H  0 H# $ $ #H #H#H       " +
"  ###H############H###H     " +
"   ## $  #### $   H$  ##H   " +
"    ####H  $ ###H H##H #H   " +
"     #$#H###H $ H H$#H$#H   " +
"  0   ##################H & " +
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@",

//======<<< Level 025 >>>======

"    @     @     @         S@" +
"    @     @     @   $     S@" +
"    @X####@     @####  ###S@" +
"###         ###H0  $     $S@" +
"###########H   H######## #H@" +
"       &   H ##H#   $    #H@" +
"#H#########H $#H# #####H #H@" +
"#--------##H ##H# #    H #H@" +
"#  #  # $##H   HH # ###H #H@" +
"#  #  #  #HH####H##$###H #H@" +
"#  # $#  #H#      # ###H  H@" +
"#  ####  #H# #### #    H#HH@" +
"#H##  ##HHH# #$## #######H @" +
"#H   @@#HH##   #  ##$    H#@" +
"#H   @   H##X####X#######H#@" +
"#H###    H     0         H @",

//======<<< Level 026 >>>======

"                          S " +
"     0                    S " +
"H##########H  0  $     $  S " +
"H          H#####H   ###H###" +
"H $      $ H    @H      H   " +
"H #  ### # H $$ @H    0 H   " +
"H # ###  # H @@ @#########@@" +
"H #  ### # H @@           @$" +
"H # ###  # H @-------  $  @H" +
"H #$ ### # H @$      ####H@H" +
"H #####  # H @@          H H" +
"H ######## H @@    $     H##" +
"H          H @@ ######   H  " +
"H@@@@@@@@#@@@@@          H  " +
"H             &          H  " +
"############################",

//======<<< Level 027 >>>======

"S                          S" +
"S      &            0      S" +
"S   @#H#@----------@#H#@   S" +
"S   @$H @ $      $ @ H @   S" +
"S @## H ##@      @## H$##@ S" +
"SS@$  H  $@ $   $@ $ H #$@SS" +
"@S### H   ##@  @#####H # #S@" +
"@     H     @ $@$    H #  $@" +
"@     H#####@H#@##  $H ## #@" +
"@ $ 0 H   0  H     ##H     @" +
"@H####H   @##H###@   H   #H@" +
" H@ $ H   #  H $ #   H  0@H " +
" H@## H ###  H   ### H ##@H " +
" H $@ H @    H    $@ H @$ H " +
" H   ###     H      ###   H " +
"############################",

//======<<< Level 028 >>>======

"             S              " +
"-----------  S              " +
"  $    $ @H  S $            " +
"#########@@@@@@@H  $H@H     " +
"#@#@#@#@@@@@   @@@@@@@H     " +
"          @@  $      @H 0$  " +
"--------H @@#####H   @@####H" +
"        H @@     H0    ####H" +
"        H @@ ########H ####H" +
" $    $ H @@ #      #H ####H" +
"###0  # H @@ #   $  #H ##$#H" +
"####### H @@ ########H ## #H" +
"        H    #  $   #H    #H" +
"############## H##H #######H" +
"          &    H $H        H" +
"############################",

//======<<< Level 029 >>>======

"  0 -- -             0      " +
"####  H   -         ##H     " +
"####  H ## -   0   -##H     " +
"#$$#  H ##- #######  -H     " +
"####  H     ####### H H###  " +
"      H---  ####### H  #$#  " +
"    -     H ####### H  ###  " +
"     #### H ##$$$## H       " +
"   - #### H ####### H       " +
"###- #$$# H-     - -H       " +
"#$#  #### H -   - H  ####   " +
"###       H   &   H  ####   " +
"          H  ###  H  #$$#   " +
"   ##     H  #$#  H  ####   " +
"   ##     H  #X#  H         " +
"          H       H         ",

//======<<< Level 030 >>>======

"@                          S" +
"@     $$$$0 0 0      &     S" +
"@##########X###############H" +
"                           H" +
"    @ $  $       $      $@ H" +
"    @#######X#######X####@ H" +
"                           H" +
"      @  $    $     $  @   H" +
"      @###X######X#####@   H" +
"                           H" +
"       @  $     $    $@    H" +
"      @@##############@    H" +
"                           H" +
"                           H" +
"$$$$   0          0     H@ H" +
"##########@@@@@@#######@@@ H",

//======<<< Level 031 >>>======

"             S              " +
"             S              " +
"$            SS            $" +
"#H H----------S---------H H#" +
"##HH 0                $ HH##" +
"###H H------ ---------H H###" +
"####HH $              HH####" +
"####XH H------ -----H0HX####" +
"####X#HH          $ HH#X####" +
"####X##H H--- ----H H##X####" +
"####X###HH $      HH###X####" +
"####X####H H-- -H H####X####" +
"####X#####HH    HH#####X####" +
"####X######H    H######X####" +
"####X#######H&$H#######X####" +
"####0       H##H        ####",

//======<<< Level 032 >>>======

"                            " +
"###S####         ------ 0   " +
"   S --  0            @@@@@H" +
"   H#  #####H######---   # H" +
"H####  #$---H-----#   ####H#" +
"H      ####   ###H#   #$  H " +
"H      #----H----H#   #-  H " +
"H &#   #H$#$H$#H$H#   #   H$" +
"#H##   ############   ##H###" +
" H    $#     $    #     H   " +
" H    ##   ###H   #     H   " +
" H  $# #      H   #$  H#####" +
" H  #  #   $  H   ##  H     " +
" H$#   # H######H # #$H     " +
" H#  $ # H#  $ #H    #H     " +
"############################",

//======<<< Level 033 >>>======

"#####S################# ####" +
"    #S# -------            #" +
"S##S S# #$   #H#         0 #" +
"S ##### ######H#####$ #H####" +
"#S    $---####H########H# ##" +
"#######   #  #H### ####H# ##" +
"       0     #H### ## #H#$ #" +
"H#######H#H$ #H### ## #H####" +
"H       H#####H###$ # #H## #" +
"H         ####H###### #H##$#" +
"H       #     H        H   #" +
"H###H####H#@#@#@#@#@#@#H#@#@" +
"H###H####H######  #####H#@#@" +
"H   H    H#######  ####H    " +
"H########H########$ #######H" +
"H&       H $ ######  0     H",

//======<<< Level 034 >>>======

" --------$$######$$-------- " +
"H       $###HHHH###$       H" +
"H      $##HHH00HHH##$      H" +
"H      ##HH      HH##      H" +
"H     $#HH        HH#$     H" +
"H     ##H$        $H##     H" +
"H     #HH$        $HH#     H" +
"H     #H$$        $$H#     H" +
"H     #HH$        $HH#     H" +
"H     ##H$        $H##     H" +
"H      #HH$      $HH#      H" +
"H      #XHH$$  $$HHX#      H" +
"H       X#HHH$$HHH#X       H" +
"H        ###HHHH###        H" +
"H&      0  ######  0       H" +
"#########H        H#########",

//======<<< Level 035 >>>======

"S            ##            S" +
"S            @@            S" +
"S $       $  ##  $       $ S" +
"@#@#@#@#@#@#H@@H#@#@#@#@#@#@" +
"   $     $  H##H  $     $   " +
"H@#@#@#@#@#@#@@#@#@#@#@#@#@H" +
"H   $   $    ##    $   $   H" +
"@#@#@#@#@#@#H@@H#@#@#@#@#@#@" +
"    $0 0$   H##H   $0 0$    " +
"H@#@#@#@#@#@#@@#@#@#@#@#@#@H" +
"H  $     $   ##   $     $  H" +
"@#@#@#@#@#@#H@@H#@#@#@#@#@#@" +
"  $       $ H##H $       $  " +
"H@#@#@#@#@#@#@@#@#@#@#@#@#@H" +
"H            &             H" +
"#@#@#@#@#@#@#@#@#@#@#@#@#@#@",

//======<<< Level 036 >>>======

"    $    $     $       0$   " +
"H######H### #####H### #####H" +
"H      H         H         H" +
" H      H  -    H         H " +
"H      H  - -    H         H" +
" H      H-   -  H --------H " +
"H------H      -  H         H" +
"    0   H-     -H         H " +
"###### H  -   -  H    0$ $ H" +
"## ###  H  - -  H    -###@@@" +
" $   $ H    -    H   -###@@@" +
"##X###  H  - -  H    -###@@@" +
"##X# # H  -   -  H   -##$$@@" +
"  $ $   H-     -H    -@@@@@@" +
"###### H    $ &  H $  @@@@@@" +
"############################",

//======<<< Level 037 >>>======

"S                           " +
"S      0                    " +
"S##########@@@@@@#@@@@#@@@@H" +
"$                     H    H" +
"##         @   $    $---$  H" +
"#####HH#HH########  #   #  H" +
"    #HH HH# @@####     0   H" +
"    #HH$HH# @ #### ###H####H" +
"    ####### @$###     H    H" +
"                      H    H" +
"       &       #H#####H@@@@H" +
"##H########H### H $$  H    H" +
"  H        H    H @@     ##H" +
"  H##$#    H  ### @@###### H" +
"  H####   0H   $  @@       H" +
"##################@@####@@@@",

//======<<< Level 038 >>>======

"S                          S" +
"S                          S" +
"######H####H0 0H####H#######" +
" -    H    H@H@H    H     - " +
"H #####      H   $  ###### H" +
"H #####  #HHHHHHH#  ###### H" +
"H ###$#  #H@@@@@H#  ##$### H" +
"H #####  #HHHHHHH#  ###### H" +
"H         -------          H" +
"H 0   H      @      H    0 H" +
"H@@@@@H    $@@@$    H@@@@@@H" +
"H     H    @@@@@    H      H" +
"H#####H   @@@@@@@   H######H" +
"H     H $@@@@@@@@@$ H      H" +
"H@@@@@H @@@@@@@@@@@ H@@@@@@H" +
"$     H@@@@@@@@@@@@@H  &   $",

//======<<< Level 039 >>>======

"###  S ##    ##    ## S  ###" +
"#### S#### 0#### 0####S ####" +
"H  ##H#  ##H#  #H##  #H##  H" +
"H   #H--H #H   $H# H--H#   H" +
"H 0####$H####HH####H$#### &H" +
"H###  ##H#  #H##  #H##  ###H" +
"H##    #H$   H#   $H#    ##H" +
"H###  ####HH####HH####  ###H" +
"H  ##H#  ##H#  #H##  #H##  H" +
"H   #H    #H   $H#    H#   H" +
"H  ####HH####HH####HH####  H" +
"H###  ##H#  #H##  #H##  ###H" +
"H##    #H    H#    H#    ##H" +
"H###  ####HH####HH####  ###H" +
"H    $    HH $  HH    $    H" +
"H##########################H",

//======<<< Level 040 >>>======

"S          #################" +
"S          ########@ ------#" +
"S    $   H#    $   @H # $  #" +
"#########H@####### @H ######" +
"    $    H@    $   @H ######" +
"H#########@ ##X### @H ######" +
"H    0$   @      $ @H   0   " +
"#########H@ ##XXX# ########H" +
" $       H@    $           H" +
"H#########@ ##X###         H" +
"H  $      @      $         H" +
"#########H@ ##XXX#  #####  H" +
"        $H@      $  #  $#  H" +
"H#########@ ##X###    H##  H" +
"H   0       &         H# $ H" +
"############################",

//======<<< Level 041 >>>======

"    --$ --------0----- -----" +
"   H $#$        H- # -H  $$$" +
"$&H $# #$      H- ### -H  $$" +
"## $#   #$    H- #   # -H  $" +
" 0 X  #  #   H- ##   ## -H 0" +
"H##  ###  @@@-   #$$$#   -#H" +
"H   #   #   $   HH###      H" +
"H  - ###   $H  H##H#       H" +
"H   - #   $H   H$$H -------H" +
"H    -   $H   H@@@@H       H" +
"@@@H  ---H    H$  $H ------H" +
"   H         H######H      H" +
"###H###H     H$    $H -----H" +
"       H    H@@@@@@@@H     H" +
"       H  0 H$   0  $H ----H" +
"########@@@@@########H     H",

//======<<< Level 042 >>>======

"  $       $          $    $ " +
"H###    H###    H##########H" +
"H $   $ H     $ H $    $   H" +
"H###H###H   #####@##@####@##" +
"H   H  0H   --------------- " +
"####H######H      $   $0   H" +
"    H      H @####@@@@@@###H" +
"    H@@@@@ H @      $  $   H" +
"#   H  $ @ H @   @@@@@@@@@ H" +
"#$$@@@###@ H @   @  $ $  @ H" +
"###@@@###@ H @ $ @ H####H@ H" +
"  $  $     H @@X@@ H    H@ H" +
"#########  H @     H   0H@ H" +
"  $ $   @  H @########@@@@ H" +
"######H @@@@####@   $  $  &H" +
"####$#H           H#########",

//======<<< Level 043 >>>======

"                            " +
"  S                       S " +
"  H#######################H " +
"  H H##   $   $ 0 $   ##H H " +
"  H###H###############H###H " +
"  H H H ### $   $0##H H H H " +
"  ##H###H H#######H H###H## " +
"  H H H H H H###H H H H H H " +
"  H###H###H H $ H H###H###H " +
"$ H H H H H0H@@@H0H H H H H$" +
"####H###H$H@H@@@H@H$H###H###" +
"##H H H H@H@H@@@H@H@H H H H#" +
"##H## H@H@H@H@@@H@H@H@H ##H#" +
"##H H@H@H@H@H@@@H@H@H@H@H H#" +
"##H@H H H H H  &H H H H H@H#" +
"############H#$#H###########",

//======<<< Level 044 >>>======

"###########################S" +
"#   HHHHHHHHHHHHHHHHHHH   #S" +
"# & H HHH    H   HH   H 0 #S" +
"####H HHH HH H HH H HHH####S" +
"#   H HHH HH H HH H   H   #S" +
"# 0 H HHH HH H HH H HHH 0 #S" +
"####H   H    H   HH   H####S" +
"HHHHHHHHHHHHHHHHHHHHHHHHHHHS" +
"H $ H $ H $  H  $ H $ H $ HS" +
"HHHHHHHHHHHHHHHHHHHHHHHHHHHS" +
"H   H H H HH H HH H   H   HS" +
"H H H H H  H H  H H HHH H HS" +
"H  HH H H H  H H  H   H  HHS" +
"H H H H H HH H HH H HHH H HS" +
"H H H   H HH H HH H   H H HS" +
"HHHHHHHHHHHHHHHHHHHHHHHHHHHS",

//======<<< Level 045 >>>======

"@@@@@@@@@@@@@@@  S @@@@@@@@@" +
"  0H      H---   S H      $ " +
"@@@S##@@@@@#X#@@@S H@@@@ H@#" +
"@--H       H----H  H   #####" +
"@  H       $ #$#H0 H  $   ##" +
"$ XH       H    @#H @@####@#" +
"@#XH-------H-----@H-------H@" +
"#$ @       H   $H@@@      H#" +
"@@X#    $$$H    H@----  $ HH" +
"@          H    H@H $   X#@H" +
"###X##     H &  H@H        H" +
"#H---- H@###@##X@@H        H" +
"#H$   #H        H#H  @#### H" +
"#H@--###H       H@H  # $ @ H" +
"#H  ###@#H  0   H H   #@@#@@" +
"@#####@@@@##############@###",

//======<<< Level 046 >>>======

" $                   S      " +
"####H            0   S      " +
"  $ H          H######H   $ " +
"########H######H     #######" +
"        H      H $        $ " +
"     $  H      H############" +
"#H######H   $  H            " +
" H   $  H@@@@@@H      $     " +
"#H######H      #####H######H" +
"        H 0    $    H      H" +
" $      H###H#######@@@@@@@@" +
"###H#####   H  $      $ 0   " +
"   H       H########H#######" +
"   H-------H        H       " +
"   H         &      H     $ " +
"#######################S####",

//======<<< Level 047 >>>======

"@               @@@@@@@@@@@S" +
"@0        0     @  $ @     S" +
"@@------#####H &@ H@ @H@###S" +
"@#####   $  ###@@ H@ @H@###S" +
"@    ######       H@ @H@   S" +
"###H      ####H $ H@ @H@ $ S" +
"# ###@#H      H###@@ @H@###S" +
"#  $  ##@#H   H    @ @H@###S" +
"#####    ###@#H    @ @H@   S" +
"# $ #@H#     ##@##H@ @H@$$ S" +
"###   H##@@#  $  @H@ @H@###S" +
"# #@##H    ###@@#@H@ @H@###S" +
"#   ###@##H  $   @H@ @H@ ##S" +
"# H##   $###@@#H#@H@ @H@  #S" +
"# H#           H $H@  H   $S" +
"#$H#@####@#####@##@@##@#####",

//======<<< Level 048 >>>======

"            $               " +
" ------- ####H&             " +
"H          $ H    $      $  " +
"H        H@@@@ #######H#####" +
"H        H $          H     " +
"H######H ####H        H     " +
"H      H   $ H0H###########H" +
"H      H H@@@@ H@@@@@@@@@@@H" +
"H    $H# H$    H@     $   @H" +
"H    H#  ####H H@H@@@@@@@H@H" +
"H  $H#      $H H@H@   $  H@H" +
"H  H#    H@@@@ H@H@@@@@@@@@H" +
"H H#     H $   H@H    $    H" +
"HH#      ####H H@@@@@@@@@@@@" +
"HH  0        S H    0       " +
"############################",

//======<<< Level 049 >>>======

"     -     - -      -  $  $ " +
"-   - -   - H -    - H######" +
" - -   - -  H  -  -  H      " +
"  -     -   H   --   H  0   " +
" $   $  $   H   -    H@@@@@H" +
"@@@@@@@X@@@@@@H-     H@ $ @H" +
"              @      H@H@$@H" +
"             $@  & $ H@H@$@H" +
"H##########H#@@H####-H@H@$@H" +
"H     0    H##HH     H@H@$@H" +
"H    ##    H##H   $0  @H@$@H" +
"H ###  ### H##@@#####H@H----" +
"H ###  ### H##       H      " +
"H ###$$### H#     --$H #### " +
"H $ $##$ $ H##  H#  #H##$$##" +
"############################",

//======<<< Level 050 >>>======

"H   -                  H----" +
"H    H                 H @  " +
"H    H             0   H @$$" +
"H $  H####  $  $H#####X#H###" +
"H##  H   #########      HH#X" +
"H    H                   HHX" +
"H     H-------------------HH" +
"H     H                    H" +
"H     H $       0   $     $H" +
"H     #####H@@@@@@@@@@##X###" +
"H---       H          ---   " +
"   0$      H         H      " +
"#########H H   $     H-   $ " +
"        #####H@@@H#### #$###" +
"$       &    H   H   0 #####" +
"#############H   H##########",

//======<<< Level 051 >>>======

"#@#@@#             S@#@@###@" +
"##@@##             S#@@###@@" +
"   @#@#  $      $  S#@     @" +
"H#   @##@###@H##@  S#@ #@H @" +
"H#@  @#@@###@H ## $S@  #@H @" +
"H##     @##@@H  #@### $#@H @" +
"H@##$    #@@#H        ##@H$ " +
"H#@####   @##H  -------#@@#H" +
"H @@#@##$  #@H $       #@  H" +
"H     H##   @@#@@#@    #@  H" +
"@###@@H@##            $#@  H" +
"#@#@@@H#@##$   0    $###@  H" +
"   $  H@@###X@@@@@@X###@@H##" +
"H#@###@@   0         &   H@#" +
"H@###@  H##@@#@@##@#@@##@@@#" +
"H   $   H            0   @#@",

//======<<< Level 052 >>>======

"         H                  " +
"         H      $    0      " +
"----  $  S     @@@@@@@@@@@@H" +
"H  @@@@@@@                 H" +
"H         -----  ----- H@@@@" +
"H---------        H    H    " +
"    0          $  H#   H    " +
"H@@@@@@@@@@@@@@@@@@#   @@@@H" +
"H                         HH" +
"H      $      $     0  @  H " +
"@@@@##@@@@H #@@#@@@@@@@@  H " +
"          H               H " +
"       $  H      $        H " +
"H@@@@@@@@@@ @@@@@@@@      H " +
"H                   ------H " +
"H          &        0       ",

//======<<< Level 053 >>>======

"                            " +
"         0     0        $ $S" +
"      H##############  H####" +
"      H ############  H#####" +
"H######  #$##$##$##  H######" +
"H#######           0H#######" +
"H#############X#########    " +
"H########$ $    $ $##### $$ " +
"H#########X###X#############" +
"H       0          $######  " +
"H  H#####H#####H  -H####  $H" +
"H  H  H  H  H  H   ###  $H##" +
"H  H$$H$$H$$H$$H   #  $H####" +
"H  H#####H#####H    $H######" +
"H              &   H########" +
"H###########################",

//======<<< Level 054 >>>======

"S              #############" +
"S  $     $     #############" +
"##############H  $          " +
"###########################H" +
"     $ 0   0 $             H" +
"H###########################" +
"H        $          $       " +
"###########################H" +
"    $        $      $      H" +
"H###########################" +
"H   $  0 0  0     $         " +
"###########################H" +
"   $      $      $      $  H" +
"H###########################" +
"H     $           $  &      " +
"############################",

//======<<< Level 055 >>>======

"############S ##############" +
"#---------# S  #---------#  " +
" #$  H  $#  S   #$  H  $#   " +
"  #$ H $#   S    #$ H $#    " +
"   #$H$#    S     #$H$#     " +
"    #H#     S@@@@@##H#      " +
" &  #H#     S@   $ #H#  0   " +
"###H#H######X#######H######H" +
"   H H 0            H      H" +
"H##@#H##############H#@#####" +
"H---#H#------------#H#      " +
"H $# H #$        $# H #     " +
"H$# $H$ #$      $#  H  #    " +
"H# $#H#$ #$  H###   H   # $ " +
"H $##H$#HH#@H#@#  0 H  $ ###" +
"#########H  H $#############",

//======<<< Level 056 >>>======

"$$$----$$$ $$$-----------$$$" +
"###    ###H###           ###" +
"###    ###H###           ###" +
"###    ###H###    $$$    ###" +
"###    ###H###    ###    ###" +
"###    ###H###    ###    ###" +
"###    ###H###    ###    ###" +
"###    ###H###    ###    ###" +
"###    ###H###    ###    ###" +
"###$--$###H###$--$###$--$###" +
"####$$####H####$$#####$$####" +
"##########H#################" +
" ######## H ####### ####### " +
"  ######  H  #####   #####  " +
"   0     &H          0      " +
"############################",

//======<<< Level 057 >>>======

"#S##########################" +
"#S------------------------ #" +
"#S#@@@#@@@#@@@#@@#@H#@---#H#" +
"#S#    $    $   $  H   $H#H#" +
"#S$H@@@@@@@@@@@@@@@@@@@@H@H#" +
"#S#H#----------------@ $H#H#" +
"#S$H# @@@@@@@@@@@@@@@@####H#" +
"#S#H# @ $$$$$$$$$$$$   $#$H#" +
"#S$H# @###@@@@@@#@@@@@H###H#" +
"#S#H#     0           H$#$H#" +
"#S$H#@@@@@@@@@@@##@@@@H# @H#" +
"#S#H------------------  H#H#" +
"#S#@@##@@H@@#@#@@H@@@@@@H$H#" +
"#S 0     H @@    H  0  $H#H#" +
"#@@@#@###@@@@H@@#@#@@##@@#H#" +
" &           H            H#",

//======<<< Level 058 >>>======

"#####################     S#" +
"# &##--- @@   $           S#" +
"# #@  $ H@@######HH H#H H S#" +
"# #     H    @@# HH$H H H S#" +
"# #H####@##$   # HH H H#H S#" +
"# #H#      @##   HH H H H S#" +
"#$ H#   $  #@# H# H H H H S#" +
"##HH##X#@###@# H#$#S##H#H S#" +
"##H      0     H#X#S# H H S#" +
"##H##@#######@HHH #S# H H S#" +
"##H #@#######@HH  #S# H H0H#" +
"# H  @  $    @H   #S#HH###H#" +
"# HH#@#######@H $ #S#H0   H#" +
"# #H#@#######@H@@@#S####  H#" +
"# #H#     $  @@#   S   #  H#" +
"# $H #@@@@@@@@@# 0 S   #####",

//======<<< Level 059 >>>======

"   -- $         -$    $     " +
"  H  ##        H ##   ##H   " +
"  H        $0  H        H  $" +
" $H--      ## $H  0$    HH##" +
"##H  H$0     ##H  ##   $ H  " +
"   $ H##       H      ## H  " +
"  ## H- --0$---H         H  " +
"  $    H  ##    $   $-   H$ " +
" ##    H       ##  ## H$H## " +
"    - $H  $           H##   " +
"   H ##H  ##   $      H     " +
" $ H     $    ## $    H$    " +
"H##H    ##       ##   H##   " +
"H                           " +
"H             &             " +
"############################",

//======<<< Level 060 >>>======

"               -----        " +
"          ----H     0$  $   " +
"     ----H      0 $ #######H" +
" ---H         $ #####  $  #H" +
"H         &$ ####   $0#X#H#H" +
"H  X#X ## ####  $ #X### #H#H" +
"H  $ $ $  #  $ ##X#  $  #H#H" +
"H ## X#X  # ####   $###H#H#H" +
"H  $ $ $  # #  $ #X#X #H#H#H" +
"H  ### X# # # ##X#  $ #H#H#H" +
"H  $ $ $  # # #  $ ##H#H#H#H" +
"H #X X##  # # # #####H#H#H#H" +
"H  $ $ $  # # # #   #H#H#H#H" +
"H  ##X X# # # # # $ #H#H#H#H" +
"H        0# # # #####H#H#H#H" +
"###########          H H H H",

//======<<< Level 061 >>>======

"          S                 " +
"          S                 " +
" $ 0 $   @H@   -------- &   " +
"H@###@@# @H$          ####  " +
"H@       @H@    $          $" +
"H@----   @H@  ####---      H" +
"H@      $@H@  $         $  H" +
"H  $@###@@H@###      H#### H" +
"H@#@@    @H@      0$ H#    H" +
"H@-------$H@   ########    H" +
"H@    $  @H@   $        $  H" +
"H@   @###@H@--####--  H##  H" +
"H@$      @H@        $ H    H" +
"H@##     @H@      #####    H" +
"H     0   H                H" +
"@###@####@@@@###@####@@##@@@",

//======<<< Level 062 >>>======

"##S####S#####S#####S#####S##" +
"# S$0  S     S   $ S $   S #" +
"#H########X####X##########H#" +
"#H#$       0$        $   #H#" +
"#H#####X########X#######H#H#" +
"#H#  $          $      #H#H#" +
"#H#H####X####X#####X##H#H#H#" +
"#H#H#                #H#H#H#" +
"#H#H#H#$     0     $ #H#H#H#" +
"#H#H#H###X##X###X#####H#H#H#" +
"#H#H#H   $        $   H#H#H#" +
"#H#H###X############X###H#H#" +
"#H#H   $         $      H#H#" +
"#H###X####X####X######X###H#" +
"#H   0   $    &     $  0  H#" +
"############################",

//======<<< Level 063 >>>======

"                  0         " +
"###########################S" +
"$ 0     #       $  # $     S" +
"###H# #H#H######## #H# ##H##" +
"###H#H#H#H#  $   # #H# ##H##" +
"###H#H# #H# #### # #H#   H H" +
"#$#H#H#H#H#H#& # # #H# ####H" +
"#  H#H#H#H#H## # # #H# #H  H" +
" H#H#H#H#H#H  $# # #H# #H###" +
"H### H#H#H###### # #H# #H  H" +
"H## #H#H#H $     # #H -####H" +
"H  -#H#H########## #H# #H  H" +
"H## #H#H           #H# #H###" +
"--# #H##############H# #H  H" +
"     H      0       H# ####H" +
"###################### 0   H",

//======<<< Level 064 >>>======

"@S                        S@" +
"@S  0$$$$$$$$ $$$$$$$$$0  S@" +
"@@@@@@@@@@@@@S@@@@@@@@@@@@@@" +
"      $ $    S     $  $     " +
"    @H@@@@   S   @H@@@@@    " +
"     H$ $    S    H$  $     " +
"   @@@@@@H@  S  @@@@@@@H@   " +
"      $ $H   S     $  $H    " +
"  @H@@@@@@@@ S @H@@@@@@@@@  " +
"   H  $ $    S  H  $  $     " +
" @@@@@@@@@@H@S@@@@@@@@@@@H@ " +
"      $  $ H S    $   $  H  " +
" @H@@@@@@@@@@S@@@@@@@@@@@@@ " +
"  H                         " +
"  H   $  $      & $   $    0" +
"############################",

//======<<< Level 065 >>>======

"                   #######  " +
"----------$      0S ######  " +
"H        H#H----   S ######H" +
"H       HX#XH $H$   S ##  #H" +
"H-------HX#XH ###H   S #$ #H" +
"H       HX#XH0###H    S ###H" +
"H0      HHHHH ###H     S ##H" +
"#-----  @XHX@ ###H      S #H" +
"##$  H  @XHX@    H       SSH" +
"###$ H  @XHX@ H--H---------H" +
"####$H  @XHX@ H             " +
"#####H0 @XHX@ H------H##$###" +
"     H  @XHX@ H     H@######" +
"     H  @XHX@ H    H@#######" +
"     H   &H   H    H@#######" +
"############################",

//======<<< Level 066 >>>======

"#######HH----------HH#######" +
"######HH   -    -   HH######" +
"#####HH     #00#     HH#####" +
"####HH    - #### -    HH####" +
"###HH    - ###### -    HH###" +
"##HH----- ######## -----HH##" +
"#HH    - ####$$#### -    HH#" +
"HH      ############      HH" +
"#HH    - ####$$#### -    HH#" +
"##HH    - ######## -    HH##" +
"###HH    - ###### -    HH###" +
"####HH    - #### -    HH####" +
"#####HH    -    -    HH#####" +
"######HH            HH######" +
"#######HH0   &    0HH#######" +
"############################",

//======<<< Level 067 >>>======

"S                           " +
"S    #   0 #       0   0    " +
"S------$H#H ##H##SS#SS##H   " +
"H      #H #H# H# $# $#  H   " +
"H &     #  # H# H#  #   H   " +
"#####    ## H#  #  #    H   " +
"    #   $# H# $#  # --- H   " +
"   #    # HHH #    #  #####H" +
" $#   $#  #HH#  ##  X      H" +
"##    # $# H#  #  #  #     H" +
"#   $#  # H#  #    #  #$   H" +
"    # $# H# $#  H#  #$ #   H" +
"  $#  # H#  #   H #  #  #  H" +
"  # $# H#  #    H  #$ #  # H" +
" #  # HH     $  H   #     #H" +
"      H##################  H",

//======<<< Level 068 >>>======

"@@@@@@@@@@@@@@@@@@@@@@S    @" +
"@         0           S    @" +
"@    H#@##@@#H@       S    @" +
"@    H      SH@#@##@@#S    @" +
"@ ##@H     HSH# # 0#-------@" +
"@$   H   $SHS## # @#      $@" +
"@    H   HSHS#  #  #      0@" +
"@H   H   HSHS# $#& #      #@" +
"@H   H   HS@##  ## #     $#@" +
"@H@@@@X#@@S@     # #     ##@" +
"@H --------@-----# #  $   #@" +
"@H     $  H     ## #    ###@" +
"@H  H@X@@@H@@@#H#  #   $#  @" +
"@H  H@   @H@  #H####X#@# $ @" +
"@H  H@   @H@$ #H        ##@@" +
"@H $H@ 0 @H@#####@@###@####@",

//======<<< Level 069 >>>======

"H 0 ##          ------------" +
"H#####       ##H            " +
"H#####       ##H #@#@#@#@#@#" +
"H#####       ##H $ $ $ $ $ $" +
"H##$##       ##H#X#X#X#X#X#X" +
"H##### $  0  ##H#X#X#X#X#X#X" +
"H##############H------------" +
"H##############H   @ @ @ @ @" +
"H  & 0         H   #X#X#X###" +
"H########H########H     X###" +
"H########H   #####H####HX###" +
"H########H##$  ###H####HX###" +
"H########H####$  #H 0  HX###" +
"         H######  H####HX###" +
"    $ $  H########H####HX###" +
"##################H $$ HX###",

//======<<< Level 070 >>>======

"                           S" +
"                           S" +
"                     0-$$$-S" +
"  $-$-               H$###$H" +
"$H# # $-            $H#####H" +
"#H    #           $ #H##$##H" +
" H      $-        #H-H#####H" +
" H      #       $ -H  $###$ " +
" H              #H          " +
" H        $      H    $$$$  " +
" H        #   $ -H   $####$ " +
" H            #H     ####HX " +
" H         $-  H     ###HX# " +
" H         # $-H     ##HX## " +
" H          $# H     #HX### " +
" H  &       #  H 0   HX#### ",

//======<<< Level 071 >>>======

"    S                       " +
"    S              0        " +
"    S            H#####H    " +
" $H####H#H0    $ H#   #H    " +
"#H#####H#####H##H######H###H" +
"#H    @H $  @H @H  @# #H  $H" +
"#H ###@H @# @H @H $@# #H ##H" +
"#H $##@H   $@H @H # # #H ##H" +
"#H ###@H # #@H @H @@  #H ##H" +
"#H   $@H @   H$#H ##$ #H0 $H" +
"#H#####H#####HX#H######H###H" +
"$H------- $$ H  0 ##     @$H" +
"@@@H    ##@@@##H@@#$     $@H" +
"   H###$#@@@@@#H@@@@@@H@@@@H" +
"&  H#$##$$$$$$ H$     H    H" +
"@@@@@@####@@@@@@@###########",

//======<<< Level 072 >>>======

"S                           " +
"S      ------------------###" +
"H    $0         H          #" +
"H##X####        H          #" +
"H      #        H $0H ## $ #" +
"H $ H  # $   ---H###H#######" +
"H###H$ ##### $  H   H       " +
"    H##########XH   H      $" +
"H   H##  $ ####XH $#H-----##" +
"H###H##########XH###H $ H ##" +
"H     #---------H#$#HX##H ##" +
"H$0H  #     $   H###H   H ##" +
"###H  #   $ ##  H###H   H ##" +
"   H  # $ ##    H###H   H ##" +
"   H &####    $ H###H  0H ##" +
"############################",

//======<<< Level 073 >>>======

"                            " +
"      SSSSSSS&S       S     " +
"    0    S    SS     SS0@   " +
"  $H$    S     SS   SS @@@  " +
" $HHH$   S      SS SS @@@@@ " +
"$HHHHH$  S       SSS @@@@@@@" +
"HHHHHHH--S  $0 $  S----HHH  " +
"   H    ############    H   " +
"  $@$   # $      $ #    H   " +
" $@@@$  # -------- #    H   " +
" @@@@@  # H      H #    H   " +
"  @@@   # H      H #    H   " +
"H#####H #$H   0  H$#    H   " +
"H     H ############    H   " +
"H     H  H        H     H   " +
"H#####HH############HH#####H",

//======<<< Level 074 >>>======

"     S                      " +
"     S           @@@@@@@@@@@" +
"@@@@@S@@@@@H----H          @" +
"@    S     H &  H   0      @" +
"#####H######################" +
"##H  H  H###    ####      ##" +
"#HH#####H### ## ############" +
"#H###### H## $# ### ##  ## #" +
"#H# ### #H## ## ### $### $ #" +
"#H## $ ##H##    ### ## $## #" +
"#H#######H#########X########" +
"#H  # #$ HH              0H#" +
"#H####### H########H######H#" +
"#H $###   H      ##H      H#" +
"#H      0 H   $  ##H   $  H#" +
"############################",

//======<<< Level 075 >>>======

"         $   $              " +
" $   $   ##H##   $   $    $ " +
" ##H##     H     ##H##   #H#" +
"   H      H        H      H " +
"    H      H        H    H  " +
"   H       0H   $$   H    H " +
"  H        H    ##  H ---- H" +
"   H      H        H      H " +
"    H      H ------ H    H& " +
"   H ----- 0H        H    ##" +
"  H   $$   H        H       " +
"   H  ##  H        H        " +
"  0 H      H        H 0     " +
"#####XXXXXXXXXXXXXXX#######H" +
"                           H" +
"############################",

//======<<< Level 076 >>>======

"###############            S" +
"#             #            S" +
"# ------------HH#######$   S" +
"#             H#  $  # #---H" +
"#$ $0      &  H#     # #0  H" +
"#H######H@@@@@@#@@   H  ## H" +
"#H     #H      ###   H     H" +
"#H$    #H-------   0 #H    H" +
"#H   ##@H      #######H   H#" +
"#H  ##$@H    ###     #H#####" +
"#H  #  @H  $##$# $$  #H## ##" +
"#H##   @H  ##  #######H# # #" +
"#H#$   @H ##   #-----#H## ##" +
"#H     HHH#    #  $  #H#$# #" +
"#H     H#H           #H## ##" +
"############################",

//======<<< Level 077 >>>======

" ----      $$$$$$$     ---- " +
"H    ##################    H" +
"H @@@##################@@@ H" +
"H    ##################    H" +
"H0@H ################## H@0H" +
"@@@H #    #    #    ### H@@@" +
"   H #$$$$#$$$$#$$$$### H   " +
"   H ################## H   " +
"   H ################## H   " +
"   H ################## H   " +
"   H ###    #    #    # H   " +
"   H ###$$$$#$$$$#$$$$# H   " +
"   H ################## H   " +
"   H ################## H   " +
"   H ################## H   " +
"   H                   &H   ",

//======<<< Level 078 >>>======

"#                         #S" +
"#      $  0   -----------$#S" +
"#############HH    0 $  H##S" +
"####         HH########### S" +
"#####  $  0  HH        ##  S" +
"#############HH  $    ###H S" +
"#######      HH########  H S" +
"   $  ##  $  HH     ###X#H S" +
"H############HH $  ##    H S" +
"H## # ####   HH##### $   H S" +
"H  H#H# $##  HH  #####X##H S" +
"@@@H H#H####&HH ## $     H S" +
"@@@@@H H# ###HH#####X####H S" +
"@@@@@@@HHH# #HH#         H S" +
"         H H HH          H S" +
"############################",

//======<<< Level 079 >>>======

"                     S      " +
"    0           @    S   0 $" +
"H@@@@@ @@@@@@@H@@   #S#H####" +
"H       ---   H@$##H#S#H####" +
"##H## ##  H#0 H ###H#S#H##$#" +
"  H  ##$# H # H##  H#S#H####" +
"H#   ####XH  #H  H###S#H    " +
"H    &    H   #  H#  S ####H" +
"H######## # $#  $H#H#######H" +
"H########X# #  ####H##     H" +
"H########X#     $##H  ######" +
"H##$   ##X#----H# #H------  " +
"H##   $##X#H   #  #$    # #H" +
"H########X#H  #######H###$#H" +
"H   ##$    H ##      H  ###H" +
"H##########H###########    H",

//======<<< Level 080 >>>======

"      -----------$          " +
"@@@@@@   ##     #@@@@@@#H   " +
"@------  $$     #      #H   " +
"@H      ###X    # 0   $#H   " +
"@H$$    $  $    ######X#H   " +
"@@@@H $ #X##          0HH   " +
"    H       $   $   0-- H   " +
"    H     #@@@@@@@@@#-- H   " +
"    H$0 $ #0     $  #   H   " +
"    H####H######X####   H   " +
"     #  #H              H   " +
"     #  #H              H   " +
"     #$$#H              H   " +
"     ##X#H              H   " +
"         H    0  &      H   " +
"###@@@@@###@@@@###@@@@###@@@",

//======<<< Level 081 >>>======

"S                           " +
"S                           " +
"@@@@@@@H               H@@@@" +
"       H   0         0 H    " +
"       H#######@@@#####H    " +
"   #   H               H    " +
"  #  --H               H    " +
"  # $ $H    $#$     $$$H    " +
"  # #$#H--  # # $$$ ###H--  " +
" #  #$#H$ $--$# ### #$#H$ $-" +
" #  ###H#$# $#$ $$$ ###H#$# " +
" #    #H$#$ ### ### #$#H$#$ " +
"#     #H#$#         ###H#$# " +
"       H-H             H-H  " +
"       H    &          H    " +
"###@@@#########@@@@#########",

//======<<< Level 082 >>>======

"@@@@@@@@@@@@ S @@@@@@@@@@@@@" +
"@--------H#@-S-@#H---------@" +
"@      $ H#--S--#H $       @" +
"@   $  ##H--$S$--H##  $    @" +
"@  $##X-HH#@#S#@#HH-#X# $  @" +
"@ $##--H-#X-HSH-X#-H--###$ @" +
"#$##--H-----HSH-----H---##$@" +
"#X---H------HSH------H----X#" +
"#---H0------HSH------0H----#" +
"#   H######XH&HX######H    #" +
"# $ H       ###       H  $ #" +
"H   H    0  #$#  0    H    H" +
"H---H#X#####H H#####X#H----H" +
"H $  H      H H      H  $  H" +
"H    H  $   H H  $   H     H" +
"#########@#######@######@@@@",

//======<<< Level 083 >>>======

" ----$                $ $&#S" +
"     #H              H#####S" +
"     #H             HX#####S" +
"     #H            H#X##  #S" +
"     #H           H##X##$ #S" +
" $ 0 #H          H#$#X##XX#S" +
"####  #H        H# H#X##  #S" +
"$   #$ #H$     H# $H#X##  #S" +
"###H #  ##H   H####H#X##  #S" +
"$  #H #$ #H$0H# $ $H#X##  #S" +
"##H #H #  ##H######H#X##  #S" +
"$ #H #H #$ #H $ $ -H#X##  #S" +
"#H #H #H # #H##### H#X##XX#S" +
" #H #H #H          H#X##   S" +
"  H  H  H     0    H       S" +
"############################",

//======<<< Level 084 >>>======

"                      S     " +
"                      S     " +
"0       $#$           S#$   " +
"#####H########H#H##########H" +
"$   #H $      H#H    #     H" +
"###H#####H##########H#H#####" +
"$  H     H  0       H#H    $" +
"#H##############H###########" +
"$H##$  #      $#H    0 #$   " +
"#########H#########H########" +
"##H     0H###$ ##  H  ##  $#" +
"##H####H#########H###H######" +
"$ H####H# $#####$H###H    ##" +
"##H####H#########H######H###" +
"##H   #H     # & H  #   H  $" +
"############################",

//======<<< Level 085 >>>======

"              0  $          " +
"         $  ######H# $      " +
"     ###X####     H#####X#  " +
"     #      #     H#     #  " +
"     # 0$   #     H#     #  " +
" ######## $ #$  #H#####$$#  " +
" #      ###X#####H    #X####" +
" #      #     $ #H 0$    - #" +
" #      #    H########### H#" +
" #   $ $#    H#         $ H#" +
" #  #####    H# $  H#H H####" +
" ####   # $#H####  H###X#   " +
"    # $ ####H   # $H#       " +
"    #####  #H   ###X#       " +
"            H      &        " +
"@#@#@#@#@#@#@#@#@#@#@#@#@#@#",

//======<<< Level 086 >>>======

"S                          S" +
"S--------------------------S" +
"HH                        HH" +
"H  #X##    ###X##  ######  H" +
"H  #  ##   #    #  #    X  H" +
"H  #   ##  #       #       H" +
"H  #    #  #       #       H" +
"H  #   $#  #    $  #       H" +
"H  #   ##  #   ##  #    $  H" +
"H  #$ ##   #   $#  #$  $#  H" +
"H  ####    ###X##  ##X###  H" +
"H      &                   H" +
"H H######  ######  #H####  H" +
"H H#   $#  ######H #H##$#  H" +
"H0H#    # 0## $##H  H####  H" +
"############################",

//======<<< Level 087 >>>======

" S                          " +
"  S                         " +
" H$    $H      $H     $H    " +
" $H    H$      H$     H$    " +
" H$    $H      $H     $H    " +
" $H    H$      H$     H$    " +
" H$    $H      $H     $H    " +
" $H    H$      H$     H$    " +
" H$    $H      $H     $H    " +
" $H    H$      H$     H$    " +
" H$    $H      $H     $H    " +
" $H    H$      H$     H$    " +
" H$    $H      $H     $H    " +
" $H    H$      H$     H$    " +
"&H$    $H     0$H   0 $H  0 " +
"############################",

//======<<< Level 088 >>>======

" --------#          0       " +
"H        #  $    H####H # #H" +
"H XXXXXX #####H@ H@   H # #H" +
"H XXXXXX #  $ H@ H@H@ H # #H" +
"H XXXXXX #H####@ H@H@ H # #H" +
"H XX$$XX #H $  @ H@H@ H # #H" +
"H XXXXXX #####H@ H@H@ H # #H" +
"H XXXXXX #  $ H@ H@H@ H #$#H" +
"H       0#H####@ H@H@ H ##XH" +
"H#########H $  @ H@H@ H    H" +
"H#############H@##@H@######H" +
"H#########  $ H@@@@H@@@@###H" +
"H##$$#####H####@ $ S $ @$##H" +
"H########$H@#@@@@@@@@@@@###H" +
"H@@@@@@@@@@       $  0$    H" +
"H &        H################",

//======<<< Level 089 >>>======

"@S#@@@#@@##@##@@#@ @@#@@##@#" +
"@HSSSSS@S@#@@#S@SSSSSS@@####" +
"@H & $S@S $$$ S S  0 S $  S#" +
"@H@#@#S@S#@##@H#H@###H####S#" +
"@H $  S@S $$$ H H $##H###@S#" +
"@H@#@SS@S ### H H @@$H$##$S#" +
"@HSSS $@S     H$H  #@H@#@@S#" +
"@H  S##@S  $  H@H  $ H----S#" +
"@H$ 0S @S ### H@H  #@H  $@##" +
"@H####H@S  #  H$H  # H ##$S#" +
"@H  @ H@SSSSSSH@H  # H   @H@" +
"@H  @ H---------H$0# H@$$$H#" +
"@H  @$H@####H $@H###########" +
"@H  @#H@   #####@#@-------H#" +
"@H $  H  $   $       0 $$$H#" +
"@######@#@@@@@@@@@@@@#@@@@H#",

//======<<< Level 090 >>>======

"                  H   S     " +
"        --        H   S     " +
"$   $  -- H     --H  $S0    " +
"####H--   H 0  ---#X##H#H   " +
"    H  @#X#H  ---$#$  S#H   " +
"XX###H  $  H-H@@ @######H   " +
"X$   H  @    H   @@@@ --H   " +
" X$  H      $H $     H@     " +
"  #$ H#X##H@@@@@@H#X@H@     " +
"  H#$H    H  $   H   H@     " +
"  H XH@   H#X####H##@H@     " +
"  H -H  $ H  $   H  @H@     " +
"  H@ $  @ H####X#H @$H$@    " +
"  H  @    H  $   H @@H@@    " +
"  H       H##X###H  0H      " +
"##########H  0  &H##########",

//======<<< Level 091 >>>======

"              S             " +
"              S             " +
"              S             " +
" ------   0  H#H  0   ------" +
"      H---H#$H#H$#H---H     " +
" H#$ #H   H#######H   H# $#H" +
" H####    H-H# #H-H    ####H" +
" HH##       H###H       ##HH" +
"  H##       H# #H       ##H " +
"  H##       H###H       ##H " +
"  H##       H# #H       ##H " +
"  H##       H###H       ##H " +
"  H##       H# #H &   0 ##H " +
"  H#########H###H#########H " +
"$ H##   $  #H $ H#  $   ##H$" +
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@",

//======<<< Level 092 >>>======

"                        S   " +
"               $     #0#S#  " +
"      H---H########### #S#  " +
"$ ----H    #      $  # #S#  " +
"#H         #    ###### #S#  " +
"##H      0 #    $      #S#  " +
"###H     $ #     ----- #S#  " +
"####H -----#$  $#    H  S   " +
"@@@@@@H    ######    H--S   " +
"      H    ######    H #####" +
"      H    ######    H #$ 0 " +
"      H    ######    H ####H" +
"      H              H     H" +
"    --H              H     H" +
"0 $#  H       &      H     H" +
"####  H##$###########H  ###H",

//======<<< Level 093 >>>======

"             SS             " +
"  0 HHHHH  $$SS$$  HHHHH 0  " +
"    HHHHH H######H HHH H    " +
"  H#H H H H  $   H H H H#H  " +
"  H#H H H H######H H H H#H  " +
"   #H H H-H  & $ H-H H H#   " +
"   $@ H @-########-@ H @$   " +
"   XH H H-H######H-H H HX   " +
"  HXH H H-H######H-H H HXH  " +
"  HHH H H  H#XX#H  H H HHH  " +
"  HHH H H  H#XX#H  H H HHH  " +
"   HH H H   #$$#   H H HH   " +
"    HHH H          H HHH    " +
"     HHHH          HHHH     " +
"      HHH          HHH      " +
"       0H##########H0       ",

//======<<< Level 094 >>>======

"$  ############S############" +
"H#---    -   $#S#          #" +
"H#$# #### #####S#H###H####H#" +
"H#$# #  #   $ #S#H###H####H#" +
"H#$# #$$#######S#H  #H 0$#H#" +
"H#$# ##########S###H#H####H#" +
"H#$#  $    0   S  #H#H####H#" +
"H#$#####H####$ S $#H#H    H#" +
"H#$#    H   #######H######H#" +
"H#$#H###$##H  $   #H   $ #H#" +
"H#$#H# $  #######H########H#" +
"H#$#H H##H0$    #H    $  #H#" +
"H#$############H########H#H#" +
"H#$#$  # $ # $ H$ #   $ H#H#" +
"H#X#H#H#H#H#H######H######H#" +
"H $ H#H$H#H$H#&  $ H  $   H#",

//======<<< Level 095 >>>======

"  S                         " +
"  S                         " +
"  S      -----        -----H" +
" 0H    -      H  -- 0H     H" +
"X#H---H #X##  H##  ##H ##X##" +
"X#    H##X### H##  ##H ##X# " +
"X#    H##0-   H##  ##H ##   " +
"X#    H##H ## H##  ##H- #   " +
"X# $  H##H$## H##$ ##$HXX$& " +
"X --H-H##H ## H##  ## H#### " +
"## HH  ##H  # H##  ## H#### " +
"##HH   ##H X -H##  ## H##   " +
"##H    ##H ##  ##  ## H##   " +
"##H $--##H  $   # $#  H   $ " +
"#####H ######H  ##X#  H####H" +
"#####H $#### H  $#X$  H#####",

//======<<< Level 096 >>>======

" -  0   #### 0  $   ####    " +
"H H####H####H###### #######H" +
"H H####H  $ H###$## ####$##H" +
"H H#$$#H###########    ####H" +
"H #####H     --------------H" +
"H     #H0        $  $       " +
"H#X#H #H#####X#######H $ $  " +
"H$ #H #H----- -----H@@@@@@@@" +
"## #H #H    $ $    H  &$  $ " +
"   $H #H#####X#####H#######H" +
"##H@@ #H-----------H       H" +
"##H   $H    $     @######H H" +
"##H##############S@    $ H H" +
"$#H#             S@#####X# H" +
"##H#     $    $  S@    0   H" +
"############################",

//======<<< Level 097 >>>======

"             HH----HHHHH####" +
"            H##H---H$$ H####" +
"           H####H   HH$H H H" +
"          H######H    HH$H$H" +
"          H######H     HHHHH" +
"          H#@#@X@H     H H H" +
"          H$@#@X$H     H H H" +
"          H#@#@X@H     H$H$H" +
"$---------H#@#@X@H     HHHHH" +
"H$        H$@#@X$H     H H H" +
"#H$       H#@#@X@H     H H H" +
"##H$      H#@#@X@H     H$H$H" +
"###H$     H$###X$H     HHHHH" +
"####H$    H######H     H H H" +
"#####H$  H@# #@ #@H   &H$H$H" +
"######H 0H@# #@ #@H0 H######",

//======<<< Level 098 >>>======

"@S                         @" +
"@S@@@@ @@@@@@@@@#@@@@@@@@@$@" +
"@S    $   $----   --------H@" +
"@S       H##  #####     ##H@" +
"@S     $ H       $#  # $#$H@" +
"@S    ###H  $ &  ##  #X##@H@" +
"@S $     H#####H  # 0     H@" +
"@S ###   H#   #H  #---H####@" +
"@S     0 H#$  #H  #   H--- @" +
"@S   H#########H###   H  $ @" +
"@### H#$ # $  #   #   H ###@" +
"@$ ##H#########   #   H #  @" +
"@####H---$$@$$#$  ##@@@H@##@" +
"@   #H  ###@#####H#    H  $@" +
"@ $ #H    $      HH  0 H#H @" +
"#####H############H#########",

//======<<< Level 099 >>>======

"  ---      $  $    ---  @ #H" +
"##  #H    H####H  H0  ##@  H" +
" ## #H   H##########H ##@ #H" +
"##  #H#####$##$#####H #$@##H" +
"$##$#H     0        H     #H" +
"#################X#########H" +
"   $ 0   $          &   0  H" +
"@@@@@@@@@@@@@@@@H###########" +
" ------------- @H           " +
"H      -      H@H---------- " +
"H     - -     H@## ## ## ##H" +
"H    - # -    H@@@@@@@@@@@@H" +
"H   - ### -   H------------H" +
"H  - ##### -  HX#X#X#X#X#X#X" +
"H - ##$$$## - H@            " +
"H- ######### -H@        0   ",

//======<<< Level 100 >>>======

"                 0 0 0-     " +
"               H###### H###H" +
"               H#    # H###H" +
"           H######   # H###H" +
"           H#    #   # H###H" +
"       H######   #$$$# H###H" +
"       H#    #   ##### H###H" +
"   H######   #$$$#     H###H" +
"  0H#    #   ##### H#######H" +
"######   #$$$#    0H#    ##H" +
"#    #   ##### H######   ##H" +
"#    #$$$#     H#    #   ##H" +
"#    ##### H##### $$$#$$$##H" +
"#$$$$#     H#@@@@@@#@@@#@@@H" +
"###### H#####        &     H" +
"       H####################",

//======<<< Level 101 >>>======

"H                          H" +
"H     H#$##H     H##$#H    H" +
"H0$   H####H     H####H   $H" +
"####H H####H-----H####H H###" +
"    H H##$#H     H#$##H H   " +
"  $0H H####H     H####H H$  " +
"H#### H####H     H####H ###H" +
"H     H#$##H-----H$###H    H" +
"H $   H####H     H#$##H  $ H" +
"####H H##$#H     H####H H###" +
"    H H$###H     H##$#H H   " +
"  $ H H####H-----H####H H $ " +
"H#### H#$##H     H###$H ###H" +
"H     H####H     H#$##H    H" +
"H  &  H##$$H  0  H####H  0 H" +
"############################",

//======<<< Level 102 >>>======

"---------    H      -----   " +
"         H    H    H        " +
"   ------H $   H   H        " +
"  H $ 0  ###   H    H       " +
"  H ####      H ---  H $$-- " +
"  H          H   $   H @@   " +
"  H----   $ H    @  H      $" +
"       H ## H      H       #" +
"       H     H     @@@###@##" +
"       H      H --          " +
"   $0$ H       H         @ @" +
"  #### H----   H   @@@@@@@ @" +
"$        $$   H $      $ $0@" +
"@        @@  H  #  #########" +
"           & H              " +
"#####@@@#########@@@########",

//======<<< Level 103 >>>======

"-----------------------H    " +
"  $    $     $     $   H    " +
"####  ####  ###X  ##X# H    " +
"     $    $      $     H    " +
"#  #X##  ##X#  X###  # H    " +
" $      $   $      $   H    " +
"####  ####  ###X  ##X# H    " +
"    $     $     $      H    " +
"#  ##X#  #X##  X###  # H    " +
"  $     $     $    $   H    " +
"####  ####  ###X  ##X# H    " +
"0    &           0     H   0" +
"########################S###" +
"########################S###" +
"######################  S  #" +
"###################### 0S0 #",

//======<<< Level 104 >>>======

"            0              S" +
"    $                 $    S" +
"  H###H    ##H##    H###H  S" +
" H# $ #HH##HHHHH##HH# $ #H S" +
"#H#####H##HHHHHHH#H######H#S" +
"     0   HHHH$HHHH         S" +
"#########HHHHHHHHH#########S" +
" ##$##   #HHHHHHH#  ##$##  S" +
"  ###     #HHHHH#    ###   S" +
"   #       #HHH#      #    S" +
"            #H#            S" +
"            #H#            S" +
"            #H#            S" +
"            #H#            S" +
"    0        H     &       S" +
"###########################S",

//======<<< Level 105 >>>======

"####@@#####################S" +
"# $  @     $  0    &      #S" +
"#H#H @#X#H######X######## #S" +
"#H##H #X#HH##$--------$   #S" +
"#H ##H X##HH##$   $  $##H #S" +
"#H  ##H ###HH##$    $## H#HS" +
"#HH  ##H ##HHH##$  $##  HHHS" +
"#HHH$ #HH #H#HH##  ##  #HH#S" +
"#HHHH  H#H H##HH#X##  #HHH#S" +
"#$HHHH0H##HH###HHX#  HHH$H#S" +
"#HH$  HH ##H ###HX $#HHHH##S" +
"###H####$ ##H ##H  #HHH0HH#S" +
"#HHHHHHHH  #HH HH0HHH$  HH#S" +
"#H HH $  H  H#HHH#HH#####H#S" +
"#$ H#H####H     HHH$     H S" +
"#####HHHH$H#####HH##########",

//======<<< Level 106 >>>======

"@@@@@@@@@@@@S  @@@       @#@" +
"#######@##@@S  ##@       #@#" +
"   $  #@#@#@S  @#@       #  " +
"H@###X#    @S 0 #@      $# $" +
"H####   ----H##@#@X#####H@ H" +
"H# $# ---@#@H#    X@####H# H" +
"H###---  @#@H#----X@####H@#H" +
"H##---      H@     $ ##@H##H" +
"H#--$   ##@#H#    X##@@#H##H" +
"H-- @-------H   ----- ##H #H" +
"   @#0  $  @HX##@ & $   H##H" +
"##X#@## @##@HX##@@#@@#@    H" +
"##X#@      @HX    0 $ @#####" +
"##X#@-------HX##  ####@  $ #" +
"##     $   @H          #####" +
"#@####@##H  H  H###@########",

//======<<< Level 107 >>>======

" ----------  &   ---------- " +
"H    ----  ######  ----    H" +
"H    --- ########## ---    H" +
"H    -- ############ --    H" +
"H    - #####$$$$##### -    H" +
"H    - ############## -    H" +
"H     ################     H" +
"H     ##$$$$####$$$$##     H" +
"H     ################     H" +
"H     ######$$$$######     H" +
"H      ##############      H" +
"H    - ############## -    H" +
"H    -  #$$$$##$$$$#  -    H" +
"H    --  ##########  --    H" +
"H0$$$---$  ######  $---$$$0H" +
"#########H$$$$$$$$H#########",

//======<<< Level 108 >>>======

"############    ######@@###S" +
"#--------------------- ## #S" +
"# H#########H  S#-----H----S" +
"& H$@$$$$   H  S#$  $$H   $S" +
"##H#####@###H  S###H###X#H#S" +
"# HHHHH @  $H  S#$ H-----H S" +
"#$  @$H  $$#H  S#@ H @@@ H$S" +
"#######X####H  S#$ H0  $$H@H" +
"#  $@$$ @  #H  S######H####H" +
"#  @@@@ @  #H--H#$    H  $$S" +
"# $$$ $$@$ #H$0H#@$   H ###H" +
"#H###X####H#########H######H" +
"#H--------H### -----H-@ ---H" +
"#H $  $$$ H  $H $ $ H @H$ $#" +
"##H##H@#H###X#H##@#X#####H##" +
" $H$$H0 H     H        $$H$$",

//======<<< Level 109 >>>======

"HH #####0H@@@ @@@H0##### HH@" +
"H@HH $ HH@HHHHHHH@HH $ HH@HH" +
"$H@H#H#H@H$##H##$H@H#H#H@H$#" +
"# H@HHH@H # HHH # H@HHH@H #H" +
" #HH@H@HH# H   H #HH@H@HH#  " +
"H# HHHHH #H ### H# HHHHH #H#" +
"H#H     H#H# $ #H#H     H#H&" +
"H# HHHHH #H ### H# HHHHH #H#" +
" #HH@H@HH# H   H #HH@H@HH#  " +
"X H@HHH@H # HHH # H@HHH@H #H" +
"$H@H#H#H@H$##H##$H@H#H#H@H$#" +
"H@HH $ HH@HHHHHHH@HH $ HH@HH" +
"@H ##### H@@@H@@@H ##### H@@" +
"@H H $ H H@@HHH@@H H $ H H@@" +
"@H H#H#H0HH@HHH@HH0H#H#H H@@" +
"H@H@HHH@H@HHHHHHH@H@HHH@H@HH",

//======<<< Level 110 >>>======

"      @-------  --- HH##H  S" +
"$   0$@------$##   HH##HH  S" +
"###H##@     $##   HH##HH$  S" +
"   H  @    $##   HH##HH$ @@S" +
"$  H $@   $##   HH##HH$ @@ S" +
"###H##@  $##   HH##HH$ @@  S" +
"  &H  @ $##   HH##HH$ @@ $$S" +
"###H $@$##   HH##HH$ @@ H## " +
"###H##@##   HH##HH$ @@  H$$ " +
"#$#H  @ $  HH0 HH$ @@ H#### " +
"###H $@###########H@  H$ 0$ " +
"$##H##@-----------H@ H##### " +
"###H $@$ $  H      @ H$   $ " +
"#@@@@@@###  H #### @ H##### " +
"           0H##$$##@ H$   $ " +
"############@######@ #######",

//======<<< Level 111 >>>======

"            HHH             " +
"           HHHH             " +
"             HH             " +
"  0         HHHH         0  " +
"-----------HHHHHH-----------" +
"-----------HHHHHH-----------" +
" ----------HHHHHH---------- " +
"   --------HHHHHH--------   " +
"     ------HHHHHH------     " +
"        ---HHHHHH---        " +
"$ $ $ $ $  HHHHHH  $ $ $ $ $" +
"           HH0&HH           " +
"###########HH##HH###########" +
"###########HH##HH###########" +
" $ $ $ $    H  H    $ $ $ $ " +
"############################",

//======<<< Level 112 >>>======

"                     @@@@@@H" +
"--------------  0          H" +
"H            H@@@@@@@ H# HS#" +
"H 0H@H       H-----H #H #H  " +
"@@@@@H@H@ &        H  ## S#X" +
"H----H H#X###@@@ ##H ##HSS#X" +
"H    H H# $#   $   H # H#--X" +
"H      H#  $#### @@H $H#$ $$" +
"H      H# 0#####   H #H#   #" +
"HX$     # #####$ @@HSSH#H###" +
"H #     # $##### $ H  # H## " +
"H  #    # ###### H@H ###H ##" +
"H   #   #H $#$ # H H  # H# $" +
"H    #   H###### H@H # ## ##" +
"H       #          H        " +
"##@@@#########@@@@#@#@@@#@@@",

//======<<< Level 113 >>>======

"S                           " +
"S                           " +
"###############H## $      & " +
"    0     0    H##X#@@@@@@@H" +
"$  HHHHHHHHHHH H           H" +
"#$ H  HHHHHHHH H $ $ H#####H" +
" #$H  H        H #S# ######H" +
"  #H  H$ $ $ $  H #        H" +
"   #$ H#X#X#X# H     0$ $ $H" +
"    # H         H    #H####H" +
"      H H H H  H      H     " +
"      H         H     H 0   " +
"       H H H   H      #####H" +
"        H H H   H          H" +
"    0    $S#   H   0       H" +
"############################",

//======<<< Level 114 >>>======

"       --          --    -- " +
" ######$-H########H-$####$- " +
" #######$H########H$######$ " +
" ########H########H######## " +
" ### ####H###     H###   ## " +
" ###  ###H###$$$  H###$$$-- " +
" ###  ###H######  H######$- " +
" ###  ###H######  H ######$ " +
" ###  ###H######  H  ###### " +
" ### $###H###     H     ### " +
" ###$####H###$$$$$H##$$$### " +
" ########H########H##X##### " +
" ####### H########H #X####  " +
" ######  H########H  X###   " +
"  0  0   H   &    H   0  0  " +
"#########S###HH###S#########",

//======<<< Level 115 >>>======

"                           S" +
"-------- #H            $  $S" +
"   $#$  H#H#@#@#@#@#@X@#@#@#" +
"  $# #$ H#H    $   $  ------" +
" $#   #$H##@#@#@#@#@#H     H" +
" #     XH#@@@@@@@@@@@H  $  H" +
"        H----------H###X###H" +
"                   H#      H" +
"  $ &$             H#      H" +
"H#######H 0 $  $   H# $  $0H" +
"H 0$  $ H#@#@#@#@#@#@@#@X@#H" +
"H#######H######$ ###       H" +
"H  $ $  H######## ##       H" +
"H#######H######### #       H" +
"H   $ $ H##########  $  $  H" +
"############################",

//======<<< Level 116 >>>======

"##S#@#@#@#@#@@# #S#@ ##S####" +
"##S######@#@@H@ @S@# # S  H#" +
"#@S      #@  H   S $  0S  H#" +
"###X##H------H##X#########H#" +
" & $  H$H#@$ H @  @#@  #  H#" +
"#####H##H@#@  $ @    @ ---H#" +
"  @# H@ H@@@#@@# @  -----#H#" +
"$ 0  H  H  #---------@ $##H#" +
"#X@##H  H$@@#$ #@$  @  ## H#" +
"@X @ H  $@#@@#$ @#---H#   H#" +
"  #  H $@ $$$ @$  @  H    H " +
"H----H$@ H#@#  @$   #H######" +
"H H  @@--H      @  $ H @@@@@" +
"H H#@#$$ H--H  H ####H  @  #" +
"H H$ $##$0$$H--H  ##@H   0$#" +
"############H $H$###########",

//======<<< Level 117 >>>======

"            ###            S" +
"    $  0 $  @@@     $0  $  S" +
"H##############H############" +
"H---------- @@@H            " +
"           H###H  --------- " +
" ----------H@@@H$          H" +
"H $  ----&  ######       $H#" +
"#####    #H @@@@@@    0$H###" +
"  - #    #H ######   $H#####" +
"##$H#    #H @@@@@@ $H#######" +
"$##H#    #H----- $H#########" +
"##$H#    #H @@@ H@@@@@@@@@@@" +
"$##H# $$ #H ### H           " +
"##$H####X#H @@@ H##########H" +
"$##H  0   H$###$H#$        H" +
"############@@@###@@@@@@@@@@",

//======<<< Level 118 >>>======

"----------------            " +
"     $          H0          " +
"    $$$        HHH          " +
"    $$$        HHH          " +
"   $$         HH            " +
" $$ $$$     HH HHH  --------" +
"$$ $$  $$  HH HH  HH   0    " +
"   HH         HH      HHHHH " +
" 0 HHH        HHH     $$$$$ " +
"HHHH HH    HHHH HH    HHHHH " +
"     HH         HH    $$$$$ " +
"     HH       & HH    HHHHH " +
"############H###############" +
"            H               " +
"            H               " +
"############################",

//======<<< Level 119 >>>======

"                        S   " +
"   $                    S   " +
"H@##                    S@@H" +
"H@$## $                $S@@H" +
"H  #$###          0 #######H" +
"H  # #  ###$     ### $     H" +
"H--  #$ #  #  $ ##$ @@@@   H" +
"H  ######   ###X#      ###@H" +
"H$ &             #@@@H# $  H" +
"H@@@@--------        H###$ H" +
"H   @    0$$$$       H  ####" +
"H $ @$  @@@@@@@@@@   H $@  $" +
"H#####               H##@@##" +
"H----H------         H      " +
"     H               H0     " +
"   $ H   ###################",

//======<<< Level 120 >>>======

"             S              " +
"             S              " +
"         H   S            H " +
"   ######H   H------------H " +
"   #  $ #H   H          0 H " +
"   #    #H   H@@@@@@##@@##@@" +
"@#@@#@@#@@#@@H#-----#X###  #" +
" $0 $     $  H# H   #-- #  #" +
"#######X#####H# H#$$#$#H#$ #" +
" ------------H# H####X#H#  #" +
"H0           H# H$   --HHH##" +
"H############H######H $  H  " +
"H           &H      H##  HHH" +
"H$##### $ ###H## $ #H#$--  H" +
"H## $ #####$ H$#####H##$ ##H" +
"####################H  #####",

//======<<< Level 121 >>>======

"                            " +
"######HS            SH######" +
"###HHH$S            S$HHH###" +
"HH###HHH$          $HHH#X#HH" +
"$HHH#X#HHH$0    0$HHH###HHH$" +
"  $HHH###HHH$  $HHH#X#HHH$  " +
"    $HHH#X#HHHHHH###HHH$    " +
"      $HHH###HH###HHH$      " +
"        $HHH#HH#HHH$        " +
"      $HHH###HH###HHH$      " +
"    $HHH###HHHHHH#X#HHH$    " +
"  $HHH#X#HHH$  $HHH###HHH$  " +
"$HHH###HHH$      $HHH#X#HHH$" +
"HH#X#HHH$          $HHH###HH" +
"###HHH$S            S$HHH###" +
"######HS       &    SH######",

//======<<< Level 122 >>>======

"S                           " +
"S      0          $         " +
"S @@H@@@@         @@@@H@@@@@" +
"S   H    #$      #    H# ---" +
"S---H-----#     #-----H@H  $" +
"#$  H  $   #   #      H#H-- " +
" #0 H--- #H # #   $   H@   H" +
"  #     # H  X        H#$  H" +
"&  #   #  H         $ H@ --H" +
"@@# # #   H# ------ # H#H   " +
"    #X    H # $    #  H@H 0 " +
"$H###     H  #    # $ H####H" +
"#H@-------H   #  #  ##H####H" +
" H             XX     H    H" +
" H                    H    H" +
"@@@@@@#######@@@@####@@@@@@@",

//======<<< Level 123 >>>======

"              S             " +
"   --------  -S---          " +
"  H        H-     H H####H  " +
"  H-------0H------ H# H- #H " +
"  H       H#  --- H#  H $ XH" +
"  H      HX #H   H#   H   $#" +
"  H  -- H#   #H - &---H----#" +
"H #HHS H#$H## #H  #        #" +
"H# #HS H#######H  #### #####" +
"##X##S H#  #$ #H-H    -   0H" +
"##X##S H#######  H#### ####H" +
"# $ #S H# $#  #H H#$## ####H" +
"#####S H#######H H#### ##$#H" +
"#####S H#  #$  H H#    #   H" +
"#   #S H#######H H##X###X##H" +
"# $  S#H      #H#H   #  $  H",

//======<<< Level 124 >>>======

"S                          S" +
"S                          S" +
"S-----H     H------H#     #H" +
"      H-----H      H# $   #H" +
" $    H     H 0 $  H#####X#H" +
"### $ #HH   #############X#H" +
"####### H $          $     H" +
"#####$  H##   $#$   ##     H" +
"######$ H##  $###$  ##     H" +
"#######$H## $#####$ ## 0 $ H" +
"########H##X###########H@@#H" +
"#      0H              H ##H" +
"#  $  ##H       &      H ##H" +
"########H----H####H$---H ##H" +
"#  $    H  $ H##$#H#  #H$##H" +
"##################H####H###H",

//======<<< Level 125 >>>======

"    ------              -   " +
" ###      H--   0  H####    " +
" #$      H-- ######H####    " +
" ###     --  X####XH#$$#    " +
"     ###X    X####XH####    " +
"     ###X ##-X#$$#XH    X###" +
"     #$$X ## X####XH    X###" +
"     ###X          H    X$$#" +
"                   H    X###" +
"         X##X      H        " +
"X###X    X$$X      HX###    " +
"X###X    X##X      HX### ## " +
"X $ X              HX$$# ## " +
"X###X              HX###    " +
"              0    H &      " +
"############################",

//======<<< Level 126 >>>======

"   $      - -  0   -      -0" +
"H### H####$#$#####H -    - H" +
"H  $ H############H -$ - $ H" +
"H### H##$#####$###H-  - - -H" +
"H  $ H############H $   $  H" +
"H### H#$#######$##H --  -  H" +
"H  $ H############H - $ -$-H" +
"H### H##$#####$###H   -  - H" +
"H  $ H############H  - -   H" +
"H### H###$###$####H-  - - -H" +
"H  $ H############H  $   - H" +
"H### H####$#$#####H   -- $ H" +
"H  $ H############H -  - - H" +
"H### H###$###$####H $ - - -H" +
"H 0  H############H     &   " +
"H####H##$#####$###H#########",

//======<<< Level 127 >>>======

"      S                    S" +
"      S      0             S" +
"--- 0 S------#####H    0   S" +
"H##@### #######H$##########H" +
"H##$### @$   H#H##   $   $ H" +
"H###### @@@@@H@H   ------- H" +
"H        ----H H   H       H" +
"##X###H        H   H  #    H" +
"---   H###### #######H######" +
"$   H##     ----# HHHHHHHH--" +
"    H#  @@@H    #$HHHHHHHH $" +
"H####  #   @@@H #-HHHHHHHH -" +
"H     #  H####H #$HHHHHHHH  " +
"H   H#   H####H #-HHHHHHHH  " +
"H&  H#H  H# $#H ###########H" +
"###############            H",

//======<<< Level 128 >>>======

" -                        - " +
"H ######################## H" +
"H #    #  $  $#       #  # H" +
"H # $  ####X###       #  # H" +
"H #X####     # $0 $   # $# H" +
"H #   #      ############# H" +
"H # $ #      #      #    # H" +
"H #####  $ 0 #      #    # H" +
"H #   #########     #  $ # H" +
"H #      #    #$  0 ##X### H" +
"H # $  $ #    #######    # H" +
"H ###X####    #   #      # H" +
"H # $ #$   0$ #$  # $    # H" +
"H ###X##########X######X## H" +
"H           &      0       H" +
"############################",

//======<<< Level 129 >>>======

"             HH             " +
"  0H         HH         H 0 " +
" ##H##     ##HH##     ##H## " +
"##$H$##   ###HH###   ##$H$##" +
"#  H     ##$ HH $##  #  H   " +
"##$H$ ---##  HH      ##$H$  " +
" ##H##   ##$ HH0$     ##H## " +
"  $H$##   ###HH##      $H$##" +
"   H  #    ##HH### --   H  #" +
"##$H$##    $ HH $##  ##$H$##" +
" #XHX#       HH  ##   ##HX# " +
"   H     ##$ HH0$##     H   " +
"          ###HH###          " +
"           ##HH##           " +
"        &    HH             " +
"#############HH#############",

//======<<< Level 130 >>>======

"H                           " +
"H  --      -----------------" +
"H   S     $H    $    H   0 H" +
"### #######H-------H H H@@@@" +
" $         H $     H H H    " +
"@@@H### 0  H-------H H @@@@H" +
"   H $ #####    $  H H     H" +
" & H #####$#-------H H H@@@@" +
"H# H---------------H H H $  " +
"H#######X#####   0   H @@@@H" +
"H$  ####     #$  ####H     H" +
"H#############@@ ######H####" +
"H@############   ######H###$" +
"H@############H@ ##$###H####" +
"H@ $##########H@       H    " +
"H #######$    H@############",

//======<<< Level 131 >>>======

"            S               " +
"#         #$S$#         #   " +
" #---H-----#H#-----H---#    " +
"  #$ H 0   $H$   0 H $#     " +
"   #-H-H---#H#---H-H-#      " +
"    #  H  X H X  H  #       " +
" H---# H #--H--# H #------H " +
" H-H  #H#       #H#     H-H " +
"   H  #H#       #H#     H   " +
" H-H  #H# & $   #H####  H-H " +
" H    #H#########H####    H " +
" H-H  #H# ##### #H##$#  H-H " +
"  $H  #H# ##$## #H####  H$  " +
" H-H0 #H# ##### #H#    0H-H " +
" H---- H -     - H -------H " +
" H    #H# ##### #H#       H ",

//======<<< Level 132 >>>======

"#S                         #" +
"#S-------------------------#" +
"#S       X###H###X         #" +
"#S    $X#X   H   X## $     #" +
"#S  $X#X$$$$$H$$0$$#X# $   #" +
"#S ##X#X#####H######X#X# $ #" +
"####         H         #X#X#" +
"##     $$$$  H0 $$$$     #X#" +
"#    H######XH#######H     #" +
"#    H       H       H     #" +
"#   $H  $$$$$H $ $$$$H 0   #" +
"# HX#########HX#########H  #" +
"# H          H          H  #" +
"# H          H          H  #" +
"# H          H  &       H  #" +
"############################",

//======<<< Level 133 >>>======

"-------------H--------------" +
" $      $    H   $   $ 0$  $" +
"0$  $    0 $ H $   $ $      " +
" #X##X#H H#X####H H#X#      " +
" #X##X##HH#X####XHH#X#      " +
" #X##X##XH#X####X#H#X#      " +
" #X#  ##XH#X#  #X#H#X#      " +
" #X#  ##XH#X#  #X#H#X#      " +
" #X#  ##XH#X#  #X#H#X#      " +
" #X#  ##XH#X#  #X#H#X#      " +
" #X# $##XH#X# $#X#H#X#      " +
" #X#X###XH#X#X##X#H#X###X## " +
" #X#X### H#X#X##X H#X###X## " +
" #X#X##  H#X#X##  H#X###X## " +
"         H   &    H         " +
"############################",

//======<<< Level 134 >>>======

"$0     #####################" +
"##H    #####################" +
"H####H    ##################" +
"H#######H 0  ###############" +
"H##### ####H    ############" +
"H##### #######H    #########" +
"H##### ##########H 0  ######" +
"H#### $ ############H    ###" +
"H####### $ ############H    " +
"H##### #### $ #############H" +
"H##### ####### $ ##########H" +
"H##### #########H $ #######H" +
"H##### #########H### ######H" +
"H$   $   $   $ #H### ######H" +
"##############  H###      &H" +
"############################",

//======<<< Level 135 >>>======

"       S                    " +
"       S                    " +
"       S   H@@@@@@@@@@@@@@@@" +
"##HH###H###H     0   -------" +
"#$#H# #H# #H############  $ " +
"# #H#$#H#$#HHHH$HHHH$HHH###H" +
"#XHH###H# #HH@@@@HH@@@HH   H" +
"HHHHHHHHHHHHH@  $HH@  HH##H$" +
"HH    H ## HH@ -@HH@ $HH# H#" +
"HH ###H #$#HH@@@@HH@@@HH#H #" +
"HH #$ H  ##HH---- HHHHHH#H  " +
"HH ## H # #H  $   HHHHH####H" +
"HH    H&## H#######  $H###$H" +
"HHHHHHH@@@@H#HHHHH@ ##H### H" +
"H     $  @@H#H H H@ ##H ##H#" +
"#####H   0  #H H$H@  $H# 0H#",

//======<<< Level 136 >>>======

"                     000    " +
"                  $$$$$$S   " +
"           $$$$$$S#######   " +
"    $$$$$$S@@@@@@@          " +
"   S#######                 " +
"   SS                       " +
"    S                       " +
"$$$$S                       " +
"####H                       " +
"##########H                 " +
"###############H            " +
"###################H        " +
"######################H     " +
"########################H   " +
"#########################H  " +
"#########################H& ",

//======<<< Level 137 >>>======

"S                           " +
"S   $   $   $0 0$   $   $   " +
"##############S#############" +
"              H             " +
"             #H#            " +
"             $H$            " +
"   0        ##H##       0   " +
"   H        $ H $       H   " +
"  #H#      ###H###     #H#  " +
"  $H$      $  H  $     $H$  " +
" ##H##    ####H####   ##H## " +
" $ H $    $   H   $   $ H $ " +
"###H###  #####H##### ###H###" +
"$  H  $  $    H    $ $  H  $" +
"   H          H &       H   " +
"############################",

//======<<< Level 138 >>>======

"             S              " +
"             S              " +
"          0  S  $---        " +
" --------H@@@@#X##  H       " +
"H        H       $  H       " +
"H      ######@@@#######     " +
"H      #$ #   #   #   #     " +
"H 0 $$ #  #  $# $$# $$# $   " +
"H#######  ################# " +
"H#  # #####     #           " +
"H# $# $  #   H$ # &      $  " +
"H###########@H@#######X#####" +
"H            H          --- " +
"H            H         H  $ " +
"H        $   H         H ###" +
"#############H    $ 0  H  $ ",

//======<<< Level 139 >>>======

"S               S  @####    " +
"S###############S  @ $H# $  " +
"S-----------H  #H--@##H# @@@" +
"$H#@#     $ H--#H   $ H#   H" +
"@H   ##     H  #H  @##H#  $H" +
"@H##  $#   &H  #H $@0 H#H--H" +
"HH $########H  #H  @#H##H  H" +
"H  ###     @H  #H    H  H $ " +
"H   ##    $@H  ##H   H  H###" +
"HH   ######@H0  ###H H  H   " +
"@H###------@##H   ###HH H##H" +
"#H    0       #@H   ##H#   H" +
"#H#######H      #@H   H#   H" +
"#H##$####H#####H###@@HH### H" +
"#H#####$#H#####H$  $ HH#$  H" +
"#H###################H#####H",

//======<<< Level 140 >>>======

"                            " +
"          SSSSSSSS          " +
"          H######H          " +
"        0 H# 0  #H 0        " +
"          H#  $ #H          " +
"     H################H     " +
"     H#    #    #    #H     " +
"     H#    #    #    #H     " +
"     H#    #    #    #H     " +
"     H#  $ #0 $ #  $ #H     " +
"H#############X############H" +
"H#    #    #    #    #    #H" +
"H#    #    #    #    #    #H" +
"H#  $ #  $ #  $ #  $ #  $ #H" +
"H#H##H#H##H#H##H#H##H#H##H#H" +
"H H##H H##H&H##H0H##H H##H H",

//======<<< Level 141 >>>======

"----------        ----------" +
"H         ########         H" +
"H       ############       H" +
"H   0  ##############  0   H" +
"H @@@@################@@@@ H" +
"H        ##########        H" +
"H @H        ####        H@ H" +
"@@@H                    H@@@" +
"   H  $  $  $  $  $  $  H   " +
"   H                    H   " +
"   H        ####        H   " +
"   H     ###XXXX###  &  H   " +
"   H  ###XXXXXXXXXX###  H   " +
"   H   XXXXXXXXXXXXXX   H   " +
"   H    XXXXXXXXXXXX    H   " +
"   H      XXXXXXXX      H   ",

//======<<< Level 142 >>>======

"-----------                 " +
"           H     #   - -    " +
"  $  $  $ 0H---- #### H ####" +
"###########     H#### H X###" +
"$$       $$ ----H#### H X###" +
"##$     $##H     # ## H X$$#" +
"###$   $###H---- # ## H X###" +
"####$ $####     H# ## H X$$#" +
"#####$#####  0  H# ## H X###" +
"###########H######$$# H X$$#" +
"           H     #### H X###" +
"#S#    &   H         0H X$$#" +
"#S###########H##########X###" +
"#S    ###$###H#####$        " +
"#S    ####$##H##$ $##H     $" +
"#S$  $#####  H  ############",

//======<<< Level 143 >>>======

"########S###################" +
"& @  @@@S   @H #   H------- " +
"#H   H @H@@ @H$#H@@H        " +
"$H@@#H @H@@  H  H         $ " +
"##H  H @H  ###H@H-----      " +
"$@H##@$@H##---H@H       ####" +
"  H    @H@ $@ H@##   $      " +
" 0H  $ @H@####H@ H       0  " +
"@@##H# @H@    H--H@@@@@@@@@@" +
"H  @H#  H@###### H   @-----@" +
"H#  H###H@ $#$  ###H @ H   @" +
"H@ H@@ @H@  #      H   H   @" +
"H@ H@ $@H   ###########H@  @" +
"H ### @@H@###          H   @" +
"H    0  H@$ @H $    $  H   @" +
"#########@##$H@@####@@@H  $@",

//======<<< Level 144 >>>======

"                            " +
"     ---S      ---    -   --" +
"H   H  -#@@@@@@   #### @@H  " +
"H$  H$  #   @$           H $" +
"##H-@@H @H  @@#@ XXXX## H#X#" +
" $H 0$H @H  @$          H   " +
"H##-H@@ @HH @@#H X    X H   " +
"H$  H$  @ HH  @H  #$$#  H   " +
"##H-@@H @  HH @H   ##H--H $ " +
"0$H  $H @   HH@H     H  ##X#" +
"H##-H@@ @    H@H  0  H      " +
"H$  H$0 @     @H@@@@@@@@H $ " +
"##H-@@H @     @H#  $ $ #H#X#" +
" $H  $H @     @H#H#@#@##H   " +
"H##-@@@ @0$$H# H#H $ $  H   " +
"H &     ######@@##@#@#@#@#@#",

//======<<< Level 145 >>>======

"      0   S       S   0     " +
"           S     S          " +
"            S   S           " +
"          $###H###$         " +
"          #$#$H$#$#         " +
"  $      #$H H#H H$#    $ $ " +
"  ##H#H######H H######H#H## " +
" $# H#H      HHH      H#H$# " +
" # HH#HHHHHHHHHHHHHHHHH#HH #" +
" #H0$ #HHHHHHH#HHHHHHH# $0H#" +
"  ###H #H $  H H  $ H# H### " +
"   $##H#######H#######H##$  " +
"   ## H     $ H $     H ##  " +
"   # H##HHHHHH#HHHHHH##H #  " +
" $  H###HHH#HHHHH#HHH###H&$ " +
"############################",

//======<<< Level 146 >>>======

"#    -     &    -    # $    " +
"####H ########## H#### ####H" +
"####H #  ##### # H####   $ H" +
"#$##H # #####  # H##$# H####" +
"####H #  ##### # H#### H$   " +
"##$#H # #####  # H#$## ####H" +
"####H #  ##### # H####    $H" +
"#$##H # #####  # H#### H####" +
"####H #  ##### # H ### H $  " +
"##$#H # #####  # H#### ####H" +
"####H #   #### # H#$##  $  H" +
"#$##H #$#####$$# H#### H####" +
"####H ########## H##$  H  $ " +
"##$#H ########## H#### ####H" +
"####H  0     0   H####  0  H" +
"############################",

//======<<< Level 147 >>>======

"                S           " +
" 0-         -&  S     -     " +
" H H       H H  S    H H   H" +
"H  HH     H   H S   H   H  H" +
" #$H H   H #$# HS  H #$# H-H" +
" ##H  ---H0### H---H0#H#   H" +
"@##H##X##@##@##@##X##@H#X##H" +
"#  H  X  #  $###  $# #H X  H" +
"#--H--X--# H#----H----H-#--H" +
"#  H  X  # H#  # HXH #0 $  H" +
"#X@H#@#X@##H##@##@XH@##@#X#H" +
" X####   ##H##   #XH##   X#H" +
"   H--- --#H#-- --XH#-- --#H" +
"  #H#  $  #H#  $  #H   $  #H" +
" $#H#  @  #H#  @  #H#  @  #H" +
"#X H X#@## H ##@## H ##@#X H",

//======<<< Level 148 >>>======

"                            " +
"          00 SS 00          " +
"         $$$S##S$$$         " +
"   $$$$$S@@@@@@@@@@S$$$$$   " +
"  S######          ######S  " +
"  SSS                  SSS  " +
"    S                  S    " +
"    S                  S    " +
"    S                  S    " +
"    S                  S    " +
"    S                  S    " +
"    S                  S    " +
"    S                  S    " +
"    S                  S    " +
"    S          &       S    " +
"@######@#####@@#####@######@",

//======<<< Level 149 >>>======

"                            " +
"         H##    ##H         " +
"        H##      ##H        " +
"       H##        ##H       " +
"      H##$  0     $##H      " +
"  $--H################H--$0 " +
" H#H   ##$        $##   H#H " +
" HH#H   ## $    $ ##   H#HH " +
" $HH#H0  ####  ####   H#HH$ " +
"  $HH#H   ###  ###   H#HH$  " +
"   $HH#H   ##$&##   H#HH$   " +
"    $HH#H   ####   H#HH$    " +
"     $HH#H   HH   H#HH$     " +
"      $HH#H  HH  H#HH$      " +
"$  0   $H##H HH H##H$   0  $" +
"############################",

//======<<< Level 150 >>>======

" ----        0&        ---- " +
"H    ##H$          $H##    H" +
"H    ##H$          $H##    H" +
"H     ##H$        $H##     H" +
"H$ $  ##H$        $H##  $ $H" +
"H####H ##H$      $H## H####H" +
"H$  $H ##H$      $H## H$  $H" +
"H#####H ##H$    $H## H#####H" +
"H$0 0$H ##H$    $H## H$0 0$H" +
"H######H ##H$  $H## H######H" +
"H$    $H ##H$  $H## H$    $H" +
"H#######H ##H$$H## H#######H" +
"H$     $H ######## H$     $H" +
"H########H ###X## H########H" +
"H$      $H $$#X$$ H$      $H" +
"#############@@##S##########"

];
