//************************************************************
//* All levels extract from: 
//* Championship Lode Runner (Apple-II 1984) DISK IMAGE
//* by Simon Hung 2014/02/20
//* 
//* "level 51" : Championship demo level (2014/04/27)
//************************************************************

var championData = [
//======<<< Level 001 >>>======

"                            " +
"H--------------------------H" +
"H $  $ $$$$ $    $     $$  H" +
"H $  $ $    $    $    $  $ H" +
"H $$$$ $$$  $    $    $  $ H" +
"H $  $ $    $    $    $  $ H" +
"H $  $ $$$$ $$$$ $$$$  $$  H" +
"H                       0 0H" +
"H--HHH---HHH---HHH--HHHH---H" +
"H&S   S S   S S   S S   S  H" +
"H#H#    S   S S   S S   H##H" +
"H#S #HH S   S S   S S###S #H" +
"H#S   S#H#  S S   H#H   S #H" +
"H# SSSS  SHH#$$HHH  SSSS  #H" +
"H#                        #H" +
"############################",

//======<<< Level 002 >>>======

"$0    @@    S$S   0      & $" +
"H-----@-@----H----@@-------H" +
"H----$@--@---H----@-@------H" +
"H---@@@------H---$@--@-----H" +
"H---@@@------H--@@@--------H" +
"H------------H--@@@--------H" +
"H0   $$$     0            0H" +
"H            $         $$  H" +
"H------------H---------@@--H" +
"H--------@@--H---------@-@-H" +
"H--------@-@-H--------$@--@H" +
"H-------$@--@H-------@@@---H" +
"H------@@@-----------@@@---H" +
"H      @@@        $$$      H" +
"H                          H" +
"H$$$$$$$$$$$$$$$$$$$$$$$$$$H",

//======<<< Level 003 >>>======

"HHHHH$HH0HHHHHHHH&HHH      S" +
"HHHHHHHHHHHHHHHHHHHHH@     S" +
"HHHHHHHHHHHHHHHHHHHHH@     S" +
"$HHHHH0HHHH$HHHHHHHHH@######" +
"HHHH@@@@@@@@@@@@@@@@@@@@@@@@" +
"HHHHHHHHHHHHHHHHHHHHHHHHHHHH" +
"HHHHH$HHHHHHHH0HH$HHHHHHHHHH" +
"@@@@@@@@@@@@@@@@@@@@@@@@HHHH" +
"HHHHHHHH$HHHHHHHHHH$HHH@HHH$" +
"HHHHHHHHHHHHHHHHHHHHHHH@HHHH" +
"HHHHHHHHHHHHHHHHHHHHHHH@HHHH" +
"HHHH$HHHHHHHHH$HHHHHHH$@$HHH" +
"HHHH@@@@@@@@@@@@@@HHHHH@HHHH" +
"HHHHHHHHHHHHHHHHH@HHHHHHHHHH" +
"HHHHHHHHHHH0H$H$H@HHHHHHHHHH" +
"@@@@@@@@@@@@@@@#@@H$HHHHHHH$",

//======<<< Level 004 >>>======

"             H              " +
"-------------S--------------" +
"            $S$            H" +
"      $    H#H#    0$      H" +
"H@@@@@@@@@@@@H@@@@@@@@@@@@@@" +
"H            S              " +
"H           $S$             " +
"H 0   $    ##H##H   $    0  " +
"@@@@@@@@@@@@@H@@@@@@@@@@@@@H" +
"             S             H" +
"            $S$            H" +
"      $  H###H###   $    0 H" +
"H@@@@@@@@@@@@H@@@@@@@@@@@@@@" +
"H            S              " +
"H           $S$             " +
"H     $& ####H####H $    0  ",

//======<<< Level 005 >>>======

"########################### " +
"###########################S" +
"&             $ #          S" +
"H@#@#@#@#@#@# # ###########H" +
"H@#@#@#@#@#@#@# # ####### #H" +
"H            $  # ####### #H" +
"H#@#@#@#@#@# #  # #-###-# #H" +
"H#@#@#@#@#@#@#  # #-###-# #H" +
"H           $   # #-# #-# #H" +
"H@#@#@#@#@# #   # #-# #-# #H" +
"H@#@#@#@#@#@#   # #-# #-# #H" +
"H          $    # #-# #-# #H" +
"H#@#@#@#@# #    #$#$#$#$#$#H" +
"H#@#@#@#@#@#    #X#########H" +
"H                      0000H" +
"H###########    ############",

//======<<< Level 006 >>>======

"H--------------------------H" +
"H# #  # #     $  ### # #   H" +
"H###  ###   # #  # # ###   H" +
"H   $   $   ###     $     &H" +
"H # #  ###       $ ###  # #H" +
"H ###  # #$    ### # #  ###H" +
"H$   $    # #  # #    0    H" +
"H# # # #  ###       $ # #  H" +
"H### ###      $   # # ###  H" +
"H   $    $  # #   ###    $ H" +
"H # #   ### ###  $     # # H" +
"H ###   # #      # #   ### H" +
"H    $     # #   ###   0   H" +
"H  # # # # ###$ $     ###  H" +
"H  ### ###    # #     # #  H" +
"H 000 $       ###   $     $H",

//======<<< Level 007 >>>======

"HHHHHHHHHHHHHHHHHHHHHHHHHHHH" +
"H                          H" +
"H            $$            H" +
"H           $XX$           H" +
"H           #XX#           H" +
"H        $ $#XX#$ $        H" +
"H        #$# $ ##$#        H" +
"H     $ $### #$ ###$ $     H" +
"H     #$### $##$ ###$#     H" +
"H     ####  ####  ####     H" +
"H  $ $## $ $# ##$ $ ##$ $  H" +
"H  #$##  #$##  ##$#  ##$#  H" +
"H  #X $ $###    ###$ $ X#  H" +
"H  ## #$###      ###$# ##  H" +
"H  ## ###  $$$$$$  ### ##  H" +
"H   &     H######H    0000 H",

//======<<< Level 008 >>>======

"H$H##H$H@@H$H##H$H@@H$H##H$H" +
"H@@H H##H H@@H H##H0H@@H H#H" +
"HH0H@@H H##H0H@@H H##H H@@HH" +
"HH##H H@@H H##H H@@H H##H HH" +
"H@H H##H H@@H H##H H@@H H##H" +
"H H@@H H##H H@@H H##H H@@H H" +
"H##H H@@H H##H H@@H H##H0H@H" +
"HH H##H H@@H H##H H@@H H##HH" +
"HH@@H H##H H@@H H##H H@@H HH" +
"H#H H@@H H##H H@@H H##H H@@H" +
"H H##H H@@H H##H H@@H H##H H" +
"H@@H H##H H@@H H##H H@@H H#H" +
"HH H@@H H##H0H@@H H##H H@@HH" +
"HH##H H@@H H##H H@@H H##H HH" +
"H@H H##H H@@H H##H H@@H H##H" +
"H&H@@H$H##H$H@@H$H##H H@@H$H",

//======<<< Level 009 >>>======

"############S # S##########S" +
"## 0HHH HH 0S   S0HH  HH 0#S" +
" $##  $# $#HH   H#$ ##$ ##$S" +
"$##  $# $#HH    H##$ ##$ ##S" +
"##  $# $#HH $ & H ##$ ##$ ##" +
"#  $# $#HH $####H$ ##$ ##$ #" +
" $ # $#HH $##  ##H$ ##$ ##$ " +
"H## $#HH $## $$ ##H$ ##$ ## " +
"H# $#HH $##$H##H$##H$ ##$ ##" +
"H $#HH $##$H#  #H$##H$ ##$  " +
"H$#HH $##$H# $$ #H$##H$ ##$0" +
"H#HH $##$H# $##$ #H$##H$ ##H" +
"HHH $##$H# $####$ #H$##H$ #H" +
"HH $##$H# $##$$##$ #H$##H$ H" +
"H$ ##$H# $   ##   $ #H$##H$H" +
"##H $#H ############ H# $H##",

//======<<< Level 010 >>>======

"H---  ####   $HH  ########  " +
"H  $##$###  $H  $##       # " +
"H $####$## $H  $##$H####### " +
"H$######$# H$ -##$H     ##  " +
"H######### $H -# H       ## " +
"H --$$#$$# H$ -#H        $# " +
"H$  ##$##$ $H -#H#       H# " +
"&H  $##$## H$ -#H#$H#$H#$H# " +
" #H ##$##$ $H -#H@@@@@@@@@# " +
"0#H $##$## H$ -#H         # " +
" #H ##$##$ $H -######H##### " +
" #H $##$## #H -##$  #H#  $# " +
" $H ##$##$# H -  # 0#H#  ## " +
" #H  #####  H  ## ###H####  " +
"  H--- #####    #HHHHH###   " +
"  S                         ",

//======<<< Level 011 >>>======

"H--------------------------H" +
"H   &                      H" +
"H ##### #####  ##### ##### H" +
"H # $ # # $ #  # $ # # $ # H" +
"H #@### #####  ##### #@### H" +
"H   #     #      #     #   H" +
"H ###@# #####  ##### ###@# H" +
"H # $ # # $ #  # $ # # $ # H" +
"H #@### #####  ##### #@### H" +
"H   #     #      #     #   H" +
"H ###@# #####  ##### ###@# H" +
"H # $ # # $ #  # $ # # $ # H" +
"H ##### #####  ##### ##### H" +
"H   #     #      #     #   H" +
"H0        #      #        0H" +
"############################",

//======<<< Level 012 >>>======

"S  ------------------------H" +
" #S  X 0 #   # 0 #   #   # H" +
"  $XS $#$ $X$ $#$ $X$ $#$  H" +
"X #X#S### #X# ##X XX# ###  H" +
"   # S #   #   #   #   #   H" +
"$#$ $XS SXS $#$ $X$ $X$ $#$H" +
"X## ###S##XSX## #XX ### ###H" +
" #   # 0 # S # 0 X   #   # H" +
"  $X$ $#$ $XS $X$ $#$ $#$  H" +
"X ### ### ###S### X## X#X  H" +
"   #   #   # S #   #   #   H" +
"$#$ $#$ $X$ $#S $#$ $#$ $#$H" +
"X## ### ### ###S##X ### ##XH" +
" # $ # $ # $ # S # $ # $ # H" +
"& H#H HXH H#H S#  H#H H#H 0H" +
"##H H H H H H H H H H H H##H",

//======<<< Level 013 >>>======

"@ @@@@@@@@@@@@@@@@@@@@@@@@@S" +
"@S&H H$H H$H H$H H$H H$H H@S" +
"@@@H@@@@@@@H@@@@@@@H@@@@@H@S" +
"@H@H$H H$H@H$H H$H@H$H@H@H@S" +
"@H@@@@@@@H@H@@@@@@@@@H@H@H@S" +
"@H$H H$H@H@H@H$H H$H@H@H@H@S" +
"@@@H@@@@@H@H@H@@@@@H@H@H@H@S" +
"@H@H@H H$H@H@H@H$H@H@H H$H@S" +
"@H@H@H@@@@@H@H@H@H@H@@@@@H@S" +
"@H$H H$H@H$H@H$H@H@H H$H@H@S" +
"@H@@@@@H@H@H@@@H@H@@@@@H@H@S" +
"@H@H$H H@H@H$H@H@H H$H@H@H@S" +
"@H@H@@@@@@@@@@@H@H@@@H@H@@@S" +
"@H@H H$H H$H H$H@H@H@H@H0H@S" +
"@H@@@@@@@@@@@@@@@H@H@H@@@H@S" +
"@H0H$H H@H H$H H$H@H$H H@H  ",

//======<<< Level 014 >>>======

"   &   0   0   0   0   0   S" +
"###H#X#H###H#X#H###H#X#H###H" +
"###H#X#H###H#X#H###H#X#H###H" +
"###H#X#H###H#X#H###H#X#H###H" +
"HHHHHHHHHHHHHHHHHHHHHHHHHHHH" +
"###H#X# #X#H### #X#H#X# ###H" +
"###H#X# #X#H### #X#H#X# ###H" +
"###H#X#$#X#H###$#X#H#X#$###H" +
"HHHHHHHHHHHHHHHHHHHHHHHHHHHH" +
"#X# ###H#X# ###H#X# ###H#X#H" +
"#X# ###H#X# ###H#X# ###H#X#H" +
"#X#$###H#X#$###H#X#$###H#X#H" +
"H$HHH$HHH$HHH$HHH$HHH$HHH$HH" +
"###H###H###H###H###H###H###H" +
"###H###H###H###H###H###H###H" +
"###H###H###H###H###H###H###H",

//======<<< Level 015 >>>======

"0                           " +
"&$  $  $  $  $  $  $  $  S  " +
" H- H- H- H- H- H- H- H- H- " +
" H  H  H  H0 H  H  H0 H  H  " +
" H  H  H  H  H  H  H  H  H  " +
" H  H  H  H  H  H  H  H  H  " +
" H  H  H  H  H  H  H  H -H  " +
" H  H  H  H  H  H  H -H     " +
" H  H  H  H  H  H -H        " +
" H  H  H  H  H -H     #####H" +
" H  H  H  H -H     #$######H" +
" H  H  H -H     ###########H" +
" H  H -H     ##############H" +
" H -H     # ###############H" +
"-H     ####################H" +
" S  #######################H",

//======<<< Level 016 >>>======

"HHHH  HHHHHHHHHHHHHHHHHHHHHH" +
"H  $##  @@ $ @H$0 @@$  @H $H" +
"H $##     @@0$ @H$  @@$  @HH" +
"H$##      $ @@ $ @H$  @@$  H" +
"H##      H##  @@ $ @H$  @@$H" +
"H@ $    HX#     @@ $ @H$  @H" +
"H @@ $ H#X        @@ $ @H$ H" +
"H$  @# ##          $@@ $ @@H" +
"H@H$  @@ $       H##  @@ $ H" +
"H$ @H$  @@ $    HX#     @@&H" +
"H@$  @H$0 @@ $ H#X       $#H" +
"H @@$0 @H$  @# ##      $#@@H" +
"H$  @@ $ @H$  @@ $    $#@  H" +
"H@H$  @@$  @H$  @@ $ $#@   H" +
"H0 @H   @@   @H   ## ##    H" +
"HHHHHHHHHHHHHHHHHHHH#######H",

//======<<< Level 017 >>>======

"         S        S         " +
"    $    S        S         " +
"   H@#H0 S        S  H#@H $ " +
"H@#H  H@@H        H@@H  H@@H" +
"H& $  $  H#@H $H#@H  $  $  H" +
"@@H $    $ SH@@H         H@#" +
"  H#@H0 H@@S$  H@@H   H@#H $" +
"H@@$ H#@H      $  HS@@H$ H@@" +
"H    $  H#@H0   H@#S  H#@H  " +
"H#@S    $  H@@S H  $  H  0  " +
" $ S@@H  H@@  S#@H    H@#@H " +
"      H@#H    $  H@@H   $ H " +
"   H@#H $H@@H       H#@H  H " +
"H@@H  H#@H  H@#H H@#H$ H@@H " +
"H  S  S 0S  S$ S$S  S  S $S " +
"H@@@@@@@@H# @@#@@H# @@@@@@@@",

//======<<< Level 018 >>>======

"########################### " +
"& -  #H   ##H   ##H   ## ##H" +
"##-###H###-#H###-#H###-# ##H" +
"##-#X#H###-#H###-#H#$#-# ##H" +
"##-#X#H##- #H###-#H#X- # ##H" +
"##-#X#H - ##H   -#H   #####H" +
"##-#X#H ####H#X#-#H#### # #H" +
"##-#X#H# ###H###-#H#### # #H" +
"##-#X#H##$##H###-#H####$  #H" +
"##-#$ H#XX  H#$#- H# $### #H" +
"###X#########X##X###X######H" +
" SSS -------------------0 0H" +
"S     SS  S SS S SS S  S 0 H" +
" SS  S  S SS   SS    SS    H" +
"   S S  S S    S     S     H" +
"SSS   SS  S    S    S    S H",

//======<<< Level 019 >>>======

"        -- @  -  @@@   -  @@" +
"#H@$#@@H  #$#@ H#   $#@ H-$ " +
"#H ##$ @H  @@  H#$  #@ H  # " +
"#@@@@#  @H   0H@# @## H  #@ " +
"$    #@@@H#@@@#@@#@@ H  #@@ " +
"X H@     H# --   ----H ##$@ " +
"X@H @@#@@#@ $ @#   @X@  #@@ " +
" @@H  -   @@#@@@# @@$@@  @@ " +
"  @@H  @#$@    $#@@@X@@@  @ " +
"-- @@H  @#    @@@ ---H @@$  " +
"$ H @@H          H    H @@  " +
" #H   @H  H#@H----    @H @@ " +
" #H@## @H#@# H 0   #0@  H   " +
"@# $##@ H@$##@@#S #@#  HXS  " +
"@@@### H#@@## $#S#$@  H@$@S$" +
"@$  #H@H  &#@@ @S@#  H  X S@",

//======<<< Level 020 >>>======

"S                           " +
"S$    0       ------------$$" +
"H@------------ $$$$$$$$ $$@H" +
"H@X#######X###X###X####X##@H" +
"H@ $  0  $  $     $     $ @H" +
"H@ @@@@@@@@@@@ ###X####X##@H" +
"H@ $$$0$$$$$ @ @ $$$$$$$$ @H" +
"H@ ######### @ @ ######## @H" +
"H@ $  0  $  $  @  $     $ @H" +
"H#H###########X##########H#H" +
"H#H$  0  $  $  $  $  $   H#H" +
"H############# @@@@@@@@@@##H" +
"H  $  &  $  $@ $  $  $  $  H" +
"H############# ########## #H" +
"H  $  $  $  $@ $  $  $  $  H" +
"H############# ############H",

//======<<< Level 021 >>>======

"###########################S" +
"####--------#---------    #S" +
"###     &   #    0    H#  #S" +
"###   ####  ######### H#  #S" +
"##   #####  ###$##$## H#  #S" +
"##     $##  #$#####$# H#  #S" +
"#    0      ###$####$ H#  #S" +
"#   ####    #$####$## H#  #S" +
"#X######@@  ###$#$### H#  #S" +
"#X#$$$$$#HH #$#####$# H#  #S" +
"#X######HH ####$####$ H#  #S" +
"#X####    ###$####$## HX  #S" +
"#X####H# ############ H####S" +
"#     H # ###         H#  #S" +
"#    H ### #          H# $#S" +
"########### #############XSS",

//======<<< Level 022 >>>======

"@@ @@@@@@@@@@S@@@@@@@@@@@ @@" +
"#H$$$$$$$$$$$S&$$$$$$0$$$$H#" +
"@H@@@@@@@@@@@H@@@@@@@@@@@@H@" +
"#H@0$$$$$$$H H H$$$$$$$$ @H#" +
"@H#$@@@@#@@H$H$H@@#@@@@@$#H@" +
"#H@$#H$$$0@HHHHH@ $0$$ #$@H#" +
"@H#$@H@@@X@@HHH@@X@@@@H@$#H@" +
"#H@$#H@ $$$$HHH$$$ $H@H#$@H#" +
"@H#$@H#$@@@@HHH@@@$@H#H@$#H@" +
"#H@$#H@$$ $$HHH$$0$$H@H#$@H#" +
"@H#$@H@@@X@@HHH@@X@@@@H@$#H@" +
"#H@$#H$$$$#HHHHH#$$$$$H#$@H#" +
"@H#$@@@@@@@H@$@H@@@@@@@@$#H@" +
"#H@$$$$$$$$H#$#H$$$$$$$$$@H#" +
"@H@@@@@@@@@@@$@@@@@@@@@@@@H@" +
"#H$$$$$$$$$$$$$$$$$$$$$$$$H#",

//======<<< Level 023 >>>======

"########################### " +
"#& #  #     #  #   -- -- --H" +
"#$ #   $H#   $ #  # $#  #$ H" +
"####H############### ##H###H" +
"#  #H$#  # $#  # $   #$H#  H" +
"#  #H    #  #    H#----H#  H" +
"#####H#####################H" +
"#  # H#  #  # $#   $ #$H#  H" +
"# $  H#$       #  #H  HH#$ H" +
"# #########################H" +
"#  #  #  #$H#  #    H#  #  H" +
"#   $ #  #  #   $H#  #  #  H" +
"# ##H########H#############H" +
"# $#H #  #   H$#  #$    #  H" +
"#  #H  $    #H      S#    $H" +
"############################",

//======<<< Level 024 >>>======

"H---------------- 0#### ----" +
"H----- 0 ------- ####### ---" +
"H---  ###  ---- ######## ---" +
"H-- #######  - #######  ----" +
"H- #  ####### ######   -----" +
"H- # $ ############ ##### --" +
"H-- ### ########## ######## " +
"H------- ########## ########" +
"H       ############ #######" +
"H      ###$###$###### ######" +
"H      ############## ######" +
"H   -----########-----######" +
"H    ----##   ###------#####" +
"H-- ###S####H##### #### ####" +
"H  #$##S  ######  ###### ###" +
"H&HXH###S        ##H#H## ###",

//======<<< Level 025 >>>======

"##########HHHHHHHH##########" +
"#######HHHH00   &HHHH#######" +
"######HH   ######   HH######" +
"#####HH #####-###### HH#####" +
"####HH ######--# #$## HH####" +
"###HH ##$####--####### HH###" +
"###H ####0   --   0#### H###" +
"###H ########--######## H###" +
"###H #####--#--#--##### H###" +
"###H ####--##--##--#### H###" +
"###HH ##- ## --###$-## HH###" +
"####HH ###### -###### HH####" +
"#####HH ###### ##### HH#####" +
"######HH   ######   HH######" +
"#######HHHH      HHHH#######" +
"##########HHHHHHHH##########",

//======<<< Level 026 >>>======

"#####HHHHHHHHHHHHHHHHH######" +
"####HH               HH#####" +
"###HH     &      0    HH####" +
"##HH  H######H######H  HH###" +
"##H   H#  $ #H# $  #H   H###" +
"##H---H@$   #H#   $@H---H###" +
"##H$$$H## ###H### ##H$$$H###" +
"##H$$$H # X@@@@@# # H$$$H###" +
"##H   H ###     ### H   H###" +
"##H---H     $$$     H---H###" +
"##H   H ########### H   H###" +
"##H0      $HHHHH$     0H####" +
"###H    XX#XXXXX#XX   H#####" +
"####H0              0H######" +
"#####H              H#######" +
"######H$$$$$$$$$$$$H########",

//======<<< Level 027 >>>======

"   @0         @             " +
"   @H@@@@@@@@ @             " +
"   @H@@       @             " +
"   @H@@ @@@@@@@             " +
"    H H                     " +
"    H H                     " +
"    H H                     " +
"    H H @@@@@@@@@@@@@@@@@@@S" +
"    H $$@$$$$$$$$$$$$$$$$$$H" +
"    H @@@@@@@@@@@@@@@@@@@@@@" +
"    H                       " +
"    H $$$$$$$$$$$$$$$$$$$$$H" +
"    H @@@@@@@@@@@@@@@@@@@@@@" +
"    H                       " +
"    H $$$$$$$$$$$$$$$$$$$$$H" +
"&   H @@@@@@@@@@@@@@@@@@@@@@",

//======<<< Level 028 >>>======

"   &           0            " +
"##S#####X#########S#########" +
"  S   #          #S         " +
"S##########X##########X###S#" +
"S         #            #  S " +
"####S###############X###  S " +
"    S------------         S " +
"    - H          ###   ####H" +
"####--H###########      ---H" +
"####- H                -   H" +
"##0#- #####H#######    -   H" +
"####-      H         $ -  H#" +
"##0#- ##H###### H##H # - H##" +
"####-   H       H  H    H###" +
"#$$#    H       H  H    H###" +
"############################",

//======<<< Level 029 >>>======

"HHH#H            H#& 0#0HHHH" +
"X#X#H $ $ $ $    H###$##X##H" +
"H#X#H HHHHHHHH  $HHH#$0$$0#H" +
"H#HHH H#X#XXXH   $ H#####$##" +
"H##HH H#SS$$XHHHHH HHHHH#$$0" +
"X##H$ H#$SS#X#XX#H $ $ H#X##" +
"HHHHH H#SS$#XS$$#HHHHH HHHHH" +
"H###H H###X#XSS##X#X#H  $$$S" +
"H$$#H HHHHH#$$$##$SS#H $HHHH" +
"HHH#H$    H#X####SS$#H  $HXX" +
"HXH#H     HHHHH#$$$$#H  $HXH" +
"HXH#####H$    H####X#H HHHXH" +
"HXHHHHH#H     HHHHHHHH H#XXH" +
"HX##X#H#X###H$  $   $ $H#HHH" +
"HHHH$#HHHH###HHHH   HHHH#H#X" +
"XXXXH###$HHH#XXXH$ $HXXX#H#H",

//======<<< Level 030 >>>======

"##############S#############" +
"#    0 $ 0  &SSS  0 $ 0    #" +
"#S###########   ##########S#" +
" H------------------------H " +
" H           S            H " +
" H           S            H " +
" H           S            H " +
" H           S            H " +
" H           S            H " +
" H           S            H " +
" H           S            H " +
" H           S$           H " +
" H     $      @      $    H " +
" H     @      @      @    H " +
"H      @      @      @  0  H" +
"H#####   #### @ ####   ####H",

//======<<< Level 031 >>>======

" SS---S---S---S---S---S---SS" +
" H##X###X###X###X###X###X##H" +
" H#---#   #-- # --#   #---#H" +
" H#X#X#X#X#X#X#X#####X#X#X#H" +
" H#    #---#   #   X---#  #H" +
" H##X#X#X#X#X#X#X###X#X#X##H" +
" H#   #   #---#---#   #   #H" +
" H#X#X#X###X#X#X#X#X#X#X#X#H" +
" H#  X  H#---#---#   #    #H" +
" H##XXX#X#X#X#X#X#####X#X##H" +
" H#   #---#   X   #H--#   #H" +
" H#X#X#X#X#X#XX######X#X#X#H" +
" H#--- #   #   #H  #   #--#H" +
" H##X#X#X#X#XXXXX#X#X#X#X##H" +
" H&00         $         000H" +
" ############S S############",

//======<<< Level 032 >>>======

" S            &           S " +
" H H##########@@@@@@@@@@@ H " +
" H H#                   H H " +
" H H@$#H#       $ 0  $H#H H " +
" H H@@@@@@@@@@@@@@@@@@##H H " +
" H  H#              ---H  H " +
" H  H#$ 0 0 0   $#H# $#H  H " +
" H  H#######@@@@@@@@@@#H  H " +
" H---H---            #    H " +
" H   H#$ #H#    $$   @H   H " +
" H   H######@@@@@@@@@@H   H " +
" H    H@                  H " +
" H    H@$0 #H#H $$  #H    H " +
" H    H@#@@@@@@@@@@@#H    H " +
" H                        H " +
" H                        H ",

//======<<< Level 033 >>>======

"-------------H$-------------" +
" $ $0$       $H       $&$ $ " +
"########     H$     ########" +
"##     ##    $H    ##     ##" +
"#S#    # #   H$   # #    #S#" +
"#SS#   #  #  $H  #  #   #SS#" +
"#SSS#0 #   # H$ #   # 0#SSS#" +
"#SSSSXX###X##$H##X###XXSSSS#" +
"#SSSSX #    #H$#    # XSSSS#" +
"#####X##$   #$H#   $##X#####" +
" #HHHXHH#$  #H$#  $#HHXHHH# " +
"  #HHXHHH#$ #$H# $#HHHXHH#  " +
"H  #HXHHHHX$#H$#$XHHHHXH#  H" +
"HH  #XHHHHHX#$H#XHHHHHX#  HH" +
"  H  XX####X#H$#X####XX  H  " +
"##HH         $H         HH##",

//======<<< Level 034 >>>======

" S  -            0          " +
"@S H  #H          @--------X" +
" H@H#@@@@##@H###@H H       H" +
"H@@@H - @ $ @H##@H  @   @  H" +
"H@$  H$ $@H0-HH#@H--$   $-@H" +
"H@@H H H@@H  @@H@H  @ $-@  H" +
"H$@H H @$ H  $@H@H--$ @ $-@H" +
"H@$H-H@@H H $H@H@H  @-$ @  H" +
"H$@H @$ H H XH H@H--$ @ $-@H" +
"H@$H@@H H H @$@H@H  @ $-@  H" +
"H@@@$ H H H $X$H@H--$ @ $-@H" +
"H$@@H H H H H@@@ H  @-$ @  H" +
"@@$ H H H H H@  #H--$ @ $-@H" +
"@ H H H H H H #H@H  @   @  H" +
"$@H@H@H@H@H @@@ &H@S    00 H" +
"H H H H H H    #H@@@####@@#@",

//======<<< Level 035 >>>======

"S                          S" +
"S  $  0 $       $    $  0 $S" +
"@@@@@@@@@@#H  H#@@@@@@@@@@@@" +
"           H  H             " +
"           H##H             " +
"$  0$    $ H  H      $  0 $ " +
"#@#@#@#@#@#@HH@#@#@#@#@#@#@#" +
"            HH              " +
"------    $ HH   $  --------" +
"      H@@@@@@@@@@@@H        " +
"      H            H        " +
" $ 0  H $     $    H   $0 $ " +
"@@@@X#######HH#######X@@@@@@" +
"            HH              " +
"            HH              " +
" $    &$    HH     $      $ ",

//======<<< Level 036 >>>======

"  SSSSSSSSSSSSSSSSSSSSSSSSS " +
"  S  0      -----     &   S " +
"  S#########  H  #########S " +
"  SSH-H-H-H #HHH# H-H-H-HSS " +
"  #-H-H-H-H-#H H#-H-H-H-H-# " +
"  #-H$H H$H-#HHH#-H$H H$H-# " +
"   ######### HHH #########  " +
"             H H            " +
"             HHH     ###    " +
"             HHH    #--H $  " +
"H# -----$    H H   # $ H### " +
"H@$ --- #    HHH-- @ # H--  " +
"H#@#$- #H#@#@#H#  #    H    " +
"H  #@#@#H   0 H #@#@#@#@# $@" +
"@H      @# #@#H#H   $   $ #@" +
"#@#@H$#H      $ H#@#@#@#@#@#",

//======<<< Level 037 >>>======

"                          S " +
"     H------------------HS  " +
"     H- - - - - - - -###H   " +
"     H # # # # # #   # # H  " +
"   H###############  ###  H " +
"   H# #### # ### # X#### H  " +
"   H###############X####H   " +
" 0 H### ##### #####X#### H  " +
"H########## #### $ X####  H " +
"H##-############X##X####   H" +
"H####  $### ####X##X####  H " +
"H#   H##### ###-X#-X#-## H  " +
"HX###HX####$ ##X##XX####H   " +
"HX#-###--####--X##X--### H  " +
"HX####----##----##----##  H " +
"H   HH  0 HH  $ HH $  HH & H",

//======<<< Level 038 >>>======

"&HHHH#### H###H-----####HHHH" +
"H###H-----H###H#### ####H##H" +
"H### ##X#0H###H####-----H##H" +
"H $0$0 $0$H $ H$ $  $$  $  H" +
"### @@X# #HX#H##H# X#X# #XH#" +
"###  $X# #HX#H##H# $#X# ##H#" +
"#X# ##X# #HHHH##H# X#X# H HH" +
"$$ $---------  $H $ $   $ $ " +
"## XH##0#X## #X#H #X#H ##XX " +
"## XH## #X#$-HHHH #$#H------" +
"## XH## #X## ###H #X#H #### " +
"$ $ H   $ $  $$ H $$ H  $$ $" +
"#HXH#XHX### ####HX##XH#### #" +
"#HXH##HX### ####HX##XH#### #" +
"#HHHHHHX### ####HX##XH#### #" +
"$H$$$$$$$$$$$$$$H$$$$H$$$$$$",

//======<<< Level 039 >>>======

" 0         --          &    " +
"   H#######   ######H       " +
"   H#######   ######H-H- SS " +
"   H    ###   ###   0 H S  S" +
"H--H    ###   ###     H S  S" +
"H  H   ###     ###    H  SS " +
"H  0  ###       ###   H     " +
"H    ### $$   $$ ###  H S S " +
"H    ### ##   ## ###  H SS  " +
"H    ###         ###  H S SS" +
"H    ###  #####  ###  H     " +
"H    ###  #####  ###  H#@##H" +
"H     ##   ###   ###  # $ #H" +
"#####H###  $#$  ###---# # #H" +
"# $ #H ###########----## ##H" +
"# # #H   ##   ##           H",

//======<<< Level 040 >>>======

"                            " +
"H----                       " +
"H &0 H###H  ---------  H###H" +
"H   #H#####H  -----  H#####H" +
"H  ##H#H###H##     ##H###H#H" +
"H  ##H#H###H## ### ##H###H#H" +
"H   #H###H####  H  ####H###H" +
"H    H###H#### #H# ####H###H" +
"H   #H#H###H## #H# ##H###H#H" +
"H  ##H#H###H## #H# ##H###H#H" +
"H  ##H###H#### #H# ####H###H" +
"H   #H###H#### #H# ####H###H" +
"H    H H###H## #H# ##H###H#H" +
"#H  H##H###H   #H#   H###H#H" +
"##HH##### $   ##H##   $ ###H" +
"#########################  H",

//======<<< Level 041 >>>======

"         0    S           #S" +
"##   H###     S  # #S######S" +
"   ##H    #S###### ###    #S" +
"     H  # #####  #     H# #S" +
" #S######        #######  #S" +
" ###    #######       0  ##S" +
"                #  ####### S" +
"#### ##   &  ####H #       S" +
"       H####     H     H###S" +
" H##   H   $ ####H H#### $ S" +
"#H   ### H###      $    H#XS" +
" H  $    H     $ H###   H   " +
" ######H## ##### H    ####H " +
" $   0 H     $   H        H " +
"### ######H ###  ####H  H###" +
"          H          H  H   ",

//======<<< Level 042 >>>======

"     ----        SS0        " +
"    H    #######S  S######  " +
"  H##### #     #S  S#    #  " +
"  H#   #####   #&SS # H#####" +
"H#H### #   #H  ###H## H# # #" +
"H#   # #   #H   # H   H### #" +
"H#  $# # #H#######H   H#   #" +
"H# ##### #H      ###H# #####" +
"H# # # # ###  #H##  H####H  " +
"H##### ### H#####   H#  #H  " +
"H  #     #$H # #######H #H$ " +
"H  #  ###### # # 0 # $H#### " +
"#H###H# 0# # # #   #  H# 0# " +
"#H  #H# $##### #   #####  # " +
"#H  #H######   #####   #X## " +
"#####H            #     X   ",

//======<<< Level 043 >>>======

"   ###H###        ###H###   " +
" ###  H     ####     H  ### " +
" #    H######  ######H    # " +
" ##S####            ####S## " +
"  #S     H###  ###H     S#  " +
"X #S#####H        H#####S# X" +
"X@@S@@@@@@@@H  H@@@@@@@@S@@X" +
"X  S   $ #  H  H  # $   S  X" +
"X@@S@@@@@@H@ -- @H@@@@@@S@@X" +
"   S      H #  # H      S   " +
"0# S #H & H##  ##H 0 H# S #0" +
" #####H####H#  #H####H##### " +
"0    #H##$ H#$$#H $##H#    0" +
"##  ##H #--H#$$#H--# H##  ##" +
"###   H  ##########  H   ###" +
"########H          H########",

//======<<< Level 044 >>>======

"                  &        S" +
" ##H#H#######H#########H###S" +
"   H #H#     H #H#     H # S" +
" ##H##H## #H####H##S#######S" +
"  H S H     H   H  H     H S" +
"  #H  H#  ##H  #H# #H  # H- " +
" # H  H  - #H  ###  #H###H  " +
" #H# #H##$#H#H     # H   #H " +
"  H#  #H#-H# H-#H#   H #H#H " +
"  H    H####0## H ####  H#H " +
" #H - #H#-  #  #H     - H#H " +
" #H  # H#### H# H H#$## H#H " +
"  H  H#H---## #H  HH#---H#H " +
" ##H H  H    #H# # H#####HH " +
"   ###H- H----H---##-----H  " +
"            0               ",

//======<<< Level 045 >>>======

"#############               " +
"#& #  # $   # H   ----------" +
"#  #$   H# $#-H   H         " +
"#####H#######0H  SH ####### " +
"#  #$H#  #$ # H S H $###$## " +
"#$ # H#$    #-HS  H #$####$ " +
"## ##H#######     H $###$## " +
"# $# H# $#H #     H #$####$ " +
"#   $H#  #$ #     H $###$## " +
"#####H#######     H #$####$ " +
"#--# H#--#  #     H         " +
"#--# H#--# 0#     H#########" +
"#############     H#  H#  $#" +
"#H #     #        H#########" +
"#H0   # $  H#     H#   #H $#" +
"############################",

//======<<< Level 046 >>>======

"       0S     S0            " +
"@@ @@  @S  &  S@@  @  @@@@@ " +
"@ @ @  @ S H S @ @ @  @@@   " +
"@   @  @  SHS  @  @@  @@@@@ " +
"#####X###@#H########## 0##  " +
"H-         H -  - $-$$#H###H" +
"H  $#####$#H#$H# H# H##H  #H" +
"H $$#####$#H#@@@XX#H#X#$###H" +
"H$$$#####$#H $    @@ $   $ H" +
"H#$######$#HX@@#X######@@##H" +
"H  @@X$X@@@H@ $XX# $#@ $@@@H" +
"##H@@$$$@@@H#H###@#########H" +
"# H@$$$$$@@H@$       $   $#H" +
"#H#########H@@@@@@ #####@@#H" +
"#H $ $ $ $ H #####H#$     $H" +
"############@ ####H0#H#S####",

//======<<< Level 047 >>>======

"H - 0  0  0  0   -  -  - &-H" +
"H# ##$##$##$##$## ## ## ## H" +
"H## ## ## ## ## ## ## ## ##H" +
"H ## ## ## ## ## ## ## ## #H" +
"H# ## ## ## ## ## ## ## ## H" +
"H## ## ## ## ## ## ## ## ##H" +
"H ## ## ## ## ## ## ## ## #H" +
"H# ## ## ## ## ## ## ## ## H" +
"H## ## ## ## ## ## ## ## ##H" +
"H ## ## ## ## ## ## ## ## #H" +
"H# ## ## ## ## ## ## ## ## H" +
"H## ## ## ## ## ## ## ## ##H" +
"H ##$##$##$##$##$##$##$##$#H" +
"H# ## ## ## ## ## ## ## ## H" +
"H                          H" +
"############################",

//======<<< Level 048 >>>======

"         S        S         " +
"         S        S         " +
"    #    S        S    #    " +
"    #@@X#H#X@@@@X#H#X@@#    " +
"    #$$X#H#X    X#H#X$$#    " +
"    ### @H# #### #H@ ###    " +
"       @@H@@    @@H@@       " +
"   #@@X@HH@      @HH@X@@#   " +
"   #$$X@H##@X@@X@##H@X$$#   " +
"   ### @H#$$X@@X$$#H@ ###   " +
"      @@H### @@ ###H@@      " +
"  #@@X@HH   @@@@   HH@X@@#  " +
"  #$$X@H            H@X$$#  " +
"  ### @H            H@ ###  " +
"  00 @HH  &       00HH@ 0   " +
"####H H##############H H####",

//======<<< Level 049 >>>======

"##S                     S###" +
"#####S0     &       0S######" +
"#########SH#####HS##########" +
"     $    HX   XH     $     " +
"   H##    H##$##H    ##H    " +
"H####  H# H#####H #H  #####H" +
"H     H##S#######S##H      H" +
"H  0 HX #S#  X$ #SX #H  0  H" +
"H######$#S#$### #S#$#######H" +
"H     #X#S#####X#S#X#      H" +
"X#H      S       S      H###" +
"X####H# S#########S #H###XX#" +
"X$  #H##SH# $#$ #HS##H  # $#" +
"##$  H ##H# X#X #H## H #  ##" +
"###  H   H#######H   H#     " +
"#####H###H       H###H######",

//======<<< Level 050 >>>======

"&      --    -- ---- # $0$ $" +
"0#H  H@  $ @H#$#$#   #H#X# H" +
"@#####@H# ##H# # ####HH##  H" +
"@#####@H # #H#-- #$##H ##- H" +
"        H   H########H  $  H" +
"H######XH   H--# #$##  ## ##" +
"H#  #H #H# $# H#$ ###@@  ###" +
"H#$ # $#H## # H###$H       $" +
"H ##### H  #  H#$##H- $ #H##" +
"H# H#  #H  #0#H###$H ## $H#$" +
"H#$ # $XH   ##H#$#  H#$H# # " +
"H ##### H    #H#  0#H#HH####" +
"H#  #  #H    -H $ #HH ##   $" +
" #$ # $#H   H $ # #H     H##" +
"$#######H   H # #@HH H## H#$" +
"        H#  # #@  H  H##$H# ",

//======<<< Level 051 >>>======
	
"& #0000#    $    $          " +
"# #----#H##########S#####   " +
"  #    #H#    -    S  -  -  " +
"  $    #H#H###S####$## ## ##" +
"###    #H#H#$#S#####$## ## #" +
"HH     #H#H# #S    ##$## ## " +
"HH     HH#H###S     ##$## ##" +
"HH        H#  S      ##$## #" +
"###    ###H#  S       ##$## " +
"@@@@@@@@@@##S#######H  ##$##" +
"            S#$H#   H   ## #" +
"$         #HS#  #   H       " +
"#########H####@@########H##H" +
"         H          #    # H" +
"$        H    HXH  $#####$ H" +
"#########################XH#"	

];
