/* Generated by re2c 1.2.1 on Wed Apr  1 00:57:32 2020 */
#line 1 "src/net/URL.re"
/*
 * Copyright (C) Tildeslash Ltd. All rights reserved.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 *
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.
 */


#include "Config.h"

#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>

#include "URL.h"


/**
 * Implementation of the URL interface. The scanner handle 
 * ISO Latin 1 or UTF-8 encoded url's transparently. 
 *
 * @file
 */


/* ----------------------------------------------------------- Definitions */


typedef struct param_t {
        char *name;
        char *value;
        struct param_t *next;
} *param_t;

#define T URL_T
struct URL_S {
        int ip6;
	int port;
       	char *ref;
	char *path;
	char *host;
	char *user;
        char *qptr;
	char *query;
	char *portStr;
	char *protocol;
	char *password;
	char *toString;
        param_t params;
        char **paramNames;
	uchar_t *data;
	uchar_t *buffer;
	uchar_t *marker, *ctx, *limit, *token;
        /* Keep the above align with zild URL_T */
};

/* Unsafe URL characters: [00-1F, 7F-FF] <>\"#%}{|\\^[] ` */
static const uchar_t urlunsafe[256] = {
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
	1, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 
	1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
};

#define UNKNOWN_PORT -1
#define YYCURSOR     U->buffer
#define YYLIMIT      U->limit
#define YYTOKEN      U->token
#define SET_PROTOCOL(PORT) *(YYCURSOR-3)=0; U->protocol=U->token; U->port=PORT; goto authority


/* ------------------------------------------------------- Private methods */


static bool _parseURL(T U) {
        param_t param = NULL;
	#line 127 "src/net/URL.re"

proto:
	if (YYCURSOR >= YYLIMIT)
		return false;
	YYTOKEN = YYCURSOR;
	
#line 118 "<stdout>"
{
	unsigned char yych;
	static const unsigned char yybm[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128,   0,   0,   0,   0,   0,   0, 
		  0, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128,   0,   0,   0,   0,   0, 
		  0, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
	};
	yych = *U->buffer;
	if (yych <= '@') {
		if (yych <= '\r') {
			if (yych <= 0x08) goto yy2;
			if (yych <= '\n') goto yy4;
			if (yych >= '\r') goto yy4;
		} else {
			if (yych <= ' ') {
				if (yych >= ' ') goto yy4;
			} else {
				if (yych <= '/') goto yy2;
				if (yych <= '9') goto yy6;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy6;
			if (yych <= '`') goto yy2;
			if (yych <= 'l') goto yy6;
			goto yy7;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy6;
				goto yy8;
			} else {
				if (yych <= 'p') goto yy9;
				if (yych <= 'z') goto yy6;
			}
		}
	}
yy2:
	++U->buffer;
yy3:
#line 154 "src/net/URL.re"
	{
                goto proto;
         }
#line 192 "<stdout>"
yy4:
	++U->buffer;
#line 134 "src/net/URL.re"
	{
                goto proto;
         }
#line 199 "<stdout>"
yy6:
	yych = *(U->marker = ++U->buffer);
	if (yych <= '@') {
		if (yych <= '/') goto yy3;
		if (yych <= ':') goto yy11;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy11;
		if (yych <= '`') goto yy3;
		if (yych <= 'z') goto yy11;
		goto yy3;
	}
yy7:
	yych = *(U->marker = ++U->buffer);
	if (yych <= 'Z') {
		if (yych <= '/') goto yy3;
		if (yych <= ':') goto yy11;
		if (yych <= '@') goto yy3;
		goto yy11;
	} else {
		if (yych <= 'x') {
			if (yych <= '`') goto yy3;
			goto yy11;
		} else {
			if (yych <= 'y') goto yy14;
			if (yych <= 'z') goto yy11;
			goto yy3;
		}
	}
yy8:
	yych = *(U->marker = ++U->buffer);
	if (yych <= 'Z') {
		if (yych <= '/') goto yy3;
		if (yych <= ':') goto yy11;
		if (yych <= '@') goto yy3;
		goto yy11;
	} else {
		if (yych <= 'q') {
			if (yych <= '`') goto yy3;
			goto yy11;
		} else {
			if (yych <= 'r') goto yy15;
			if (yych <= 'z') goto yy11;
			goto yy3;
		}
	}
yy9:
	yych = *(U->marker = ++U->buffer);
	if (yych <= 'Z') {
		if (yych <= '/') goto yy3;
		if (yych <= ':') goto yy11;
		if (yych <= '@') goto yy3;
		goto yy11;
	} else {
		if (yych <= 'n') {
			if (yych <= '`') goto yy3;
			goto yy11;
		} else {
			if (yych <= 'o') goto yy16;
			if (yych <= 'z') goto yy11;
			goto yy3;
		}
	}
yy10:
	yych = *++U->buffer;
yy11:
	if (yybm[0+yych] & 128) {
		goto yy10;
	}
	if (yych <= '/') goto yy12;
	if (yych <= ':') goto yy13;
yy12:
	U->buffer = U->marker;
	goto yy3;
yy13:
	yych = *++U->buffer;
	if (yych == '/') goto yy17;
	goto yy12;
yy14:
	yych = *++U->buffer;
	if (yych == 's') goto yy18;
	goto yy11;
yy15:
	yych = *++U->buffer;
	if (yych == 'a') goto yy19;
	goto yy11;
yy16:
	yych = *++U->buffer;
	if (yych == 's') goto yy20;
	goto yy11;
yy17:
	yych = *++U->buffer;
	if (yych == '/') goto yy21;
	goto yy12;
yy18:
	yych = *++U->buffer;
	if (yych == 'q') goto yy23;
	goto yy11;
yy19:
	yych = *++U->buffer;
	if (yych == 'c') goto yy24;
	goto yy11;
yy20:
	yych = *++U->buffer;
	if (yych == 't') goto yy25;
	goto yy11;
yy21:
	++U->buffer;
#line 150 "src/net/URL.re"
	{
                SET_PROTOCOL(UNKNOWN_PORT);
         }
#line 312 "<stdout>"
yy23:
	yych = *++U->buffer;
	if (yych == 'l') goto yy26;
	goto yy11;
yy24:
	yych = *++U->buffer;
	if (yych == 'l') goto yy27;
	goto yy11;
yy25:
	yych = *++U->buffer;
	if (yych == 'g') goto yy28;
	goto yy11;
yy26:
	yych = *++U->buffer;
	if (yych == ':') goto yy29;
	goto yy11;
yy27:
	yych = *++U->buffer;
	if (yych == 'e') goto yy30;
	goto yy11;
yy28:
	yych = *++U->buffer;
	if (yych == 'r') goto yy31;
	goto yy11;
yy29:
	yych = *++U->buffer;
	if (yych == '/') goto yy32;
	goto yy12;
yy30:
	yych = *++U->buffer;
	if (yych == ':') goto yy33;
	goto yy11;
yy31:
	yych = *++U->buffer;
	if (yych == 'e') goto yy34;
	goto yy11;
yy32:
	yych = *++U->buffer;
	if (yych == '/') goto yy35;
	goto yy12;
yy33:
	yych = *++U->buffer;
	if (yych == '/') goto yy37;
	goto yy12;
yy34:
	yych = *++U->buffer;
	if (yych == 's') goto yy38;
	goto yy11;
yy35:
	++U->buffer;
#line 138 "src/net/URL.re"
	{
                SET_PROTOCOL(MYSQL_DEFAULT_PORT);
         }
#line 367 "<stdout>"
yy37:
	yych = *++U->buffer;
	if (yych == '/') goto yy39;
	goto yy12;
yy38:
	yych = *++U->buffer;
	if (yych == 'q') goto yy41;
	goto yy11;
yy39:
	++U->buffer;
#line 146 "src/net/URL.re"
	{
                SET_PROTOCOL(ORACLE_DEFAULT_PORT);
         }
#line 382 "<stdout>"
yy41:
	yych = *++U->buffer;
	if (yych != 'l') goto yy11;
	yych = *++U->buffer;
	if (yych != ':') goto yy11;
	yych = *++U->buffer;
	if (yych != '/') goto yy12;
	yych = *++U->buffer;
	if (yych != '/') goto yy12;
	++U->buffer;
#line 142 "src/net/URL.re"
	{
                SET_PROTOCOL(POSTGRESQL_DEFAULT_PORT);
         }
#line 397 "<stdout>"
}
#line 157 "src/net/URL.re"

authority:
	if (YYCURSOR >= YYLIMIT)
		return true;
	YYTOKEN = YYCURSOR;
	
#line 406 "<stdout>"
{
	unsigned char yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		 16,  56,  56,  16,  56, 184,  56,  56, 
		 56,  56,  56,  56,  56,  60,  56,  56, 
		252, 252, 252, 252, 252, 252, 252, 252, 
		252, 252, 184,  16,  56,  56,  56,  16, 
		 32, 188, 188, 188, 188, 188, 188, 188, 
		188, 188, 188, 188, 188, 188, 188, 188, 
		188, 188, 188, 188, 188, 188, 188, 188, 
		188, 188, 188,  32,  56,  32,  56,  56, 
		 56, 188, 188, 188, 188, 188, 188, 188, 
		188, 188, 188, 188, 188, 188, 188, 188, 
		188, 188, 188, 188, 188, 188, 188, 188, 
		188, 188, 188,  56,  56,  56,  56,  56, 
		 56,  56,  56,  56,  56,  56,  56,  56, 
		 56,  56,  56,  56,  56,  56,  56,  56, 
		 56,  56,  56,  56,  56,  56,  56,  56, 
		 56,  56,  56,  56,  56,  56,  56,  56, 
		 56,  56,  56,  56,  56,  56,  56,  56, 
		 56,  56,  56,  56,  56,  56,  56,  56, 
		 56,  56,  56,  56,  56,  56,  56,  56, 
		 56,  56,  56,  56,  56,  56,  56,  56, 
		 56,  56,  56,  56,  56,  56,  56,  56, 
		 56,  56,  56,  56,  56,  56,  56,  56, 
		 56,  56,  56,  56,  56,  56,  56,  56, 
		 56,  56,  56,  56,  56,  56,  56,  56, 
		 56,  56,  56,  56,  56,  56,  56,  56, 
		 56,  56,  56,  56,  56,  56,  56,  56, 
		 56,  56,  56,  56,  56,  56,  56,  56, 
		 56,  56,  56,  56,  56,  56,  56,  56, 
	};
	yych = *U->buffer;
	if (yybm[0+yych] & 4) {
		goto yy55;
	}
	if (yych <= '.') {
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy49;
			if (yych <= '\n') goto yy51;
		} else {
			if (yych <= '\r') goto yy51;
			if (yych <= 0x1F) goto yy49;
			if (yych <= ' ') goto yy53;
			goto yy54;
		}
	} else {
		if (yych <= '@') {
			if (yych <= '/') goto yy58;
			if (yych <= ':') goto yy61;
			if (yych <= '?') goto yy54;
		} else {
			if (yych <= '[') goto yy62;
			if (yych != ']') goto yy54;
		}
	}
yy49:
	++U->buffer;
yy50:
#line 209 "src/net/URL.re"
	{
                return true;
         }
#line 475 "<stdout>"
yy51:
	++U->buffer;
yy52:
#line 164 "src/net/URL.re"
	{
                goto authority;
         }
#line 483 "<stdout>"
yy53:
	yyaccept = 0;
	yych = *(U->marker = ++U->buffer);
	if (yych <= '[') {
		if (yych <= 0x1F) goto yy52;
		if (yych <= 'Z') goto yy64;
		goto yy52;
	} else {
		if (yych == ']') goto yy52;
		goto yy64;
	}
yy54:
	yyaccept = 1;
	yych = *(U->marker = ++U->buffer);
	if (yych <= '[') {
		if (yych <= 0x1F) goto yy50;
		if (yych <= 'Z') goto yy64;
		goto yy50;
	} else {
		if (yych == ']') goto yy50;
		goto yy64;
	}
yy55:
	yyaccept = 2;
	yych = *(U->marker = ++U->buffer);
	if (yybm[0+yych] & 4) {
		goto yy55;
	}
	if (yych <= '?') {
		if (yych <= 0x1F) goto yy57;
		if (yych <= ',') goto yy63;
		if (yych <= '.') goto yy68;
		goto yy63;
	} else {
		if (yych <= '[') {
			if (yych <= '@') goto yy66;
		} else {
			if (yych != ']') goto yy63;
		}
	}
yy57:
#line 186 "src/net/URL.re"
	{
                U->host = Str_ndup(YYTOKEN, (int)(YYCURSOR - YYTOKEN));
                goto authority;
         }
#line 530 "<stdout>"
yy58:
	yyaccept = 3;
	yych = *(U->marker = ++U->buffer);
	if (yybm[0+yych] & 8) {
		goto yy58;
	}
	if (yych <= 0x1F) goto yy60;
	if (yych <= ';') goto yy63;
	if (yych <= '?') goto yy69;
	if (yych <= '@') goto yy71;
	goto yy72;
yy60:
#line 197 "src/net/URL.re"
	{
                *YYCURSOR = 0;
                U->path = URL_unescape(YYTOKEN);
                return true;
         }
#line 549 "<stdout>"
yy61:
	yyaccept = 1;
	yych = *(U->marker = ++U->buffer);
	if (yybm[0+yych] & 64) {
		goto yy74;
	}
	if (yych <= '[') {
		if (yych <= 0x1F) goto yy50;
		if (yych <= 'Z') goto yy64;
		goto yy50;
	} else {
		if (yych == ']') goto yy50;
		goto yy64;
	}
yy62:
	yyaccept = 1;
	yych = *(U->marker = ++U->buffer);
	if (yybm[0+yych] & 128) {
		goto yy77;
	}
	goto yy50;
yy63:
	yych = *++U->buffer;
yy64:
	if (yybm[0+yych] & 16) {
		goto yy63;
	}
	if (yych <= 0x1F) goto yy65;
	if (yych <= '@') goto yy66;
yy65:
	U->buffer = U->marker;
	if (yyaccept <= 2) {
		if (yyaccept <= 1) {
			if (yyaccept == 0) {
				goto yy52;
			} else {
				goto yy50;
			}
		} else {
			goto yy57;
		}
	} else {
		if (yyaccept <= 4) {
			if (yyaccept == 3) {
				goto yy60;
			} else {
				goto yy70;
			}
		} else {
			goto yy76;
		}
	}
yy66:
	++U->buffer;
yy67:
#line 168 "src/net/URL.re"
	{
                *(YYCURSOR - 1) = 0;
                U->user = YYTOKEN;
                char *p = strchr(U->user, ':');
                if (p) {
                        *(p++) = 0;
                        U->password = URL_unescape(p);
                }
                URL_unescape(U->user);
                goto authority;
         }
#line 617 "<stdout>"
yy68:
	yych = *++U->buffer;
	if (yybm[0+yych] & 4) {
		goto yy55;
	}
	if (yych <= '@') {
		if (yych <= 0x1F) goto yy65;
		if (yych <= '?') goto yy63;
		goto yy66;
	} else {
		if (yych == '\\') goto yy63;
		if (yych <= ']') goto yy65;
		goto yy63;
	}
yy69:
	yyaccept = 4;
	yych = *(U->marker = ++U->buffer);
	if (yych <= '[') {
		if (yych <= 0x1F) goto yy70;
		if (yych <= 'Z') goto yy64;
	} else {
		if (yych != ']') goto yy64;
	}
yy70:
#line 203 "src/net/URL.re"
	{
                *(YYCURSOR-1) = 0;
                U->path = URL_unescape(YYTOKEN);
                goto query;
         }
#line 648 "<stdout>"
yy71:
	yych = *++U->buffer;
	if (yych <= '#') {
		if (yych <= ' ') goto yy67;
		if (yych <= '"') goto yy73;
		goto yy67;
	} else {
		if (yych == ';') goto yy67;
		goto yy73;
	}
yy72:
	yych = *++U->buffer;
yy73:
	if (yybm[0+yych] & 32) {
		goto yy72;
	}
	if (yych <= ';') goto yy60;
	goto yy79;
yy74:
	yyaccept = 5;
	yych = *(U->marker = ++U->buffer);
	if (yybm[0+yych] & 64) {
		goto yy74;
	}
	if (yych <= 'Z') {
		if (yych <= 0x1F) goto yy76;
		if (yych == '@') goto yy66;
		goto yy63;
	} else {
		if (yych == '\\') goto yy63;
		if (yych >= '^') goto yy63;
	}
yy76:
#line 191 "src/net/URL.re"
	{
                U->portStr = YYTOKEN + 1; // read past ':'
                U->port = Str_parseInt(U->portStr);
                goto authority;
         }
#line 688 "<stdout>"
yy77:
	yych = *++U->buffer;
	if (yybm[0+yych] & 128) {
		goto yy77;
	}
	if (yych == ']') goto yy80;
	goto yy65;
yy79:
	++U->buffer;
	goto yy70;
yy80:
	++U->buffer;
#line 180 "src/net/URL.re"
	{
                U->ip6 = true;
                U->host = Str_ndup(YYTOKEN + 1, (int)(YYCURSOR - YYTOKEN - 2));
                goto authority;
         }
#line 707 "<stdout>"
}
#line 212 "src/net/URL.re"

query:
        if (YYCURSOR >= YYLIMIT)
		return true;
	YYTOKEN =  YYCURSOR;
	
#line 716 "<stdout>"
{
	unsigned char yych;
	static const unsigned char yybm[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		128, 128, 128,   0, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
	};
	yych = *U->buffer;
	if (yybm[0+yych] & 128) {
		goto yy86;
	}
	++U->buffer;
#line 226 "src/net/URL.re"
	{
                return true;
         }
#line 762 "<stdout>"
yy86:
	yych = *++U->buffer;
	if (yybm[0+yych] & 128) {
		goto yy86;
	}
#line 219 "src/net/URL.re"
	{
                *YYCURSOR = 0;
                U->query = Str_ndup(YYTOKEN, (int)(YYCURSOR - YYTOKEN));
                YYCURSOR = YYTOKEN; // backtrack to start of query string after terminating it and
                goto params;
         }
#line 775 "<stdout>"
}
#line 229 "src/net/URL.re"

params:
	if (YYCURSOR >= YYLIMIT)
		return true;
	YYTOKEN =  YYCURSOR;
	
#line 784 "<stdout>"
{
	unsigned char yych;
	static const unsigned char yybm[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		 64, 192, 192, 192, 192, 192, 128, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192,  64, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
	};
	yych = *U->buffer;
	if (yych <= ' ') goto yy91;
	if (yych == '=') goto yy94;
	goto yy93;
yy91:
	++U->buffer;
yy92:
#line 254 "src/net/URL.re"
	{
                return true;
         }
#line 832 "<stdout>"
yy93:
	yych = *(U->marker = ++U->buffer);
	if (yych <= ' ') goto yy92;
	goto yy98;
yy94:
	yych = *++U->buffer;
	if (yybm[0+yych] & 64) {
		goto yy94;
	}
	if (yych >= ' ') goto yy102;
yy96:
#line 244 "src/net/URL.re"
	{
                *YYTOKEN++ = 0;
                if (*(YYCURSOR - 1) == '&')
                        *(YYCURSOR - 1) = 0;
                if (! param) // format error
                        return true; 
                param->value = URL_unescape(YYTOKEN);
                goto params;
         }
#line 854 "<stdout>"
yy97:
	yych = *++U->buffer;
yy98:
	if (yybm[0+yych] & 128) {
		goto yy97;
	}
	if (yych >= '!') goto yy100;
	U->buffer = U->marker;
	goto yy92;
yy100:
	++U->buffer;
	U->buffer -= 1;
#line 236 "src/net/URL.re"
	{
                NEW(param);
                param->name = YYTOKEN;
                param->next = U->params;
                U->params = param;
                goto params;
         }
#line 875 "<stdout>"
yy102:
	++U->buffer;
	goto yy96;
}
#line 257 "src/net/URL.re"

        return false;
}


static inline int _x2b(uchar_t *x) {
	register int b;
	b = ((x[0] >= 'A') ? ((x[0] & 0xdf) - 'A')+10 : (x[0] - '0'));
	b *= 16;
	b += (x[1] >= 'A' ? ((x[1] & 0xdf) - 'A')+10 : (x[1] - '0'));
	return b;
}


static inline uchar_t *_b2x(uchar_t b, uchar_t *x) {
        static const char _b2x_table[] = "0123456789ABCDEF";
        *x++ = '%';
        *x++ = _b2x_table[b >> 4];
        *x = _b2x_table[b & 0xf];
        return x;
}


static void _freeParams(param_t p) {
        for (param_t q = NULL; p; p = q) {
                q = p->next;
                FREE(p);
        }
}


static T _ctor(uchar_t *data) {
        T U;
	NEW(U);
	U->data = data;
	YYCURSOR = U->data;
	U->port = UNKNOWN_PORT;
	YYLIMIT = U->data + strlen(U->data);
	if (! _parseURL(U))
                URL_free(&U);
	return U;
}


/* -------------------------------------------------------- Public methods */


T URL_new(const char *url) {
        if (STR_UNDEF(url))
                return NULL;
        Exception_init();
        return _ctor((uchar_t*)Str_dup(url));
}


T URL_create(const char *url, ...) {
        if (STR_UNDEF(url))
                return NULL;
        Exception_init();
	va_list ap;
        va_start(ap, url);
	T U = _ctor((uchar_t*)Str_vcat(url, ap));
  	va_end(ap);
        return U;
}

void URL_free(T *U) {
	assert(U && *U);
        _freeParams((*U)->params);
        FREE((*U)->paramNames);
	FREE((*U)->toString);
	FREE((*U)->query);
	FREE((*U)->data);
	FREE((*U)->host);
	FREE(*U);
}


/* ------------------------------------------------------------ Properties */


const char *URL_getProtocol(T U) {
	assert(U);
	return U->protocol;
}


const char *URL_getUser(T U) {
	assert(U);
	return U->user;
}


const char *URL_getPassword(T U) {
	assert(U);
	return U->password;
}


const char *URL_getHost(T U) {
	assert(U);
	return U->host;
}


int URL_getPort(T U) {
	assert(U);
	return U->port;
}


const char *URL_getPath(T U) {
	assert(U);
	return U->path;
}


const char *URL_getQueryString(T U) {
	assert(U);
	return U->query;
}


const char **URL_getParameterNames(T U) {
        assert(U);
        if (U->params && (U->paramNames == NULL)) {
                param_t p;
                int i = 0, len = 0;
                for (p = U->params; p; p = p->next) len++;
                U->paramNames = ALLOC((len + 1) * sizeof *(U->paramNames));
                for (p = U->params; p; p = p->next)
                        U->paramNames[i++] = p->name;
                U->paramNames[i] = NULL;
        }
	return (const char **)U->paramNames;
}


const char *URL_getParameter(T U, const char *name) {
	assert(U);
        assert(name);
        for (param_t p = U->params; p; p = p->next) {
                if (Str_isByteEqual(p->name, name))
                        return p->value;
        }
        return NULL;
}


/* ---------------------------------------------------------------- Public */


const char *URL_toString(T U) {
	assert(U);
	if (! U->toString) {
                uchar_t port[11] = {};
                if (U->portStr) // port seen in URL
                        snprintf(port, 10, ":%d", U->port);
		U->toString = Str_cat("%s://%s%s%s%s%s%s%s%s%s%s%s",
                                      U->protocol,
                                      U->user ? U->user : "",
                                      U->password ? ":" : "",
                                      U->password ? U->password : "",
                                      U->user ? "@" : "",
                                      U->ip6 ? "[" : "",
                                      U->host ? U->host : "",
                                      U->ip6 ? "]" : "",
                                      port,
                                      U->path ? U->path : "",
                                      U->query ? "?" : "",
                                      U->query ? U->query : ""); 
	}
	return U->toString;
}


/* --------------------------------------------------------- Class methods */


char *URL_unescape(char *url) {
	if (STR_DEF(url)) {
                register int x, y;
                for (x = 0, y = 0; url[y]; x++, y++) {
                        if ((url[x] = url[y]) == '+')
                                url[x] = ' ';
                        else if (url[x] == '%') {
                                if (! (url[y + 1] && url[y + 2]))
                                        break;
                                url[x] = _x2b(url + y + 1);
                                y += 2;
                        }
                }
                url[x] = 0;
        }
	return url;
}


char *URL_escape(const char *url) {
        char *escaped = 0;
        if (url) {
                char *p;
                int i, n;
                for (n = i = 0; url[i]; i++) 
                        if (urlunsafe[(unsigned char)(url[i])]) 
                                n += 2;
                p = escaped = ALLOC(i + n + 1);
                for (; *url; url++, p++) {
                        if (urlunsafe[(unsigned char)(*p = *url)])
                                p = _b2x(*url, p);
                }
                *p = 0;
        }
        return escaped;
}

