#
# Write a pkg-config pc file for given "name" with "decription"
# Arguments:
#   name: a library name (withoud "lib" prefix and "so" suffixes
#   desc: a desription string
#
macro (create_pkgconfig_file name desc)
    set(_pkgfname "${CMAKE_CURRENT_BINARY_DIR}/${name}.pc")
    #message(STATUS "${name}: writing pkgconfig file ${_pkgfname}")

    file(WRITE "${_pkgfname}"
            "# file generated by razor-qt cmake build\n"
            "prefix=${CMAKE_INSTALL_PREFIX}\n"
            "libdir=\${prefix}/lib${LIB_SUFFIX}\n"
            "includedir=\${prefix}/include\n"
            "\n"
            "Name: ${name}\n"
            "Description: ${desc}\n"
            "Version: ${RAZOR_VERSION}\n"
            "Libs: -L\${libdir} -l${name}\n"
            "Cflags: -I\${includedir}\n"
            "\n"
    )

    install(FILES ${_pkgfname} DESTINATION lib${LIB_SUFFIX}/pkgconfig)
endmacro()
