/***************************************\
*                                       *
*   ǤŬȨŜŠ LIBRARY FOR C++               *
*   (c) Copyright Sylvain Saucier 2012  *
*   Licenced under GPL3                 *
*                                       *
\***************************************/

#include "Guess.h"

gu_sig *Guess::sign(string _word)
{
	return sign(&_word);
}

gu_sig *Guess::sign(string *_word)
{
	vchar32* thevec;
	thevec = string_to_vchar32(_word);
	if(thevec->size() < 1)
	{
		for(uint16 x = 0; x < _word->length(); x++)
		{
			thevec->push_back(_word->at(x));
		}
	}
	return sign(thevec);
}

gu_sig *Guess::sign(vchar32 *_word){
//cout << "sign()" << endl;
	gu_sig *newsig;
	newsig = new gu_sig;
	newsig->i64 = 0LLU;
	newsig->i8 = 0;


	uint16 stop = _word->size();
	gu_sig symbol;
	for(uint16 x = 0; x < stop; x++)
	{
		map<char32, gu_sig>::iterator i = alpha->symbols.find(_word->at(x));
		if(i == alpha->symbols.end()) continue;
		symbol = i->second;
//cout << *(char_to_utf8(_word->at(x))) << " : ";
		newsig->i64 |= symbol.i64;
		newsig->i8  |= symbol.i8;
//cout << setfill('0') << setw(2) << hex << (int)newsig->i8 << endl;
	}
	return newsig;
}
