/***************************************\
*                                       *
*   ǤŬȨŜŠ LIBRARY FOR C++               *
*   (c) Copyright Sylvain Saucier 2012  *
*   Licenced under GPL3                 *
*                                       *
\***************************************/

#include "Guess.h"

vector<sig8>* Guess::mask8(uint8 depth, uint8 bit)
{
	vector<sig8>* results = new vector<sig8>;//What is returned to the caller
	vector<sig8>* appends;//What is returned from recursion

	for(uint32 counter = bit, stop = (sizeof(sig8)*8) - max(0, (int)depth - 1), end = (sizeof(sig8)*8); counter < stop; counter++)
	{
		if(depth > 1 && counter < end - 1)//get more masks!!!
		{
			appends = mask8(depth - 1, counter + 1);
			for(uint32 counter2 = 0, stop2 = appends->size(); counter2 < stop2; counter2++)
			{
				results->push_back(1 << counter | appends->at(counter2));
			}
			delete appends;
		}
		else//return a single bitmask
		{
			results->push_back(1 << counter);
		}
	}
	return results;
}
