/***************************************\
*                                       *
*   ǤŬȨŜŠ LIBRARY FOR C++               *
*   (c) Copyright Sylvain Saucier 2012  *
*   Licenced under GPL3                 *
*                                       *
\***************************************/

#include "Guess.h"

inline factor weight(vchar32* needle, vchar32* choice)
{
	uint16 found = 0, ns = needle->size(), cs = choice->size(), minnscs = min(ns, cs), maxnscs = max(ns, cs);
	for(uint16 x = 0;x < minnscs;x++)
		if(needle->at(x) == choice->at(x))
			found++;
	for(uint16 x = 0, stop = minnscs - found;x < stop;x++)
		if(needle->at(ns - x - 1) == choice->at(cs - x - 1))
			found++;
	return (factor)(maxnscs - found);
}

inline void Guess::search_8bits(sig8 needlesig, uint8 depth, set<uint32>* results)
{
	sig8 bitmask;
	multimap<sig8,uint32>::iterator elements;
	pair<multimap<sig8,uint32>::iterator,multimap<sig8,uint32>::iterator> range;
	vector<sig8> *sigs;
	sigs = mask8(depth, 0); //recode using 1<<x iterations, saves memory and possibly cpu cycles
	for(uint32 cursig = 0, stop = sigs->size(); cursig < stop; cursig++)
	{
		bitmask = sigs->at(cursig) ^ needlesig;
		range = voc->words8.equal_range(bitmask);
		if(range.first != range.second)
			for (elements = range.first; elements != range.second; ++elements)
				results->insert(elements->second);
	}
	delete sigs;
}



inline bool enoughResults(set<uint32>* results, gu_param* param)
{
	if(results->size() >= param->minresult) return true;
	else return false;
}

multimap<factor,string>* Guess::find(vchar32* needle)
{
	set<uint32>* results = new set<uint32>;
	multimap<factor,string>* returnresults = new multimap<factor,string>;
	multimap<factor,uint32>* interimresults = new multimap<factor,uint32>;
	gu_sig* needlesig = sign(needle);

	multimap<sig8,uint32>::iterator  element;
	pair<multimap<sig8,uint32>::iterator,multimap<sig8,uint32>::iterator> range = voc->words8.equal_range(needlesig->i8);
	if(range.first != range.second) // If the range contain element(s)...
	{
		for (element = range.first; element != range.second; ++element) //processing each element found
		{
			results->insert(element->second);
		}
	}
	for(	uint8 curdepth8 = 1, maxdepth8 = param->maxdepth;
			!enoughResults(results, param) && curdepth8 <= maxdepth8;
			curdepth8++)
	{
		search_8bits(needlesig->i8, curdepth8, results);
	}
	for(	set<uint32>::iterator i = results->begin(), stop = results->end();
			i != stop;
			i++)
	{
		factor f = (factor)__builtin_popcountll(needlesig->i64 ^ (voc->words[*i]).sig);
		interimresults->insert(pair<factor, uint32>(f, *i));
	}

	uint8 counter = 0;
	for(	multimap<factor,uint32>::iterator i = interimresults->begin(), stop = interimresults->end();
			i != stop;
			i++)
	{
		string* utf8temp = vchar32_to_utf8( (voc->words[i->second]).word );
		factor f = i->first + weight(needle, &(voc->words[i->second]).word);

		returnresults->insert(pair<factor, string>(f, *utf8temp));
		delete utf8temp;

		if(++counter >= param->maxresult)
		{
			break;
		}
	}

	delete results;
	delete interimresults;
	delete needlesig;
	return returnresults;
}
