/***************************************\
*                                       *
*   ǤŬȨŜŠ LIBRARY FOR C++               *
*   (c) Copyright Sylvain Saucier 2012  *
*   Licenced under GPL3                 *
*                                       *
\***************************************/

#include "Guess.h"


vector<sig64> *Guess::extract64(sig64 sig)
{
	return extract64(&sig);
}

vector<sig64> *Guess::extract64(sig64 *sig)
{
	vector<sig64> *a = new vector<sig64>;
	sig64 b = 0ULL;
	uint16 x = 0;
	uint16 y = sizeof(sig64)*8;
	while(x < y)
	{
		b = (1ULL << x) & *sig;
		if(b != 0ULL)
			a->push_back(b);
		x++;
	}
	return a;
}


vector<sig32> *Guess::extract32(sig32 sig)
{
	return extract32(&sig);
}

vector<sig32> *Guess::extract32(sig32 *sig)
{
	vector<sig32> *a = new vector<sig32>;
	sig32 b = 0ULL;
	uint16 x = 0;
	uint16 y = sizeof(sig32)*8;
	while(x < y)
	{
		b = (1ULL << x) & *sig;
		if(b != 0ULL)
			a->push_back(b);
		x++;
	}
	return a;
}


vector<sig16> *Guess::extract16(sig16 sig)
{
	return extract16(&sig);
}

vector<sig16> *Guess::extract16(sig16 *sig)
{
	vector<sig16> *a = new vector<sig16>;
	sig16 b = 0ULL;
	uint16 x = 0;
	uint16 y = sizeof(sig16)*8;
	while(x < y)
	{
		b = (1ULL << x) & *sig;
		if(b != 0ULL)
			a->push_back(b);
		x++;
	}
	return a;
}


vector<sig8> *Guess::extract8(sig8 sig)
{
	return extract8(&sig);
}

vector<sig8> *Guess::extract8(sig8 *sig)
{
	vector<sig8> *a = new vector<sig8>;
	sig8 b = 0ULL;
	uint16 x = 0;
	uint16 y = sizeof(sig8)*8;
	while(x < y)
	{
		b = (1ULL << x) & *sig;
		if(b != 0ULL)
			a->push_back(b);
		x++;
	}
	return a;
}
