/***************************************\
*                                       *
*   ǤŬȨŜŠ LIBRARY FOR C++               *
*   (c) Copyright Sylvain Saucier 2012  *
*   Licenced under GPL3                 *
*                                       *
\***************************************/

#include "Guess.h"

bool Guess::add(string _word)
{
	return add(&_word, false);
}

inline bool Guess::add(string *_word, bool delsrc)
{
	vchar32* thevec;
	thevec = string_to_vchar32(_word);
	if(thevec->size() < 1)
	{
		for(uint16 x = 0; x < _word->length(); x++)
		{
			thevec->push_back(_word->at(x));
		}
	}
	return add(thevec, true);
}

inline bool Guess::add(vchar32* _word, bool delsrc)
{
	uint32 index = voc->words.size();
	gu_word word;
	gu_sig *sig = sign(_word);

	word.word = *_word;
	word.sig = sig->i64;

	voc->words.push_back(word);

	voc->words8.insert (pair<sig8, uint32>(sig->i8,  index));
//	cout << dict.words.find(*sig)->first << " => " << _word->size() << endl;
	delete sig;
	if(delsrc) delete _word;
	return true;
}
