/***************************************\
*                                       *
*   ǤŬȨŜŠ LIBRARY FOR C++               *
*   (c) Copyright Sylvain Saucier 2012  *
*   Licenced under GPL3                 *
*                                       *
\***************************************/

#ifndef GUESS_H_
#define GUESS_H_

#include <iostream>
#include <fstream>
#include <string>
#include <sstream>
#include <algorithm>
#include <cctype>
#include <map>
#include <set>
#include <vector>
#include <utility>
#include <stdint.h>
#include <iomanip>


using namespace std;

#define __GUSIGBITS__ 64 //IF YOU CHANGE THIS VALUE TO 32, CHANGE TYPE OF SIG64 TO UINT32
#define __GUAUTOTEST__ 1 //TODO, MAKE A BUILD OPTION

#define GU_MODE8 = 1
#define GU_MODE16 = 2
#define GU_MODE32 = 3
#define GU_MODE64 = 4

typedef uint64_t uint64;
typedef uint32_t uint32;
typedef uint16_t uint16;
typedef uint8_t  uint8;

typedef int64_t int64;
typedef int32_t int32;
typedef int16_t int16;
typedef int8_t  int8;

typedef uint64 sig64;
typedef uint32 sig32;
typedef uint16 sig16;
typedef uint8  sig8;

typedef uint16 factor;

typedef wchar_t char32;
typedef wstring  string32;

typedef vector<char32> vchar32;
typedef vector<string> vstring;

struct gu_sig
{
	sig64	i64;
	sig8	i8;
};

struct gu_word
{
	sig64	sig;
	vchar32	word;
};

struct gu_alpha
{
	uint8  bitcount;
	map<char32, gu_sig> symbols;
};

struct gu_voc
{
	vector<gu_word> words;
	multimap<sig8,  uint32> words8;
};

struct gu_param {
	uint8 maxdepth;
	uint8 minresult;
	uint8 maxresult;
};

class Guess{

	private:

	gu_alpha* alpha;
	gu_voc* voc;
	gu_param* param;

	gu_sig*	sign	(vchar32*);
	gu_sig*	sign	(string*);
	gu_sig*	sign	(string);

	vector<sig64>	*extract64	(sig64*);
	vector<sig64>	*extract64	(sig64);
	vector<sig32>	*extract32	(sig32*);
	vector<sig32>	*extract32	(sig32);
	vector<sig16>	*extract16	(sig16*);
	vector<sig16>	*extract16	(sig16);
	vector<sig8>	*extract8	(sig8*);
	vector<sig8>	*extract8	(sig8);

	vector<sig8>*  mask8(uint8, uint8);

	void search_8bits(sig8, uint8, set<uint32>*);

	public:

	Guess (string*, uint8, uint8, uint8);
	void setalpha (string*);
	void setparam (uint8, uint8, uint8);
	~Guess ();

	multimap<factor,string> *find(vchar32*);

	bool add(vchar32*, bool);
	bool add(string*, bool);
	bool add(string);

//	void diagnose(void);
//	void bench(void);

	void clearalpha(void);
	void clearvoc(void);

	string	*char_to_utf8			(char32);
	vchar32	*string_to_vchar32	(string*);
	vchar32	*string_to_vchar32	(string);
	string	*vchar32_to_utf8		(vchar32*);
	string	*vchar32_to_utf8		(vchar32);
	vstring	*string_to_vstring	(string*, char);
};

#endif /* GUESS_H_ */
