/***************************************\
*                                       *
*   ǤŬȨŜŠ LIBRARY FOR C++               *
*   (c) Copyright Sylvain Saucier 2012  *
*   Licenced under GPL3                 *
*                                       *
\***************************************/

#include "Guess.h"


Guess::Guess
(
	string*	_path,
	uint8	_maxdepth,
	uint8	_minresult,
	uint8	_maxresult
)
{
//cout << "new alpha" << endl;
	alpha = new gu_alpha;
//cout << "new voc" << endl;
	voc = new gu_voc;
//cout << "new param" << endl;
	param = new gu_param;
//cout << "set param" << endl;
	setparam(_maxdepth, _minresult, _maxresult);
//cout << "set alpha" << endl;
	setalpha(_path);
//cout << "Guess initialized successfully" << endl;
}

Guess::~Guess()
{
	clearvoc();
	clearalpha();

}

void Guess::clearalpha()
{
	alpha->symbols.clear();
}

void Guess::clearvoc()
{
	voc->words.clear();
	voc->words8.clear();
}

void Guess::setparam
(
	uint8	_maxdepth,
	uint8	_minresult,
	uint8	_maxresult
)
{
//cout << "Guess::reset()" << endl;
	param->maxdepth = _maxdepth;
	param->minresult = _minresult;
	param->maxresult = _maxresult;
}

void Guess::setalpha
(
	string*	_path
)
{
//cout << "Guess::reset()" << endl;

	ifstream gas (_path->c_str());
	string* source;

	if (gas.is_open())
	{
//cout << "Using file..." << endl;
		string sourc;
		gas.seekg(0, ios::end);
		sourc.resize(gas.tellg());
		gas.seekg(0, ios::beg);
		gas.read(&sourc[0], sourc.size());
		source = &sourc;
	}
	else
	{
//cout << "Using string..." << endl;
		source = _path;
	}
	gas.close();

	vstring* worker;
//cout << "Converting to vector..." << endl;
	worker = string_to_vstring(source, '\n');

	uint32 charcount;

	gu_sig signature;
	signature.i64 = 1ULL;
	signature.i8 = 1;

	uint8 symbolcount = (worker->size() < __GUSIGBITS__) ? worker->size() : __GUSIGBITS__ ;

	alpha->symbols.clear();
//	voc->words64.clear();
//	voc->words32.clear();
//	voc->words16.clear();
//	voc->words8.clear();

	uint8 curbit64 = 0;

//	alpha->bits8.masks.push_back(signature.i8);
//	alpha->bits16.masks.push_back(signature.i16);
//	alpha->bits32.masks.push_back(signature.i32);
//	alpha->bits64.masks.push_back(signature.i64);

	//cout << "Making dictionnary..." << endl;
	while(true)
	{
//cout << "Processing bit #" << (int) curbit64 << '-' << (int) curbit32 << '-' << (int) curbit16 << '-' << (int) curbit8 << endl;

		charcount = (worker->at(curbit64)).size();
		for(uint32 y = 0; y < charcount; y++)
			alpha->symbols.insert(pair<char32, gu_sig>((worker->at(curbit64)).at(y), signature));

		curbit64++;
		if(curbit64 % 8 == 0)
			signature.i8  <<= 1;

		if(curbit64 >= symbolcount) break;
		signature.i64 <<= 1;

//cout << "  Increment counter... 8" << endl;
	}
}



