#include <gd.h>
#include "gdtest.h"

int main()
{
	gdImagePtr src, dst;
	int w, b;
	void *p;
	int size = 0;
	int status = 0;
	CuTestImageResult result = {0, 0};

	src = gdImageCreate(100, 100);
	if (src == NULL) {
		printf("could not create src\n");
		return 1;
	}
	w = gdImageColorAllocate(src, 0xFF, 0xFF, 0xFF);
	b = gdImageColorAllocate(src, 0, 0, 0);
	gdImageRectangle(src, 20, 20, 79, 79, b);
	gdImageEllipse(src, 70, 25, 30, 20, b);

#define OUTPUT_WBMP(name) do {							\
		FILE *fp;										\
														\
		fp = fopen("wbmp_im2im_" #name ".wbmp", "wb");	\
		if (fp) {										\
			gdImageWBMP(name, 1, fp);					\
			fclose(fp);									\
		}												\
	} while (0)

	OUTPUT_WBMP(src);
	p = gdImageWBMPPtr(src, &size, 1);
	if (p == NULL) {
		status = 1;
		printf("p is null\n");
		goto door0;
	}
	if (size <= 0) {
		status = 1;
		printf("size is non-positive\n");
		goto door1;
	}

	dst = gdImageCreateFromWBMPPtr(size, p);
	if (dst == NULL) {
		status = 1;
		printf("could not create dst\n");
		goto door1;
	}
	OUTPUT_WBMP(dst);
	gdTestImageDiff(src, dst, NULL, &result);
	if (result.pixels_changed > 0) {
		status = 1;
		printf("pixels changed: %d\n", result.pixels_changed);
	}
	gdImageDestroy(dst);
 door1:
	gdFree(p);
 door0:
	gdImageDestroy(src);
	return status;
}
