#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "ccls.h"
#include "ccl_private.h"

extern CCL *ccl;

/* Static functions */
static gboolean _CCL_member_store(gint member);

/* Public interface */
gint
CCL_member_new(const gchar * name)
{
  gchar *cmd = NULL;
  gint id;

  id = CCL_member_find(name);

  if (-1 == id)
    {
      CCL_member *member = g_new0(CCL_member, 1);

      _CCL_member_init(member, name);
      cmd = sqlite3_mprintf("INSERT INTO MEMBERS\n"
			    "(NAME, SDATE, FLAGS) VALUES(%Q, %ld, %d);",
			    name, time(NULL), 0);
      sqlite3_exec(ccl->db, cmd, NULL, NULL, NULL);
      sqlite3_free(cmd);
      id = sqlite3_last_insert_rowid(ccl->db);
      g_datalist_id_set_data_full(&(ccl->members), id, member,
				  _destroy_member);
    }

  return id;
}

gint
CCL_member_get_nth(guint nth)
{
  gchar *cmd = NULL;
  sqlite3_stmt *stmt = NULL;
  gint i;
  gint member = -1;

  cmd = sqlite3_mprintf("SELECT ID FROM MEMBERS ORDER BY ID ASC;");
  sqlite3_prepare(ccl->db, cmd, -1, &stmt, NULL);
  sqlite3_free(cmd);
  for (i = nth; i > 0; i--)
    sqlite3_step(stmt);

  if (sqlite3_step(stmt) == SQLITE_ROW)
    member = sqlite3_column_int(stmt, 0);

  sqlite3_finalize(stmt);
  
  return member;
}

gboolean
CCL_member_exists(gint member)
{
  if (g_datalist_id_get_data(&(ccl->members), member))
    return TRUE;
  else
    return FALSE;
}

gint
CCL_member_find(const gchar * name)
{
  gchar *cmd = NULL;
  sqlite3_stmt *stmt = NULL;
  gint id = -1;
 
  cmd = sqlite3_mprintf("SELECT ID FROM MEMBERS WHERE NAME = %Q;",
			 name);
  sqlite3_prepare(ccl->db, cmd, -1, &stmt, NULL);
  sqlite3_free(cmd);

  if (sqlite3_step(stmt) == SQLITE_ROW)
    id = sqlite3_column_int(stmt, 0);
  
  sqlite3_finalize(stmt);

  return id;
}

const gchar *
CCL_member_name_get(gint member)
{
  CCL_member *m = g_datalist_id_get_data(&(ccl->members), member);

  g_return_val_if_fail(m, NULL);
  
  return m->name;
}

void
CCL_member_name_set(gint member, const gchar * name)
{
  CCL_member *m = g_datalist_id_get_data(&(ccl->members), member);

  g_return_if_fail(m);
  g_return_if_fail(-1 == CCL_member_find(name));
  g_return_if_fail(strlen(name) > 0);

  g_free(m->name);
  m->name = g_strdup(name);
  _CCL_member_store(member);
}

gint
CCL_member_tarif_get(gint member)
{
  CCL_member *m = g_datalist_id_get_data(&(ccl->members), member);

  g_return_val_if_fail(m, 0);
  
  return m->tarif;
}

void
CCL_member_tarif_set(gint member, gint tarif)
{
  CCL_member *m = g_datalist_id_get_data(&(ccl->members), member);

  g_return_if_fail(m && (CCL_tarif_exists(tarif) || 0 == tarif));

  m->tarif = tarif;
  _CCL_member_store(member);
}

const gchar *
CCL_member_phone_get(gint member)
{
  CCL_member *m = g_datalist_id_get_data(&(ccl->members), member);

  g_return_val_if_fail(m, NULL);
  
  return m->phone;
}

void
CCL_member_phone_set(gint member, const gchar * phone)
{
  CCL_member *m = g_datalist_id_get_data(&(ccl->members), member);

  g_return_if_fail(m);

  if (m->phone) g_free(m->phone);
  m->phone = g_strdup(phone);
  _CCL_member_store(member);
}

const gchar *
CCL_member_email_get(gint member)
{
  CCL_member *m = g_datalist_id_get_data(&(ccl->members), member);

  g_return_val_if_fail(m, NULL);

  return m->email;
}

void
CCL_member_email_set(gint member, const gchar * email)
{
  CCL_member *m = g_datalist_id_get_data(&(ccl->members), member);

  g_return_if_fail(m);
      
  if (m->email) g_free(m->email);
  m->email = g_strdup(email);
  _CCL_member_store(member);
}

gpointer
CCL_member_data_set(gint member, gpointer data)
{
  CCL_member *m = g_datalist_id_get_data(&(ccl->members), member);
  gpointer olddata = NULL;

  g_return_val_if_fail(m, NULL);
      
  olddata = m->data; 
  m->data = data;
      
  return olddata;
}

gpointer
CCL_member_data_get(gint member)
{
  CCL_member *m = g_datalist_id_get_data(&(ccl->members), member);

  g_return_val_if_fail(m, NULL);

  return m->data;
}

void
CCL_member_flags_set(gint member, guint flags)
{
  CCL_member *m = g_datalist_id_get_data(&(ccl->members), member);

  g_return_if_fail(m);

  m->flags = flags;
  _CCL_member_store(member);
}

guint
CCL_member_flags_get(gint member)
{
  CCL_member *m = g_datalist_id_get_data(&(ccl->members), member);

  g_return_val_if_fail(m, 0);

  return m->flags;
}

void
CCL_member_flags_toggle(gint member, guint flags, gboolean on)
{
  CCL_member *m = g_datalist_id_get_data(&(ccl->members), member);

  g_return_if_fail(m);
      
  if (on)
    m->flags |= flags;
  else
    m->flags &= ~flags;

  _CCL_member_store(member);
}

gboolean
CCL_member_flags_areset(gint member, guint flags)
{
  CCL_member *m = g_datalist_id_get_data(&(ccl->members), member);

  g_return_val_if_fail(m, FALSE);
  
  return ((m->flags & flags) == flags);
}

/**********************************************************/

gboolean
_CCL_member_restore(gint member)
{
  CCL_member *m = g_datalist_id_get_data(&(ccl->members), member);
  gchar *cmd = NULL;
  sqlite3_stmt *stmt = NULL;

  g_return_val_if_fail(m, FALSE);
      
  cmd = sqlite3_mprintf("SELECT NAME, TARIF, EMAIL, PHONE, FLAGS\n"
			"FROM MEMBERS WHERE ID = %d;", member);
  sqlite3_prepare(ccl->db, cmd, -1, &stmt, NULL);
  sqlite3_free(cmd);
  
  if (sqlite3_step(stmt) == SQLITE_ROW)
    {
      if (m->name) g_free(m->name);
      if (m->email) g_free(m->email);
      if (m->phone) g_free(m->phone);
      
      m->name = g_strdup((gchar *)sqlite3_column_text(stmt, 0));
      m->tarif = sqlite3_column_int(stmt, 1);
      m->email = g_strdup((gchar *)sqlite3_column_text(stmt, 2));
      m->phone = g_strdup((gchar *)sqlite3_column_text(stmt, 3));
      m->flags = sqlite3_column_double(stmt, 4);
    }

  sqlite3_finalize(stmt);

  return TRUE;
}

/* Static */
static gboolean
_CCL_member_store(gint member)
{
  CCL_member *m = g_datalist_id_get_data(&(ccl->members), member);
  gchar *cmd = NULL;

  g_return_val_if_fail(m, FALSE);
      
  cmd = sqlite3_mprintf("UPDATE MEMBERS\n"
			"SET TARIF = %d,\n"
			"    NAME = %Q,\n"
			"    EMAIL = %Q,\n"
			"    PHONE = %Q,\n"
			"    FLAGS = %u\n"
			"WHERE ID = %d;", m->tarif, m->name, m->email,
			m->phone, m->flags, member);
  sqlite3_exec(ccl->db, cmd, NULL, NULL, NULL);
  sqlite3_free(cmd);

  return TRUE;
}

void
_destroy_member(gpointer data)
{
  CCL_member *member = (CCL_member *) data;

  if (member->name) g_free(member->name);
  if (member->email) g_free(member->email);
  if (member->phone) g_free(member->phone);

  g_free(member);
}

void
_CCL_member_init(CCL_member * member, const gchar * name)
{
  member->name = g_strdup(name);
  member->tarif = 0;
  member->email = NULL;
  member->phone = NULL;
  member->flags = 0;
  member->data = NULL;
}
