#include <stdlib.h>

#include "mytestdoc.h"


static void DoFlipH(MyTestDoc *pDoc)
{
  XImage *ximage = pDoc->getXImage();
  if (!ximage) return;

  int partx, DIBWidth1;
  int bperpix, bperline;
  unsigned char *imagedata, *lpBits;

  partx = ((pDoc->getImageWidth() % pDoc->getMCUwidth()) * pDoc->getScale() + 7 ) >> 3;
  DIBWidth1 = ximage->width - partx - 1;

  bperline = ximage->bytes_per_line;
  bperpix  = ximage->bits_per_pixel;
  imagedata = (unsigned char *) ximage->data;

  switch (bperpix)
  {
  case 8:
    for (int i = 0; i < ximage->height; i++)
    {
      lpBits = imagedata;
      for (int j = 0; j * 2 < DIBWidth1; j++)
  	  {
  	    unsigned char temp = lpBits[j];
  	    lpBits[j] = lpBits[DIBWidth1 - j];
  	    lpBits[DIBWidth1 - j] = temp;
  	  }
      imagedata += bperline;
  	}
    break;
  case 16:
    for (i = 0; i < ximage->height; i++)
    {
      lpBits = imagedata;
      for (int j = 0; j * 2 < DIBWidth1; j++)
  	  {
  	    unsigned short temp = ((unsigned short *)lpBits)[j];
  	    ((unsigned short *)lpBits)[j] = ((unsigned short *)lpBits)[DIBWidth1 - j];
  	    ((unsigned short *)lpBits)[DIBWidth1 - j] = temp;
  	  }
      imagedata += bperline;
  	}
    break;
  case 24:
    for (i = 0; i < ximage->height; i++)
  	{
      lpBits = imagedata;
      for (int j = 0; j * 2 < DIBWidth1; j++)
  	  {
  	    unsigned char temp = lpBits[3*j];
  	    lpBits[3*j] = lpBits[3*(DIBWidth1 - j)];
  	    lpBits[3*(DIBWidth1 - j)] = temp;
  	    temp = lpBits[3*j + 1];
  	    lpBits[3*j + 1] = lpBits[3*(DIBWidth1 - j) + 1];
  	    lpBits[3*(DIBWidth1 - j) + 1] = temp;
  	    temp = lpBits[3*j + 2];
  	    lpBits[3*j + 2] = lpBits[3*(DIBWidth1 - j) + 2];
  	    lpBits[3*(DIBWidth1 - j) + 2] = temp;
  	  }
      imagedata += bperline;
  	}
    break;
  case 32:
    for (i = 0; i < ximage->height; i++)
    {
      lpBits = imagedata;
      for (int j = 0; j * 2 < DIBWidth1; j++)
  	  {
  	    unsigned long temp = ((unsigned long *)lpBits)[j];
  	    ((unsigned long *)lpBits)[j] = ((unsigned long *)lpBits)[DIBWidth1 - j];
  	    ((unsigned long *)lpBits)[DIBWidth1 - j] = temp;
  	  }
      imagedata += bperline;
  	}
    break;
  }
}

static void DoTransformFlipH(MyTestDoc *pDoc)
{
  DoFlipH(pDoc);

  pDoc->updateAllViews();
}

static void DoFlipV(MyTestDoc *pDoc)
{
  XImage *ximage = pDoc->getXImage();
  if (!ximage) return;

  int party, DIBHeight1;
  int bperpix, bperline;
  int DIBLineWidth;
  unsigned char *lpBits1, *lpBits2;

  party = ((pDoc->getImageHeight() % pDoc->getMCUheight()) * pDoc->getScale() + 7) >> 3;
	DIBHeight1 = ximage->height - party - 1;

  bperline = ximage->bytes_per_line;
  bperpix  = ximage->bits_per_pixel;

  DIBLineWidth = ximage->width * bperpix / 8;
  
  lpBits1 = (unsigned char *) ximage->data;
  lpBits2 = lpBits1 + bperline * DIBHeight1;

  for (int i = 0; i * 2 < DIBHeight1; i++)
	{
    for (int j = 0; j < DIBLineWidth; j++)
	  {
  		unsigned char temp = lpBits1[j];
	    lpBits1[j] = lpBits2[j];
  		lpBits2[j] = temp;
	  }
    lpBits1 += bperline;
	  lpBits2 -= bperline;
	}
}

static void DoTransformFlipV(MyTestDoc *pDoc)
{
  DoFlipV(pDoc);

  pDoc->updateAllViews();
}

static void DoRot90(MyTestDoc *pDoc)
{
  XImage *ximage = pDoc->getXImage();
  if (!ximage) return;
  
  int party, DIBHeight1;
  int bperpix, bperline;
  unsigned char *lpBits;

  party = ((pDoc->getImageHeight() % pDoc->getMCUheight()) * pDoc->getScale() + 7) >> 3;
  DIBHeight1 = ximage->height - party;
  
  bperline = ximage->bytes_per_line;
  bperpix  = ximage->bits_per_pixel;
  lpBits = (unsigned char *) ximage->data;

  if (bperpix == 8)
  {
    Display *theDisp = qt_xdisplay();
    int theScreen = qt_xscreen();
    XImage *xNew = XCreateImage(theDisp, DefaultVisual(theDisp,theScreen),
                                DefaultDepth(theDisp,theScreen), ZPixmap, 0, NULL,
                                ximage->height, ximage->width, 32, 0);
    int NEWbperline = xNew->bytes_per_line;
    unsigned char *NEWBits =
      (unsigned char *) malloc((size_t) (xNew->height * NEWbperline));
    xNew->data = (char *) NEWBits;

    for (int i = DIBHeight1; i > 0;)
	  {
	    int k = --i;
      for (int j = 0; j < ximage->width;)
	    {
		    NEWBits[k] = lpBits[j++];
	      k += NEWbperline;
	    }
      lpBits += bperline;
	  }
    for (i = DIBHeight1; i < ximage->height;)
	  {
	    int k = i++;
      for (int j = 0; j < ximage->width;)
	    {
		    NEWBits[k] = lpBits[j++];
	      k += NEWbperline;
	    }
      lpBits += bperline;
	  }
    pDoc->ReplaceXimage(xNew);
  }
  else if (bperpix == 16)
  {
    Display *theDisp = qt_xdisplay();
    int theScreen = qt_xscreen();
    XImage *xNew = XCreateImage(theDisp, DefaultVisual(theDisp,theScreen),
                                DefaultDepth(theDisp,theScreen), ZPixmap, 0, NULL,
                                ximage->height, ximage->width, 32, 0);
    int NEWbperline = xNew->bytes_per_line;
    unsigned char *NEWBits =
      (unsigned char *) malloc((size_t) (xNew->height * NEWbperline));
    xNew->data = (char *) NEWBits;

    for (int i = DIBHeight1; i > 0;)
	  {
	    int k = 2 * --i;
      for (int j = 0; j < ximage->width;)
	    {
		    *(unsigned short *)(NEWBits + k) = ((unsigned short *)lpBits)[j++];
	      k += NEWbperline;
	    }
      lpBits += bperline;
	  }
    for (i = DIBHeight1; i < ximage->height;)
	  {
	    int k = 2 * i++;
      for (int j = 0; j < ximage->width;)
	    {
		    *(unsigned short *)(NEWBits + k) = ((unsigned short *)lpBits)[j++];
	      k += NEWbperline;
	    }
      lpBits += bperline;
	  }
    pDoc->ReplaceXimage(xNew);
  }
  else if (bperpix == 24)
  {
    Display *theDisp = qt_xdisplay();
    int theScreen = qt_xscreen();
    XImage *xNew = XCreateImage(theDisp, DefaultVisual(theDisp,theScreen),
                                DefaultDepth(theDisp,theScreen), ZPixmap, 0, NULL,
                                ximage->height, ximage->width, 32, 0);
    int NEWbperline = xNew->bytes_per_line;
    unsigned char *NEWBits =
      (unsigned char *) malloc((size_t) (xNew->height * NEWbperline));
    xNew->data = (char *) NEWBits;

    for (int i = DIBHeight1; i > 0;)
	  {
	    int k = 3 * --i;
      for (int j = 0; j < 3 * ximage->width;)
	    {
		    NEWBits[k]   = lpBits[j++];
		    NEWBits[k+1] = lpBits[j++];
		    NEWBits[k+2] = lpBits[j++];
	      k += NEWbperline;
	    }
      lpBits += bperline;
	  }
    for (i = DIBHeight1; i < ximage->height;)
	  {
	    int k = 3 * i++;
      for (int j = 0; j < 3 * ximage->width;)
	    {
		    NEWBits[k]   = lpBits[j++];
		    NEWBits[k+1] = lpBits[j++];
		    NEWBits[k+2] = lpBits[j++];
	      k += NEWbperline;
	    }
      lpBits += bperline;
	  }
    pDoc->ReplaceXimage(xNew);
  }
  else if (bperpix == 32)
  {
    Display *theDisp = qt_xdisplay();
    int theScreen = qt_xscreen();
    XImage *xNew = XCreateImage(theDisp, DefaultVisual(theDisp,theScreen),
                                DefaultDepth(theDisp,theScreen), ZPixmap, 0, NULL,
                                ximage->height, ximage->width, 32, 0);
    int NEWbperline = xNew->bytes_per_line;
    unsigned char *NEWBits =
      (unsigned char *) malloc((size_t) (xNew->height * NEWbperline));
    xNew->data = (char *) NEWBits;

    for (int i = DIBHeight1; i > 0;)
	  {
	    int k = 4 * --i;
      for (int j = 0; j < ximage->width;)
	    {
		    *(unsigned long *)(NEWBits + k) = ((unsigned long *)lpBits)[j++];
	      k += NEWbperline;
	    }
      lpBits += bperline;
	  }
    for (i = DIBHeight1; i < ximage->height;)
	  {
	    int k = 4 * i++;
      for (int j = 0; j < ximage->width;)
	    {
		    *(unsigned long *)(NEWBits + k) = ((unsigned long *)lpBits)[j++];
	      k += NEWbperline;
	    }
      lpBits += bperline;
	  }
    pDoc->ReplaceXimage(xNew);
  }
}

static void DoTransformRot90(MyTestDoc *pDoc)
{
  DoRot90(pDoc);

  pDoc->updateAllViews(0, 1);
}

static void DoRot270(MyTestDoc *pDoc)
{
  XImage *ximage = pDoc->getXImage();
  if (!ximage) return;

  int partx, DIBWidth1;
  int bperpix, bperline;
  unsigned char *lpBits;

  partx = ((pDoc->getImageWidth() % pDoc->getMCUwidth()) * pDoc->getScale() + 7) >> 3;
  DIBWidth1 = ximage->width - partx;

  bperline = ximage->bytes_per_line;
  bperpix  = ximage->bits_per_pixel;
  lpBits = (unsigned char *) ximage->data;

  if (bperpix == 8)
  {
    Display *theDisp = qt_xdisplay();
    int theScreen = qt_xscreen();
    XImage *xNew = XCreateImage(theDisp, DefaultVisual(theDisp,theScreen),
                                DefaultDepth(theDisp,theScreen), ZPixmap, 0, NULL,
                                ximage->height, ximage->width, 32, 0);
    int NEWbperline = xNew->bytes_per_line;
    unsigned char *NEWBits =
      (unsigned char *) malloc((size_t) (xNew->height * NEWbperline));
    xNew->data = (char *) NEWBits;

    for (int i = 0; i < ximage->height;)
	  {
      int k = i++;
      for (int j = DIBWidth1; j > 0;)
	    {
		    NEWBits[k] = lpBits[--j];
	      k += NEWbperline;
	    }
      for (j = DIBWidth1; j < ximage->width;)
	    {
		    NEWBits[k] = lpBits[j++];
	      k += NEWbperline;
	    }
      lpBits += bperline;
	  }
    pDoc->ReplaceXimage(xNew);
  }
  else if (bperpix == 16)
  {
    Display *theDisp = qt_xdisplay();
    int theScreen = qt_xscreen();
    XImage *xNew = XCreateImage(theDisp, DefaultVisual(theDisp,theScreen),
                                DefaultDepth(theDisp,theScreen), ZPixmap, 0, NULL,
                                ximage->height, ximage->width, 32, 0);
    int NEWbperline = xNew->bytes_per_line;
    unsigned char *NEWBits =
      (unsigned char *) malloc((size_t) (xNew->height * NEWbperline));
    xNew->data = (char *) NEWBits;

    for (int i = 0; i < ximage->height;)
	  {
      int k = 2 * i++;
      for (int j = DIBWidth1; j > 0;)
	    {
		    *(unsigned short *)(NEWBits + k) = ((unsigned short *)lpBits)[--j];
	      k += NEWbperline;
	    }
      for (j = DIBWidth1; j < ximage->width;)
	    {
		    *(unsigned short *)(NEWBits + k) = ((unsigned short *)lpBits)[j++];
	      k += NEWbperline;
	    }
      lpBits += bperline;
	  }
    pDoc->ReplaceXimage(xNew);
  }
  else if (bperpix == 24)
  {
    Display *theDisp = qt_xdisplay();
    int theScreen = qt_xscreen();
    XImage *xNew = XCreateImage(theDisp, DefaultVisual(theDisp,theScreen),
                                DefaultDepth(theDisp,theScreen), ZPixmap, 0, NULL,
                                ximage->height, ximage->width, 32, 0);
    int NEWbperline = xNew->bytes_per_line;
    unsigned char *NEWBits =
      (unsigned char *) malloc((size_t) (xNew->height * NEWbperline));
    xNew->data = (char *) NEWBits;

    for (int i = 0; i < ximage->height;)
	  {
      int k = 3 * i++;
      for (int j = 3 * DIBWidth1; j > 0;)
	    {
		    NEWBits[k+2] = lpBits[--j];
		    NEWBits[k+1] = lpBits[--j];
		    NEWBits[k]   = lpBits[--j];
	      k += NEWbperline;
	    }
      for (j = 3 * DIBWidth1; j < 3 * ximage->width;)
	    {
		    NEWBits[k]   = lpBits[j++];
		    NEWBits[k+1] = lpBits[j++];
		    NEWBits[k+2] = lpBits[j++];
	      k += NEWbperline;
	    }
      lpBits += bperline;
	  }
    pDoc->ReplaceXimage(xNew);
  }
  else if (bperpix == 32)
  {
    Display *theDisp = qt_xdisplay();
    int theScreen = qt_xscreen();
    XImage *xNew = XCreateImage(theDisp, DefaultVisual(theDisp,theScreen),
                                DefaultDepth(theDisp,theScreen), ZPixmap, 0, NULL,
                                ximage->height, ximage->width, 32, 0);
    int NEWbperline = xNew->bytes_per_line;
    unsigned char *NEWBits =
      (unsigned char *) malloc((size_t) (xNew->height * NEWbperline));
    xNew->data = (char *) NEWBits;

    for (int i = 0; i < ximage->height;)
	  {
      int k = 4 * i++;
      for (int j = DIBWidth1; j > 0;)
	    {
		    *(unsigned long *)(NEWBits + k) = ((unsigned long *)lpBits)[--j];
	      k += NEWbperline;
	    }
      for (j = DIBWidth1; j < ximage->width;)
	    {
		    *(unsigned long *)(NEWBits + k) = ((unsigned long *)lpBits)[j++];
	      k += NEWbperline;
	    }
      lpBits += bperline;
	  }
    pDoc->ReplaceXimage(xNew);
  }
}

static void DoTransformRot270(MyTestDoc *pDoc)
{
  DoRot270(pDoc);

  pDoc->updateAllViews(0, 1);
}

static void DoRot180(MyTestDoc *pDoc)
{
  XImage *ximage = pDoc->getXImage();
  if (!ximage) return;

  int partx, party;
  int DIBWidth1, DIBHeight1;
  int bperpix, bperline;
  unsigned char *lpBits1, *lpBits2;

  partx = ((pDoc->getImageWidth() % pDoc->getMCUwidth()) * pDoc->getScale() + 7) >> 3;
  party = ((pDoc->getImageHeight() % pDoc->getMCUheight()) * pDoc->getScale() + 7) >> 3;

  DIBWidth1 = ximage->width - partx - 1;
  DIBHeight1 = ximage->height - party - 1;

  bperline = ximage->bytes_per_line;
  bperpix  = ximage->bits_per_pixel;

  lpBits1 = (unsigned char *) ximage->data;
  lpBits2 = lpBits1 + bperline * ximage->height;

  switch (bperpix)
  {
  case 8:
    for (int i = 0; i < party; i++)
  	{
  	  lpBits2 -= bperline;
      for (int j = 0; j * 2 < DIBWidth1; j++)
  	  {
  	    unsigned char temp = lpBits2[j];
  	    lpBits2[j] = lpBits2[DIBWidth1 - j];
  	    lpBits2[DIBWidth1 - j] = temp;
  	  }
  	}
    for (i = 0; i < DIBHeight1; i += 2)
  	{
  	  lpBits2 -= bperline;
      for (int j = 0; j <= DIBWidth1; j++)
  	  {
  	    unsigned char temp = lpBits1[j];
  	    lpBits1[j] = lpBits2[DIBWidth1 - j];
  	    lpBits2[DIBWidth1 - j] = temp;
  	  }
      for (; j < ximage->width; j++)
  	  {
  	    unsigned char temp = lpBits1[j];
  	    lpBits1[j] = lpBits2[j];
  	    lpBits2[j] = temp;
  	  }
      lpBits1 += bperline;
  	}
  	if (i == DIBHeight1)
      for (int j = 0; j * 2 < DIBWidth1; j++)
  	  {
  	    unsigned char temp = lpBits1[j];
  	    lpBits1[j] = lpBits1[DIBWidth1 - j];
  	    lpBits1[DIBWidth1 - j] = temp;
  	  }
    break;
  case 16:
    for (i = 0; i < party; i++)
  	{
  	  lpBits2 -= bperline;
      for (int j = 0; j * 2 < DIBWidth1; j++)
  	  {
  	    unsigned short temp = ((unsigned short *)lpBits2)[j];
  	    ((unsigned short *)lpBits2)[j] = ((unsigned short *)lpBits2)[DIBWidth1 - j];
  	    ((unsigned short *)lpBits2)[DIBWidth1 - j] = temp;
  	  }
  	}
    for (i = 0; i < DIBHeight1; i += 2)
  	{
  	  lpBits2 -= bperline;
      for (int j = 0; j <= DIBWidth1; j++)
  	  {
  	    unsigned short temp = ((unsigned short *)lpBits1)[j];
  	    ((unsigned short *)lpBits1)[j] = ((unsigned short *)lpBits2)[DIBWidth1 - j];
  	    ((unsigned short *)lpBits2)[DIBWidth1 - j] = temp;
  	  }
      for (; j < ximage->width; j++)
  	  {
  	    unsigned short temp = ((unsigned short *)lpBits1)[j];
  	    ((unsigned short *)lpBits1)[j] = ((unsigned short *)lpBits2)[j];
  	    ((unsigned short *)lpBits2)[j] = temp;
  	  }
      lpBits1 += bperline;
  	}
  	if (i == DIBHeight1)
      for (int j = 0; j * 2 < DIBWidth1; j++)
  	  {
  	    unsigned short temp = ((unsigned short *)lpBits1)[j];
  	    ((unsigned short *)lpBits1)[j] = ((unsigned short *)lpBits1)[DIBWidth1 - j];
  	    ((unsigned short *)lpBits1)[DIBWidth1 - j] = temp;
  	  }
    break;
  case 24:
  	for (i = 0; i < party; i++)
  	{
  	  lpBits2 -= bperline;
      for (int j = 0; j * 2 < DIBWidth1; j++)
  	  {
  	    unsigned char temp = lpBits2[3*j];
  	    lpBits2[3*j] = lpBits2[3*(DIBWidth1 - j)];
  	    lpBits2[3*(DIBWidth1 - j)] = temp;
  	    temp = lpBits2[3*j + 1];
  	    lpBits2[3*j + 1] = lpBits2[3*(DIBWidth1 - j) + 1];
  	    lpBits2[3*(DIBWidth1 - j) + 1] = temp;
  	    temp = lpBits2[3*j + 2];
  	    lpBits2[3*j + 2] = lpBits2[3*(DIBWidth1 - j) + 2];
  	    lpBits2[3*(DIBWidth1 - j) + 2] = temp;
  	  }
  	}
  	for (i = 0; i < DIBHeight1; i += 2)
  	{
  	  lpBits2 -= bperline;
      for (int j = 0; j <= DIBWidth1; j++)
  	  {
  	    unsigned char temp = lpBits1[3*j];
  	    lpBits1[3*j] = lpBits2[3*(DIBWidth1 - j)];
  	    lpBits2[3*(DIBWidth1 - j)] = temp;
  	    temp = lpBits1[3*j + 1];
  	    lpBits1[3*j + 1] = lpBits2[3*(DIBWidth1 - j) + 1];
  	    lpBits2[3*(DIBWidth1 - j) + 1] = temp;
  	    temp = lpBits1[3*j + 2];
  	    lpBits1[3*j + 2] = lpBits2[3*(DIBWidth1 - j) + 2];
  	    lpBits2[3*(DIBWidth1 - j) + 2] = temp;
  	  }
      for (; j < ximage->width; j++)
  	  {
  	    unsigned char temp = lpBits1[3*j];
  	    lpBits1[3*j] = lpBits2[3*j];
  	    lpBits2[3*j] = temp;
  	    temp = lpBits1[3*j + 1];
  	    lpBits1[3*j + 1] = lpBits2[3*j + 1];
  	    lpBits2[3*j + 1] = temp;
        temp = lpBits1[3*j + 2];
  	    lpBits1[3*j + 2] = lpBits2[3*j + 2];
  	    lpBits2[3*j + 2] = temp;
  	  }
      lpBits1 += bperline;
  	}
  	if (i == DIBHeight1)
      for (int j = 0; j * 2 < DIBWidth1; j++)
  	  {
  	    unsigned char temp = lpBits1[3*j];
  	    lpBits1[3*j] = lpBits1[3*(DIBWidth1 - j)];
  	    lpBits1[3*(DIBWidth1 - j)] = temp;
  	    temp = lpBits1[3*j + 1];
  	    lpBits1[3*j + 1] = lpBits1[3*(DIBWidth1 - j) + 1];
  	    lpBits1[3*(DIBWidth1 - j) + 1] = temp;
  	    temp = lpBits1[3*j + 2];
  	    lpBits1[3*j + 2] = lpBits1[3*(DIBWidth1 - j) + 2];
  	    lpBits1[3*(DIBWidth1 - j) + 2] = temp;
  	  }
    break;
  case 32:
    for (i = 0; i < party; i++)
  	{
  	  lpBits2 -= bperline;
      for (int j = 0; j * 2 < DIBWidth1; j++)
  	  {
  	    unsigned long temp = ((unsigned long *)lpBits2)[j];
  	    ((unsigned long *)lpBits2)[j] = ((unsigned long *)lpBits2)[DIBWidth1 - j];
  	    ((unsigned long *)lpBits2)[DIBWidth1 - j] = temp;
  	  }
  	}
    for (i = 0; i < DIBHeight1; i += 2)
  	{
  	  lpBits2 -= bperline;
      for (int j = 0; j <= DIBWidth1; j++)
  	  {
  	    unsigned long temp = ((unsigned long *)lpBits1)[j];
  	    ((unsigned long *)lpBits1)[j] = ((unsigned long *)lpBits2)[DIBWidth1 - j];
  	    ((unsigned long *)lpBits2)[DIBWidth1 - j] = temp;
  	  }
      for (; j < ximage->width; j++)
  	  {
  	    unsigned long temp = ((unsigned long *)lpBits1)[j];
  	    ((unsigned long *)lpBits1)[j] = ((unsigned long *)lpBits2)[j];
  	    ((unsigned long *)lpBits2)[j] = temp;
  	  }
      lpBits1 += bperline;
  	}
  	if (i == DIBHeight1)
      for (int j = 0; j * 2 < DIBWidth1; j++)
  	  {
  	    unsigned long temp = ((unsigned long *)lpBits1)[j];
  	    ((unsigned long *)lpBits1)[j] = ((unsigned long *)lpBits1)[DIBWidth1 - j];
  	    ((unsigned long *)lpBits1)[DIBWidth1 - j] = temp;
  	  }
    break;
  }
}

static void DoTransformRot180(MyTestDoc *pDoc)
{
  DoRot180(pDoc);

  pDoc->updateAllViews();
}

static void DoTranspose(MyTestDoc *pDoc)
{
  XImage *ximage = pDoc->getXImage();
  if (!ximage) return;

  int bperpix, bperline;
  unsigned char *lpBits;

  bperline = ximage->bytes_per_line;
  bperpix  = ximage->bits_per_pixel;
  lpBits = (unsigned char *) ximage->data;

  if (bperpix == 8)
  {
    Display *theDisp = qt_xdisplay();
    int theScreen = qt_xscreen();
    XImage *xNew = XCreateImage(theDisp, DefaultVisual(theDisp,theScreen),
                                DefaultDepth(theDisp,theScreen), ZPixmap, 0, NULL,
                                ximage->height, ximage->width, 32, 0);
    int NEWbperline = xNew->bytes_per_line;
    unsigned char *NEWBits =
      (unsigned char *) malloc((size_t) (xNew->height * NEWbperline));
    xNew->data = (char *) NEWBits;

    for (int i = 0; i < ximage->height;)
	  {
	    int k = i++;
      for (int j = 0; j < ximage->width;)
	    {
		    NEWBits[k] = lpBits[j++];
	      k += NEWbperline;
	    }
      lpBits += bperline;
	  }
    pDoc->ReplaceXimage(xNew);
  }
  else if (bperpix == 16)
  {
    Display *theDisp = qt_xdisplay();
    int theScreen = qt_xscreen();
    XImage *xNew = XCreateImage(theDisp, DefaultVisual(theDisp,theScreen),
                                DefaultDepth(theDisp,theScreen), ZPixmap, 0, NULL,
                                ximage->height, ximage->width, 32, 0);
    int NEWbperline = xNew->bytes_per_line;
    unsigned char *NEWBits =
      (unsigned char *) malloc((size_t) (xNew->height * NEWbperline));
    xNew->data = (char *) NEWBits;

    for (int i = 0; i < ximage->height;)
	  {
	    int k = 2 * i++;
      for (int j = 0; j < ximage->width;)
	    {
		    *(unsigned short *)(NEWBits + k) = ((unsigned short *)lpBits)[j++];
	      k += NEWbperline;
	    }
      lpBits += bperline;
	  }
    pDoc->ReplaceXimage(xNew);
  }
  else if (bperpix == 24)
  {
    Display *theDisp = qt_xdisplay();
    int theScreen = qt_xscreen();
    XImage *xNew = XCreateImage(theDisp, DefaultVisual(theDisp,theScreen),
                                DefaultDepth(theDisp,theScreen), ZPixmap, 0, NULL,
                                ximage->height, ximage->width, 32, 0);
    int NEWbperline = xNew->bytes_per_line;
    unsigned char *NEWBits =
      (unsigned char *) malloc((size_t) (xNew->height * NEWbperline));
    xNew->data = (char *) NEWBits;

    for (int i = 0; i < ximage->height;)
	  {
	    int k = 3 * i++;
      for (int j = 0; j < 3 * ximage->width;)
	    {
		    NEWBits[k]   = lpBits[j++];
		    NEWBits[k+1] = lpBits[j++];
		    NEWBits[k+2] = lpBits[j++];
	      k += NEWbperline;
	    }
      lpBits += bperline;
	  }
    pDoc->ReplaceXimage(xNew);
  }
  else if (bperpix == 32)
  {
    Display *theDisp = qt_xdisplay();
    int theScreen = qt_xscreen();
    XImage *xNew = XCreateImage(theDisp, DefaultVisual(theDisp,theScreen),
                                DefaultDepth(theDisp,theScreen), ZPixmap, 0, NULL,
                                ximage->height, ximage->width, 32, 0);
    int NEWbperline = xNew->bytes_per_line;
    unsigned char *NEWBits =
      (unsigned char *) malloc((size_t) (xNew->height * NEWbperline));
    xNew->data = (char *) NEWBits;

    for (int i = 0; i < ximage->height;)
	  {
	    int k = 4 * i++;
      for (int j = 0; j < ximage->width;)
	    {
		    *(unsigned long *)(NEWBits + k) = ((unsigned long *)lpBits)[j++];
	      k += NEWbperline;
	    }
      lpBits += bperline;
	  }
    pDoc->ReplaceXimage(xNew);
  }
}

static void DoTransformTranspose(MyTestDoc *pDoc)
{
  DoTranspose(pDoc);

  pDoc->updateAllViews(0, 1);
}

static void DoTransverse(MyTestDoc *pDoc)
{
  XImage *ximage = pDoc->getXImage();
  if (!ximage) return;

  int partx, party;
  int DIBWidth1, DIBHeight1;
  int bperpix, bperline;
  unsigned char *lpBits;

  partx = ((pDoc->getImageWidth() % pDoc->getMCUwidth()) * pDoc->getScale() + 7) >> 3;
  party = ((pDoc->getImageHeight() % pDoc->getMCUheight()) * pDoc->getScale() + 7) >> 3;

  DIBWidth1 = ximage->width - partx;
  DIBHeight1 = ximage->height - party;

  bperline = ximage->bytes_per_line;
  bperpix  = ximage->bits_per_pixel;

  lpBits = (unsigned char *) ximage->data;

  if (bperpix == 8)
  {
    Display *theDisp = qt_xdisplay();
    int theScreen = qt_xscreen();
    XImage *xNew = XCreateImage(theDisp, DefaultVisual(theDisp,theScreen),
                                DefaultDepth(theDisp,theScreen), ZPixmap, 0, NULL,
                                ximage->height, ximage->width, 32, 0);
    int NEWbperline = xNew->bytes_per_line;
    unsigned char *NEWBits =
      (unsigned char *) malloc((size_t) (xNew->height * NEWbperline));
    xNew->data = (char *) NEWBits;

    for (int i = DIBHeight1; i > 0;)
	  {
	    int k = --i;
      for (int j = DIBWidth1; j > 0;)
	    {
		    NEWBits[k] = lpBits[--j];
	      k += NEWbperline;
	    }
      for (j = DIBWidth1; j < ximage->width;)
	    {
		    NEWBits[k] = lpBits[j++];
	      k += NEWbperline;
	    }
      lpBits += bperline;
	  }
    for (i = DIBHeight1; i < ximage->height;)
	  {
	    int k = i++;
      for (int j = DIBWidth1; j > 0;)
	    {
		    NEWBits[k] = lpBits[--j];
	      k += NEWbperline;
	    }
      for (j = DIBWidth1; j < ximage->width;)
	    {
		    NEWBits[k] = lpBits[j++];
	      k += NEWbperline;
	    }
      lpBits += bperline;
	  }
    pDoc->ReplaceXimage(xNew);
  }
  else if (bperpix == 16)
  {
    Display *theDisp = qt_xdisplay();
    int theScreen = qt_xscreen();
    XImage *xNew = XCreateImage(theDisp, DefaultVisual(theDisp,theScreen),
                                DefaultDepth(theDisp,theScreen), ZPixmap, 0, NULL,
                                ximage->height, ximage->width, 32, 0);
    int NEWbperline = xNew->bytes_per_line;
    unsigned char *NEWBits =
      (unsigned char *) malloc((size_t) (xNew->height * NEWbperline));
    xNew->data = (char *) NEWBits;

    for (int i = DIBHeight1; i > 0;)
	  {
	    int k = 2 * --i;
      for (int j = DIBWidth1; j > 0;)
	    {
		    *(unsigned short *)(NEWBits + k) = ((unsigned short *)lpBits)[--j];
	      k += NEWbperline;
	    }
      for (j = DIBWidth1; j < ximage->width;)
	    {
		    *(unsigned short *)(NEWBits + k) = ((unsigned short *)lpBits)[j++];
	      k += NEWbperline;
	    }
      lpBits += bperline;
	  }
    for (i = DIBHeight1; i < ximage->height;)
	  {
	    int k = 2 * i++;
      for (int j = DIBWidth1; j > 0;)
	    {
		    *(unsigned short *)(NEWBits + k) = ((unsigned short *)lpBits)[--j];
	      k += NEWbperline;
	    }
      for (j = DIBWidth1; j < ximage->width;)
	    {
		    *(unsigned short *)(NEWBits + k) = ((unsigned short *)lpBits)[j++];
	      k += NEWbperline;
	    }
      lpBits += bperline;
	  }
    pDoc->ReplaceXimage(xNew);
  }
  else if (bperpix == 24)
  {
    Display *theDisp = qt_xdisplay();
    int theScreen = qt_xscreen();
    XImage *xNew = XCreateImage(theDisp, DefaultVisual(theDisp,theScreen),
                                DefaultDepth(theDisp,theScreen), ZPixmap, 0, NULL,
                                ximage->height, ximage->width, 32, 0);
    int NEWbperline = xNew->bytes_per_line;
    unsigned char *NEWBits =
      (unsigned char *) malloc((size_t) (xNew->height * NEWbperline));
    xNew->data = (char *) NEWBits;

    for (int i = DIBHeight1; i > 0;)
	  {
	    int k = 3 * --i;
      for (int j = 3 * DIBWidth1; j > 0;)
	    {
		    NEWBits[k+2] = lpBits[--j];
		    NEWBits[k+1] = lpBits[--j];
		    NEWBits[k]   = lpBits[--j];
	      k += NEWbperline;
	    }
      for (j = 3 * DIBWidth1; j < 3 * ximage->width;)
	    {
		    NEWBits[k]   = lpBits[j++];
		    NEWBits[k+1] = lpBits[j++];
		    NEWBits[k+2] = lpBits[j++];
	      k += NEWbperline;
	    }
      lpBits += bperline;
	  }
    for (i = DIBHeight1; i < ximage->height;)
	  {
	    int k = 3 * i++;
      for (int j = 3 * DIBWidth1; j > 0;)
	    {
		    NEWBits[k+2] = lpBits[--j];
		    NEWBits[k+1] = lpBits[--j];
		    NEWBits[k]   = lpBits[--j];
	      k += NEWbperline;
	    }
      for (j = 3 * DIBWidth1; j < 3 * ximage->width;)
	    {
		    NEWBits[k]   = lpBits[j++];
		    NEWBits[k+1] = lpBits[j++];
		    NEWBits[k+2] = lpBits[j++];
	      k += NEWbperline;
	    }
      lpBits += bperline;
	  }
    pDoc->ReplaceXimage(xNew);
  }
  else if (bperpix == 32)
  {
    Display *theDisp = qt_xdisplay();
    int theScreen = qt_xscreen();
    XImage *xNew = XCreateImage(theDisp, DefaultVisual(theDisp,theScreen),
                                DefaultDepth(theDisp,theScreen), ZPixmap, 0, NULL,
                                ximage->height, ximage->width, 32, 0);
    int NEWbperline = xNew->bytes_per_line;
    unsigned char *NEWBits =
      (unsigned char *) malloc((size_t) (xNew->height * NEWbperline));
    xNew->data = (char *) NEWBits;

    for (int i = DIBHeight1; i > 0;)
	  {
	    int k = 4 * --i;
      for (int j = DIBWidth1; j > 0;)
	    {
		    *(unsigned long *)(NEWBits + k) = ((unsigned long *)lpBits)[--j];
	      k += NEWbperline;
	    }
      for (j = DIBWidth1; j < ximage->width;)
	    {
		    *(unsigned long *)(NEWBits + k) = ((unsigned long *)lpBits)[j++];
	      k += NEWbperline;
	    }
      lpBits += bperline;
	  }
    for (i = DIBHeight1; i < ximage->height;)
	  {
	    int k = 4 * i++;
      for (int j = DIBWidth1; j > 0;)
	    {
		    *(unsigned long *)(NEWBits + k) = ((unsigned long *)lpBits)[--j];
	      k += NEWbperline;
	    }
      for (j = DIBWidth1; j < ximage->width;)
	    {
		    *(unsigned long *)(NEWBits + k) = ((unsigned long *)lpBits)[j++];
	      k += NEWbperline;
	    }
      lpBits += bperline;
	  }
    pDoc->ReplaceXimage(xNew);
  }
}

static void DoTransformTransverse(MyTestDoc *pDoc)
{
  DoTransverse(pDoc);

  pDoc->updateAllViews(0, 1);
}

void MyTestDoc::doTransform()
{
  switch (m_transform)
  {
	case 0: break;
	case 1: DoFlipH(this); break;
	case 2: DoFlipV(this); break;
	case 3: DoTranspose(this); break;
	case 4: DoTransverse(this); break;
	case 5: DoRot90(this); break;
	case 6: DoRot180(this); break;
	case 7: DoRot270(this); break;
  }
}

void MyTestDoc::transformDocument( int new_transform )
{
  int old_transform = m_transform;
  m_transform = new_transform;
  switch (new_transform)
  {
  case 0:
  switch (old_transform)
  {
	case 0: break;
	case 1: DoTransformFlipH(this); break;
	case 2: DoTransformFlipV(this); break;
	case 3: DoTransformTranspose(this); break;
	case 4: DoTransformTransverse(this); break;
	case 5: DoTransformRot270(this); break;
	case 6: DoTransformRot180(this); break;
	case 7: DoTransformRot90(this); break;
  }
  break;
  case 1:
  switch (old_transform)
  {
	case 0: DoTransformFlipH(this); break;
	case 1: break;
	case 2: DoTransformRot180(this); break;
	case 3: DoTransformRot90(this); break;
	case 4: DoTransformRot270(this); break;
	case 5: DoTransformTransverse(this); break;
	case 6: DoTransformFlipV(this); break;
	case 7: DoTransformTranspose(this); break;
  }
  break;
  case 2:
  switch (old_transform)
  {
	case 0: DoTransformFlipV(this); break;
	case 1: DoTransformRot180(this); break;
	case 2: break;
	case 3: DoTransformRot270(this); break;
	case 4: DoTransformRot90(this); break;
	case 5: DoTransformTranspose(this); break;
	case 6: DoTransformFlipH(this); break;
	case 7: DoTransformTransverse(this); break;
  }
  break;
  case 3:
  switch (old_transform)
  {
	case 0: DoTransformTranspose(this); break;
	case 1: DoTransformRot270(this); break;
	case 2: DoTransformRot90(this); break;
	case 3: break;
	case 4: DoTransformRot180(this); break;
	case 5: DoTransformFlipH(this); break;
	case 6: DoTransformTransverse(this); break;
	case 7: DoTransformFlipV(this); break;
  }
  break;
  case 4:
  switch (old_transform)
  {
	case 0: DoTransformTransverse(this); break;
	case 1: DoTransformRot90(this); break;
	case 2: DoTransformRot270(this); break;
	case 3: DoTransformRot180(this); break;
	case 4: break;
	case 5: DoTransformFlipV(this); break;
	case 6: DoTransformTranspose(this); break;
	case 7: DoTransformFlipH(this); break;
  }
  break;
  case 5:
  switch (old_transform)
  {
	case 0: DoTransformRot90(this); break;
	case 1: DoTransformTransverse(this); break;
	case 2: DoTransformTranspose(this); break;
	case 3: DoTransformFlipH(this); break;
	case 4: DoTransformFlipV(this); break;
	case 5: break;
	case 6: DoTransformRot270(this); break;
	case 7: DoTransformRot180(this); break;
  }
  break;
  case 6:
  switch (old_transform)
  {
	case 0: DoTransformRot180(this); break;
	case 1: DoTransformFlipV(this); break;
	case 2: DoTransformFlipH(this); break;
	case 3: DoTransformTransverse(this); break;
	case 4: DoTransformTranspose(this); break;
	case 5: DoTransformRot90(this); break;
	case 6: break;
	case 7: DoTransformRot270(this); break;
  }
  break;
  case 7:
  switch (old_transform)
  {
	case 0: DoTransformRot270(this); break;
	case 1: DoTransformTranspose(this); break;
	case 2: DoTransformTransverse(this); break;
	case 3: DoTransformFlipV(this); break;
	case 4: DoTransformFlipH(this); break;
	case 5: DoTransformRot180(this); break;
	case 6: DoTransformRot90(this); break;
	case 7: break;
  }
  break;
  }
}
